/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.PropertyContainer;
import esecurity.dsd.core.Utils;
import esecurity.dsd.core.http.RESTClient;
import esecurity.dsd.core.http.Token;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class AdminHTTPClient {
    private LocalConfigurationProvider configurator;
    private RESTClient restClient = null;
    private Token token = Token.invalidToken();

    private RESTClient rest() {
        if (this.restClient == null) {
            this.restClient = RESTClient.getInstance(this.configurator.getProvidedConfiguration());
        }
        return this.restClient;
    }

    public AdminHTTPClient(LocalConfigurationProvider configurator) {
        this.configurator = configurator;
    }

    public boolean checkAuthentication() {
        if (!this.token.isValid()) {
            PropertyContainer properties = this.configurator.getProvidedConfiguration();
            try {
                String username = properties.getValue("user", String.class).orElseThrow(() -> new IllegalArgumentException("Username missing."));
                String pwd = properties.getValue("pwd", String.class).orElseThrow(() -> new IllegalArgumentException("Password missing."));
                System.out.println("Check auth with username: " + username);
                this.token = this.rest().getToken(username, pwd, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.token = Token.invalidToken();
            }
        }
        return this.token.isValid();
    }

    /*
     * Exception decompiling
     */
    private void handleExceptions(Exception e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> getUsers() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.checkAuthentication()) {
            try {
                this.rest().sendRequest(this.token, RESTClient.HTTPMethod.GET, RESTClient.Services.ADMIN_USERS, Optional.empty(), "username", "").filter(RESTClient.HTTPResponse::isSuccessful).ifPresent(response -> {
                    JsonElement json = response.body();
                    if (json.isJsonArray()) {
                        json.getAsJsonArray().forEach(uname -> result.add(uname.getAsString()));
                    }
                });
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return result;
    }

    public boolean editDomain(String domain, JsonElement body, String[] privatekeys, String ... deletekeys) {
        boolean ok = false;
        if (this.checkAuthentication()) {
            try {
                Pairs pairs = new Pairs("domain", domain);
                Stream.of(deletekeys).forEach(pk -> pairs.add("delete", (String)pk));
                if (privatekeys != null) {
                    Stream.of(privatekeys).forEach(pk -> pairs.add("private", (String)pk));
                }
                Optional<RESTClient.HTTPResponse> resp = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.PUT, RESTClient.Services.DOMAIN_PROPERTIES, Optional.of(body == null ? new JsonObject() : body), pairs.toArray()).filter(RESTClient.HTTPResponse::isSuccessful);
                ok = resp.isPresent();
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return ok;
    }

    public boolean editDomain(String domain, JsonElement body, String[] privatekeys, List<String> deletekeys) {
        boolean ok = false;
        if (this.checkAuthentication()) {
            try {
                Pairs pairs = new Pairs("domain", domain);
                for (String dk : deletekeys) {
                    Stream.of(deletekeys).forEach(pk -> pairs.add("delete", dk));
                }
                if (privatekeys != null) {
                    Stream.of(privatekeys).forEach(pk -> pairs.add("private", (String)pk));
                }
                Optional<RESTClient.HTTPResponse> resp = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.PUT, RESTClient.Services.DOMAIN_PROPERTIES, Optional.of(body == null ? new JsonObject() : body), pairs.toArray()).filter(RESTClient.HTTPResponse::isSuccessful);
                ok = resp.isPresent();
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return ok;
    }

    public boolean deleteDomain(String domain) {
        boolean ok = false;
        if (this.checkAuthentication()) {
            try {
                Optional<RESTClient.HTTPResponse> resp = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.DELETE, RESTClient.Services.DOMAIN_PROPERTIES, Optional.empty(), new Pairs("domain", domain).toArray()).filter(RESTClient.HTTPResponse::isSuccessful);
                ok = resp.isPresent();
                if (ok) {
                    System.out.println("OK - Domain ".concat(domain).concat(" deleted."));
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return ok;
    }

    public boolean createDomain(String domain, JsonElement body, String ... privatekeys) {
        if (domain == null) {
            throw new IllegalArgumentException("Missing domain name.");
        }
        return this.createOrCopyDomain(domain, null, false, body, privatekeys);
    }

    public boolean copyDomain(String domain, String source, boolean withData, String ... privatekeys) {
        if (domain == null) {
            throw new IllegalArgumentException("Missing domain name.");
        }
        if (source == null) {
            throw new IllegalArgumentException("Missing replica name.");
        }
        return this.createOrCopyDomain(domain, source, withData, null, privatekeys);
    }

    private boolean createOrCopyDomain(String domain, String source, boolean withData, JsonElement body, String ... privatekeys) {
        boolean ok = false;
        if (this.checkAuthentication()) {
            try {
                Optional<RESTClient.HTTPResponse> resp;
                Pairs pairs = new Pairs("domain", domain);
                if (source != null) {
                    pairs.add("replica", source);
                    pairs.add("withData", Boolean.toString(withData));
                }
                if (privatekeys != null) {
                    Stream.of(privatekeys).forEach(pk -> pairs.add("private", (String)pk));
                }
                if (ok = (resp = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.POST, RESTClient.Services.DOMAIN_PROPERTIES, Optional.of(body == null ? new JsonObject() : body), pairs.toArray()).filter(RESTClient.HTTPResponse::isSuccessful)).isPresent()) {
                    System.out.println("OK - Domain ".concat(domain).concat(" created."));
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return ok;
    }

    public Optional<Credential> getUserDetails(String username) {
        Credential credential = null;
        if (this.checkAuthentication()) {
            try {
                Optional<RESTClient.HTTPResponse> resp = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.GET, RESTClient.Services.ADMIN_USERS, Optional.empty(), "username", username).filter(RESTClient.HTTPResponse::isSuccessful);
                if (resp.isPresent()) {
                    credential = (Credential)Utils.Gson().fromJson(resp.get().body(), Credential.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Optional.ofNullable(credential);
    }

    public boolean addUser(String username, List<String> roles, String password) {
        boolean succedeed = false;
        if (this.checkAuthentication()) {
            try {
                Credential credential = new Credential();
                credential.setPwd(password);
                credential.setRoles(roles);
                credential.setUsername(username);
                JsonObject jsonElement = new Gson().toJsonTree((Object)credential).getAsJsonObject();
                succedeed = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.POST, RESTClient.Services.ADMIN_USERS, Optional.of(jsonElement), "username", username).filter(RESTClient.HTTPResponse::isSuccessful).isPresent();
                if (succedeed) {
                    System.out.println("OK - User created.");
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return succedeed;
    }

    public boolean changePwd(String username, String password) {
        boolean succedeed = false;
        if (this.checkAuthentication()) {
            try {
                JsonElement jsonElement = Utils.Gson().toJsonTree((Object)password);
                succedeed = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.POST, RESTClient.Services.ADMIN_USERS_CHANGEPWD, Optional.of(jsonElement), "username", username).filter(RESTClient.HTTPResponse::isSuccessful).isPresent();
                if (succedeed) {
                    System.out.println("OK -Password changed.");
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return succedeed;
    }

    public boolean changeRoles(String username, String ... roles) {
        boolean succedeed = false;
        if (this.checkAuthentication()) {
            try {
                JsonElement jsonElement = Utils.Gson().toJsonTree((Object)roles);
                succedeed = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.POST, RESTClient.Services.ADMIN_USERS_CHANGEROLES, Optional.of(jsonElement), "username", username).filter(RESTClient.HTTPResponse::isSuccessful).isPresent();
                if (succedeed) {
                    System.out.println("OK - Roles changed.");
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return succedeed;
    }

    public boolean deleteUser(String username) {
        boolean succedeed = false;
        if (this.checkAuthentication()) {
            try {
                succedeed = this.rest().sendRequest(this.token, RESTClient.HTTPMethod.DELETE, RESTClient.Services.ADMIN_USERS, Optional.empty(), "username", username).filter(RESTClient.HTTPResponse::isSuccessful).isPresent();
                if (succedeed) {
                    System.out.println("OK - User ".concat(username).concat(" deleted."));
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return succedeed;
    }

    public class Pairs {
        private List<String> values = new LinkedList<String>();

        public Pairs(String ... values) {
            if (values.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters must be a pair of name and value. ");
            }
            Stream.of(values).forEach(this.values::add);
        }

        public void add(String k, String v) {
            this.values.add(k);
            this.values.add(v);
        }

        public String[] toArray() {
            return this.values.toArray(new String[this.values.size()]);
        }
    }

    public class Credential {
        private String username;
        private String pwd;
        private List<String> roles;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPwd() {
            return this.pwd;
        }

        public void setPwd(String pwd) {
            this.pwd = pwd;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }
    }
}

