/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import org.bouncycastle.jcajce.spec.XDHParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;

public class KeyPairGeneratorSpi
extends java.security.KeyPairGeneratorSpi {
    private static final int EdDSA = -1;
    private static final int XDH = -2;
    private static final int Ed448 = 0;
    private static final int Ed25519 = 1;
    private static final int X448 = 2;
    private static final int X25519 = 3;
    private int algorithm;
    private AsymmetricCipherKeyPairGenerator generator;
    private boolean initialised;
    private SecureRandom secureRandom;

    KeyPairGeneratorSpi(int algorithm, AsymmetricCipherKeyPairGenerator generator) {
        this.algorithm = algorithm;
        this.generator = generator;
    }

    @Override
    public void initialize(int strength, SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        block0 : switch (strength) {
            case 255: 
            case 256: {
                switch (this.algorithm) {
                    case -1: 
                    case 1: {
                        this.setupGenerator(1);
                        break block0;
                    }
                    case -2: 
                    case 3: {
                        this.setupGenerator(3);
                        break block0;
                    }
                }
                throw new InvalidParameterException("key size not configurable");
            }
            case 448: {
                switch (this.algorithm) {
                    case -1: 
                    case 0: {
                        this.setupGenerator(0);
                        break block0;
                    }
                    case -2: 
                    case 2: {
                        this.setupGenerator(2);
                        break block0;
                    }
                }
                throw new InvalidParameterException("key size not configurable");
            }
            default: {
                throw new InvalidParameterException("unknown key size");
            }
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec paramSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.secureRandom = secureRandom;
        if (paramSpec instanceof ECGenParameterSpec) {
            this.initializeGenerator(((ECGenParameterSpec)paramSpec).getName());
        } else if (paramSpec instanceof ECNamedCurveGenParameterSpec) {
            this.initializeGenerator(((ECNamedCurveGenParameterSpec)paramSpec).getName());
        } else if (paramSpec instanceof EdDSAParameterSpec) {
            this.initializeGenerator(((EdDSAParameterSpec)paramSpec).getCurveName());
        } else if (paramSpec instanceof XDHParameterSpec) {
            this.initializeGenerator(((XDHParameterSpec)paramSpec).getCurveName());
        } else {
            String name = ECUtil.getNameFrom(paramSpec);
            if (name != null) {
                this.initializeGenerator(name);
            } else {
                throw new InvalidAlgorithmParameterException("invalid parameterSpec: " + paramSpec);
            }
        }
    }

    private void algorithmCheck(int algorithm) throws InvalidAlgorithmParameterException {
        if (this.algorithm != algorithm) {
            if (this.algorithm == 1 || this.algorithm == 0) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == -1 && algorithm != 1 && algorithm != 0) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == 3 || this.algorithm == 2) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == -2 && algorithm != 3 && algorithm != 2) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            this.algorithm = algorithm;
        }
    }

    private void initializeGenerator(String name) throws InvalidAlgorithmParameterException {
        if (name.equalsIgnoreCase("Ed448") || name.equals(EdECObjectIdentifiers.id_Ed448.getId())) {
            this.algorithmCheck(0);
            this.generator = new Ed448KeyPairGenerator();
            this.setupGenerator(0);
        } else if (name.equalsIgnoreCase("Ed25519") || name.equals(EdECObjectIdentifiers.id_Ed25519.getId())) {
            this.algorithmCheck(1);
            this.generator = new Ed25519KeyPairGenerator();
            this.setupGenerator(1);
        } else if (name.equalsIgnoreCase("X448") || name.equals(EdECObjectIdentifiers.id_X448.getId())) {
            this.algorithmCheck(2);
            this.generator = new X448KeyPairGenerator();
            this.setupGenerator(2);
        } else if (name.equalsIgnoreCase("X25519") || name.equals(EdECObjectIdentifiers.id_X25519.getId())) {
            this.algorithmCheck(3);
            this.generator = new X25519KeyPairGenerator();
            this.setupGenerator(3);
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.generator == null) {
            throw new IllegalStateException("generator not correctly initialized");
        }
        if (!this.initialised) {
            this.setupGenerator(this.algorithm);
        }
        AsymmetricCipherKeyPair kp = this.generator.generateKeyPair();
        switch (this.algorithm) {
            case 0: {
                return new KeyPair(new BCEdDSAPublicKey(kp.getPublic()), new BCEdDSAPrivateKey(kp.getPrivate()));
            }
            case 1: {
                return new KeyPair(new BCEdDSAPublicKey(kp.getPublic()), new BCEdDSAPrivateKey(kp.getPrivate()));
            }
            case 2: {
                return new KeyPair(new BCXDHPublicKey(kp.getPublic()), new BCXDHPrivateKey(kp.getPrivate()));
            }
            case 3: {
                return new KeyPair(new BCXDHPublicKey(kp.getPublic()), new BCXDHPrivateKey(kp.getPrivate()));
            }
        }
        throw new IllegalStateException("generator not correctly initialized");
    }

    private void setupGenerator(int algorithm) {
        this.initialised = true;
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        switch (algorithm) {
            case 0: {
                this.generator.init((KeyGenerationParameters)new Ed448KeyGenerationParameters(this.secureRandom));
                break;
            }
            case -1: 
            case 1: {
                this.generator.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(this.secureRandom));
                break;
            }
            case 2: {
                this.generator.init((KeyGenerationParameters)new X448KeyGenerationParameters(this.secureRandom));
                break;
            }
            case -2: 
            case 3: {
                this.generator.init((KeyGenerationParameters)new X25519KeyGenerationParameters(this.secureRandom));
            }
        }
    }

    public static final class X25519
    extends KeyPairGeneratorSpi {
        public X25519() {
            super(3, (AsymmetricCipherKeyPairGenerator)new X25519KeyPairGenerator());
        }
    }

    public static final class X448
    extends KeyPairGeneratorSpi {
        public X448() {
            super(2, (AsymmetricCipherKeyPairGenerator)new X448KeyPairGenerator());
        }
    }

    public static final class XDH
    extends KeyPairGeneratorSpi {
        public XDH() {
            super(-2, null);
        }
    }

    public static final class Ed25519
    extends KeyPairGeneratorSpi {
        public Ed25519() {
            super(1, (AsymmetricCipherKeyPairGenerator)new Ed25519KeyPairGenerator());
        }
    }

    public static final class Ed448
    extends KeyPairGeneratorSpi {
        public Ed448() {
            super(0, (AsymmetricCipherKeyPairGenerator)new Ed448KeyPairGenerator());
        }
    }

    public static final class EdDSA
    extends KeyPairGeneratorSpi {
        public EdDSA() {
            super(-1, null);
        }
    }
}

