/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import jdk.internal.jimage.ImageReader;
import jdk.internal.jrtfs.ExplodedImage;

abstract class SystemImage {
    static final String RUNTIME_HOME;
    static final Path moduleImageFile;
    static final boolean modulesImageExists;
    static final Path explodedModulesDir;

    SystemImage() {
    }

    abstract ImageReader.Node findNode(String var1) throws IOException;

    abstract byte[] getResource(ImageReader.Node var1) throws IOException;

    abstract void close() throws IOException;

    static SystemImage open() throws IOException {
        if (modulesImageExists) {
            final ImageReader image = ImageReader.open(moduleImageFile);
            image.getRootDirectory();
            return new SystemImage(){

                @Override
                ImageReader.Node findNode(String path) throws IOException {
                    return image.findNode(path);
                }

                @Override
                byte[] getResource(ImageReader.Node node) throws IOException {
                    return image.getResource(node);
                }

                @Override
                void close() throws IOException {
                    image.close();
                }
            };
        }
        if (Files.notExists(explodedModulesDir, new LinkOption[0])) {
            throw new FileSystemNotFoundException(explodedModulesDir.toString());
        }
        return new ExplodedImage(explodedModulesDir);
    }

    private static String findHome() {
        CodeSource cs = SystemImage.class.getProtectionDomain().getCodeSource();
        if (cs == null) {
            return System.getProperty("java.home");
        }
        URL url = cs.getLocation();
        if (!url.getProtocol().equalsIgnoreCase("file")) {
            throw new InternalError(url + " loaded in unexpected way");
        }
        try {
            Path lib = Paths.get(url.toURI()).getParent();
            if (!lib.getFileName().toString().equals("lib")) {
                throw new InternalError(url + " unexpected path");
            }
            return lib.getParent().toString();
        }
        catch (URISyntaxException e) {
            throw new InternalError(e);
        }
    }

    static {
        PrivilegedAction<String> pa = SystemImage::findHome;
        RUNTIME_HOME = AccessController.doPrivileged(pa);
        FileSystem fs = FileSystems.getDefault();
        moduleImageFile = fs.getPath(RUNTIME_HOME, "lib", "modules");
        explodedModulesDir = fs.getPath(RUNTIME_HOME, "modules");
        modulesImageExists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Files.isRegularFile(moduleImageFile, new LinkOption[0]);
            }
        });
    }
}

