/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.arubasign.tabview;

import esecurity.desktop.Region;
import esecurity.desktop.View;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.swt.DragAndDropInnerArea;
import it.arubapec.arubasign.gui.DropdownEntry;
import it.arubapec.arubasign.tabview.Tab;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class TabSection {
    private final String name;
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final DOMElement parent;
    private final View view;
    private DivContainer buttonsContainer;
    private DivContainer tabContentContainer;
    private List<DropdownEntry> dropdownToHide;
    private String visibleTab = "";

    public TabSection(String name, DOMElement parent, View view, List<DropdownEntry> dropdownToHide) {
        this.name = name;
        this.parent = parent;
        this.view = view;
        this.dropdownToHide = dropdownToHide;
        this.init();
    }

    private void init() {
        this.buttonsContainer = new DivContainer("buttonsContainer_" + this.name, this.parent, this.view);
        this.buttonsContainer.addClass("as_buttonsContainer");
        this.tabContentContainer = new DivContainer("tabContentContainer_" + this.name, this.parent, this.view);
        this.tabContentContainer.addClass("as_tabContentContainer");
    }

    public List<Tab> getTabSectionList() {
        return this.tabs;
    }

    public void removeTab(Tab tab) {
        if (this.tabs.contains(tab)) {
            this.tabs.remove(tab);
            this.view.removeDragAndDropInnerArea(tab.getDragAndDropInnerArea());
            tab.getButton().remove();
            tab.getContent().remove();
            for (Tab t : this.tabs) {
                t.getDragAndDropInnerArea().setArea(t.getButton().getBoundingClientRect());
            }
        }
    }

    public void addTab(Tab tab, String nameToShow, List<String> JSFunctionsToExecute) {
        if (!this.tabs.contains(tab)) {
            this.tabs.add(tab);
            Button tabButton = new Button(tab.getName() + "_button", (DOMElement)this.buttonsContainer, this.view, () -> nameToShow);
            tab.setTabButton(tabButton);
            tabButton.addClass("tabs_tablinks");
            DivContainer divContainer = new DivContainer(tab.getName() + "_div", (DOMElement)this.tabContentContainer, this.view);
            divContainer.addClass("tabs_tabcontent");
            tab.setDivContainer(divContainer);
            tab.setActive(false, this.dropdownToHide);
            divContainer.setInnerPageFragment(tab.getController());
            tab.getButton().onClick(evt -> {
                tab.setActive(true, this.dropdownToHide);
                this.visibleTab = tab.getName();
                for (Tab tabToHide : this.tabs) {
                    if (tab.equals(tabToHide)) continue;
                    tabToHide.setActive(false, this.dropdownToHide);
                }
                if (JSFunctionsToExecute != null) {
                    for (String func : JSFunctionsToExecute) {
                        this.view.execute(func);
                    }
                }
            });
            DragAndDropInnerArea dropInnerArea = new DragAndDropInnerArea(tabButton.getBoundingClientRect(), obj -> {
                tab.setActive(true, this.dropdownToHide);
                this.visibleTab = tab.getName();
                for (Tab tabToHide : this.tabs) {
                    if (tab.equals(tabToHide)) continue;
                    tabToHide.setActive(false, this.dropdownToHide);
                    tabToHide.getController().onDragLeave();
                }
                tab.getController().onDragEnter();
            }, null, null);
            this.view.addDragAndDropInnerArea(dropInnerArea);
            tab.setDragAndDropInnerArea(dropInnerArea);
            for (int i = 0; i < this.tabs.size(); ++i) {
                int marginRight = 0;
                int marginLeft = 0;
                if (i == 0 || i != this.tabs.size() - 1) {
                    marginRight = 5;
                }
                if (i == this.tabs.size() - 1 || i != 0) {
                    marginLeft = 5;
                }
                Button tabBtn = this.tabs.get(i).getButton();
                tabBtn.setStyle("margin", "0px " + marginRight + "px 0px " + marginLeft + "px");
                if (i == 0) {
                    this.tabs.get(i).getDragAndDropInnerArea().setOnResizeView(obj -> {
                        Region area = obj.getArea();
                        area.setWidth((int)((double)area.getWidth() * obj.getResizeRatio().getX()));
                    });
                } else {
                    this.tabs.get(i).getDragAndDropInnerArea().setOnResizeView(obj -> {
                        Region area = obj.getArea();
                        Point2D resizeRatio = obj.getResizeRatio();
                        area.setWidth((int)((double)area.getWidth() * resizeRatio.getX()));
                        area.setX((int)((double)area.getX() * resizeRatio.getX()));
                    });
                }
                this.tabs.get(i).getDragAndDropInnerArea().setArea(tabBtn.getBoundingClientRect());
            }
        }
    }

    public void show(String tabName) {
        for (Tab tab : this.tabs) {
            if (tab.getName().equals(tabName)) {
                tab.setActive(true, this.dropdownToHide);
                this.visibleTab = tab.getName();
                continue;
            }
            tab.setActive(false, this.dropdownToHide);
        }
    }

    public Tab getTabByName(String tabName) {
        for (Tab tab : this.tabs) {
            if (!tab.getName().equals(tabName)) continue;
            return tab;
        }
        return null;
    }

    public String getVisibleTab() {
        return this.visibleTab;
    }

    public void setAttribute(String attribute, String value) {
        this.buttonsContainer.setAttribute(attribute, value);
    }
}

