/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11;

import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final int CLASS = 0;
    public static final int TOKEN = 1;
    public static final int PRIVATE = 2;
    public static final int LABEL = 3;
    public static final int APPLICATION = 16;
    public static final int VALUE = 17;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int ISSUER = 129;
    public static final int SERIAL_NUMBER = 130;
    public static final int KEY_TYPE = 256;
    public static final int SUBJECT = 257;
    public static final int ID = 258;
    public static final int SENSITIVE = 259;
    public static final int ENCRYPT = 260;
    public static final int DECRYPT = 261;
    public static final int WRAP = 262;
    public static final int UNWRAP = 263;
    public static final int SIGN = 264;
    public static final int SIGN_RECOVER = 265;
    public static final int VERIFY = 266;
    public static final int VERIFY_RECOVER = 267;
    public static final int DERIVE = 268;
    public static final int START_DATE = 272;
    public static final int END_DATE = 273;
    public static final int MODULUS = 288;
    public static final int MODULUS_BITS = 289;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PRIME_1 = 292;
    public static final int PRIME_2 = 293;
    public static final int EXPONENT_1 = 294;
    public static final int EXPONENT_2 = 295;
    public static final int COEFFICIENT = 296;
    public static final int PRIME = 304;
    public static final int SUBPRIME = 305;
    public static final int BASE = 306;
    public static final int VALUE_BITS = 352;
    public static final int VALUE_LEN = 353;
    public static final int EXTRACTABLE = 354;
    public static final int LOCAL = 355;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int MODIFIABLE = 368;
    public static final int COPYABLE = 369;
    public static final int DESTROYABLE = 370;
    public static final int ECDSA_PARAMS = 384;
    public static final int EC_POINT = 385;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int INVALID = -1;
    public static final Integer DATA = 0;
    public static final Integer CERTIFICATE = 1;
    public static final Integer PUBLIC_KEY = 2;
    public static final Integer PRIVATE_KEY = 3;
    public static final Integer SECRET_KEY = 4;
    public static final Integer RSA;
    public static final Integer DSA;
    public static final Integer DH;
    public static final Integer ECDSA;
    public static final Integer MAYFLY;
    public static final Integer KEA;
    public static final Integer GENERIC_SECRET;
    public static final Integer RC2;
    public static final Integer RC4;
    public static final Integer DES;
    public static final Integer DES2;
    public static final Integer DES3;
    public static final Integer CAST;
    public static final Integer CAST3;
    public static final Integer CAST5;
    public static final Integer CAST128;
    public static final Integer RC5;
    public static final Integer IDEA;
    public static final Integer SKIPJACK;
    public static final Integer BATON;
    public static final Integer JUNIPER;
    public static final Integer CDMF;
    public static final Integer X_509;
    public static final Boolean TRUE;
    public static final Boolean FALSE;
    private static final String[] a;
    private static final int[] b;
    private static final String[] c;
    private static final Class[] d;
    private static final Integer[] e;
    private static final String[] f;
    private static final char[] g;

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract int size() throws PKCS11Exception;

    public Object[] getAttributeValues(int[] nArray) throws PKCS11Exception {
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.getAttributeValue(nArray[i]);
        }
        return objectArray;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public boolean getBoolAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != Boolean.class) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(n);
    }

    public int getIntAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != Integer.class) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(n);
    }

    public String getStringAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != String.class) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(n);
    }

    public byte[] getByteArrayAttributeValue(int n) throws PKCS11Exception {
        Class<byte[]> clazz = byte[].class;
        if (PKCS11Object.valueClass(n) != clazz) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(n);
    }

    public Date getDateAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != Date.class) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(n);
    }

    public BigInteger getBigIntegerAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != BigInteger.class) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(n);
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public void setBoolAttributeValue(int n, boolean bl) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != Boolean.class) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n, bl);
    }

    public void setIntAttributeValue(int n, int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != Integer.class) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n, n2);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = "                    ";
        stringBuffer.append("object:\n");
        for (n = 0; n < 45; ++n) {
            String string2;
            String string3;
            block5: {
                Object object;
                int n2 = b[n];
                string3 = PKCS11Object.typeToString(n2);
                string2 = null;
                try {
                    object = this.getAttributeValue(n2);
                    string2 = PKCS11Object.attrToString(n2, object);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    object = pKCS11Exception;
                    if (pKCS11Exception.getCode() != 17) break block5;
                    string2 = "(ATTRIBUTE_SENSITIVE)";
                }
            }
            if (string2 == null) continue;
            stringBuffer.append("\t").append(string3).append(":");
            stringBuffer.append(string.substring(string3.length()));
            stringBuffer.append(string2).append("\n");
        }
        try {
            n = this.size();
            stringBuffer.append("\tSIZE:").append(string.substring(4)).append(n).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {}
        return stringBuffer.toString();
    }

    public static Class valueClass(int n) {
        for (int i = 0; i < 45; ++i) {
            if (b[i] != n) continue;
            return d[i];
        }
        return null;
    }

    public static String typeToString(int n) {
        for (int i = 0; i < 45; ++i) {
            if (b[i] != n) continue;
            return c[i];
        }
        return "0x" + Integer.toString(n, 16);
    }

    public static String classToString(Integer n) {
        int n2 = n;
        if (n2 >= 0 && n2 < 5) {
            return a[n2];
        }
        return "0x" + Integer.toString(n2, 16);
    }

    public static String keyToString(Integer n) {
        int n2 = n;
        for (int i = 0; i < 21; ++i) {
            if (e[i] != n2) continue;
            return f[i];
        }
        return "0x" + Integer.toHexString(n2);
    }

    public static String certToString(Integer n) {
        if (n.equals(X_509)) {
            return "X_509";
        }
        return n.toString();
    }

    public static String attrToString(int n, Object object) {
        if (object == null) {
            return "null";
        }
        switch (n) {
            case 0: {
                return PKCS11Object.classToString((Integer)object);
            }
            case 256: {
                return PKCS11Object.keyToString((Integer)object);
            }
            case 128: {
                return PKCS11Object.certToString((Integer)object);
            }
            case 17: 
            case 129: 
            case 130: 
            case 257: 
            case 258: {
                return PKCS11Object.bytesToString((byte[])object, 10);
            }
            case 288: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 304: 
            case 305: 
            case 306: {
                return "0x" + ((BigInteger)object).toString(16);
            }
        }
        return object.toString();
    }

    public static String bytesToString(byte[] byArray, int n) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (n != 0 && n3 > n) {
                stringBuffer.append(" ... (").append(byArray.length).append(" bytes)");
                break;
            }
            if (n2 == 16) {
                stringBuffer.append('\n');
                n2 = 0;
            }
            if (n2 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(g[byArray[n3] >> 4 & 0xF]);
            stringBuffer.append(g[byArray[n3] & 0xF]);
            ++n3;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String docuTable() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("  * <TABLE BORDER RULES=ALL CELLPADDING=3>\n");
        stringBuffer.append("  * <TR> <TH> attribute type     <TH> object type\n");
        for (int i = 0; i < 45; ++i) {
            String string;
            String string2 = d[i].getName();
            if (string2.endsWith("[B")) {
                string = "byte[]";
            } else {
                String string3 = string2;
                string = string3.substring(string3.lastIndexOf(46) + 1);
            }
            string2 = string;
            stringBuffer.append("  * <TR> <TD> <TT>").append(c[i]);
            stringBuffer.append("</TT> <TD> <TT>").append(string2).append("</TT>\n");
        }
        stringBuffer.append("  * </TABLE> <P>\n");
        return stringBuffer.toString();
    }

    static {
        CAST128 = 24;
        X_509 = 0;
        a = new String[]{"DATA", "CERTIFICATE", "PUBLIC_KEY", "PRIVATE_KEY", "SECRET_KEY"};
        b = new int[]{0, 1, 2, 3, 16, 17, 128, 129, 130, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 272, 273, 288, 289, 290, 291, 292, 293, 294, 295, 296, 304, 305, 306, 352, 353, 354, 355, 356, 357, 368, 384, 385};
        c = new String[]{"CLASS", "TOKEN", "PRIVATE", "LABEL", "APPLICATION", "VALUE", "CERTIFICATE_TYPE", "ISSUER", "SERIAL_NUMBER", "KEY_TYPE", "SUBJECT", "ID", "SENSITIVE", "ENCRYPT", "DECRYPT", "WRAP", "UNWRAP", "SIGN", "SIGN_RECOVER", "VERIFY", "VERIFY_RECOVER", "DERIVE", "START_DATE", "END_DATE", "MODULUS", "MODULUS_BITS", "PUBLIC_EXPONENT", "PRIVATE_EXPONENT", "PRIME_1", "PRIME_2", "EXPONENT_1", "EXPONENT_2", "COEFFICIENT", "PRIME", "SUBPRIME", "BASE", "VALUE_BITS", "VALUE_LEN", "EXTRACTABLE", "LOCAL", "NEVER_EXTRACTABLE", "ALWAYS_SENSITIVE", "MODIFIABLE", "ECDSA_PARAMS", "EC_POINT"};
        f = new String[]{"RSA", "DSA", "DH", "ECDSA", "MAYFLY", "KEA", "GENERIC_SECRET", "RC2", "RC4", "DES", "DES2", "DES3", "CAST", "CAST3", "CAST5", "RC5", "IDEA", "SKIPJACK", "BATON", "JUNIPER", "CDMF"};
        g = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        RSA = 0;
        DSA = 1;
        DH = 2;
        ECDSA = 3;
        MAYFLY = 4;
        KEA = 5;
        GENERIC_SECRET = 16;
        RC2 = 17;
        RC4 = 18;
        DES = 19;
        DES2 = 20;
        DES3 = 21;
        CAST = 22;
        CAST3 = 23;
        CAST5 = 24;
        RC5 = 25;
        IDEA = 26;
        SKIPJACK = 27;
        BATON = 28;
        JUNIPER = 29;
        CDMF = 30;
        TRUE = Boolean.TRUE;
        FALSE = Boolean.FALSE;
        d = new Class[]{Integer.class, Boolean.class, Boolean.class, String.class, String.class, byte[].class, Integer.class, byte[].class, byte[].class, Integer.class, byte[].class, byte[].class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Date.class, Date.class, BigInteger.class, Integer.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, byte[].class, byte[].class};
        e = new Integer[]{RSA, DSA, DH, ECDSA, MAYFLY, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF};
    }
}

