/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11;

import it.actalis.ellips.capi.core.CapiException;

public class PKCS11Exception
extends RuntimeException {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HOST_MEMORY = 2;
    public static final int SLOT_ID_INVALID = 3;
    public static final int GENERAL_ERROR = 5;
    public static final int FUNCTION_FAILED = 6;
    public static final int ARGUMENTS_BAD = 7;
    public static final int NO_EVENT = 8;
    public static final int NEED_TO_CREATE_THREADS = 9;
    public static final int CANT_LOCK = 10;
    public static final int ATTRIBUTE_READ_ONLY = 16;
    public static final int ATTRIBUTE_SENSITIVE = 17;
    public static final int ATTRIBUTE_TYPE_INVALID = 18;
    public static final int ATTRIBUTE_VALUE_INVALID = 19;
    public static final int DATA_INVALID = 32;
    public static final int DATA_LEN_RANGE = 33;
    public static final int DEVICE_ERROR = 48;
    public static final int DEVICE_MEMORY = 49;
    public static final int DEVICE_REMOVED = 50;
    public static final int ENCRYPTED_DATA_INVALID = 64;
    public static final int ENCRYPTED_DATA_LEN_RANGE = 65;
    public static final int FUNCTION_CANCELED = 80;
    public static final int FUNCTION_NOT_PARALLEL = 81;
    public static final int FUNCTION_PARALLEL = 82;
    public static final int FUNCTION_NOT_SUPPORTED = 84;
    public static final int KEY_HANDLE_INVALID = 96;
    public static final int KEY_SIZE_RANGE = 98;
    public static final int KEY_TYPE_INCONSISTENT = 99;
    public static final int KEY_NOT_NEEDED = 100;
    public static final int KEY_CHANGED = 101;
    public static final int KEY_NEEDED = 102;
    public static final int KEY_INDIGESTIBLE = 103;
    public static final int KEY_FUNCTION_NOT_PERMITTED = 104;
    public static final int KEY_NOT_WRAPPABLE = 105;
    public static final int KEY_UNEXTRACTABLE = 106;
    public static final int MECHANISM_INVALID = 112;
    public static final int MECHANISM_PARAM_INVALID = 113;
    public static final int OBJECT_HANDLE_INVALID = 130;
    public static final int OPERATION_ACTIVE = 144;
    public static final int OPERATION_NOT_INITIALIZED = 145;
    public static final int PIN_INCORRECT = 160;
    public static final int PIN_INVALID = 161;
    public static final int PIN_LEN_RANGE = 162;
    public static final int PIN_EXPIRED = 163;
    public static final int PIN_LOCKED = 164;
    public static final int SESSION_CLOSED = 176;
    public static final int SESSION_COUNT = 177;
    public static final int SESSION_EXCLUSIVE_EXISTS = 178;
    public static final int SESSION_HANDLE_INVALID = 179;
    public static final int SESSION_PARALLEL_NOT_SUPPORTED = 180;
    public static final int SESSION_READ_ONLY = 181;
    public static final int SESSION_EXISTS = 182;
    public static final int SESSION_READ_ONLY_EXISTS = 183;
    public static final int SESSION_READ_WRITE_SO_EXISTS = 184;
    public static final int SIGNATURE_INVALID = 192;
    public static final int SIGNATURE_LEN_RANGE = 193;
    public static final int TEMPLATE_INCOMPLETE = 208;
    public static final int TEMPLATE_INCONSISTENT = 209;
    public static final int TOKEN_NOT_PRESENT = 224;
    public static final int TOKEN_NOT_RECOGNIZED = 225;
    public static final int TOKEN_WRITE_PROTECTED = 226;
    public static final int UNWRAPPING_KEY_HANDLE_INVALID = 240;
    public static final int UNWRAPPING_KEY_SIZE_RANGE = 241;
    public static final int UNWRAPPING_KEY_TYPE_INCONSISTENT = 242;
    public static final int USER_ALREADY_LOGGED_IN = 256;
    public static final int USER_NOT_LOGGED_IN = 257;
    public static final int USER_PIN_NOT_INITIALIZED = 258;
    public static final int USER_TYPE_INVALID = 259;
    public static final int USER_ANOTHER_ALREADY_LOGGED_IN = 260;
    public static final int USER_TOO_MANY_TYPES = 261;
    public static final int WRAPPED_KEY_INVALID = 272;
    public static final int WRAPPED_KEY_LEN_RANGE = 274;
    public static final int WRAPPING_KEY_HANDLE_INVALID = 275;
    public static final int WRAPPING_KEY_SIZE_RANGE = 276;
    public static final int WRAPPING_KEY_TYPE_INCONSISTENT = 277;
    public static final int RANDOM_SEED_NOT_SUPPORTED = 288;
    public static final int RANDOM_NO_RNG = 289;
    public static final int INSERTION_CALLBACK_SET = 320;
    public static final int INSERTION_CALLBACK_NOT_SUPPORTED = 321;
    public static final int BUFFER_TOO_SMALL = 336;
    public static final int SAVED_STATE_INVALID = 352;
    public static final int INFORMATION_SENSITIVE = 368;
    public static final int STATE_UNSAVEABLE = 384;
    public static final int CRYPTOKI_NOT_INITIALIZED = 400;
    public static final int CRYPTOKI_ALREADY_INITIALIZED = 401;
    public static final int MUTEX_BAD = 416;
    public static final int MUTEX_NOT_LOCKED = 417;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    private static int[] a = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 16, 17, 18, 19, 32, 33, 48, 49, 50, 64, 65, 80, 81, 82, 84, 96, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 130, 144, 145, 160, 161, 162, 163, 164, 176, 177, 178, 179, 180, 181, 182, 183, 184, 192, 193, 208, 209, 224, 225, 226, 240, 241, 242, 256, 257, 258, 259, 260, 261, 272, 274, 275, 276, 277, 288, 289, 320, 321, 336, 352, 368, 384, 400, 401, 416, 417, Integer.MIN_VALUE};
    private static String[] b = new String[]{"Function has completed successfully", "Function should be canceled", "Not enough memory on host", "Slot ID is invalid", "Unrecoverable error", "The requested function could not be performed", "Supplied arguments not appropriate", "No new events available", "Native thread support required", "Locking not available", "Attribute is read-only", "Attribute is sensitive and cannot be revealed", "Attribute type is invalid", "Attribute value is invalid", "Data is invalid", "Invalid data length", "Device error", "Not enough memory on device", "Device has been removed", "Encrypted data is invalid", "Encrypted data length is out of range", "Function has been canceled", "No function is executing in parallel", "Function is executing in parallel", "The requested function is not supported", "Key handle is invalid", "Key size is out of range", "Key type is inconsistent with mechanism", "Key not needed, extraneous key supplied", "Key has been changed", "Key needed, no key supplied", "The value of the specified key cannot be digested", "Function not permitted for this key", "Key cannot be wrapped", "Key is unextractable", "Mechanism invalid", "Mechanism parameter is invalid", "Object handle is invalid", "Another operation is already active", "Operation has not been initialized", "Pin is incorrect", "New PIN cotains invalid characters", "New PIN length is out of range", "Pin has expired", "Pin is locked", "Session has been closed", "Session limits have been reached", "An exclusive session already exists", "Session handle is invalid", "Parallel execution is not supported", "Session is read-only", "A session with the token is already open", "A read-only session already exists and the SO cannot be logged in", "A read/write SO session already exists and the SO cannot be logged in", "Signature is invalid", "Signature length is out of range", "Template is incomplete", "Template is inconsistent", "Slot does not contain a token", "The token was not recognized", "Token is write-protected", "Unwrapping key handle is invalid", "Unwrapping key size is out of range", "Unwrapping key is inconsistent with mechanism", "A user is already logged in", "A user is not logged in", "The user's PIN has not been initialized", "User type is invalid", "Another user is already logged in", "Too many users logged in", "Wrapped key is invalid", "Wrapped key length is out of range", "Wrapping key handle is invalid", "Wrapping key size is invalid", "Wrapping key type is inconsistent with mechanism", "Random number generator does not accept seeding", "The token does not have a random number generator", "Insertion_CALLBACK_SET", "The slot does not support token insertion callbacks", "Buffer too small", "The saved operations state is invalid and cannot be restored", "The requested information is sensitive and cannot be revealed", "The operations state cannot be saved", "Cryptoki is not yet initialized", "Cryptoki is already initialized", "Mutex object is bad", "Mutex is not locked"};
    private int c;

    public PKCS11Exception(int n, boolean bl) {
        super(PKCS11Exception.a(n, bl));
        this.c = n;
    }

    public PKCS11Exception(int n) {
        this(n, false);
    }

    public PKCS11Exception(String string) {
        super(string);
        this.c = Integer.MIN_VALUE;
    }

    public int getCode() {
        return this.c;
    }

    private static String a(int n, boolean n2) {
        if (n2 != 0 && n >= Integer.MIN_VALUE) {
            return "Vendor defined error (0x" + Integer.toHexString(n) + ")";
        }
        if ((n & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return "Vendor defined error";
        }
        for (n2 = 0; n2 < 87; ++n2) {
            if (a[n2] != n) continue;
            return b[n2];
        }
        return "Unknown error (0x" + Integer.toHexString(n) + ")";
    }

    public CapiException toCapiException() {
        return this.toCapiException(false, false);
    }

    public CapiException toCapiException(boolean bl) {
        return this.toCapiException(bl, false);
    }

    /*
     * WARNING - void declaration
     */
    public CapiException toCapiException(boolean bl, boolean bl2) {
        void var1_45;
        String string;
        switch (this.getCode()) {
            case 176: 
            case 179: 
            case 257: {
                string = "User not logged in";
                int n = 10013;
                break;
            }
            case 50: {
                string = "Token removed";
                int n = 10012;
                break;
            }
            case 224: {
                string = "Token not inserted";
                int n = 10011;
                break;
            }
            case 49: {
                string = "No space on device";
                int n = 10030;
                break;
            }
            case 48: {
                string = "Problem on device";
                int n = 11001;
                break;
            }
            case 16: {
                string = "Cannot modify label";
                int n = 11010;
                break;
            }
            case 17: 
            case 368: {
                string = "Cannot read private data";
                int n = 11011;
                break;
            }
            case 400: {
                string = "Library not initialized";
                int n = 10003;
                break;
            }
            case 182: 
            case 401: {
                string = "Library already init";
                int n = 10002;
                break;
            }
            case 84: {
                string = "Function not supported";
                int n = 11002;
                break;
            }
            case 98: {
                string = "Unsupported key size";
                int n = 10031;
                break;
            }
            case 105: 
            case 106: {
                string = "Cannot extract key";
                int n = 11012;
                break;
            }
            case 112: 
            case 113: {
                string = "Unsupported mechanism";
                int n = 11013;
                break;
            }
            case 163: {
                string = bl ? "Expired PUK" : "Expired PIN";
                int n = bl ? 2010 : 2007;
                break;
            }
            case 160: {
                string = bl ? "Wrong PUK" : "Wrong PIN";
                int n = bl ? 2005 : 2001;
                break;
            }
            case 161: 
            case 162: {
                string = bl ? "Invalid PUK" : "Invalid PIN";
                int n = bl ? 2009 : 2006;
                break;
            }
            case 164: {
                string = bl ? "Locked PUK" : "Locked PIN";
                int n = bl ? 2008 : 2003;
                break;
            }
            case 177: 
            case 256: 
            case 259: 
            case 260: 
            case 261: {
                string = "cannot login";
                int n = 11014;
                break;
            }
            case 3: {
                string = "Invalid slot";
                int n = 11003;
                break;
            }
            case 225: 
            case 226: {
                string = "Token is not valid";
                int n = 11004;
                break;
            }
            case 258: {
                string = "Token is not initialized";
                int n = 10010;
                break;
            }
            case 104: {
                string = "Function not permitted for this type of key";
                int n = 10038;
                break;
            }
            case 32: {
                string = "Data is Invalid";
                int n = 10038;
                break;
            }
            case -2147483136: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_ERR";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483135: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_UNK";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483134: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_CONN";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483133: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_RCV";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483132: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_SND";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483131: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_NOSOCK";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483130: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_ARGS";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483129: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_LIB";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483128: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_MEM";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483127: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_MSGS";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483126: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_TIMEOUT";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483125: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_WND";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483124: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_AGAIN";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483123: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NET_QUIT";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483122: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NO_SERVER";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483121: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NO_CARD_FOUND";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483120: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_REMOTE_CALL_ERROR";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483117: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_INVALID_MAC";
                    int n = this.getCode();
                    break;
                }
            }
            case -2147483116: {
                void var2_46;
                if (var2_46 != false) {
                    string = "AS_VENDOR_NO_MAC_KEY";
                    int n = this.getCode();
                    break;
                }
            }
            default: {
                string = "General error on Token";
                int n = 10040;
            }
        }
        return new CapiException(string, (int)var1_45);
    }
}

