/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ServerToken;
import it.actalis.ellips.capi.provider.pkcs11.ASProvider;
import it.actalis.ellips.capi.provider.pkcs11.AS_PrivateKey;
import it.actalis.ellips.capi.provider.pkcs11.AS_RSACipher;
import it.actalis.pkcs11.PKCS11;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.vol.utils.Constants;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;

public class ASToken
extends ServerToken {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static boolean b = false;
    private static String c = null;
    private static String d = "semaphore for init and destroy";
    private static PKCS11 e = null;
    private PKCS11Slot f = null;
    private PKCS11Session g = null;
    private PKCS11Object h = null;
    private PKCS11Object i = null;
    private PKCS11Object j = null;

    public ASToken(String string) throws CapiException {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void init() throws CapiException {
        if (b) {
            ASToken.a("initializing...");
        }
        String string = d;
        synchronized (string) {
            if (c != null) {
                throw new CapiException("Token already initialized", 10002);
            }
            c = "init done at " + System.currentTimeMillis();
        }
        try {
            try {
                if (b) {
                    ASToken.a("... security provider ...");
                }
                ASProvider aSProvider = new ASProvider();
                TokenSpi.addProvider((Provider)aSProvider, (int)2);
                TokenSpi.addProvider((Provider)new BouncyCastleProvider(), (int)3);
                try {
                    if (b) {
                        ASToken.a("loading library cryptoki");
                    }
                    e = NativePKCS11.getInstance("cryptoki", true);
                    if (b) {
                        ASToken.a("loaded  library");
                    }
                    string = "bridge v" + e.getBridgeVersion();
                    if (b) {
                        ASToken.a(string);
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    a.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode(), (Throwable)pKCS11Exception);
                    throw pKCS11Exception.toCapiException(false, true);
                }
                catch (Exception exception) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Cannot link Library", 11000);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    a.debug(unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
                    throw new CapiException("Cannot link Library", 11000);
                }
                catch (Error error) {
                    a.debug(error.getMessage(), (Throwable)error);
                    throw new CapiException("Cannot link Library", 11000);
                }
                if (b) {
                    ASToken.a("Initialization done.");
                }
                return;
            }
            catch (CapiException capiException) {
                if (b) {
                    ASToken.a("Initialization failed:");
                }
                a.debug(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("initialization failure", 10040);
            }
        }
        catch (Throwable throwable) {
            c = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void destroy() throws CapiException {
        if (b) {
            ASToken.a("destroying...");
        }
        String string = d;
        synchronized (string) {
            if (c != null) {
                try {
                    if (b) {
                        ASToken.a("unloading library...");
                    }
                    ((NativePKCS11)e).unloadLibrary();
                }
                catch (Exception exception) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                catch (Error error) {
                    a.debug(error.getMessage(), (Throwable)error);
                }
                e = null;
                if (b) {
                    ASToken.a("removing provider...");
                }
                TokenSpi.removeProvider((String)"ACTALIS");
            }
            c = null;
        }
        if (b) {
            ASToken.a("done.");
        }
    }

    public final void getRSACred(String string) throws CapiException {
        if (b) {
            this.print("getRSACred");
        }
        if (c == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        this.a(string, true);
    }

    public final void releaseRSACred() throws CapiException {
        if (b) {
            this.print("releaseRSACred");
        }
        if (c == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        try {
            if (this.g != null) {
                this.g.close();
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
        }
        this.f = null;
        this.g = null;
        this.h = null;
        this.i = null;
        this.j = null;
    }

    public final byte[] getRSAKeyCert() throws CapiException {
        try {
            return this.j.getByteArrayAttributeValue(17);
        }
        catch (NullPointerException nullPointerException) {
            a.debug(nullPointerException.getMessage(), (Throwable)nullPointerException);
            throw new CapiException("Object not found", 10022);
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode(), (Throwable)pKCS11Exception);
            throw pKCS11Exception.toCapiException(false, true);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    public final String getCertificate() throws CapiException {
        Object object;
        if (b) {
            this.print("getCertificate");
        }
        if (c == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        try {
            this.a(null, false);
            object = this.getRSAKeyCert();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 10040);
        }
        finally {
            this.releaseRSACred();
        }
        if (object != null) {
            String string = Util.base64EncodeStr((byte[])object);
            object = string;
            return string;
        }
        return null;
    }

    public final String getPublicKeyInfo() throws CapiException {
        Object object;
        if (b) {
            this.print("getPublicKeyInfo");
        }
        if (c == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        try {
            this.a(null, false);
            object = this.getRSAKeyCert();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 10040);
        }
        finally {
            this.releaseRSACred();
        }
        if (object != null) {
            Certificate certificate = new Certificate(object);
            object = certificate;
            return certificate.getSubjectPublicKeyInfo();
        }
        return null;
    }

    public PrivateKey getPrivateKey() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Object not found", 10021);
        }
        return new AS_PrivateKey(this);
    }

    public byte[] doSign(byte[] byArray) throws CapiException {
        if (b) {
            this.print("doSign alias=" + this.thealias);
        }
        if (this.h == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            this.g.signInit(1, null, this.h);
            if (b) {
                this.print("signing RSA LENGTH: in=" + byArray.length);
            }
            byte[] byArray2 = new byte[512];
            int n = this.g.sign(byArray, 0, byArray.length, byArray2, 0);
            if (b) {
                this.print("signed  OK        :  n =" + n);
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            return byArray3;
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode(), (Throwable)pKCS11Exception);
            throw pKCS11Exception.toCapiException(false, true);
        }
    }

    public byte[] doDecrypt(byte[] byArray) throws CapiException {
        if (b) {
            this.print("doDecrypt alias=" + this.thealias);
        }
        if (this.h == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            this.g.decryptInit(1, null, this.h);
            if (b) {
                this.print("LENGTH: in=" + byArray.length);
            }
            byte[] byArray2 = new byte[512];
            int n = this.g.decrypt(byArray, 0, byArray.length, byArray2, 0);
            if (b) {
                this.print("decrypt OK        :  n =" + n);
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            return byArray3;
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode(), (Throwable)pKCS11Exception);
            throw pKCS11Exception.toCapiException(false, true);
        }
    }

    public void print(String string) {
        a.info(System.currentTimeMillis() + ":[ASToken]" + string);
    }

    private static void a(String string) {
        a.info(System.currentTimeMillis() + ":[ASToken]" + string);
    }

    private void a(String pKCS11ObjectArray, boolean bl) throws CapiException {
        if (b) {
            this.print("getRSAcredential");
        }
        try {
            try {
                if (b) {
                    this.print("getting alias:" + this.thealias);
                }
                if ((pKCS11ObjectArray = e.getRSAcredential(this.thealias, 6, (String)(bl ? pKCS11ObjectArray : null))) == null || pKCS11ObjectArray.length != 3) {
                    throw new CapiException("array not found", 10023);
                }
                this.h = pKCS11ObjectArray[0];
                if (bl && this.h == null) {
                    throw new CapiException("private key object not found", 10021);
                }
                this.i = pKCS11ObjectArray[1];
                if (this.i == null) {
                    throw new CapiException("public key object not found", 10021);
                }
                this.j = pKCS11ObjectArray[2];
                if (this.j == null) {
                    throw new CapiException("certificate object not found", 10022);
                }
                this.g = this.j.getSession();
                if (this.g == null) {
                    throw new CapiException("session object not found", 10040);
                }
                this.f = this.g.getSlot();
                if (this.f == null) {
                    throw new CapiException("slot object not found", 10040);
                }
                if (b) {
                    this.print("get alias:" + this.thealias);
                }
                return;
            }
            catch (PKCS11Exception pKCS11Exception) {
                a.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode(), (Throwable)pKCS11Exception);
                throw pKCS11Exception.toCapiException(false, true);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 10040);
            }
        }
        catch (Throwable throwable) {
            this.f = null;
            this.g = null;
            this.h = null;
            this.i = null;
            this.j = null;
            throw throwable;
        }
    }

    public PublicKey getPublicKey() throws CapiException {
        if (b) {
            this.print("getPublicKey...");
        }
        if (this.i == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            if (b) {
                this.print("getting BigInteger Modulus key...");
            }
            Object object = this.i.getBigIntegerAttributeValue(288);
            if (b) {
                this.print("getting BigInteger PubExponent key...");
            }
            Object object2 = this.i.getBigIntegerAttributeValue(290);
            if (b) {
                this.print("RSAPubKey ...");
            }
            object2 = new RSAPublicKeySpec((BigInteger)object, (BigInteger)object2);
            object = KeyFactory.getInstance("RSA");
            object2 = ((KeyFactory)object).generatePublic((KeySpec)object2);
            return object2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode(), (Throwable)pKCS11Exception);
            throw pKCS11Exception.toCapiException(false, true);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    public static void setDebug(boolean bl) {
        b = bl;
        AS_RSACipher.a = bl;
    }
}

