/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.functionality;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.functionality.DecryptFacade$DecryptFacade;
import esecurity.crypto.gui.functionality.DecryptFacade$EncryptFacade;
import esecurity.crypto.gui.functionality.DecryptFacade$ValidationFacade;
import esecurity.crypto.gui.functionality.utzgqpee;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.model.OperationResult;
import esecurity.crypto.gui.model.SignatureRequest;
import esecurity.crypto.gui.model.Status;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.MutableASiCOptions;
import it.actalis.ellips.capi.asic.generator.ASiCGenerator;
import it.actalis.ellips.capi.asic.generator.ASiCGeneratorOptions;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.pades.PadesSignatureGenerator;
import it.actalis.ellips.capi.pades.PadesSignatureOptions;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.SignatureOperation;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.ArubaDTSClient;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.xades.XadesSignatureGenerator;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.capi.xades.exception.XadesModeException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;

public class SignatureFacade {
    private static final EllipsLogger logger = SignatureFacade.rM("1qkrgih", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static Status signatureStatus;

    private static void validate(SignatureRequest request) throws CapiException {
        if (SignatureFacade.rM("oo3gh7", request) == null) {
            char[] cArray = "\uf0bd\u5f02\ue7c1\u9935\u0ef8\u7bed\ubf4c\u3b20\u969a\u1c6f\u6d58\uca4e\u5639\u3d74\u910f\ucc3a\uc97b\ue822\ua0c3\ua1f1\ubfcd\uc2b4\u7c25\uf815\u9d18\u616e".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x2D19);
            throw new CapiException(DecryptFacade$DecryptFacade.H(cArray, (short)27203, 4, (short)4), 1001);
        }
        if (SignatureFacade.rM("-13qqfeq", request) == null) {
            char[] cArray = "\u8287\u69ff\ufc48\u6f82\u2bac\u1b3b\uae1a\u32b4\u2fbd\ue775\u2f58\u4bb6\u7569\ud48e\ufffb\u5aaf\ufae0\u594b\u0592\uface\u2f99".toCharArray();
            cArray[19] = (char)(cArray[19] ^ 0x53BB);
            throw new CapiException(DecryptFacade$DecryptFacade.H(cArray, (short)13931, 4, (short)4), 1001);
        }
        if (SignatureFacade.rM("-1b5afer", request) == null) {
            char[] cArray = "\u42e8\u6f4a\uaafb\ub11d\ud748\u632f\ue6e9\u039c\u8878\u3055\ud0d7\uc934\u2a6a\u0579\u8552\ue490\ue3c5\u0933".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x6022);
            throw new CapiException(DecryptFacade$DecryptFacade.H(cArray, (short)22490, 2, (short)5), 1001);
        }
        if (SignatureFacade.rM("74tgh4", request) == null) {
            char[] cArray = "\u79e4\u4977\ub5b5\ubcc4\u3923\u15dc\u2cc5\ud0b4\u20c6\u951c\u4c1c\uf1e8\ua5cc\u7843\u2241\ua16f\u2325\u6501\u6421\u159c\u2c3e\u0b85\uf6df\u989d\uc55e\uf061\uc2ac\ue6ba\u6768".toCharArray();
            cArray[17] = (char)(cArray[17] ^ 0x3720);
            throw new CapiException(DecryptFacade$DecryptFacade.H(cArray, (short)9429, 1, (short)3), 1001);
        }
        if (SignatureFacade.rM("-1mkoff5", request).isEmpty()) {
            char[] cArray = "\u1a8d\u1bc4\u33c7\ub14d\u2320\u8e76\u6734\ua31b\u5ab2\u9a42\ua6dd\u280f\ufa0e\u690e\u807e\u216c\ueb37\ued5b\u1fb8\u6890\ue338\u4003\ua151\u1db5".toCharArray();
            cArray[20] = (char)(cArray[20] ^ 0x36CD);
            throw new CapiException(DecryptFacade$DecryptFacade.H(cArray, (short)9126, 0, (short)4), 1001);
        }
        if (SignatureFacade.rM("18hjggq", request) == null && SignatureFacade.rM("-upaff7", (Object)SignatureType.ASICE, SignatureFacade.rM("oo3gh7", request)) != false) {
            char[] cArray = "\ud4a5\udf6f\u907f\u24c3\u8d9e\u8dea\ucaa2\ub6d6\ue0e2\u7779\u797c\u09ae\ud992\u8664\u5973\u03e1\u0266\ud86a\u8b6e\u23ed\u3c9f\u43ee\u59f7\u77c5\u3fcd\u0f4e\ud9d0\u841f\u4e3e\uc929\u055c\u04bc\ufaf5\ud6dd\uefac\u47ad\u297a\u9f68\u025b\u5869\u29ae\ue9c2\u21ce\u034b\u5a1f\u6447\ub9b1\u9eb1\ub813\uc174\ue39e\u677d\ub601\u0637\u7406".toCharArray();
            cArray[52] = (char)(cArray[52] ^ 0x710);
            throw new CapiException(DecryptFacade$DecryptFacade.H(cArray, (short)29929, 0, (short)0), 1001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationResult sign(SignatureRequest request) {
        try {
            SignatureFacade.validate(request);
            if (SignatureFacade.rM("vkfggv", SignatureFacade.rM("1hffggo", request), SignatureLevel.LT) != false && SignatureFacade.rM("-2p6ff2", request) == null) {
                char[] cArray = "\ub5e5\u1c9a\uc8c3\u41c4\u5eae$\u3344\udcfe\u4b2d\ueab2\u969c\u4b29\uf851\ua95d\u791b\u7142\uea34\ufa3f\ua825\u7ca9\u772e\ube7a\u2c6f\u1566\u8125\u7724\uf6f7\u857a\u2b0b\ua4db\udd7b\ud618\u19d8\u6407\ubde2\u5626\u1028\u02b4\u7e29\u61f5\u3140\u498e".toCharArray();
                cArray[5] = (char)(cArray[5] ^ 0x4F01);
                OperationResult operationResult = new OperationResult(new Status(StatusLevel.ERROR, DecryptFacade$DecryptFacade.H(cArray, (short)3975, 2, (short)1)), SignatureFacade.rM("-1mkoff5", request), (File)SignatureFacade.rM("1gqtggt", request));
                return operationResult;
            }
            signatureStatus = null;
            boolean withError = false;
            block4 : switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.rM("vjpggj", SignatureFacade.rM("oo3gh7", request))]) {
                case 1: 
                case 2: 
                case 3: {
                    FileToSign file;
                    SignatureOptions signatureOptions = SignatureFacade.getAdesSignatureOptions(request);
                    SignatureGenerator signatureGenerator = SignatureFacade.getAdesSignatureGenerator(request);
                    Iterator iterator = SignatureFacade.rM("-1mkoff5", request).iterator();
                    while (iterator.hasNext()) {
                        file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signAdESDocument(file, request, signatureOptions, signatureGenerator);
                        if (signatureStatus == null || SignatureFacade.rM("1cdbgfh", (Object)StatusLevel.ERROR, SignatureFacade.rM("-f9sffe", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 4: {
                    FileToSign file;
                    SignatureOptions signatureOptions = SignatureFacade.getAdesSignatureOptions(request);
                    SignatureGenerator signatureGenerator = SignatureFacade.getAdesSignatureGenerator(request);
                    Iterator iterator = SignatureFacade.rM("-1mkoff5", request).iterator();
                    while (iterator.hasNext()) {
                        file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signPAdESDocument(file, request, signatureOptions, signatureGenerator);
                        if (signatureStatus == null || SignatureFacade.rM("1cdbgfh", (Object)StatusLevel.ERROR, SignatureFacade.rM("-f9sffe", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 5: {
                    ASiCGenerator asicGenerator = new ASiCGenerator();
                    MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
                    ASiCGeneratorOptions aSiCGeneratorOptions = new ASiCGeneratorOptions();
                    TimeStampOptions tstOpts = SignatureFacade.getAsicTstOptions(request);
                    Iterator iterator = SignatureFacade.rM("-1mkoff5", request).iterator();
                    while (iterator.hasNext()) {
                        FileToSign file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signAsicS(file, request, tstOpts, aSiCGeneratorOptions, mutableASiCOptions, asicGenerator);
                        if (signatureStatus == null || SignatureFacade.rM("1cdbgfh", (Object)StatusLevel.ERROR, SignatureFacade.rM("-f9sffe", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 6: {
                    withError |= SignatureFacade.signAsicE(request);
                    break;
                }
                default: {
                    char[] cArray = "\u6d0a\u90c5\ue3ef\u736c\u3099\uc857\u2d1f\ufd8f\u85c6\ufdf9\u2cba\uff46\u1ab6\ue36b\u1123\ucce0\u6f14\u4949\u9018\ueb0b\u1496\u2262\uaffb\ua494\udd93\u5e7c\u0782\u5934".toCharArray();
                    cArray[23] = (char)(cArray[23] ^ 0x2688);
                    OperationResult operationResult = new OperationResult(new Status(StatusLevel.ERROR, DecryptFacade$DecryptFacade.H(cArray, (short)16161, 0, (short)3)), SignatureFacade.rM("-1mkoff5", request), (File)SignatureFacade.rM("1gqtggt", request));
                    return operationResult;
                }
            }
            if (withError && signatureStatus == null) {
                boolean allError = true;
                Iterator ftsIt = SignatureFacade.rM("-1mkoff5", request).iterator();
                while (ftsIt.hasNext() && allError) {
                    allError = SignatureFacade.rM("1cdbgfh", (Object)StatusLevel.SUCCESS, SignatureFacade.rM("-f9sffe", SignatureFacade.rM("5uvgfg", (FileToSign)ftsIt.next()))) == false;
                }
                signatureStatus = allError ? new Status(StatusLevel.ERROR, "") : new Status(StatusLevel.WARNING, "");
            } else if (signatureStatus == null) {
                signatureStatus = new Status(StatusLevel.SUCCESS, "");
            }
        }
        catch (Throwable ex) {
            SignatureFacade.rM("14vjgjt", logger, SignatureFacade.rM("1j37gk3", ex), (Object)ex);
            signatureStatus = new Status(StatusLevel.ERROR, ex);
        }
        finally {
            SignatureFacade.rM("r8jggs");
        }
        return new OperationResult(signatureStatus, SignatureFacade.rM("-1mkoff5", request), (File)SignatureFacade.rM("1gqtggt", request));
    }

    private static SignatureGenerator getAdesSignatureGenerator(SignatureRequest request) {
        switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.rM("vjpggj", SignatureFacade.rM("oo3gh7", request))]) {
            case 1: 
            case 3: {
                return new CadesSignatureGenerator();
            }
            case 4: {
                return new PadesSignatureGenerator();
            }
            case 2: {
                return new XadesSignatureGenerator();
            }
        }
        return null;
    }

    private static TimeStampOptions getAsicTstOptions(SignatureRequest request) throws IllegalParamException {
        if (SignatureFacade.rM("vkfggv", SignatureFacade.rM("1hffggo", request), SignatureLevel.BES) != false) {
            return null;
        }
        TimeStampOptions tstOpts = new TimeStampOptions();
        SignatureFacade.rM("3nfgfn", tstOpts, true);
        SignatureFacade.rM("1279gfl", tstOpts, new ArubaDTSClient((TSAData)SignatureFacade.rM("-uamfga", request), (NetworkConfig)SignatureFacade.rM("-17qfdo", SignatureFacade.rM("1ehhgi9"))));
        SignatureFacade.rM("-177ufgc", tstOpts, DigestAlgorithm.SHA256);
        SignatureFacade.rM("h9fgfb", tstOpts, "");
        return tstOpts;
    }

    private static SignatureOptions getAdesSignatureOptions(SignatureRequest request) throws IllegalParamException {
        CadesSignatureOptions signatureOptions = null;
        switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.rM("vjpggj", SignatureFacade.rM("oo3gh7", request))]) {
            case 1: 
            case 3: {
                signatureOptions = new CadesSignatureOptions();
                SignatureFacade.rM("1jjjgf9", signatureOptions, SignatureFacade.rM("116fgfa", request));
                break;
            }
            case 4: {
                signatureOptions = new PadesSignatureOptions();
                SignatureFacade.rM("d71gff", (PadesSignatureOptions)signatureOptions, SignatureFacade.rM("-n0gfgo", request));
                break;
            }
            case 2: {
                signatureOptions = new XadesSignatureOptions();
                SignatureFacade.rM("1jjjgf9", signatureOptions, SignatureFacade.rM("116fgfa", request));
            }
        }
        if (SignatureFacade.rM("vkfggv", SignatureFacade.rM("1hffggo", request), SignatureLevel.BES) == false) {
            TimeStampOptions timeStampOptions = new TimeStampOptions();
            SignatureFacade.rM("3nfgfn", timeStampOptions, true);
            SignatureFacade.rM("1279gfl", timeStampOptions, new ArubaDTSClient((TSAData)SignatureFacade.rM("-uamfga", request), (NetworkConfig)SignatureFacade.rM("-17qfdo", SignatureFacade.rM("1ehhgi9"))));
            SignatureFacade.rM("-177ufgc", timeStampOptions, DigestAlgorithm.SHA256);
            SignatureFacade.rM("h9fgfb", timeStampOptions, "");
            SignatureFacade.rM("-1ehqfgi", signatureOptions, timeStampOptions);
            SignatureFacade.rM("-7bcfgj", signatureOptions, SignatureFacade.rM("1hffggo", request));
            if (SignatureFacade.rM("vkfggv", SignatureFacade.rM("1hffggo", request), SignatureLevel.LT) != false) {
                SignatureFacade.rM("1b4hgfc", signatureOptions, SignatureFacade.rM("-2p6ff2", request));
            }
        }
        SignatureFacade.rM("sudgh3", signatureOptions, SignatureFacade.rM("-17qfdo", SignatureFacade.rM("1ehhgi9")));
        SignatureFacade.rM("1pafgh2", signatureOptions, SignatureFacade.rM("-13qqfeq", request));
        SignatureFacade.rM("-jbofdv", signatureOptions, SignatureFacade.rM("-1b5afer", request));
        SignatureFacade.rM("-sbsfe0", signatureOptions, SignatureFacade.rM("74tgh4", request));
        return signatureOptions;
    }

    private static boolean signPAdESDocument(FileToSign file, SignatureRequest request, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        boolean withAppearance;
        boolean withError = false;
        int appearancesCount = 0;
        int i = 0;
        boolean bl = withAppearance = SignatureFacade.rM("-n0kfdp", file) != null && !SignatureFacade.rM("-n0kfdp", file).isEmpty();
        if (withAppearance) {
            appearancesCount = SignatureFacade.rM("-n0kfdp", file).size();
        }
        File destFile = SignatureFacade.createDestinationFile(file, request);
        FileToSign convert = file;
        if (SignatureFacade.rM("1klhgi6", file) != false) {
            Object c = SignatureFacade.rM("aslgi5", file);
            convert = new FileToSign((File)c);
            SignatureFacade.rM("-raefe5", convert, SignatureFacade.rM("1umpgi4", file));
            SignatureFacade.rM("p5dghp", convert, SignatureFacade.rM("-1sm2fe6", file));
            SignatureFacade.rM("-3a2fe1", convert, SignatureFacade.rM("kd5gho", file));
        }
        ArrayDeque toDelete = new ArrayDeque();
        Object fileName = SignatureFacade.rM("-j1afe2", convert);
        do {
            File toDel;
            File tmp;
            block41: {
                if (withAppearance) {
                    SignatureFacade.setUpAppearance((PadesSignatureOptions)signatureOptions, (CapiPDFApparence)SignatureFacade.rM("-n0kfdp", file).get(i));
                }
                tmp = SignatureFacade.rM("rtbght", fileName, SignatureFacade.rM("kd5gho", convert), (FileAttribute[])new FileAttribute[0]).toFile();
                SignatureFacade.rM("gsfghs", toDelete, tmp);
                try {
                    Object ih = SignatureFacade.rM("1bfjghl", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), convert));
                    Throwable throwable = null;
                    try {
                        Object oh = SignatureFacade.rM("t0hghb", SignatureFacade.rM("925ghk", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), tmp), true));
                        Throwable throwable2 = null;
                        try {
                            SignatureFacade.rM("-1hscfed", signatureOptions, ih);
                            SignatureFacade.rM("1gg3ghi", signatureOptions, oh);
                            char[] cArray = "\u6a37\u6c29".toCharArray();
                            cArray[0] = (char)(cArray[0] ^ 0x33E5);
                            SignatureFacade.rM("p5dghp", convert, SignatureFacade.rM("-stufc1", SignatureFacade.rM("1637ggh", destFile), 0, (int)SignatureFacade.rM("-akaffg", SignatureFacade.rM("1637ggh", destFile), DecryptFacade$EncryptFacade.Y(cArray, (short)17039, (short)2, (byte)3))));
                            try {
                                if (SignatureFacade.rM("-1f40ff9", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.rM("177hggm", signatureGenerator, signatureOptions);
                                    if (SignatureFacade.rM("-upaff7", SignatureFacade.rM("oo3gh7", request), (Object)SignatureType.TSD) != false) {
                                        SignatureFacade.rM("f8nghe", SignatureFacade.rM("1ndpggl", signatureOptions));
                                        char[] cArray2 = "\u6a24\ue371\u33c5\ud614\u2f4f\u39ad\uec2f\u85f7\ue303\u79b1\ub261\ue1a9\u64d6\u9cf3\ue981\uc215\u5867\udcae\u888d\u9104\ud7db\u70c8\u4471".toCharArray();
                                        cArray2[16] = (char)(cArray2[16] ^ 0x2EB6);
                                        SignatureFacade.rM("1pppggb", SignatureFacade.rM("1bfjghl", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), tmp)), SignatureFacade.rM("t0hghb", SignatureFacade.rM("925ghk", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), tmp), true)), (Object)SignatureFacade.rM("-uamfga", request), (Object)SignatureFacade.rM("-j1afe2", file), (Object)DecryptFacade$EncryptFacade.Y(cArray2, (short)30427, (short)3, (byte)4), (Object)SignatureFacade.rM("-1h8sffc"), (boolean)false);
                                    }
                                    break block41;
                                }
                                if (SignatureFacade.rM("-1f40ff9", request) == SignatureOperation.COUNTER_SIGN) {
                                    SignatureFacade.rM("-iggffn", signatureOptions, SignatureFacade.rM("jodgga", request));
                                }
                                SignatureFacade.rM("rmjgg8", signatureGenerator, signatureOptions);
                            }
                            catch (XadesModeException e) {
                                if (SignatureFacade.rM("126bggf", (Object)e) == null) {
                                    throw e;
                                }
                                SignatureFacade.rM("1jjjgf9", signatureOptions, SignatureFacade.rM("126bggf", (Object)e));
                                if (SignatureFacade.rM("-1f40ff9", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.rM("177hggm", signatureGenerator, signatureOptions);
                                    break block41;
                                }
                                SignatureFacade.rM("rmjgg8", signatureGenerator, signatureOptions);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (oh != null) {
                                if (throwable2 != null) {
                                    try {
                                        SignatureFacade.rM("f8nghe", oh);
                                    }
                                    catch (Throwable throwable4) {
                                        SignatureFacade.rM("-1bqsfej", throwable2, throwable4);
                                    }
                                } else {
                                    SignatureFacade.rM("f8nghe", oh);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ih != null) {
                            if (throwable != null) {
                                try {
                                    SignatureFacade.rM("-1s44fek", ih);
                                }
                                catch (Throwable throwable6) {
                                    SignatureFacade.rM("-1bqsfej", throwable, throwable6);
                                }
                            } else {
                                SignatureFacade.rM("-1s44fek", ih);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    withError = true;
                    SignatureFacade.rM("14vjgjt", logger, SignatureFacade.rM("1j37gk3", ex), (Object)ex);
                    if (SignatureFacade.isTokenException(ex)) {
                        signatureStatus = new Status(StatusLevel.ERROR, ex);
                    }
                    SignatureFacade.rM("-1n4qffi", file, new Status(StatusLevel.ERROR, ex));
                }
            }
            if (SignatureFacade.rM("5uvgfg", file) == null) {
                char[] cArray = "\u6e5b\ueea1\u295c".toCharArray();
                cArray[1] = (char)(cArray[1] ^ 0x32F2);
                SignatureFacade.rM("-1n4qffi", file, new Status(StatusLevel.SUCCESS, DecryptFacade$EncryptFacade.Y(cArray, (short)21317, (short)2, (byte)5)));
            }
            convert = new FileToSign(tmp);
            SignatureFacade.rM("-raefe5", convert, SignatureFacade.rM("1umpgi4", file));
            SignatureFacade.rM("-3a2fe1", convert, SignatureFacade.rM("kd5gho", file));
            ++i;
            if (SignatureFacade.rM("-e1kffj", toDelete) <= 2 || (toDel = (File)SignatureFacade.rM("-emqffk", toDelete)) == null) continue;
            SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", toDel));
        } while (i < appearancesCount && !withError);
        if (!withError) {
            SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("-qs4fdu", convert), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        Object object = SignatureFacade.rM("-64mfgv", toDelete);
        while (object.hasNext()) {
            File del = (File)object.next();
            SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", del));
        }
        return withError;
    }

    private static void setUpAppearance(PadesSignatureOptions signatureOptions, CapiPDFApparence appearance) {
        if (appearance == null) {
            return;
        }
        SignatureFacade.rM("-113sfh0", signatureOptions, appearance);
        SignatureFacade.rM("146jgf6", signatureOptions, SignatureFacade.rM("-12mefgp", appearance));
        SignatureFacade.rM("8rpgf4", signatureOptions, SignatureFacade.rM("-1v9qfgr", appearance));
        SignatureFacade.rM("-1mgefh6", signatureOptions, SignatureFacade.rM("-1saufh5", appearance));
        SignatureFacade.rM("1jddgeo", signatureOptions, (boolean)SignatureFacade.rM("-r0mfh7", appearance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean signAdESDocument(FileToSign fileToSign, SignatureRequest request, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        block45: {
            docError = false;
            withError = false;
            destFile = SignatureFacade.createDestinationFile(fileToSign, request);
            outTmpFile = SignatureFacade.rM("rtbght", SignatureFacade.rM("-j1afe2", fileToSign), SignatureFacade.rM("kd5gho", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile();
            tsdIntTmp = null;
            defOut = SignatureFacade.rM("-11ikfh1", request) != false ? (tsdIntTmp = SignatureFacade.rM("rtbght", SignatureFacade.rM("-j1afe2", fileToSign), SignatureFacade.rM("kd5gho", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile()) : outTmpFile;
            try {
                block44: {
                    ih = SignatureFacade.rM("1bfjghl", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), fileToSign));
                    var11_12 = null;
                    try {
                        oh = SignatureFacade.rM("t0hghb", SignatureFacade.rM("925ghk", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), defOut), true));
                        var13_16 = null;
                        try {
                            SignatureFacade.rM("-1hscfed", signatureOptions, ih);
                            SignatureFacade.rM("1gg3ghi", signatureOptions, oh);
                            v0 = "\ub387s".toCharArray();
                            v0[0] = (char)(v0[0] ^ 30586);
                            SignatureFacade.rM("p5dghp", fileToSign, SignatureFacade.rM("-stufc1", SignatureFacade.rM("1637ggh", destFile), 0, (int)SignatureFacade.rM("-akaffg", SignatureFacade.rM("1637ggh", destFile), DecryptFacade$DecryptFacade.H(v0, (short)9220, 4, (short)0))));
                            try {
                                switch (1.$SwitchMap$it$actalis$ellips$capi$signature$SignatureOperation[SignatureFacade.rM("15ctgeu", SignatureFacade.rM("-1f40ff9", request))]) {
                                    case 1: {
                                        SignatureFacade.rM("177hggm", signatureGenerator, signatureOptions);
                                        if (SignatureFacade.rM("-11ikfh1", request) == false) break;
                                        SignatureFacade.applyTsd(signatureOptions, tsdIntTmp, outTmpFile, (String)SignatureFacade.rM("-j1afe2", fileToSign));
                                        break;
                                    }
                                    case 2: {
                                        SignatureFacade.rM("-iggffn", signatureOptions, SignatureFacade.rM("jodgga", request));
                                    }
                                    case 3: {
                                        SignatureFacade.rM("rmjgg8", signatureGenerator, signatureOptions);
                                    }
                                }
                            }
                            catch (XadesModeException e) {
                                if (SignatureFacade.rM("126bggf", (Object)e) == null) {
                                    throw e;
                                }
                                SignatureFacade.rM("1jjjgf9", signatureOptions, SignatureFacade.rM("126bggf", (Object)e));
                                if (SignatureFacade.rM("-1f40ff9", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.rM("177hggm", signatureGenerator, signatureOptions);
                                    break block44;
                                }
                                SignatureFacade.rM("rmjgg8", signatureGenerator, signatureOptions);
                            }
                        }
                        catch (Throwable var14_19) {
                            var13_16 = var14_19;
                            throw var14_19;
                        }
                        finally {
                            if (oh != null) {
                                if (var13_16 != null) {
                                    try {
                                        SignatureFacade.rM("f8nghe", oh);
                                    }
                                    catch (Throwable var14_18) {
                                        SignatureFacade.rM("-1bqsfej", var13_16, var14_18);
                                    }
                                } else {
                                    SignatureFacade.rM("f8nghe", oh);
                                }
                            }
                        }
                    }
                    catch (Throwable var12_15) {
                        var11_12 = var12_15;
                        throw var12_15;
                    }
                    finally {
                        if (ih != null) {
                            if (var11_12 != null) {
                                try {
                                    SignatureFacade.rM("-1s44fek", ih);
                                }
                                catch (Throwable var12_14) {
                                    SignatureFacade.rM("-1bqsfej", var11_12, var12_14);
                                }
                            } else {
                                SignatureFacade.rM("-1s44fek", ih);
                            }
                        }
                    }
                }
                if (docError) break block45;
            }
            catch (Throwable ex) {
                block46: {
                    try {
                        withError = true;
                        docError = true;
                        SignatureFacade.rM("14vjgjt", SignatureFacade.logger, SignatureFacade.rM("1j37gk3", ex), (Object)ex);
                        if (SignatureFacade.isTokenException(ex)) {
                            SignatureFacade.signatureStatus = new Status(StatusLevel.ERROR, ex);
                        } else {
                            SignatureFacade.rM("-1n4qffi", fileToSign, new Status(StatusLevel.ERROR, ex));
                        }
                        if (docError) break block46;
                    }
                    catch (Throwable var19_24) {
                        if (!docError) {
                            SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", outTmpFile), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", outTmpFile));
                        if (tsdIntTmp != null) {
                            SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tsdIntTmp));
                        }
                        throw var19_24;
                    }
                    SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", outTmpFile), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", outTmpFile));
                if (tsdIntTmp != null) {
                    SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tsdIntTmp));
                } else {
                    ** GOTO lbl108
                }
            }
            SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", outTmpFile), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", outTmpFile));
        if (tsdIntTmp != null) {
            SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tsdIntTmp));
        }
        if (SignatureFacade.rM("5uvgfg", fileToSign) == null) {
            v1 = "\u17a1\u46b9\u3ad3".toCharArray();
            v1[0] = (char)(v1[0] ^ 17386);
            SignatureFacade.rM("-1n4qffi", fileToSign, new Status(StatusLevel.SUCCESS, DecryptFacade$DecryptFacade.H(v1, (short)5867, 0, (short)0)));
        }
        return withError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean signAsicS(FileToSign fileToSign, SignatureRequest request, TimeStampOptions tstOpts, ASiCGeneratorOptions aSiCGeneratorOptions, MutableASiCOptions mutableASiCOptions, ASiCGenerator asicGenerator) throws IOException {
        File tmp;
        boolean withError;
        block35: {
            boolean docError = false;
            withError = false;
            File destFile = SignatureFacade.createDestinationFile(fileToSign, request);
            tmp = SignatureFacade.rM("rtbght", SignatureFacade.rM("-j1afe2", fileToSign), SignatureFacade.rM("kd5gho", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile();
            try {
                Object inDoc = SignatureFacade.rM("1bfjghl", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), fileToSign));
                Throwable throwable = null;
                try {
                    Object outH = SignatureFacade.rM("t0hghb", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("925ghk", SignatureFacade.rM("mujghn"), true), tmp));
                    Throwable throwable2 = null;
                    try {
                        SignatureOptions entry = new SignatureOptions();
                        SignatureFacade.rM("-1hscfed", entry, inDoc);
                        SignatureFacade.rM("1e6rget", entry, DigestAlgorithm.SHA256);
                        SignatureFacade.rM("1jjjgf9", entry, SignatureMode.DETACHED);
                        SignatureFacade.rM("1pafgh2", entry, SignatureFacade.rM("-13qqfeq", request));
                        SignatureFacade.rM("-sbsfe0", entry, SignatureFacade.rM("74tgh4", request));
                        SignatureFacade.rM("-jbofdv", entry, SignatureFacade.rM("-1b5afer", request));
                        SignatureFacade.rM("sudgh3", entry, SignatureFacade.rM("-17qfdo", SignatureFacade.rM("1ehhgi9")));
                        if (SignatureFacade.rM("vkfggv", SignatureFacade.rM("1hffggo", request), SignatureLevel.BES) == false) {
                            SignatureFacade.rM("-1ehqfgi", entry, tstOpts);
                            SignatureFacade.rM("-7bcfgj", entry, SignatureFacade.rM("1hffggo", request));
                            if (SignatureFacade.rM("vkfggv", SignatureFacade.rM("1hffggo", request), SignatureLevel.LT) != false) {
                                SignatureFacade.rM("1b4hgfc", entry, SignatureFacade.rM("-2p6ff2", request));
                            }
                        }
                        ArrayList<SignatureOptions> signEntries = new ArrayList<SignatureOptions>();
                        signEntries.add(entry);
                        SignatureFacade.rM("1durges", mutableASiCOptions, ASiCFormat.SIMPLE);
                        SignatureFacade.rM("-id4fhe", mutableASiCOptions, SignatureFacade.rM("kflgej", request));
                        SignatureFacade.rM("3qlgdh", aSiCGeneratorOptions, mutableASiCOptions);
                        SignatureFacade.rM("-7pcfig", aSiCGeneratorOptions, signEntries);
                        SignatureFacade.rM("ut5gdn", aSiCGeneratorOptions, outH);
                        char[] cArray = "\ud8fe\u1dbd".toCharArray();
                        cArray[0] = (char)(cArray[0] ^ 0x7CE9);
                        SignatureFacade.rM("p5dghp", fileToSign, SignatureFacade.rM("-stufc1", SignatureFacade.rM("1637ggh", destFile), 0, (int)SignatureFacade.rM("-akaffg", SignatureFacade.rM("1637ggh", destFile), DecryptFacade$DecryptFacade.H(cArray, (short)9671, 0, (short)4))));
                        SignatureFacade.rM("2mbgdm", asicGenerator, aSiCGeneratorOptions);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outH != null) {
                            if (throwable2 != null) {
                                try {
                                    SignatureFacade.rM("f8nghe", outH);
                                }
                                catch (Throwable throwable4) {
                                    SignatureFacade.rM("-1bqsfej", throwable2, throwable4);
                                }
                            } else {
                                SignatureFacade.rM("f8nghe", outH);
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inDoc != null) {
                        if (throwable != null) {
                            try {
                                SignatureFacade.rM("-1s44fek", inDoc);
                            }
                            catch (Throwable throwable6) {
                                SignatureFacade.rM("-1bqsfej", throwable, throwable6);
                            }
                        } else {
                            SignatureFacade.rM("-1s44fek", inDoc);
                        }
                    }
                }
                if (docError) break block35;
            }
            catch (Throwable ex) {
                block36: {
                    try {
                        withError = true;
                        docError = true;
                        SignatureFacade.rM("-ot0fd2", logger, SignatureFacade.rM("1j37gk3", ex));
                        if (SignatureFacade.isTokenException(ex)) {
                            signatureStatus = new Status(StatusLevel.ERROR, ex);
                        } else {
                            SignatureFacade.rM("-1n4qffi", fileToSign, new Status(StatusLevel.ERROR, ex));
                        }
                        if (docError) break block36;
                    }
                    catch (Throwable throwable) {
                        if (!docError) {
                            SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", tmp), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tmp));
                        throw throwable;
                    }
                    SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", tmp), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tmp));
            }
            SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", tmp), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tmp));
        if (SignatureFacade.rM("5uvgfg", fileToSign) == null) {
            char[] cArray = "\u0698\u78e3\u0c00".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x5965);
            SignatureFacade.rM("-1n4qffi", fileToSign, new Status(StatusLevel.SUCCESS, DecryptFacade$DecryptFacade.H(cArray, (short)32234, 2, (short)4)));
        }
        return withError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean signAsicE(SignatureRequest request) throws IOException, IllegalParamException {
        File tmp;
        File destFile;
        ArrayList<SignatureOptions> signEntries;
        boolean withError;
        boolean docError;
        block24: {
            docError = false;
            withError = false;
            signEntries = new ArrayList<SignatureOptions>();
            destFile = SignatureFacade.createDestinationFile((FileToSign)SignatureFacade.rM("18hjggq", request), request);
            char[] cArray = "\u273d\u16b8\uce05\ub324\u860f\u07cb\u47e8".toCharArray();
            cArray[5] = (char)(cArray[5] ^ 0x3670);
            tmp = SignatureFacade.rM("rtbght", SignatureFacade.rM("1637ggh", destFile), DecryptFacade$ValidationFacade.s(cArray, (short)28074, 5, 5), (FileAttribute[])new FileAttribute[0]).toFile();
            ASiCGenerator asicGenerator = new ASiCGenerator();
            MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
            ASiCGeneratorOptions aSiCGeneratorOptions = new ASiCGeneratorOptions();
            TimeStampOptions tstOpts = SignatureFacade.getAsicTstOptions(request);
            try {
                Throwable throwable;
                Iterator oh;
                block25: {
                    oh = SignatureFacade.rM("t0hghb", SignatureFacade.rM("925ghk", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), tmp), true));
                    throwable = null;
                    Iterator iterator = SignatureFacade.rM("-1mkoff5", request).iterator();
                    while (iterator.hasNext()) {
                        FileToSign file = (FileToSign)iterator.next();
                        SignatureOptions entry = new SignatureOptions();
                        Object inDoc = SignatureFacade.rM("1bfjghl", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), file));
                        SignatureFacade.rM("-1hscfed", entry, inDoc);
                        SignatureFacade.rM("1e6rget", entry, DigestAlgorithm.SHA256);
                        SignatureFacade.rM("1jjjgf9", entry, SignatureMode.DETACHED);
                        SignatureFacade.rM("1pafgh2", entry, SignatureFacade.rM("-13qqfeq", request));
                        SignatureFacade.rM("-sbsfe0", entry, SignatureFacade.rM("74tgh4", request));
                        SignatureFacade.rM("-jbofdv", entry, SignatureFacade.rM("-1b5afer", request));
                        if (SignatureFacade.rM("vkfggv", SignatureFacade.rM("1hffggo", request), SignatureLevel.BES) == false) {
                            SignatureFacade.rM("-1ehqfgi", entry, tstOpts);
                            SignatureFacade.rM("-7bcfgj", entry, SignatureFacade.rM("1hffggo", request));
                            if (SignatureFacade.rM("vkfggv", SignatureFacade.rM("1hffggo", request), SignatureLevel.LT) != false) {
                                SignatureFacade.rM("1b4hgfc", entry, SignatureFacade.rM("-2p6ff2", request));
                            }
                        }
                        signEntries.add(entry);
                    }
                    SignatureFacade.rM("1durges", mutableASiCOptions, ASiCFormat.EXTENDED);
                    SignatureFacade.rM("-id4fhe", mutableASiCOptions, SignatureFacade.rM("kflgej", request));
                    SignatureFacade.rM("3qlgdh", aSiCGeneratorOptions, mutableASiCOptions);
                    SignatureFacade.rM("-7pcfig", aSiCGeneratorOptions, signEntries);
                    SignatureFacade.rM("ut5gdn", aSiCGeneratorOptions, oh);
                    SignatureFacade.rM("2mbgdm", asicGenerator, aSiCGeneratorOptions);
                    if (oh == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        SignatureFacade.rM("f8nghe", oh);
                    }
                    catch (Throwable throwable2) {
                        SignatureFacade.rM("-1bqsfej", throwable, throwable2);
                    }
                    break block24;
                }
                SignatureFacade.rM("f8nghe", oh);
                break block24;
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (oh != null) {
                            if (throwable != null) {
                                try {
                                    SignatureFacade.rM("f8nghe", oh);
                                }
                                catch (Throwable throwable5) {
                                    SignatureFacade.rM("-1bqsfej", throwable, throwable5);
                                }
                            } else {
                                SignatureFacade.rM("f8nghe", oh);
                            }
                        }
                        throw throwable4;
                    }
                }
            }
            catch (Throwable ex) {
                try {
                    withError = true;
                    docError = true;
                    SignatureFacade.rM("-ot0fd2", logger, SignatureFacade.rM("1j37gk3", ex));
                    signatureStatus = new Status(StatusLevel.ERROR, ex);
                }
                catch (Throwable throwable) {
                    for (SignatureOptions entry : signEntries) {
                        if (SignatureFacade.rM("-g42fib", entry) == null) continue;
                        SignatureFacade.rM("-1s44fek", SignatureFacade.rM("-g42fib", entry));
                    }
                    if (!docError) {
                        SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", tmp), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tmp));
                    throw throwable;
                }
                for (SignatureOptions entry : signEntries) {
                    if (SignatureFacade.rM("-g42fib", entry) == null) continue;
                    SignatureFacade.rM("-1s44fek", SignatureFacade.rM("-g42fib", entry));
                }
                if (!docError) {
                    SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", tmp), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tmp));
            }
        }
        for (SignatureOptions entry : signEntries) {
            if (SignatureFacade.rM("-g42fib", entry) == null) continue;
            SignatureFacade.rM("-1s44fek", SignatureFacade.rM("-g42fib", entry));
        }
        if (!docError) {
            SignatureFacade.rM("1c9pgk1", SignatureFacade.rM("1o3gj2", tmp), SignatureFacade.rM("1o3gj2", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.rM("-ikofdt", SignatureFacade.rM("1o3gj2", tmp));
        return withError;
    }

    private static void applyTsd(SignatureOptions signatureOptions, File inputFile, File outputFile, String outFileName) throws Exception {
        TSAData tsaData = new TSAData();
        Object prop = SignatureFacade.rM("1ehhgi9");
        SignatureFacade.rM("g25gdb", tsaData, SignatureFacade.rM("ia5gdk", prop, ServerProperties.TSA_ACCOUNT, (Object)""));
        SignatureFacade.rM("1aurgda", tsaData, SignatureFacade.rM("ia5gdk", prop, ServerProperties.TSA_SERVER_ADDRESS, (Object)""));
        SignatureFacade.rM("-14h2fin", tsaData, SignatureFacade.rM("ia5gdk", prop, ServerProperties.TSA_POLICY, (Object)""));
        SignatureFacade.rM("9h7gd8", tsaData, SignatureFacade.rM("ia5gdk", prop, ServerProperties.TSA_PASSWORD, (Object)""));
        Object inputHandlerFile = SignatureFacade.rM("1bfjghl", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), inputFile));
        Throwable throwable = null;
        try {
            Object outputHandlerFile = SignatureFacade.rM("t0hghb", SignatureFacade.rM("925ghk", SignatureFacade.rM("-u8qfea", SignatureFacade.rM("mujghn"), outputFile), true));
            Throwable throwable2 = null;
            try {
                SignatureFacade.rM("f8nghe", SignatureFacade.rM("1ndpggl", signatureOptions));
                char[] cArray = "\uf9f3\u0fad\u94c9\u5424\uee35\u5270\u495f\uc23e\u36e5\u0d09\ub52f\uc817\u7266\ufdc0\u397e\u71ad\uf99e\ufc56\ub8b9\ub842\u686b\ud194\u4570".toCharArray();
                cArray[12] = (char)(cArray[12] ^ 0x3B4);
                SignatureFacade.rM("1pppggb", inputHandlerFile, outputHandlerFile, (Object)tsaData, (Object)outFileName, (Object)DecryptFacade$DecryptFacade.H(cArray, (short)3976, 4, (short)5), (Object)SignatureFacade.rM("-1h8sffc"), (boolean)false);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (outputHandlerFile != null) {
                    if (throwable2 != null) {
                        try {
                            SignatureFacade.rM("f8nghe", outputHandlerFile);
                        }
                        catch (Throwable throwable4) {
                            SignatureFacade.rM("-1bqsfej", throwable2, throwable4);
                        }
                    } else {
                        SignatureFacade.rM("f8nghe", outputHandlerFile);
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (inputHandlerFile != null) {
                if (throwable != null) {
                    try {
                        SignatureFacade.rM("-1s44fek", inputHandlerFile);
                    }
                    catch (Throwable throwable6) {
                        SignatureFacade.rM("-1bqsfej", throwable, throwable6);
                    }
                } else {
                    SignatureFacade.rM("-1s44fek", inputHandlerFile);
                }
            }
        }
    }

    private static File createDestinationFile(FileToSign src, SignatureRequest request) throws IOException {
        Object destinationFolder = SignatureFacade.rM("1gqtggt", request);
        if (destinationFolder == null) {
            destinationFolder = SignatureFacade.rM("1j7tgdf", src);
        }
        if (SignatureFacade.rM("-1f40ff9", request) == SignatureOperation.NEW_SIGN) {
            return SignatureFacade.rM("-d6cfef", destinationFolder, SignatureFacade.rM("-1sm2fe6", src), (Object)SignatureFacade.rM("kd5gho", src));
        }
        if (SignatureFacade.rM("-upaff7", (Object)SignatureType.ASICE, SignatureFacade.rM("oo3gh7", request)) != false) {
            return new File((String)SignatureFacade.rM("793ghf", SignatureFacade.rM("t8bgh9", SignatureFacade.rM("t8bgh9", SignatureFacade.rM("t8bgh9", SignatureFacade.rM("1pllgde", new StringBuilder(), destinationFolder), File.separator), SignatureFacade.rM("-1sm2fe6", src)), SignatureFacade.rM("kd5gho", src))));
        }
        return new File((String)SignatureFacade.rM("793ghf", SignatureFacade.rM("t8bgh9", SignatureFacade.rM("t8bgh9", SignatureFacade.rM("t8bgh9", SignatureFacade.rM("t8bgh9", new StringBuilder(), SignatureFacade.rM("122rgdd", src)), File.separator), SignatureFacade.rM("-1sm2fe6", src)), SignatureFacade.rM("kd5gho", src))));
    }

    private static boolean isTokenException(Throwable ex) {
        if (!(ex instanceof CapiException)) {
            return false;
        }
        CapiException capiException = (CapiException)ex;
        return SignatureFacade.rM("1vcvgdc", (Object)capiException) == 2014 || SignatureFacade.rM("1vcvgdc", (Object)capiException) == 2001 || SignatureFacade.rM("1vcvgdc", (Object)capiException) == 10013;
    }

    static /* synthetic */ I18N access$000() {
        return i18n;
    }

    static {
        char[] cArray = "\uc469\u3e7c\u8b04\u58f0\u5546\udfed\ud4a1\u2016\u1979\u4dfd\u5da7\u6d20\u6f4e\u60a5\u31b8\uae28\u59c6\ubc76\ub85c\u88b9\u9903\u5761\ue968\u5d28\u30c9\uc115\u431c\uce93\udeba\u13e4\u8ac1\ue398\ud62f\u5e2a\uf03c\ue2a6\u4c9f".toCharArray();
        cArray[10] = (char)(cArray[10] ^ 0x6632);
        i18n = SignatureFacade.rM("-18esfgt", DecryptFacade$DecryptFacade.H(cArray, (short)23580, 3, (short)5));
        signatureStatus = null;
    }

    private static Object rM(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(utzgqpee.Y(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }

    public static final class SignatureFormat
    extends Enum<SignatureFormat> {
        public static final /* enum */ SignatureFormat T;
        public static final /* enum */ SignatureFormat LT;
        public static final /* enum */ SignatureFormat TSD;
        private final SignatureLevel signatureLevel;
        private static final /* synthetic */ SignatureFormat[] $VALUES;

        public static SignatureFormat[] values() {
            return (SignatureFormat[])$VALUES.clone();
        }

        public static SignatureFormat valueOf(String name) {
            return (SignatureFormat)((Object)SignatureFormat.Yv("-1isifdg", SignatureFormat.class, name));
        }

        private SignatureFormat(SignatureLevel signatureLevel) {
            this.signatureLevel = signatureLevel;
        }

        public SignatureLevel getSignatureLevel() {
            return this.signatureLevel;
        }

        static {
            char[] cArray = "\u0d81\u4c2f".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x57AE);
            T = new SignatureFormat(SignatureLevel.T);
            char[] cArray2 = "\u2cf9\u486e\u714a".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x2166);
            LT = new SignatureFormat(SignatureLevel.LT);
            char[] cArray3 = "\uaff5\u72ab\u5dc5\u6911".toCharArray();
            cArray3[2] = (char)(cArray3[2] ^ 0x6964);
            TSD = new SignatureFormat(SignatureLevel.BES);
            $VALUES = new SignatureFormat[]{T, LT, TSD};
        }

        private static Object Yv(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(utzgqpee.Y(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }

    public static final class SignatureType
    extends Enum<SignatureType> {
        public static final /* enum */ SignatureType CADES;
        public static final /* enum */ SignatureType PADES;
        public static final /* enum */ SignatureType XADES;
        public static final /* enum */ SignatureType ASICS;
        public static final /* enum */ SignatureType ASICE;
        public static final /* enum */ SignatureType TSD;
        private final String extension;
        private final String name;
        private final String fullName;
        private final String description;
        private static final /* synthetic */ SignatureType[] $VALUES;

        public static SignatureType[] values() {
            return (SignatureType[])$VALUES.clone();
        }

        public static SignatureType valueOf(String name) {
            return (SignatureType)((Object)SignatureType.Yf("-1isifdg", SignatureType.class, name));
        }

        private SignatureType(String name, String ext, String fullName, String description) {
            this.name = name;
            this.extension = ext;
            this.fullName = fullName;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getFullName() {
            Object temp = SignatureType.Yf("12llgh0", SignatureType.Yf("-qfafev"), this.fullName, (Object[])new Object[0]);
            char[] cArray = "\u6c9e\uabe5\u2fac".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x32F3);
            char[] cArray2 = "\u9419\u73d9\u5ea3".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x5E28);
            if (SignatureType.Yf("1gobgjq", temp, SignatureType.Yf("793ghf", SignatureType.Yf("t8bgh9", SignatureType.Yf("t8bgh9", SignatureType.Yf("t8bgh9", new StringBuilder(), DecryptFacade$EncryptFacade.Y(cArray, (short)7175, (short)1, (byte)3)), this.fullName), DecryptFacade$EncryptFacade.Y(cArray2, (short)10964, (short)0, (byte)2)))) != false) {
                return this.fullName;
            }
            return temp;
        }

        public String getDescription() {
            Object temp = SignatureType.Yf("12llgh0", SignatureType.Yf("-qfafev"), this.description, (Object[])new Object[0]);
            char[] cArray = "\u63ce\u3688\u518b".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x30D3);
            char[] cArray2 = "\ua10e\u5a29\u628b".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x459C);
            if (SignatureType.Yf("1gobgjq", temp, SignatureType.Yf("793ghf", SignatureType.Yf("t8bgh9", SignatureType.Yf("t8bgh9", SignatureType.Yf("t8bgh9", new StringBuilder(), DecryptFacade$EncryptFacade.Y(cArray, (short)16830, (short)2, (byte)3)), this.description), DecryptFacade$EncryptFacade.Y(cArray2, (short)2409, (short)5, (byte)1)))) != false) {
                return this.description;
            }
            return temp;
        }

        static {
            char[] cArray = "\u72fe\u144b\uaabd\ud89f\ubeb9\u2df6".toCharArray();
            cArray[4] = (char)(cArray[4] ^ 0x3905);
            char[] cArray2 = "\u97ae\u786a\u436c\u70ad\u3116\u1990".toCharArray();
            cArray2[3] = (char)(cArray2[3] ^ 0x9A3);
            char[] cArray3 = "\uf54b\uaf2a\u21b2\u953c\u44b5".toCharArray();
            cArray3[3] = (char)(cArray3[3] ^ 0x539);
            char[] cArray4 = "\u2b2d\u44c9\u00a5\u7f16\u4837\ufdef\u5aab\u4662\u95cd\u800a\uc758\udecb\u3e51\u11a0\u6dab\u33b8\u3f90\u8af9\ubf70\u180f\u7f24\u46e5\u640d\u392f\ub520\u6209\udb8f\ua330\ufe4c\u4b50\ua560\uafc9\u40a5\u96e7\u0a69\u713f\u3909".toCharArray();
            cArray4[12] = (char)(cArray4[12] ^ 0x86F);
            char[] cArray5 = "\u40a7\ud5f9\uc760\u7b24\u1ee5\u581b\u5c3b\ueabd\uf0c5\ud737\u99fb\u81a3\u6504\u44f9\uaefe\u5486\u66ec\u52e8\u6032\u029d\u054c\u00a2\u1b78\u1739\u39cc\u60dc\u4474\u2b99\uf371\udfd0\u6349\ua012\u2bf5\uc9fb\uc529\u3e87\u4f4c\u798a\u09a5\u11aa".toCharArray();
            cArray5[17] = (char)(cArray5[17] ^ 0x6B50);
            CADES = new SignatureType(DecryptFacade$DecryptFacade.H(cArray2, (short)12259, 1, (short)1), DecryptFacade$DecryptFacade.H(cArray3, (short)19257, 4, (short)0), DecryptFacade$DecryptFacade.H(cArray4, (short)27298, 3, (short)4), DecryptFacade$DecryptFacade.H(cArray5, (short)15880, 1, (short)1));
            char[] cArray6 = "\ucf1c\u2035\u3952\u6e3f\uda4c\u5c3d".toCharArray();
            cArray6[1] = (char)(cArray6[1] ^ 0x4A77);
            char[] cArray7 = "\u51ac\ub2b2\u7924\ud46c\u4602\u4c6d".toCharArray();
            cArray7[3] = (char)(cArray7[3] ^ 0xC6C);
            char[] cArray8 = "\uda34\u5cc0\u440a\uf082\u582f".toCharArray();
            cArray8[0] = (char)(cArray8[0] ^ 0x49E1);
            char[] cArray9 = "\u3dc3\uea9f\u4d0d\uffe9\u46cd\u5a68\ub1e7\ua6c1\u4b95\ud127\u8f8e\u779c\u46de\u70cf\u8225\u1ab6\u442a\ua104\u1518\uc2c5\u1455\u0da2\u36f2\u8122\u4ef8\ua4d1\u0cd9\uef28\u0631\ua07c\u98ca\uee05\ueb17\u1d65\u2acc\ucef5\u01f5".toCharArray();
            cArray9[21] = (char)(cArray9[21] ^ 0x7C6E);
            char[] cArray10 = "\u245d\u3c13\u3fa4\u7a03\u86d0\u8127\uea1d\u242a\u321f\ucb31\ud723\u102a\u0154\u24a9\u89e5\u2687\u6eb3\ub7e3\u9ae4\u5e10\uecb2\u3e7e\uc184\u3883\u6661\uefad\u4818\ue419\u9e00\ua50b\u80b4\ua007\u377f\udc58\ubf32\ubc07\ud887\u30ca\ubf73\u1a83".toCharArray();
            cArray10[31] = (char)(cArray10[31] ^ 0x290D);
            PADES = new SignatureType(DecryptFacade$DecryptFacade.H(cArray7, (short)19540, 1, (short)3), DecryptFacade$DecryptFacade.H(cArray8, (short)534, 1, (short)5), DecryptFacade$DecryptFacade.H(cArray9, (short)31904, 5, (short)4), DecryptFacade$DecryptFacade.H(cArray10, (short)14887, 0, (short)1));
            char[] cArray11 = "\u3a72\ufb69\uca91\u9984\uff4c\u1b9b".toCharArray();
            cArray11[1] = (char)(cArray11[1] ^ 0x4644);
            char[] cArray12 = "\uaef1\ua427\u434d\uf3ee\uf15c\u21b8".toCharArray();
            cArray12[2] = (char)(cArray12[2] ^ 0x6C12);
            char[] cArray13 = "\ua0b0\udd64\u17d4\u1d2e\u0aaf".toCharArray();
            cArray13[3] = (char)(cArray13[3] ^ 0x27DB);
            char[] cArray14 = "\u1581\u585d\u33e7\u5ca1\u967f\u00f6\u6921\u9624\u8bdb\u1c2a\ub52a\ufb45\udca4\u525d\ue0a8\u4159\ua1c9\ufb43\u6baa\u3029\u41bb\uda7b\ud1dc\ubda6\u3a1d\u1265\u1919\u630f\u5828\u81e3\uda36\u0710\ucf9d\ufb04\ua3fa\uf616\u69a1".toCharArray();
            cArray14[15] = (char)(cArray14[15] ^ 0x740C);
            char[] cArray15 = "\u7119\udaae\u9b8b\u1b0f\u427c\u76e0\u16ec\u1d45\u29e7\u7a9b\ubc07\uf365\ucb12\u1987\ue09a\ubfe9\u8c03\u5c21\ubfca\u2a70\uf850\u79be\u85d4\u219e\u19dc\u72fb\u7b4c\u51bd\u14f6\u4110\u72cd\u497e\uc34e\ufa4b\u9ab1\u4a1a\u9de8\u242f\ud4f9\u7081".toCharArray();
            cArray15[20] = (char)(cArray15[20] ^ 0x2A2B);
            XADES = new SignatureType(DecryptFacade$DecryptFacade.H(cArray12, (short)21519, 0, (short)1), DecryptFacade$DecryptFacade.H(cArray13, (short)22201, 0, (short)5), DecryptFacade$DecryptFacade.H(cArray14, (short)8546, 3, (short)0), DecryptFacade$DecryptFacade.H(cArray15, (short)3923, 0, (short)2));
            char[] cArray16 = "\ua171\u3914\u0f61\u5ea4\uf0f4\u1dd4".toCharArray();
            cArray16[2] = (char)(cArray16[2] ^ 0x64F4);
            char[] cArray17 = "\ue768\u5423\u74ac\u129e\u4ccf\ueccd\u3c61".toCharArray();
            cArray17[4] = (char)(cArray17[4] ^ 0xB17);
            char[] cArray18 = "\ue1ed\ufa82\u35a4\u5401\u6662\u12ae\u0f4b".toCharArray();
            cArray18[4] = (char)(cArray18[4] ^ 0x177);
            char[] cArray19 = "\ue4cd\u7608\u3c03\u1f1c\u7a11\uc42f\u6b33".toCharArray();
            cArray19[2] = (char)(cArray19[2] ^ 0x78FB);
            char[] cArray20 = "\u5bd3\ubdf7\u3941\uc83a\u5510\u2c7c\uc664\u0b9d\u6d16\u9cd5\uc1d9\u35f5\u2342\u56a7\u0525\u60ba\ue6e7\ufddb\u40a3\ua0e1\u0517\ubb9f\u28b4\u0ca3\ucbab\uccf5\u7abb\u68c7\u5244\u10d0\uda8d\u1fdf\uabb1\u8d7c\u67a4\u221d\u4124\u2894\u27e7".toCharArray();
            cArray20[13] = (char)(cArray20[13] ^ 0x3D1D);
            ASICS = new SignatureType(DecryptFacade$DecryptFacade.H(cArray17, (short)2929, 5, (short)2), DecryptFacade$DecryptFacade.H(cArray18, (short)28429, 2, (short)5), DecryptFacade$DecryptFacade.H(cArray19, (short)18377, 3, (short)5), DecryptFacade$DecryptFacade.H(cArray20, (short)6245, 5, (short)5));
            char[] cArray21 = "\u9e95\uf486\ub9fb\u4269\ueb7d\u355d".toCharArray();
            cArray21[0] = (char)(cArray21[0] ^ 0x245B);
            char[] cArray22 = "\u6860\u6ed0\u86dd\uff42\u0ad6\ue24e\u3695".toCharArray();
            cArray22[1] = (char)(cArray22[1] ^ 0x12D1);
            char[] cArray23 = "\uf28f\u894c\u2303\u58cd\u3d72\u8201\u23bd".toCharArray();
            cArray23[2] = (char)(cArray23[2] ^ 0x2D6D);
            char[] cArray24 = "\u46a6\u0573\u991c\u1eff\u30f7\u36af\u35be".toCharArray();
            cArray24[2] = (char)(cArray24[2] ^ 0x651D);
            char[] cArray25 = "\uc92d\u6521\ub67c\u5fc4\ue506\u94df\u3887\ue92a\u3f9a\ue706\u9a6a\u4b00\u4fce\u7799\udb2bS\uc6c2\u8247\u65fd\u91ab\u1eb9\u117f\ue8eb\u6e2e\uec65\u0b11\ue30e\ub829\u66b4\uabd0\uff93\u8299\u4c22\u8854\u641d\u93b8\u3029\u9711\u244c".toCharArray();
            cArray25[24] = (char)(cArray25[24] ^ 0x31C7);
            ASICE = new SignatureType(DecryptFacade$DecryptFacade.H(cArray22, (short)14618, 2, (short)1), DecryptFacade$DecryptFacade.H(cArray23, (short)9254, 3, (short)0), DecryptFacade$DecryptFacade.H(cArray24, (short)13417, 2, (short)2), DecryptFacade$DecryptFacade.H(cArray25, (short)30173, 1, (short)0));
            char[] cArray26 = "\u2d16\ue868\uce3f\u705b".toCharArray();
            cArray26[0] = (char)(cArray26[0] ^ 0xF13);
            char[] cArray27 = "\uf4e7\uf366\u62dc\u0714".toCharArray();
            cArray27[1] = (char)(cArray27[1] ^ 0x50C9);
            char[] cArray28 = "\ua61b\ud472\u5afc\ua5f8\u1af7".toCharArray();
            cArray28[1] = (char)(cArray28[1] ^ 0x2289);
            char[] cArray29 = "\u7c3a\u86ac\ua605\u5497".toCharArray();
            cArray29[0] = (char)(cArray29[0] ^ 0x492A);
            TSD = new SignatureType(DecryptFacade$DecryptFacade.H(cArray27, (short)11209, 0, (short)1), DecryptFacade$DecryptFacade.H(cArray28, (short)20018, 5, (short)2), DecryptFacade$DecryptFacade.H(cArray29, (short)140, 2, (short)1), "");
            $VALUES = new SignatureType[]{CADES, PADES, XADES, ASICS, ASICE, TSD};
        }

        private static Object Yf(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(utzgqpee.Y(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }
}

