/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public class EncryptedEnvelope {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int DES_EDE3_CBC = 0;
    public static final int RC2_CBC = 1;
    public static final int AES256_CBC = 2;
    public static final int CAMELLIA256_CBC = 3;
    private int b = -1;
    private byte[] c = null;
    private byte[] d = null;
    private CMSEnvelopedDataGenerator e = null;
    protected CMSEnvelopedData envelopedData = null;
    protected String contentEA = CMSEnvelopedDataGenerator.DES_EDE3_CBC;

    public EncryptedEnvelope() throws CapiException {
        this.b = 0;
        this.contentEA = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
        a.debug("data encryption algorithm set to DES_EDE3_CBC");
        this.envelopedData = null;
    }

    public EncryptedEnvelope(int n) throws CapiException {
        this.b = 0;
        if (n == 3) {
            this.contentEA = CMSEnvelopedDataGenerator.CAMELLIA256_CBC;
            a.debug("Content encryption algorithm set to CAMELLIA256_CBC");
            this.envelopedData = null;
            return;
        }
        if (n == 2) {
            this.contentEA = CMSEnvelopedDataGenerator.AES256_CBC;
            a.debug("Content encryption algorithm set to AES256_CBC");
            this.envelopedData = null;
            return;
        }
        if (n == 1) {
            this.contentEA = CMSEnvelopedDataGenerator.RC2_CBC;
            a.debug("Content encryption algorithm set to RC2_CBC");
            this.envelopedData = null;
            return;
        }
        if (n == 0) {
            this.contentEA = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
            a.debug("Content encryption algorithm set to DES_EDE3_CBC");
            this.envelopedData = null;
            return;
        }
        throw new CapiException("Supplied mode is invalid", 1002);
    }

    public void setData(byte[] byArray) throws CapiException {
        if (this.b > 1) {
            throw new CapiException("Not allowed if recipient(s) already set or ciphered", 51002);
        }
        if (byArray == null) {
            throw new CapiException("Null data", 1001);
        }
        this.c = Arrays.copyOf((byte[])byArray, (int)byArray.length);
        this.b = 1;
    }

    public void addRecipient(byte[] object) throws CapiException {
        object = new Certificate(object).getInternalCert();
        EncryptedEnvelope encryptedEnvelope = this;
        Object object2 = object;
        object = encryptedEnvelope;
        encryptedEnvelope.a((X509Certificate)object2, null);
    }

    public void addRecipient(byte[] object, boolean bl) throws CapiException {
        Certificate certificate = new Certificate(object);
        object = certificate;
        X509Certificate x509Certificate = certificate.getInternalCert();
        if (x509Certificate == null) {
            throw new CapiException("No certificate", 30005);
        }
        if (!bl) {
            EncryptedEnvelope encryptedEnvelope = this;
            X509Certificate x509Certificate2 = x509Certificate;
            object = encryptedEnvelope;
            encryptedEnvelope.a(x509Certificate2, null);
            return;
        }
        if ((object = object.getSubjectKeyIdentifier()) != null && ((byte[])object).length > 0) {
            this.a(x509Certificate, (byte[])object);
            return;
        }
        throw new CapiException("Missing Extension Subject Key Identifier", 30006);
    }

    public void addRecipientFromToken(TokenSpi object, String string) throws CapiException {
        try {
            a.debug("[addRecipientFromToken] getting credential...");
            object = Util.getBytes((String)object.getCert(string));
            a.debug("[addRecipientFromToken] getting credential ok");
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
        this.addRecipient((byte[])object);
    }

    public String getEncoded() throws CapiException {
        Object object;
        if (this.b < 2) {
            throw new CapiException("Recipient(s) must be set before", 51001);
        }
        if (this.b == 4 || this.b == 3) {
            throw new CapiException("Cannot ciphered", 51002);
        }
        try {
            a.debug("Creating envelopedData ...");
            if (this.envelopedData != null) {
                throw new CapiException("Why envelopedData not null ?", 51002);
            }
            if (this.e == null) {
                throw new CapiException("Factory is null ?", 51002);
            }
            object = new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(this.contentEA));
            object.setProvider(ProvUtils.bcProvider);
            this.envelopedData = this.e.generate((CMSTypedData)new CMSProcessableByteArray(this.c), object.build());
            byte[] byArray = this.envelopedData.getEncoded();
            object = byArray;
            if (byArray == null) {
                throw new CapiException("Encoding error during ciphering", 50022);
            }
            a.debug("DOPO getEncoded ...");
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Encoding error", 50022);
        }
        catch (CapiError capiError) {
            a.debug(capiError.getMessage(), (Throwable)capiError);
            throw capiError.getCapiException();
        }
        try {
            object = ContentInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            StringWriter stringWriter = new StringWriter();
            PEMWriter pEMWriter = new PEMWriter((Writer)stringWriter);
            pEMWriter.writeObject(object);
            pEMWriter.close();
            object = new String(stringWriter.getBuffer());
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error encoding encrypted envelope", 50022);
        }
    }

    private void a(byte[] object) throws CapiException {
        try {
            a.debug("trying Base64 decode ... ");
            byte[] byArray = Util.base64Decode((byte[])object);
            this.envelopedData = new CMSEnvelopedData((InputStream)new ByteArrayInputStream(byArray));
            return;
        }
        catch (Exception exception) {
            object = new PEMParser((Reader)new StringReader(new String((byte[])object)));
            try {
                a.debug("not Base64, trying PEM Tagged format  ... ");
                ContentInfo contentInfo = (ContentInfo)object.readObject();
                object = contentInfo;
                if (contentInfo == null) {
                    throw new CapiException("Envelope format unknown or not implemented", 50021);
                }
                if (!object.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.envelopedData)) {
                    throw new CapiException("Not a valid enveloped-data object - wrong header " + object.getContentType().getId(), 50021);
                }
                this.envelopedData = new CMSEnvelopedData((ContentInfo)object);
                return;
            }
            catch (Exception exception2) {
                a.debug(exception2.getMessage(), (Throwable)exception2);
                throw new CapiException("Envelope format unknown or not implemented", 50021);
            }
        }
    }

    public EncryptedEnvelope(String string) throws CapiException {
        this.b = 4;
        if (string == null) {
            throw new CapiException("Null data", 1001);
        }
        this.a(string.getBytes());
        if (this.envelopedData == null) {
            a.debug("null envelopedData");
            throw new CapiException("Internal error", 50050);
        }
        a.debug("parsed ok");
        a.debug("Getting information about ECI...");
        string = this.envelopedData.toASN1Structure().getContentType().getId();
        a.debug("Content type: " + string);
        a.debug("Content encryption algorithm: " + this.envelopedData.getEncryptionAlgOID() + " (" + EncryptedEnvelope.getContentEncryptionAlgName(this.envelopedData.getEncryptionAlgOID()) + ")");
    }

    public static String getContentEncryptionAlgName(String string) {
        if (string.trim().equals(CMSEnvelopedDataGenerator.CAMELLIA256_CBC)) {
            return "CAMELLIA256_CBC";
        }
        if (string.trim().equals(CMSEnvelopedDataGenerator.AES256_CBC)) {
            return "AES256_CBC";
        }
        if (string.trim().equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC)) {
            return "DES_EDE3_CBC";
        }
        if (string.trim().equals(CMSEnvelopedDataGenerator.RC2_CBC)) {
            return "RC2_CBC";
        }
        return null;
    }

    public EncryptedEnvelope(byte[] object) throws CapiException {
        this.b = 4;
        if (object == null) {
            throw new CapiException("Null data", 1001);
        }
        try {
            this.envelopedData = new CMSEnvelopedData((InputStream)new ByteArrayInputStream((byte[])object));
            a.debug("DER format");
        }
        catch (CMSException cMSException) {
            this.a((byte[])object);
        }
        if (this.envelopedData == null) {
            a.debug("null envelopedData");
            throw new CapiException("Internal error", 50050);
        }
        a.debug("parsed ok");
        a.debug("Getting information about ECI...");
        object = this.envelopedData.toASN1Structure().getContentType().getId();
        a.debug("Content type: " + (String)object);
        a.debug("Content encryption algorithm: " + this.envelopedData.getEncryptionAlgOID());
    }

    public String getEncryptionAlgorithm() {
        if (this.b == 0 || this.b == 1 || this.b == 2) {
            return this.contentEA;
        }
        return this.envelopedData.getEncryptionAlgOID();
    }

    public String[] listRecipients(String string) throws CapiException {
        if (this.envelopedData == null) {
            throw new CapiException("Data must be encrypted before", 51001);
        }
        try {
            a.debug("getting recipients...");
            Object object = this.envelopedData.getRecipientInfos();
            object = object.getRecipients();
            object = new Vector(object);
            a.debug("recipients are " + ((Vector)object).size());
            String[] stringArray = new String[((Vector)object).size()];
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                RecipientInformation recipientInformation = (RecipientInformation)((Vector)object).elementAt(i);
                recipientInformation = (KeyTransRecipientId)recipientInformation.getRID();
                stringArray[i] = recipientInformation.getSerialNumber().toString() + string + recipientInformation.getIssuer().toString();
            }
            return stringArray;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    public byte[] decrypt(TokenSpi object, String string) throws CapiException {
        if (this.b < 3) {
            throw new CapiException("Data must be encrypted before", 51001);
        }
        try {
            a.debug("[decrypt] getting credential from token...");
            Object object2 = object.getCert(string);
            if (object2 == null) {
                throw new CapiException("alias not found", 51010);
            }
            Object object3 = new Certificate(Util.getBytes((String)object2));
            object2 = object3.getInternalCert();
            a.debug("...cert ok");
            object2 = new KeyTransRecipientId(JcaX500NameUtil.getIssuer((X509Certificate)object2), ((X509Certificate)object2).getSerialNumber());
            RecipientInformationStore recipientInformationStore = this.envelopedData.getRecipientInfos();
            object2 = (KeyTransRecipientInformation)recipientInformationStore.get((RecipientId)object2);
            if (object2 != null) {
                a.debug("[decrypt] recipient  Issuer and Serial number match token alias certificate");
            } else {
                a.debug("[decrypt] try using subject key identifier...");
                byte[] byArray = object3.getSubjectKeyIdentifier();
                object3 = byArray;
                if (byArray == null || ((Certificate)object3).length == 0) {
                    throw new CapiException("Token alias certificate not match", 51010);
                }
                object2 = new KeyTransRecipientId((byte[])object3);
                if ((object2 = (KeyTransRecipientInformation)recipientInformationStore.get((RecipientId)object2)) != null) {
                    a.debug("[decrypt] recipient SubjectKeyIdentifier match token alias certificate");
                } else {
                    throw new CapiException("Token alias certificate not match", 51010);
                }
            }
            object = object.getPrivateKey(string);
            object3 = this.envelopedData.getEncryptionAlgOID();
            if (((String)object3).equalsIgnoreCase(CMSEnvelopedDataGenerator.DES_EDE3_CBC)) {
                a.debug("[decrypt] content encryption algorithm is DES_EDE3_CBC");
            } else if (((String)object3).equalsIgnoreCase(CMSEnvelopedDataGenerator.RC2_CBC)) {
                a.debug("[decrypt] content encryption algorithm is RC2_CBC");
            } else {
                a.debug("[decrypt] content encryption algorithm is " + (String)object3);
            }
            string = new JceKeyTransEnvelopedRecipient((PrivateKey)object);
            string.setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)object));
            string.setContentProvider(ProvUtils.bcProvider);
            this.d = object2.getContent((Recipient)string);
            a.debug("decrypt done.");
            return Arrays.copyOf((byte[])this.d, (int)this.d.length);
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
        catch (CapiError capiError) {
            a.debug(capiError.getMessage(), (Throwable)capiError);
            throw capiError.getCapiException();
        }
    }

    public byte[] decryptAS(String string, String string2) throws CapiException {
        throw new CapiException("unsupported token type", 1003);
    }

    public byte[] getData() {
        if (this.b == 0 || this.b == 1 || this.b == 2) {
            return Arrays.copyOf((byte[])this.c, (int)this.c.length);
        }
        return Arrays.copyOf((byte[])this.d, (int)this.d.length);
    }

    public String toString() {
        try {
            switch (this.b) {
                case 0: 
                case 1: {
                    return "Envelope not ciphered yet";
                }
                case 3: 
                case 4: {
                    return this.envelopedData.toString();
                }
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
        }
        return this.getClass().getName();
    }

    private void a(X509Certificate x509Certificate, byte[] byArray) throws CapiException {
        if (this.b <= 0) {
            throw new CapiException("Data must be set before", 50000);
        }
        if (this.b == 4 || this.b == 3) {
            throw new CapiException("Cannot add recipient", 51002);
        }
        a.debug("adding Recipient ...");
        try {
            if (this.b != 2) {
                this.e = new CMSEnvelopedDataGenerator();
            }
            if (byArray != null) {
                a.debug("Recipient subjectkeyidentifier ...");
                x509Certificate = new JceKeyTransRecipientInfoGenerator(byArray, x509Certificate.getPublicKey());
            } else {
                a.debug("Recipient Issuer and Serial number ...");
                x509Certificate = new JceKeyTransRecipientInfoGenerator(x509Certificate);
            }
            this.e.addRecipientInfoGenerator((RecipientInfoGenerator)x509Certificate.setProvider(ProvUtils.bcProvider));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
        a.debug("Recipient added.");
        this.b = 2;
    }
}

