/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.loader;

import com.sun.jna.Pointer;
import esecurity.crypto.gui.pdf.bean.PdfAnnotation;
import esecurity.crypto.gui.pdf.loader.PdfLoaderServer$PdfLoaderServer;
import esecurity.crypto.gui.pdf.loader.PdfPagesLoader$PdfLoaderServer;
import esecurity.crypto.gui.pdf.loader.mxtuvghn;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfPagesLoader {
    private static final EllipsLogger logger = PdfPagesLoader.ow("1ndc285", Constants.CAPI_LOGGER_NAME);
    private static final Object CLOSE_LOCK = new Object();
    private static ExecutorService EXECUTOR_SERVICE;
    private static Future<PdfPagesLoader> pdfParserLoader;
    private static PDFRenderer pdfRenderer;
    static Pointer pdfDocument;
    private static PDDocument pdd;
    private static int pages;
    private static Dimension[] pagesDimensions;
    private static boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncInitialize(File pdfFile) {
        closed = false;
        EXECUTOR_SERVICE = PdfPagesLoader.ow("1pqq27t");
        Object object = CLOSE_LOCK;
        synchronized (object) {
            pdfParserLoader = EXECUTOR_SERVICE.submit(() -> {
                try {
                    return new PdfPagesLoader(pdfFile);
                }
                catch (IOException ex) {
                    PdfPagesLoader.ow("-19kntnn", logger, PdfPagesLoader.ow("-f85tsk", ex), (Object)ex);
                    return null;
                }
            });
        }
    }

    private PdfPagesLoader(File pdfFile) throws IOException {
        Object convertedTmp = pdfFile;
        if (PdfPagesLoader.ow("1el827u", pdfFile) != false) {
            convertedTmp = PdfPagesLoader.ow("emi283", pdfFile);
        }
        ScratchFile SCRATCH_FILE_TEMP = new ScratchFile((MemoryUsageSetting)PdfPagesLoader.ow("-1coftns", 10000000L));
        Object pdfFileBuffer = PdfPagesLoader.ow("1rvs281", SCRATCH_FILE_TEMP, new FileInputStream((File)convertedTmp));
        PDFParser parser = new PDFParser((RandomAccessRead)pdfFileBuffer, SCRATCH_FILE_TEMP);
        PdfPagesLoader.ow("l9u282", parser);
        pdd = PdfPagesLoader.ow("5po237", parser);
        pdfRenderer = new PDFRenderer(pdd);
        pages = (int)PdfPagesLoader.ow("hjq238", pdd);
        pagesDimensions = new Dimension[pages];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BufferedImage loadPage(int page, float zoom) throws IOException {
        if (closed) {
            return null;
        }
        PdfPagesLoader.getLoaderOrThrowException();
        Object object = CLOSE_LOCK;
        synchronized (object) {
            Object image = null;
            try {
                image = PdfPagesLoader.ow("1rm4235", pdfRenderer, page, (float)zoom, (Object)ImageType.RGB);
                if (pagesDimensions[page] == null) {
                    PdfPagesLoader.pagesDimensions[page] = new Dimension((int)((float)PdfPagesLoader.ow("-1ufvtsq", image) / zoom), (int)((float)PdfPagesLoader.ow("blc23b", image) / zoom));
                }
            }
            catch (IOException ex) {
                PdfPagesLoader.ow("-19kntnn", logger, PdfPagesLoader.ow("-f85tsk", ex), (Object)ex);
            }
            return image;
        }
    }

    public static int getPageCount() throws IOException {
        if (closed) {
            return 0;
        }
        PdfPagesLoader.getLoaderOrThrowException();
        return pages;
    }

    public static boolean isLoaded() {
        return pdfParserLoader.isDone();
    }

    public static synchronized Dimension getPageDimension(int page, float zoom) throws IOException {
        if (closed) {
            return new Dimension();
        }
        PdfPagesLoader.getLoaderOrThrowException();
        if (pagesDimensions[page] != null) {
            return pagesDimensions[page];
        }
        try {
            Object image = PdfPagesLoader.ow("1rm4235", pdfRenderer, page, (float)zoom, (Object)ImageType.RGB);
            PdfPagesLoader.pagesDimensions[page] = new Dimension((int)PdfPagesLoader.ow("-1ufvtsq", image), (int)PdfPagesLoader.ow("blc23b", image));
            return pagesDimensions[page];
        }
        catch (IOException ex) {
            PdfPagesLoader.ow("-19kntnn", logger, PdfPagesLoader.ow("-f85tsk", ex), (Object)ex);
            return new Dimension(0, 0);
        }
    }

    public static List<PdfAnnotation> getPageAnnotations(int page) throws IOException {
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        PdfPagesLoader.getLoaderOrThrowException();
        try {
            Object annotationList = PdfPagesLoader.ow("27k23a", PdfPagesLoader.ow("img239", pdd, page));
            Iterator iterator = annotationList.iterator();
            while (iterator.hasNext()) {
                Object annotationType;
                PDAnnotation annotation = (PDAnnotation)iterator.next();
                Object annotationDict = PdfPagesLoader.ow("ebq23f", annotation);
                if (PdfPagesLoader.ow("-ndrtsg", annotationDict, COSName.V) != null || (annotationType = PdfPagesLoader.ow("13a223d", annotationDict, COSName.FT)) == null) continue;
                char[] cArray = "\u107a\u95e0\u311e\u4473".toCharArray();
                cArray[1] = (char)(cArray[1] ^ 0x1571);
                if (PdfPagesLoader.ow("r3u23j", PdfPagesLoader$PdfLoaderServer.U(cArray, (short)6674, false, false), PdfPagesLoader.ow("-1khbtsi", annotationType)) == false) continue;
                Object rect = PdfPagesLoader.ow("1li623k", annotationDict, COSName.RECT);
                Object annotationName = PdfPagesLoader.ow("-161htsf", annotationDict, COSName.T);
                Object llx = PdfPagesLoader.ow("1j7423i", rect, 0);
                Object lly = PdfPagesLoader.ow("1j7423i", rect, 1);
                Object urx = PdfPagesLoader.ow("1j7423i", rect, 2);
                Object ury = PdfPagesLoader.ow("1j7423i", rect, 3);
                annotations.add(new PdfAnnotation(new Rectangle((int)llx, (int)ury, (int)(urx - llx), (int)(ury - lly)), (String)annotationName));
            }
        }
        catch (IOException ex) {
            PdfPagesLoader.ow("-19kntnn", logger, PdfPagesLoader.ow("-f85tsk", ex), (Object)ex);
        }
        return annotations;
    }

    public static PDDocument getPDDocument() throws IOException {
        PdfPagesLoader.getLoaderOrThrowException();
        return pdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDocument() {
        Object object = CLOSE_LOCK;
        synchronized (object) {
            closed = true;
            try {
                PdfPagesLoader.ow("1uvs22n", pdd);
            }
            catch (IOException ex) {
                PdfPagesLoader.ow("-19kntnn", logger, PdfPagesLoader.ow("-f85tsk", ex), (Object)ex);
            }
        }
    }

    public static void shutDown() {
        EXECUTOR_SERVICE.shutdownNow();
        if (!closed) {
            PdfPagesLoader.closeDocument();
        }
    }

    private static PdfPagesLoader getLoaderOrThrowException() throws IOException {
        PdfPagesLoader loader = null;
        try {
            loader = pdfParserLoader.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            PdfPagesLoader.ow("-19kntnn", logger, PdfPagesLoader.ow("-1osvtnk", ex), (Object)ex);
        }
        if (loader == null) {
            char[] cArray = "\ub933\ubd11\u2a82\uee69\u8127\u9265\uaa0b\u0099\u5b2a\u49c4\u7e0e\ud042\ud866\ufb44\ue8e7\u1e75\u3e4d\u43c7\u53b0\ube80\ue91f\u0b61\u4e8a\u90d9\uc5bf\u24b4".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x3860);
            throw new IOException(PdfLoaderServer$PdfLoaderServer.G(cArray, (short)12722, false, false));
        }
        return loader;
    }

    static {
        pages = 0;
        closed = false;
    }

    private static Object ow(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(mxtuvghn.C(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

