/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsl.TSLPointer;
import it.actalis.ellips.capi.xml.parser.SignedXMLEnvelope;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class TSLVerifier {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Date b = null;
    private X509Certificate c = null;

    public void verifySignedXMLDocument(TSLPointer tSLPointer, File object) throws CapiException {
        Object object2;
        SignedXMLEnvelope signedXMLEnvelope;
        try {
            object = DataHandlerBuilder.get().setFile((File)object).buildInput();
        }
        catch (IOException iOException) {
            throw new CapiException("tslTemporaryFileName not found", 50040);
        }
        catch (Exception exception) {
            throw new CapiException("Unable to read tslTemporaryFileName", 50040, exception);
        }
        try {
            signedXMLEnvelope = new SignedXMLEnvelope((InputHandler)object);
            object2 = signedXMLEnvelope.listSigners();
        }
        finally {
            Util.closeQuietly((Closeable)object);
        }
        if (object2 == null || ((String[])object2).length <= 0) {
            a.debug("No signers found. TSL is not signed");
            throw new CapiException("TSL is not signed", 50001);
        }
        a.debug("Checking first TSL signature");
        try {
            object = signedXMLEnvelope.verify(0);
            object2 = new Certificate(((String)object).getBytes());
            this.c = ((Certificate)object2).getInternalCert();
            a.debug("TSL signature verified successfully.");
            a.debug("Signed TSL. TSL signer: " + this.c.getSubjectX500Principal());
            this.b = null;
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                if (signedXMLEnvelope.getNumSignatureTimeStamp(0) > 0 && (object2 = signedXMLEnvelope.getSignatureTimeStamp(0, 0)) != null) {
                    byteArrayInputStream = new ByteArrayInputStream(((TimeStampToken)object2).toByteArray(true));
                    object2 = new TimeStampResponse((InputStream)byteArrayInputStream);
                    this.b = Util.getDateFromTStamp(object2.getTimeStampToken());
                    a.debug("TSL TimeStamped signTime: " + this.b.toString());
                }
            }
            catch (Exception exception) {
                this.b = null;
            }
            finally {
                Util.closeQuietly(byteArrayInputStream);
            }
            if (this.b == null && (object2 = signedXMLEnvelope.getSigningTime(0)) != null) {
                try {
                    a.debug("[verifyXMLSignature] parse TSL signTime: " + (String)object2);
                    this.b = TSLVerifier.a((String)object2);
                    a.debug("TSL signTime: " + this.b.toString());
                }
                catch (Exception exception) {
                    a.debug("Unable to parse SignTime: " + exception.getMessage());
                }
            }
            int n = signedXMLEnvelope.getNumReference(0);
            a.debug("TSL signature has " + n + " Reference items...");
            for (int i = 0; i < n; ++i) {
                boolean bl = signedXMLEnvelope.getReferenceIsVerified(0, i);
                a.debug(i + " Reference verification is " + bl);
                if (bl) continue;
                a.debug("reference item " + i + " verification failed");
                throw new CapiException("reference item " + i + " verification failed ", 3010);
            }
            try {
                if (tSLPointer.getCacerts() != null) {
                    tSLPointer.getCacerts().verify(((String)object).getBytes());
                }
            }
            catch (CapiException capiException) {
                String string = new String(Base64.encode((byte[])new Certificate(((String)object).getBytes()).getSubjectKeyIdentifier()));
                if (tSLPointer.getNot_importable_ski() == null || !tSLPointer.getNot_importable_ski().contains(string)) {
                    throw new CapiException("Invalid certificate ", 3010);
                }
                return;
            }
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug("TSL has an invalid signature");
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception verifying TSL signature " + exception.getMessage(), 3010);
        }
    }

    public Date getSignDate() {
        return this.b;
    }

    public X509Certificate getTslSignerCertificate() {
        return this.c;
    }

    private static Date a(String string) throws Exception {
        try {
            Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
            cloneable = cloneable.parse(string);
            return cloneable;
        }
        catch (Exception exception) {
            try {
                Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
                cloneable = cloneable.parse(string);
                return cloneable;
            }
            catch (Exception exception2) {
                try {
                    Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
                    cloneable = cloneable.parse(string.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2"));
                    return cloneable;
                }
                catch (Exception exception3) {
                    a.debug("Exception parsing TSL issue date: " + exception3.getMessage());
                    return null;
                }
            }
        }
    }
}

