/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.ellips.capi.tsa.TSAUtil;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.ConfigParameter;
import it.arubapec.ca.utils.UserData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampResponse;

public class ArubaDTSClient
extends DTSClient {
    public ArubaDTSClient(ConfigParameter configParameter) throws IllegalParamException {
        this(configParameter.getTSAData(), configParameter.getNetConf());
    }

    public ArubaDTSClient(UserData object, String string, NetworkConfig networkConfig) {
        object = new TSAData(((UserData)object).getTsaUrl(), ((UserData)object).getTsaAlternativeUrl(), null, ((UserData)object).getTsaUsername(), ((UserData)object).getTsaPassword(), ((UserData)object).getTsaAlternativeUsername(), ((UserData)object).getTsaAlternativePassword());
        try {
            this.initializeClient((TSAData)object, networkConfig, string);
            return;
        }
        catch (IllegalParamException illegalParamException) {
            return;
        }
    }

    public ArubaDTSClient(TSAData tSAData) throws IllegalParamException {
        this(tSAData, new NetworkConfig(), null);
    }

    public ArubaDTSClient(TSAData tSAData, NetworkConfig networkConfig) throws IllegalParamException {
        this(tSAData, networkConfig, null);
    }

    public ArubaDTSClient(TSAData tSAData, NetworkConfig networkConfig, String string) throws IllegalParamException {
        super(tSAData, networkConfig, string);
    }

    @Override
    public void initializeClient(TSAData tSAData, NetworkConfig networkConfig, String string) throws IllegalParamException {
        this.tsaData = tSAData;
        this.netConf = networkConfig == null ? new NetworkConfig() : networkConfig;
        this.requestedUrl = string;
    }

    @Override
    @Deprecated
    public void setServer(String string, HTTP hTTP) {
        this.tsaData.setTSAUrl(string);
        this.netConf = hTTP.getConfig();
    }

    @Override
    @Deprecated
    public void setServer(String string, int n) {
        string = "https://" + string + ":" + n + "/tsa/FrontEnd";
        this.tsaData.setTSAUrl(string);
    }

    @Override
    @Deprecated
    public void setTimeout(long l) {
        this.netConf.setConnectionTimeOut("" + l);
    }

    @Override
    public TimeStampToken timeStamp(String string, String string2, byte[] byArray) throws TSAException {
        return this.timeStamp(string, string2, byArray, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String string, String string2, InputStream inputStream) throws TSAException {
        return this.timeStamp(string, string2, inputStream, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String object, String string, byte[] byArray, BigInteger bigInteger, boolean bl) throws TSAException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            object = this.timeStamp((String)object, string, byteArrayInputStream, bigInteger, bl);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(byteArrayInputStream);
            throw throwable;
        }
        Util.closeQuietly(byteArrayInputStream);
        return object;
    }

    @Override
    public TimeStampToken timeStamp(String object, String string, InputStream inputStream, BigInteger bigInteger, boolean bl) throws TSAException {
        try {
            object = TSAUtil.generateMarkRequest(inputStream, (String)object, bl);
            object = TSAUtil.getMarkFromRequest((TimeStampRequest)object, this.requestedUrl, this.tsaData, this.netConf);
            return new TimeStampToken(object.getEncoded());
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException exception) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, exception);
        }
    }

    @Override
    public TimeStampToken timeStampHash(String string, String string2, byte[] byArray) throws TSAException {
        return this.timeStampHash(string, string2, byArray, null, true);
    }

    @Override
    public TimeStampToken timeStampHash(String object, String string, byte[] byArray, BigInteger bigInteger, boolean bl) throws TSAException {
        try {
            object = TSAUtil.generateMarkRequest(string, bigInteger, byArray, (String)object, bl);
            object = TSAUtil.getMarkFromRequest((TimeStampRequest)object, this.tsaData, this.netConf);
            return new TimeStampToken(object.getEncoded());
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException exception) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    @Override
    public TimeStampResponse getMark(InputStream object, boolean bl) throws ApiGeneralException, IOException, TSAException {
        try {
            object = TSAUtil.getMark((InputStream)object, bl, this.tsaData, this.netConf);
            return object;
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException | TSPException throwable) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    @Override
    public byte[] stamp(InputStream inputStream, TimeStampOptions timeStampOptions) {
        BigInteger bigInteger = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(timeStampOptions.getTSAPolicy(), timeStampOptions.getTSADigestAlgorithm().toString(), inputStream, bigInteger, timeStampOptions.isTSACertReq()).toByteArray(false, true);
        }
        catch (CapiException | IOException exception) {
            EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME).debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public byte[] stampEx(InputStream object, TimeStampOptions timeStampOptions) throws TSAException {
        BigInteger bigInteger = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(timeStampOptions.getTSAPolicy(), timeStampOptions.getTSADigestAlgorithm().toString(), (InputStream)object, bigInteger, timeStampOptions.isTSACertReq()).toByteArray(false, true);
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException exception) {
            EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME).debug(exception.getMessage(), (Throwable)exception);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }
}

