/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class StepX509IssuerIdentityCheck
extends SingleValidationSubStepImpl {
    public StepX509IssuerIdentityCheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && (validationContextParameters.getSignature() == null || validationContextParameters.getSignature().getFormat() != null && !validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST)) && validationContextParameters.getSignerCertificate().getIssuer() != null && validationContextParameters.getSignerCertificate().getIssuer().getCert().getQcStatementSemanticIdentifier() != null) {
            if (validationContextParameters.getSignerCertificate().getIssuer().getCert().getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.2")) {
                boolean bl = false;
                try {
                    String[] stringArray = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                    String[] stringArray2 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.organization.getId());
                    String[] stringArray3 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                    String[] stringArray4 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.97");
                    if (stringArray != null && stringArray.length == 1 && stringArray2 != null && stringArray2.length == 1 && stringArray3 != null && stringArray3.length == 1 && stringArray4 != null && stringArray4.length == 1) {
                        bl = true;
                    }
                }
                catch (CapiException capiException) {
                    bl = false;
                }
                if (!bl) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0018_INVALID_CERT_ISSUER_SEMANTIC, new Object[0]);
                }
            } else if (validationContextParameters.getSignerCertificate().getIssuer().getCert().getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.1")) {
                boolean bl = false;
                try {
                    String[] stringArray = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                    String[] stringArray5 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.5");
                    String[] stringArray6 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                    String[] stringArray7 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.42");
                    String[] stringArray8 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.4");
                    String[] stringArray9 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.65");
                    if (stringArray != null && stringArray.length == 1 && stringArray5 != null && stringArray5.length == 1 && stringArray6 != null && stringArray6.length == 1 && (stringArray7 != null && stringArray7.length == 1 && stringArray8 != null && stringArray8.length == 1 || stringArray9 != null && stringArray9.length == 1)) {
                        bl = true;
                    }
                }
                catch (CapiException capiException) {
                    bl = false;
                }
                if (!bl) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0018_INVALID_CERT_ISSUER_SEMANTIC, new Object[0]);
                }
            }
        }
        return null;
    }
}

