/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.VerifiedSerial;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;

public class CRLUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void addRefCrl(LinkedList<RefCRL> serializable, CRL cRL, LinkedList<X509Certificate> linkedList) {
        LinkedList<X509Certificate> linkedList2 = new LinkedList<X509Certificate>();
        for (X509Certificate x509Certificate : linkedList) {
            try {
                X509Certificate x509Certificate2 = x509Certificate;
                if (!cRL.canUseFor(x509Certificate2, x509Certificate2.getNotBefore())) continue;
                linkedList2.add(x509Certificate);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        if (linkedList2.size() == 0) {
            return;
        }
        Object object2 = null;
        boolean bl = false;
        try {
            String string = Utils.calculateDigest(new ByteArrayInputStream(cRL.getInternalCRL().getEncoded()), Constants.SHA256);
            Iterator object3 = ((AbstractSequentialList)((Object)serializable)).iterator();
            while (object3.hasNext()) {
                RefCRL refCRL = (RefCRL)object3.next();
                if (!refCRL.getId().equals(string)) continue;
                object2 = refCRL;
                break;
            }
            if (object2 == null) {
                object2 = new RefCRL();
                ((RefCRL)object2).setId(string);
                ((LinkedList)serializable).add(object2);
            }
            for (X509Certificate x509Certificate : linkedList) {
                if (!Utils.retrieveCommonName(cRL.getIssuerDN()).equals(Utils.retrieveCommonName(x509Certificate.getSubjectDN().toString()))) continue;
                cRL.verify(x509Certificate.getEncoded());
                ((RefCRL)object2).setId(string);
                ((RefCRL)object2).setIssuerDn(cRL.getIssuerDN());
                ((RefCRL)object2).setIdps(cRL.getIdps());
                ((RefCRL)object2).setUpdateDate(cRL.getInternalCRL().getThisUpdate());
                ((RefCRL)object2).setNextUpdate(cRL.getInternalCRL().getNextUpdate());
                bl = true;
                break;
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        catch (CRLException cRLException) {
            a.error(cRLException.getMessage(), (Throwable)cRLException);
        }
        ((RefCRL)object2).setValid(bl);
        for (X509Certificate x509Certificate : linkedList2) {
            try {
                VerifiedSerial verifiedSerial = new VerifiedSerial();
                serializable = x509Certificate.getSerialNumber();
                verifiedSerial.setSerial(((BigInteger)serializable).toString(16));
                verifiedSerial.setRevoked(cRL.isRevoked(x509Certificate.getSerialNumber()));
                if (verifiedSerial.isRevoked()) {
                    verifiedSerial.setReasonCode(cRL.getReasonCode((BigInteger)serializable));
                    verifiedSerial.setRevocationDate(cRL.getInternalCRL().getRevokedCertificate((BigInteger)serializable).getRevocationDate());
                }
                ((RefCRL)object2).addVerifiedSerial(verifiedSerial);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
    }
}

