/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client;

import esecurity.dsd.client.DomainConfigProvider;
import esecurity.dsd.client.DomainServiceDiscovery;
import esecurity.dsd.client.cache.CacheProvider;
import esecurity.dsd.client.cache.CacheUpdater;
import esecurity.dsd.client.config.RemoteConfigProvider;
import esecurity.dsd.core.DomainProvider;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.Log;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;

public final class DSDFactory {
    private static Map<String, DSD> instances = new LinkedHashMap<String, DSD>();

    public static boolean isInitialized() {
        return !instances.isEmpty();
    }

    public static boolean isAppConfigured(String applicationKey) {
        return instances.containsKey(applicationKey);
    }

    public static void bootstrap(String applicationKey, RemoteConfigProvider dsdServer1, RemoteConfigProvider dsdServer2, Observer observer, DomainConfigProvider ... domains) throws Exception {
        DSDFactory.bootstrap(applicationKey, dsdServer1, dsdServer2, new ArrayList<String>(), observer, domains);
    }

    public static void bootstrap(String applicationKey, RemoteConfigProvider dsdServer1, RemoteConfigProvider dsdServer2, List<String> defaultDomains, Observer observer, DomainConfigProvider ... domains) throws Exception {
        if (!instances.containsKey(applicationKey)) {
            if (dsdServer1 == null || dsdServer2 == null) {
                throw new IllegalArgumentException("Invalid remote configuration. Needs almost 2 servers.");
            }
            LocalConfigurationProvider[] providers = new LocalConfigurationProvider[2 + domains.length];
            providers[0] = dsdServer1;
            providers[1] = dsdServer2;
            int i = 2;
            for (DomainConfigProvider domain : domains) {
                providers[i++] = domain;
            }
            DomainServiceDiscovery dsd = null;
            try {
                dsd = new DomainServiceDiscovery();
                DomainProvider domainProvider = dsd.bootstrap(observer, defaultDomains, providers);
                DSD instance = new DSD();
                instance.domainProvider = domainProvider;
                instance.dsd = dsd;
                instances.put(applicationKey, instance);
            }
            catch (Exception e) {
                if (dsd != null) {
                    dsd.close();
                }
                e.printStackTrace();
                Log.logger().error("Error ".concat(e.getMessage()));
                throw e;
            }
        }
    }

    public static void bootstrap(String applicationKey, RemoteConfigProvider dsdServer1, RemoteConfigProvider dsdServer2, Observer observer, Logger logger, DomainConfigProvider ... domains) throws Exception {
        DSDFactory.bootstrap(applicationKey, dsdServer1, dsdServer2, new ArrayList<String>(), observer, logger, domains);
    }

    public static void bootstrap(String applicationKey, RemoteConfigProvider dsdServer1, RemoteConfigProvider dsdServer2, List<String> defaultDomains, Observer observer, Logger logger, DomainConfigProvider ... domains) throws Exception {
        Log.setLogger((Logger)logger);
        if (!instances.containsKey(applicationKey)) {
            if (dsdServer1 == null || dsdServer2 == null) {
                throw new IllegalArgumentException("Invalid remote configuration. Needs almost 2 servers.");
            }
            LocalConfigurationProvider[] providers = new LocalConfigurationProvider[2 + domains.length];
            providers[0] = dsdServer1;
            providers[1] = dsdServer2;
            int i = 2;
            for (DomainConfigProvider domain : domains) {
                providers[i++] = domain;
            }
            DomainServiceDiscovery dsd = null;
            try {
                dsd = new DomainServiceDiscovery();
                DomainProvider domainProvider = dsd.bootstrap(observer, defaultDomains, providers);
                DSD instance = new DSD();
                instance.domainProvider = domainProvider;
                instance.dsd = dsd;
                instances.put(applicationKey, instance);
            }
            catch (Exception e) {
                if (dsd != null) {
                    dsd.close();
                }
                e.printStackTrace();
                Log.logger().error("Error ".concat(e.getMessage()));
                throw e;
            }
        }
    }

    public static DomainProvider getProvider(String applicationKey) throws UnknownApplicationKeyException {
        return Optional.ofNullable(DSDFactory.instances.get((Object)applicationKey)).orElseThrow((Supplier<UnknownApplicationKeyException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getProvider$0(), ()Lesecurity/dsd/client/DSDFactory$UnknownApplicationKeyException;)()).domainProvider;
    }

    public static Object get(String applicationKey, String domain, String key) throws Exception {
        return DSDFactory.getProvider(applicationKey).lookupValue(domain, key).orElse(null);
    }

    public static String getString(String applicationKey, String domain, String key) throws Exception {
        return DSDFactory.getProvider(applicationKey).getDomainProperties(domain).getValue(key, String.class).orElse(null);
    }

    public static char[] getBlob(String applicationKey, String domain, String key) throws Exception {
        return DSDFactory.getProvider(applicationKey).getDomainProperties(domain).getValue(key, char[].class).orElse(null);
    }

    public static Integer getInt(String applicationKey, String domain, String key) throws Exception {
        return DSDFactory.getProvider(applicationKey).getDomainProperties(domain).getValue(key, Integer.class).orElse(null);
    }

    public static Float getFloat(String applicationKey, String domain, String key) throws Exception {
        return DSDFactory.getProvider(applicationKey).getDomainProperties(domain).getValue(key, Float.class).orElse(null);
    }

    public static boolean exists(String applicationKey, String domain, String key) throws Exception {
        return DSDFactory.getProvider(applicationKey).lookupValue(domain, key).isPresent();
    }

    public static void addDomain(String applicationKey, String domain) throws Exception {
        if (DSDFactory.isInitialized()) {
            CacheProvider provider = (CacheProvider)DSDFactory.getProvider(applicationKey);
            if (provider == null) {
                throw new NullPointerException("Failed to retrieve CacheProvider");
            }
            provider.addDomain(domain);
            new Thread(() -> {
                CacheUpdater updater = new CacheUpdater(provider);
                updater.updateDomain(domain);
            }).start();
        }
    }

    public static void close(String applicationKey) {
        if (instances.containsKey(applicationKey)) {
            try {
                DSDFactory.instances.remove((Object)applicationKey).dsd.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static /* synthetic */ UnknownApplicationKeyException lambda$getProvider$0() {
        return new UnknownApplicationKeyException();
    }

    private static final class DSD {
        DomainServiceDiscovery dsd;
        DomainProvider domainProvider;

        private DSD() {
        }
    }

    public static class Builder {
        private String appKey = "";
        private List<DomainConfigProvider> domains = new LinkedList<DomainConfigProvider>();
        private List<RemoteConfigProvider> remotes = new LinkedList<RemoteConfigProvider>();
        private List<Observer> observers = new LinkedList<Observer>();

        public Builder remotes(RemoteConfigProvider r1, RemoteConfigProvider r2) {
            this.remotes.add(r1);
            this.remotes.add(r2);
            return this;
        }
    }

    public static final class UnknownApplicationKeyException
    extends Exception {
    }
}

