/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenManager;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.ellips.capi.rs.ARSSAutomaticSignatureToken;
import it.actalis.ellips.capi.rs.ARSSAutomaticSignatureTokenV2;
import it.actalis.ellips.capi.rs.ARSSSignatureToken;
import it.actalis.ellips.capi.rs.ARSSSignatureTokenV2;
import it.actalis.ellips.capi.rs.HsmBeToken;
import it.actalis.ellips.capi.rs.RemoteSignatureToken;
import it.actalis.ellips.capi.rs.RemoteSignatureTokenV2;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import org.slf4j.Logger;

public class RemoteSignatureTokenManagerImpl
implements TokenManager {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public Provider retrieveProviderForKey(PrivateKey key) {
        if (key instanceof Actalis_PrivateKey) {
            return ActalisSingleton.getActalisProvider();
        }
        return null;
    }

    public TokenSpi retrieveTokenByAlias(String alias) {
        try {
            return Token.getTokenSpi((String)alias);
        }
        catch (CapiException ex) {
            logger.info("Nessun Token Trovato per questo alias.");
            return null;
        }
    }

    public TokenSpi initToken(String tokenType) {
        TokenSpi tk = null;
        if (tokenType.equals("RemoteSignatureToken")) {
            logger.debug("trying to load Remote Signature Token...");
            return new RemoteSignatureToken();
        }
        if (tokenType.equals("RemoteSignatureTokenV2")) {
            logger.debug("trying to load Remote Signature Token V2...");
            return new RemoteSignatureTokenV2();
        }
        if (tokenType.equals("ARSSSignatureToken")) {
            logger.debug("trying to load ARSS Signature Token...");
            return new ARSSSignatureToken();
        }
        if (tokenType.equals("ARSSAutomaticSignatureToken")) {
            logger.debug("trying to load automatic ARSS Signature Token...");
            return new ARSSAutomaticSignatureToken();
        }
        if (tokenType.equals("ARSSSignatureTokenV2")) {
            logger.debug("trying to load ARSS Signature Token V2...");
            return new ARSSSignatureTokenV2();
        }
        if (tokenType.equals("ARSSAutomaticSignatureTokenV2")) {
            logger.debug("trying to load automatic ARSS Signature Token V2...");
            return new ARSSAutomaticSignatureTokenV2();
        }
        if (tokenType.equals("HsmBeToken")) {
            logger.debug("trying to load Hsm BackEnd Token...");
            return new HsmBeToken();
        }
        return tk;
    }
}

