/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import java.io.IOException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessRead;

public class RangeRandomAccess
implements RandomAccessRead {
    private RandomAccess input;
    private long position;
    private long min;
    private long max;

    public RangeRandomAccess(RandomAccess randomAccess, int min, int max) {
        this.input = randomAccess;
        this.position = 0L;
        this.min = min;
        this.max = max;
    }

    void restorePosition() throws IOException {
        this.input.seek(this.min + this.position);
    }

    public int available() throws IOException {
        this.restorePosition();
        long available = this.input.length() - this.input.getPosition();
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    public int read() throws IOException {
        this.restorePosition();
        if (this.isEOF()) {
            return -1;
        }
        int b = this.input.read();
        ++this.position;
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.restorePosition();
        if (this.isEOF()) {
            return -1;
        }
        int new_len = len;
        if (this.min + this.position + (long)len > this.max) {
            new_len = (int)(this.max - (this.min + this.position));
        }
        int n = this.input.read(b, off, new_len);
        this.position += (long)n;
        return n;
    }

    public int read(byte[] b) throws IOException {
        this.restorePosition();
        if (this.isEOF()) {
            return -1;
        }
        long len = b.length;
        if (this.min + this.position + (long)b.length > this.max) {
            len = this.max - (this.min + this.position);
        }
        this.position += len;
        this.input.read(b, 0, (int)len);
        return (int)len;
    }

    public long getPosition() throws IOException {
        return this.position;
    }

    public void seek(long newposition) throws IOException {
        if (this.position < 0L) {
            throw new IOException("Invalid position " + this.position);
        }
        if (newposition < this.max - this.min) {
            this.input.seek(this.min + newposition);
            this.position = newposition;
        } else {
            this.position = this.max;
        }
    }

    public long length() throws IOException {
        return this.max - this.min;
    }

    public boolean isClosed() {
        return this.input.isClosed();
    }

    public int peek() throws IOException {
        int result = this.read();
        if (result != -1) {
            this.rewind(1);
        }
        return result;
    }

    public void rewind(int bytes) throws IOException {
        this.seek(this.getPosition() - (long)bytes);
    }

    public byte[] readFully(int length) throws IOException {
        long len = length;
        if (this.min + this.position + (long)length > this.max) {
            len = this.max - (this.min + this.position);
        }
        this.position += len;
        return this.input.readFully((int)len);
    }

    public boolean isEOF() throws IOException {
        return this.min + this.position >= this.max || this.input.isEOF();
    }

    public void close() throws IOException {
        this.input.close();
    }
}

