/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.pades.PadesUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class PadesDssInfo {
    private PDDocument document = null;
    private COSDictionary dicDSS = null;
    private LinkedList<X509Certificate> certs = new LinkedList();
    private LinkedList<BasicOCSPResp> ocsps = new LinkedList();
    private LinkedList<CRL> crls = new LinkedList();

    public PadesDssInfo(PDDocument document, COSDictionary dicDSS) {
        this.document = document;
        this.dicDSS = dicDSS;
    }

    public COSDictionary getDicDSS() {
        return this.dicDSS;
    }

    public void setDicDSS(COSDictionary dicDSS) {
        this.dicDSS = dicDSS;
    }

    public LinkedList<X509Certificate> getCerts() {
        return this.certs;
    }

    public void setCerts(LinkedList<X509Certificate> certs) {
        this.certs = certs;
    }

    public LinkedList<BasicOCSPResp> getOcsps() {
        return this.ocsps;
    }

    public void setOcsps(LinkedList<BasicOCSPResp> ocsps) {
        this.ocsps = ocsps;
    }

    public LinkedList<CRL> getCrls() {
        return this.crls;
    }

    public void setCrls(LinkedList<CRL> crls) {
        this.crls = crls;
    }

    public void addCertificate(X509Certificate cert, String VRI) throws CertificateEncodingException, IOException {
        COSStream stream = this.createStream(this.document, false, cert.getEncoded());
        this.dicDSS.setNeedToBeUpdated(true);
        if (!this.certs.contains(cert)) {
            COSArray certsArray = this.retrieveArray(this.dicDSS, "Certs");
            certsArray.add((COSBase)stream);
        }
        if (VRI != null) {
            COSArray certArray = this.retrieveArray(this.retrieveVriDic(VRI), "Cert");
            certArray.add((COSBase)stream);
        }
    }

    public void addCrl(CRL crl, String VRI) throws IOException, CRLException {
        COSStream stream = this.createStream(this.document, false, crl.getInternalCRL().getEncoded());
        this.dicDSS.setNeedToBeUpdated(true);
        if (!this.crls.contains(crl)) {
            COSArray crlsArray = this.retrieveArray(this.dicDSS, "CRLs");
            crlsArray.add((COSBase)stream);
        }
        if (VRI != null) {
            COSArray ocspArray = this.retrieveArray(this.retrieveVriDic(VRI), "CRL");
            ocspArray.add((COSBase)stream);
        }
    }

    public void addOcsp(OCSPResponse ocsp, String VRI) throws IOException {
        COSStream stream = this.createStream(this.document, false, ocsp.getFullOcspResponse().getEncoded());
        this.dicDSS.setNeedToBeUpdated(true);
        if (!this.ocsps.contains(ocsp.getBasicOcspResponse())) {
            COSArray ocspsArray = this.retrieveArray(this.dicDSS, "OCSPs");
            ocspsArray.add((COSBase)stream);
        }
        if (VRI != null) {
            COSArray ocspArray = this.retrieveArray(this.retrieveVriDic(VRI), "OCSP");
            ocspArray.add((COSBase)stream);
        }
    }

    private COSDictionary retrieveVriDic(String VRI) {
        COSDictionary dicReturn = null;
        COSDictionary vri = (COSDictionary)this.dicDSS.getDictionaryObject("VRI");
        if (vri == null) {
            vri = new COSDictionary();
            this.dicDSS.setItem("VRI", (COSBase)vri);
        } else {
            vri.setNeedToBeUpdated(true);
        }
        dicReturn = (COSDictionary)vri.getDictionaryObject(VRI);
        if (dicReturn == null) {
            dicReturn = new COSDictionary();
            vri.setItem(VRI, (COSBase)dicReturn);
        } else {
            dicReturn.setNeedToBeUpdated(true);
        }
        return dicReturn;
    }

    private COSArray retrieveArray(COSDictionary dic, String name) {
        COSArray arrReeturn = PadesUtils.parseArray(dic, name);
        if (arrReeturn == null) {
            arrReeturn = new COSArray();
            dic.setItem(name, (COSBase)arrReeturn);
        } else {
            arrReeturn.setNeedToBeUpdated(true);
        }
        return arrReeturn;
    }

    private COSStream createStream(PDDocument document, boolean direct, byte[] arrByte) throws IOException {
        COSArray filters = new COSArray();
        COSStream objReturn = document.getDocument().createCOSStream();
        objReturn.setDirect(direct);
        filters.add((COSBase)COSName.FLATE_DECODE);
        OutputStream os = objReturn.createOutputStream((COSBase)filters);
        os.write(arrByte);
        os.close();
        return objReturn;
    }
}

