/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.vol.utils.Constants;
import java.util.Comparator;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.slf4j.Logger;

public class CompareByteRangeSignature
implements Comparator<PadesSignatureInformation> {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    @Override
    public int compare(PadesSignatureInformation s1, PadesSignatureInformation s2) {
        COSDictionary cert = s1.getSignatureDictionary();
        PDSignature p1 = new PDSignature(cert);
        int[] byteRange1 = p1.getByteRange();
        if (byteRange1 == null || byteRange1.length < 2) {
            logger.debug("byteRange1==null || byteRange1.size()<2 ");
            return -1;
        }
        cert = s2.getSignatureDictionary();
        PDSignature p2 = new PDSignature(cert);
        int[] byteRange2 = p2.getByteRange();
        if (byteRange2 == null || byteRange2.length < 2) {
            if (logger.isDebugEnabled()) {
                logger.debug("byteRange2==null || byteRange2.size()<2 ");
            }
            return -1;
        }
        if (byteRange1[1] < byteRange2[1]) {
            if (logger.isDebugEnabled()) {
                logger.debug("byteRange1[1] " + byteRange1[1] + " less than byteRange2[1] " + byteRange2[1]);
            }
            return -1;
        }
        if (byteRange1[1] == byteRange2[1]) {
            if (logger.isDebugEnabled()) {
                logger.debug("byteRange1[1] " + byteRange1[1] + " equal to byteRange2[1] " + byteRange2[1]);
            }
            return 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("byteRange1[1] " + byteRange1[1] + " more than byteRange2[1] " + byteRange2[1]);
        }
        return 1;
    }
}

