/*
 * Decompiled with CFR 0.152.
 */
package esecurity.rest;

import com.google.gson.Gson;
import esecurity.rest.RestException;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.slf4j.Logger;

public abstract class RestRequest {
    private UrlClient client;
    private String method;
    private String url;
    protected InputStream body_content = null;
    protected String contentType = null;
    protected Logger logger = null;
    private CacheOutputStream os = null;
    protected URLCredentials cred = null;

    RestRequest(UrlClient client, String url, String method, Logger logger) {
        this.client = client;
        this.url = url;
        this.method = method;
        this.logger = logger;
        try {
            this.os = new CacheOutputStream(2000000);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String asDocument() {
        return null;
    }

    public String asJson() {
        return null;
    }

    private InputStream requestToStream() throws RestException {
        UrlReturn objReturn;
        RequestData data = null;
        if (this.method.equals("POST")) {
            data = new RequestData();
            data.setPostStream(this.body_content);
            data.setContentType(this.contentType);
            data.setType("JSON");
        }
        if (this.os != null) {
            this.os.close();
            try {
                this.os = new CacheOutputStream(2000000);
            }
            catch (IOException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                throw new RestException("Unable to create outputstream", ex, null, null, null, 500);
            }
        }
        if ((objReturn = this.client.downloadHttpUrl(this.url, data, this.cred, (OutputStream)this.os, null)).getStatus().equals("OK")) {
            try {
                return this.os.getCache();
            }
            catch (IOException ex) {
                throw new RestException("Rest Caused By --> " + ex.getMessage(), ex, null, null, null, 500);
            }
        }
        throw new RestException("Rest unable to connect to server code:" + objReturn.getStatus_code(), objReturn.getStatusMessage(), objReturn.getErrordata(), objReturn.getStatus(), objReturn.getStatus_code());
    }

    public <T> T asObject(Class<T> classOfT) throws RestException {
        InputStream is = this.requestToStream();
        if (is != null) {
            Gson gson = new Gson();
            return (T)gson.fromJson((Reader)new InputStreamReader(is), classOfT);
        }
        return null;
    }

    public void finalize() {
        if (this.os != null) {
            this.os.close();
        }
    }
}

