/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.dts.Client;
import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.IllegalParamException;
import esecurity.validator.parser.utils.EventHandlerMultiSelector;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.OcspUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.net.HTTP_URLConnection;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.RFC4519InternalStyle;
import it.actalis.ellips.capi.xml.DOMSubTreeData;
import it.actalis.ellips.capi.xml.InternalKeySelector;
import it.actalis.ellips.capi.xml.InternalUriDereferencer;
import it.actalis.ellips.capi.xml.parser.CounterSignedXMLEnvelope;
import it.actalis.ellips.capi.xml.utils.XMLUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ProgressMonitor;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SignedXMLEnvelope {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static XMLSignatureFactory fac = XMLUtils.getXMLSignatureFactoryInstance();
    public static final int ENVELOPED = 1;
    public static final int ENVELOPING = 2;
    public static final int DETACHED = 3;
    public static final int CANONIC_INCLUDE = 4;
    public static final int CANONIC_EXCLUDE = 5;
    private static final int UNDEFINED = 0;
    private static final int SIGNEDPROPERTIES = 4;
    private LinkedList<X509Certificate> certificates = new LinkedList();
    private HashMap<Integer, LinkedList<X509Certificate>> certsForSigner = new HashMap();
    private HashMap<Integer, LinkedList<CRL>> crlsForSigner = new HashMap();
    private HashMap<Integer, LinkedList<BasicOCSPResp>> ocspsForSigner = new HashMap();
    private InternalUriDereferencer internalUriDereferencer;
    NamespaceContext nsctx = null;
    private Document parsedDoc = null;
    private String[] signingTime = null;
    private boolean[] signingCert = null;
    private boolean[] signingCertV2 = null;
    private String[] signingCertDigestMethod = null;
    private String[] signingCertDigestValue = null;
    private String[] signingCertIssuerSerialName = null;
    private BigInteger[] signingCertIssuerSerialNumber = null;
    private ItemList[] counterSig = null;
    private Element[][] signatureTimeStamp = null;
    private String[] idlist = null;
    private Node[] dsParent = null;
    private String[] dnlist = null;
    private String[] certlist = null;
    private String[] digestlist = null;
    private String[] encdigestlist = null;
    private boolean[] verifiedlist = null;
    private boolean[][] referencedIsVerified = null;
    private Reference[][] reference;
    private boolean[] parsed = null;
    private String canonicalizerOfSignedInfo = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
    private String mimetype = "text/xml";
    private String encoding = "UTF-8";
    private int maxTransformNum = 5;
    private int transformNum = 0;
    private String[] transformAlg = null;
    private String[] transformFilter = null;
    private String[] transformFilterNSPrefix = null;
    private String[] transformFilterNSUri = null;
    private String[] transformExpr = null;
    private NodeList signatureList = null;
    private String referredStylesheet = null;
    private ProcessingInstruction nodeStylesheet = null;
    private String baseUri = "";
    private boolean isCounterSignedEnvelope = false;
    protected int signerIndexToBeCSigned = 0;
    private XMLSignature signatureToBeCSigned = null;
    protected Element counterSignatureElem = null;
    private String TSA = null;
    private String TSAhashAlgorithm = null;
    private String TSApolicy = null;
    private boolean TSAcertReq = true;
    private HttpsClient TSAhttps = null;
    private String TSABasicAuthUser = null;
    private String TSABasicAuthPassword = null;
    private DTSClient TSAClient = null;
    private String msgDigestToBeUsed = "http://www.w3.org/2001/04/xmlenc#sha256";
    private int mode = -1;
    private ProgressMonitor progressMonitor = null;
    private String[] note = null;
    private int tot;
    private int status = -1;
    private static final int ST_SIGN = 2;
    private static final int ST_PARSED = 3;

    public SignedXMLEnvelope(InputHandler infile, String baseURI, HttpsClient https, ProgressMonitor progMonitor, String[] notes) throws CapiException {
        this(infile, baseURI, https, progMonitor, notes, null, null);
    }

    public SignedXMLEnvelope(InputHandler infile, String baseURI, HttpsClient https, ProgressMonitor progMonitor, String[] notes, EventHandlerSelector fileSelector, InternalUriDereferencer internalUriDereferencer) throws CapiException {
        String aid;
        if (baseURI != null) {
            this.setBaseURI(baseURI);
        }
        this.status = -1;
        if (logger.isDebugEnabled()) {
            this.print("done init..");
        }
        if (logger.isDebugEnabled()) {
            this.print("loading XML envelope...");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException se) {
            if (logger.isDebugEnabled()) {
                logger.debug(se.getMessage(), (Throwable)se);
            }
            throw new CapiException("XML SAXNotRecognized", 50040);
        }
        boolean isValidated = false;
        if (!isValidated) {
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.parsedDoc = db.parse(infile.getInputAsNewStream());
                if (this.internalUriDereferencer == null) {
                    this.internalUriDereferencer = new InternalUriDereferencer(https, fileSelector, db);
                    this.internalUriDereferencer.setDocument(infile);
                } else {
                    this.internalUriDereferencer = internalUriDereferencer;
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw new CapiException("Envelope format unknown or not implemented", 50023);
            }
        }
        NodeList allNodes = this.parsedDoc.getElementsByTagName("*");
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Element node = (Element)allNodes.item(i);
            String aid2 = node.getAttribute("Id");
            if (aid2 != null && !aid2.equals("")) {
                node.setIdAttribute("Id", true);
                continue;
            }
            aid2 = node.getAttribute("ID");
            if (aid2 == null || aid2.equals("")) continue;
            node.setIdAttribute("ID", true);
        }
        String doc_id = this.parsedDoc.getDocumentElement().getAttribute("Id");
        if (doc_id != null && !doc_id.equals("")) {
            this.parsedDoc.getDocumentElement().setIdAttribute("Id", true);
        }
        NodeList listXades = this.parsedDoc.getElementsByTagName("xades:SignedProperties");
        for (int i = 0; i < listXades.getLength(); ++i) {
            String aid3 = ((Element)listXades.item(i)).getAttribute("Id");
            if (aid3 == null || aid3.equals("")) continue;
            ((Element)listXades.item(i)).setIdAttribute("Id", true);
        }
        NodeList listXades2 = this.parsedDoc.getElementsByTagName("SignedProperties");
        for (int i = 0; i < listXades2.getLength(); ++i) {
            String aid4 = ((Element)listXades2.item(i)).getAttribute("Id");
            if (aid4 == null || aid4.equals("")) continue;
            ((Element)listXades2.item(i)).setIdAttribute("Id", true);
        }
        NodeList listXade3 = this.parsedDoc.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedProperties");
        for (int i = 0; i < listXade3.getLength(); ++i) {
            String aid5 = ((Element)listXade3.item(i)).getAttribute("Id");
            if (aid5 == null || aid5.equals("")) continue;
            ((Element)listXade3.item(i)).setIdAttribute("Id", true);
        }
        NodeList listDSobject = this.parsedDoc.getElementsByTagName("ds:Object");
        for (int i = 0; i < listDSobject.getLength(); ++i) {
            String aid6 = ((Element)listDSobject.item(i)).getAttribute("Id");
            if (aid6 == null || aid6.equals("")) continue;
            ((Element)listDSobject.item(i)).setIdAttribute("Id", true);
        }
        NodeList listKeyInfo = this.parsedDoc.getElementsByTagName("ds:KeyInfo");
        for (int i = 0; i < listKeyInfo.getLength(); ++i) {
            String aid7 = ((Element)listKeyInfo.item(i)).getAttribute("Id");
            if (aid7 == null || aid7.equals("")) continue;
            ((Element)listKeyInfo.item(i)).setIdAttribute("Id", true);
        }
        NodeList listRevision = this.parsedDoc.getElementsByTagName("Revision");
        for (int i = 0; i < listRevision.getLength(); ++i) {
            aid = ((Element)listRevision.item(i)).getAttribute("ID");
            if (aid == null || aid.equals("")) continue;
            ((Element)listRevision.item(i)).setIdAttribute("ID", true);
        }
        Node atto = this.parsedDoc.getElementsByTagName("Atto").item(0);
        if (atto != null) {
            aid = ((Element)atto).getAttribute("ID");
            if (aid != null && !aid.equals("")) {
                ((Element)atto).setIdAttribute("ID", true);
            }
        } else {
            String aid8;
            listRevision = this.parsedDoc.getElementsByTagName("Revision");
            for (int i = 0; i < listRevision.getLength(); ++i) {
                String aid9 = ((Element)listRevision.item(i)).getAttribute("ID");
                if (aid9 == null || aid9.equals("")) continue;
                ((Element)listRevision.item(i)).setIdAttribute("ID", true);
            }
            atto = this.parsedDoc.getElementsByTagName("Atto").item(0);
            if (atto != null && (aid8 = ((Element)atto).getAttribute("ID")) != null && !aid8.equals("")) {
                ((Element)atto).setIdAttribute("ID", true);
            }
        }
        this.lookForPI(this.parsedDoc);
        this.nsctx = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("xades")) {
                    return "http://uri.etsi.org/01903/v1.3.2#";
                }
                if (prefix.equals("ds")) {
                    return "http://www.w3.org/2000/09/xmldsig#";
                }
                return null;
            }

            public Iterator getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }
        };
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(this.nsctx);
            XPathExpression expres = xPath.compile("//ds:Signature[not(ancestor::ds:Signature)]");
            this.signatureList = (NodeList)expres.evaluate(this.parsedDoc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new CapiException("XPathExpressionException getting Signature Nodes", 50001);
        }
        if (this.signatureList.getLength() == 0) {
            throw new CapiException("Envelope not signed", 50001);
        }
        this.progressMonitor = progMonitor;
        this.note = notes;
        this.parseNodeList(this.signatureList, fileSelector);
        this.status = 3;
    }

    public SignedXMLEnvelope(InputHandler infile, String baseURI, HttpsClient https) throws CapiException {
        this(infile, baseURI, https, null, null);
    }

    public SignedXMLEnvelope(InputHandler infile, String baseURI) throws CapiException {
        this(infile, baseURI, null);
    }

    public SignedXMLEnvelope(InputHandler infile, HttpsClient https) throws CapiException {
        this(infile, null, https);
    }

    public SignedXMLEnvelope(InputHandler infile) throws CapiException {
        this(infile, null, null);
    }

    public SignedXMLEnvelope(InputHandler infile, InternalUriDereferencer internalUriDereferencer) throws CapiException {
        this(infile, null, null, null, null, null, internalUriDereferencer);
    }

    public SignedXMLEnvelope(InputHandler infile, EventHandlerSelector fileSelector) throws CapiException {
        this(infile, null, null, null, null, fileSelector, null);
    }

    private void lookForPI(Document doc) {
        this.dumpPI(doc);
    }

    private void dumpPI(Node node) {
        switch (node.getNodeType()) {
            case 7: {
                this.dumpXmlStylesheetPI((ProcessingInstruction)node);
                break;
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.dumpPI(list.item(i));
        }
    }

    private void dumpXmlStylesheetPI(ProcessingInstruction node) {
        if (logger.isDebugEnabled()) {
            this.print("[dumpProcesssInstruction] PI: target=" + node.getTarget());
        }
        if (logger.isDebugEnabled()) {
            this.print("[dumpProcesssInstruction] PI: data=" + node.getData());
        }
        if (node.getTarget().startsWith("xml-stylesheet")) {
            Node parent = node.getParentNode();
            if (parent != null && parent.getNodeType() == 9) {
                this.nodeStylesheet = node;
            }
            int idx = -1;
            idx = node.getData().indexOf("href=");
            if (idx < 0) {
                if (logger.isDebugEnabled()) {
                    this.print("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            String style = node.getData().substring(idx + 5);
            idx = style.indexOf("\"");
            if (idx < 0) {
                if (logger.isDebugEnabled()) {
                    this.print("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            int idx2 = style.indexOf("\"", idx + 1);
            if (idx2 <= idx + 1) {
                if (logger.isDebugEnabled()) {
                    this.print("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            this.referredStylesheet = style.substring(idx + 1, idx2);
            if (logger.isDebugEnabled()) {
                this.print("[dumpProcesssInstruction] stylesheet href setted to: " + this.referredStylesheet);
            }
        }
    }

    SignedXMLEnvelope(Document origDoc, int signerIdx, Element elemSig, NodeList sigList) throws CapiException {
        this.parsedDoc = origDoc;
        this.signerIndexToBeCSigned = signerIdx;
        DOMValidateContext valContext = new DOMValidateContext(new InternalKeySelector(this.parsedDoc), (Node)elemSig);
        try {
            this.signatureToBeCSigned = fac.unmarshalXMLSignature(valContext);
        }
        catch (MarshalException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new CapiException("XMLSignatureException", 50025);
        }
        this.status = -1;
        this.signatureList = sigList;
        if (logger.isDebugEnabled()) {
            this.print("done init..");
        }
        if (logger.isDebugEnabled()) {
            this.print("loading XML node list...");
        }
        if (sigList != null && sigList.getLength() > 0) {
            try {
                this.parseNodeList(sigList, null);
            }
            catch (CapiException se) {
                if (logger.isDebugEnabled()) {
                    logger.debug(se.getMessage(), (Throwable)se);
                }
                throw se;
            }
        }
        Element qp = null;
        String signerId = null;
        try {
            signerId = this.signatureToBeCSigned.getId();
            if (signerId == null || signerId.equals("")) {
                signerId = "Signer-N-" + this.signerIndexToBeCSigned;
                elemSig.setAttributeNS(null, "Id", signerId);
            }
            ItemList objList = this.lookForChilds(elemSig, "ds:Object");
            int nObj = objList.getLength();
            for (int obj = 0; obj < nObj && (qp = (Element)this.lookForChild(objList.item(obj), "QualifyingProperties")) == null; ++obj) {
            }
            if (qp == null) {
                if (logger.isDebugEnabled()) {
                    this.print("[init] ds:Object not found: creating now...");
                }
                qp = this.parsedDoc.createElement("xades:QualifyingProperties");
                qp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
                qp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                qp.setAttribute("xsi:schemaLocation", "http://uri.etsi.org/01903/v1.3.2# http://uri.etsi.org/01903/v1.3.2/XAdES.xsd");
                qp.setAttributeNS(null, "Target", "#" + signerId);
                Element up = this.parsedDoc.createElement("xades:UnsignedProperties");
                qp.appendChild(up);
                Element usp = this.parsedDoc.createElement("xades:UnsignedSignatureProperties");
                up.appendChild(usp);
                this.counterSignatureElem = this.parsedDoc.createElement("xades:CounterSignature");
                usp.appendChild(this.counterSignatureElem);
                DOMStructure content = new DOMStructure(qp);
                fac.newXMLObject(Collections.singletonList(content), null, null, null);
            } else {
                String Prefix = null;
                String attrDef = qp.getAttribute("xmlns");
                if (attrDef != null && attrDef.compareToIgnoreCase("http://uri.etsi.org/01903/v1.3.2#") == 0) {
                    if (logger.isDebugEnabled()) {
                        this.print("[init] QualifyingProperties has Default namespace URI: creating elements without prefix");
                    }
                    Prefix = "";
                } else {
                    Prefix = qp.getPrefix();
                    Prefix = Prefix == null || Prefix.compareTo("") == 0 ? "" : Prefix + ":";
                }
                Node up = this.lookForChild(qp, "UnsignedProperties");
                if (up == null) {
                    if (logger.isDebugEnabled()) {
                        this.print("[init] UnsignedProperties not found: creating now...");
                    }
                    up = this.parsedDoc.createElement(Prefix + "UnsignedProperties");
                    qp.appendChild(up);
                    Element usp = this.parsedDoc.createElement(Prefix + "UnsignedSignatureProperties");
                    up.appendChild(usp);
                    this.counterSignatureElem = this.parsedDoc.createElement(Prefix + "CounterSignature");
                    usp.appendChild(this.counterSignatureElem);
                } else {
                    Node usp = this.lookForChild(up, "UnsignedSignatureProperties");
                    if (usp == null) {
                        if (logger.isDebugEnabled()) {
                            this.print("[init] UnsignedSignatureProperties not found: creating now...");
                        }
                        usp = this.parsedDoc.createElement(Prefix + "UnsignedSignatureProperties");
                        up.appendChild(usp);
                        this.counterSignatureElem = this.parsedDoc.createElement(Prefix + "CounterSignature");
                        usp.appendChild(this.counterSignatureElem);
                    } else {
                        this.counterSignatureElem = this.parsedDoc.createElement(Prefix + "CounterSignature");
                        usp.appendChild(this.counterSignatureElem);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                this.print("[init] Empty CounterSignature element added");
            }
            this.status = 3;
            this.isCounterSignedEnvelope = true;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("CounterSignature encoding error", 50025);
        }
    }

    public SignedXMLEnvelope(int mode) throws CapiException {
        this(mode, null);
    }

    @Deprecated
    public SignedXMLEnvelope(int mode, HttpsClient https) throws CapiException {
        this.status = -1;
        if (mode != 2 && mode != 1 && mode != 3) {
            throw new CapiException("mode: " + mode + " not allowed", 1002);
        }
        this.mode = mode;
        this.transformAlg = new String[this.maxTransformNum];
        this.transformExpr = new String[this.maxTransformNum];
        this.transformFilter = new String[this.maxTransformNum];
        this.transformFilterNSPrefix = new String[this.maxTransformNum];
        this.transformFilterNSUri = new String[this.maxTransformNum];
        this.status = 2;
        this.internalUriDereferencer = new InternalUriDereferencer(https, null, null);
    }

    public void setData(String mimetype, String encoding) throws CapiException {
        if (this.status != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (mimetype == null || encoding == null) {
            throw new CapiException("Null data", 1001);
        }
        if (encoding.compareTo("UTF-8") != 0 && encoding.compareTo("http://www.w3.org/2000/09/xmldsig#base64") != 0) {
            throw new CapiException("Invalid encoding", 1002);
        }
        this.mimetype = mimetype;
        this.encoding = encoding;
        if (logger.isDebugEnabled()) {
            this.print("[setData] Mimetype: " + mimetype);
        }
        if (logger.isDebugEnabled()) {
            this.print("[setData] Encoding: " + encoding);
        }
    }

    public void setBaseURI(String uri) throws CapiException {
        if (uri == null) {
            return;
        }
        try {
            URL uRL = new URL(uri);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Invalid BaseURI", 1002);
        }
        this.baseUri = uri;
    }

    private String encodeURI(String uri) throws CapiException {
        String encUri;
        if (uri == null || uri.equals("")) {
            return uri;
        }
        try {
            encUri = URLEncoder.encode(uri, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new CapiException("UnsupportedEncodingException for uri: " + uri, 1002);
        }
        return encUri;
    }

    public void setCanonicOmitComm() throws CapiException {
        this.canonicalizerOfSignedInfo = "http://www.w3.org/2006/12/xml-c14n11";
        if (logger.isDebugEnabled()) {
            this.print("[setCanonicOmitComm] done.");
        }
    }

    public void setCanonicWithComm() throws CapiException {
        this.canonicalizerOfSignedInfo = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        if (logger.isDebugEnabled()) {
            this.print("[setCanonicWithComm] done.");
        }
    }

    public void setTransfB64() throws CapiException {
        if (this.status != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.transformNum >= this.maxTransformNum) {
            throw new CapiException("Too many transforms", 50040);
        }
        this.transformAlg[this.transformNum] = "http://www.w3.org/2000/09/xmldsig#base64";
        ++this.transformNum;
        if (logger.isDebugEnabled()) {
            this.print("[setTransfB64] done.");
        }
    }

    public void setTransfCanonicWithComm() throws CapiException {
        if (this.status != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.transformNum >= this.maxTransformNum) {
            throw new CapiException("Too many transforms", 50040);
        }
        this.transformAlg[this.transformNum] = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        ++this.transformNum;
        if (logger.isDebugEnabled()) {
            this.print("[setTransfCanonicWithComm] done.");
        }
    }

    public void setTransfCanonicOmitComm() throws CapiException {
        if (this.status != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.transformNum >= this.maxTransformNum) {
            throw new CapiException("Too many transforms", 50040);
        }
        this.transformAlg[this.transformNum] = "http://www.w3.org/2006/12/xml-c14n11";
        ++this.transformNum;
        if (logger.isDebugEnabled()) {
            this.print("[setTransfCanonicOmitComm] done.");
        }
    }

    public void setTransfXpath1(String xpathExpr) throws CapiException {
        if (this.status != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.transformNum >= this.maxTransformNum) {
            throw new CapiException("Too many transforms", 50040);
        }
        if (xpathExpr == null) {
            throw new CapiException("Null data", 1001);
        }
        this.transformAlg[this.transformNum] = "http://www.w3.org/TR/1999/REC-xpath-19991116";
        this.transformExpr[this.transformNum] = xpathExpr;
        ++this.transformNum;
        if (logger.isDebugEnabled()) {
            this.print("[setTransfXpath] done. Xpath expression: " + xpathExpr);
        }
    }

    public void setTransfXpathFilter2(String xpathFilter, String xpathExpr) throws CapiException {
        this.setTransfXpathFilter2(xpathFilter, xpathExpr, null, null);
    }

    public void setTransfXpathFilter2(String xpathFilter, String xpathExpr, String xpathNSPrefix, String xpathNSUri) throws CapiException {
        if (this.status != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.transformNum >= this.maxTransformNum) {
            throw new CapiException("Too many transforms", 50040);
        }
        if (xpathExpr == null || xpathFilter == null) {
            throw new CapiException("Null data", 1001);
        }
        this.transformAlg[this.transformNum] = "http://www.w3.org/2002/06/xmldsig-filter2";
        this.transformExpr[this.transformNum] = xpathExpr;
        this.transformFilter[this.transformNum] = xpathFilter;
        this.transformFilterNSPrefix[this.transformNum] = xpathNSPrefix;
        this.transformFilterNSUri[this.transformNum] = xpathNSUri;
        ++this.transformNum;
        if (logger.isDebugEnabled()) {
            this.print("[setTransfXpathFilter2] done. Filter: " + xpathFilter + " Xpath expression: " + xpathExpr + " Xpath NS Prefix: " + xpathNSPrefix + " Xpath NS URI: " + xpathNSUri);
        }
    }

    public void setTransfXSLT(String xslStyleSheet) throws CapiException {
        if (this.status != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.transformNum >= this.maxTransformNum) {
            throw new CapiException("Too many transforms", 50040);
        }
        if (xslStyleSheet == null) {
            throw new CapiException("Null data", 1001);
        }
        this.transformAlg[this.transformNum] = "http://www.w3.org/TR/1999/REC-xslt-19991116";
        this.transformExpr[this.transformNum] = xslStyleSheet;
        ++this.transformNum;
        if (logger.isDebugEnabled()) {
            this.print("[setTransfXSLT] done. XSL Style Sheet: " + xslStyleSheet);
        }
    }

    public String[] listSigners() throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        return this.dnlist;
    }

    public String[] listSignersId() throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        return this.idlist;
    }

    @Deprecated
    public String[] listCertificates() throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        return this.certlist;
    }

    public String verify(int signerInfoIndex) throws CapiException {
        block23: {
            if (this.status != 3) {
                throw new CapiException("No parsed enveloped", 50040);
            }
            if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
                throw new CapiException("No signer found", 50010);
            }
            if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
                throw new CapiException("Wrong signer index", 50010);
            }
            if (this.signingCert[signerInfoIndex] && this.certlist[signerInfoIndex] != null) {
                Certificate crt;
                block22: {
                    crt = new Certificate(this.certlist[signerInfoIndex].getBytes());
                    if (this.signingCertDigestMethod[signerInfoIndex] != null && this.signingCertDigestValue[signerInfoIndex] != null) {
                        try {
                            DigestAlgorithm da = DigestAlgorithm.valueFromXadesId(this.signingCertDigestMethod[signerInfoIndex]);
                            if (da != null) {
                                String digestAlgo = da.getId();
                                MessageDigest md = MessageDigest.getInstance(digestAlgo, ProvUtils.bcProvider);
                                byte[] certDigest = md.digest(crt.getInternalCert().getEncoded());
                                if (!Arrays.equals(certDigest, Base64.decode((String)this.signingCertDigestValue[signerInfoIndex]))) {
                                    throw new CapiException("Wrong Signing Certificate inside SignedProperties", 50010);
                                }
                                break block22;
                            }
                            throw new CapiException("Unknown Digest Method for Signing Certificate", 50010);
                        }
                        catch (Exception ex) {
                            logger.error("Unknown Digest Method for Signing Certificate", (Throwable)ex);
                            throw new CapiException("Unknown Digest Method for Signing Certificate", 50010);
                        }
                    }
                    throw new CapiException("Missing Signing Certificate Digest inside SignedProperties", 50010);
                }
                if (this.signingCertIssuerSerialName[signerInfoIndex] != null && this.signingCertIssuerSerialNumber[signerInfoIndex] != null) {
                    try {
                        X500Name certIssuerPrincipal = crt.getX500IssuerName();
                        X500Name signingCertIssuerPrincipal = new X500Name(RFC4519InternalStyle.INSTANCE, this.signingCertIssuerSerialName[signerInfoIndex]);
                        if (certIssuerPrincipal == null || !certIssuerPrincipal.equals((Object)signingCertIssuerPrincipal)) {
                            throw new CapiException("Wrong Signing Certificate Issuer Name inside SignedProperties", 50010);
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        throw new CapiException("Wrong Signing Certificate Issuer Name inside SignedProperties", 50010);
                    }
                }
                throw new CapiException("Missing Signing Certificate Issuer Serial inside SignedProperties", 50010);
            }
            if (this.signingCertV2[signerInfoIndex] && this.certlist[signerInfoIndex] != null) {
                Certificate crt = new Certificate(this.certlist[signerInfoIndex].getBytes());
                if (this.signingCertDigestMethod[signerInfoIndex] != null && this.signingCertDigestValue[signerInfoIndex] != null) {
                    try {
                        DigestAlgorithm da = DigestAlgorithm.valueFromXadesId(this.signingCertDigestMethod[signerInfoIndex]);
                        if (da != null) {
                            String digestAlgo = da.getId();
                            MessageDigest md = MessageDigest.getInstance(digestAlgo, ProvUtils.bcProvider);
                            byte[] certDigest = md.digest(crt.getInternalCert().getEncoded());
                            if (!Arrays.equals(certDigest, Base64.decode((String)this.signingCertDigestValue[signerInfoIndex]))) {
                                throw new CapiException("Wrong Signing Certificate inside SignedProperties", 50010);
                            }
                            break block23;
                        }
                        throw new CapiException("Unknown Digest Method for Signing Certificate", 50010);
                    }
                    catch (Exception e) {
                        logger.error("Unknown Digest Method for Signing Certificate", (Throwable)e);
                        throw new CapiException("Unknown Digest Method for Signing Certificate", 50010);
                    }
                }
                throw new CapiException("Missing Signing Certificate Digest inside SignedProperties", 50010);
            }
        }
        if (!this.verifiedlist[signerInfoIndex]) {
            if (logger.isDebugEnabled()) {
                this.print("[verify] Signer n. " + signerInfoIndex + " has an invalid signature");
            }
            throw new CapiException("Invalid signature", 3010);
        }
        if (signerInfoIndex >= this.certlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.certlist[signerInfoIndex];
    }

    public String getSigningTime(int signerInfoIndex) throws CapiException {
        if (this.status != 3 || this.signingTime == null) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex >= this.signingTime.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.signingTime[signerInfoIndex];
    }

    public boolean hasCounterSignature(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.counterSig == null || signerInfoIndex >= this.counterSig.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.counterSig[signerInfoIndex] != null;
    }

    @Deprecated
    public InputStream getReference(int signerInfoIndex, int referenceIndex) throws CapiException {
        return null;
    }

    public boolean getReferenceIsVerified(int signerInfoIndex, int referenceIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.referencedIsVerified[signerInfoIndex] == null) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (referenceIndex >= this.referencedIsVerified[signerInfoIndex].length) {
            throw new CapiException("Wrong reference index", 50010);
        }
        try {
            return this.referencedIsVerified[signerInfoIndex][referenceIndex];
        }
        catch (Exception e) {
            throw new CapiException("Wrong signer index", 50010);
        }
    }

    @Deprecated
    public InputStream getReferenceInputStream(int signerInfoIndex, int referenceIndex) throws CapiException {
        return null;
    }

    public TimeStampToken getSignatureTimeStamp(int signerInfoIndex, int sigTimeStampIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.signatureTimeStamp == null || signerInfoIndex >= this.signatureTimeStamp.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.signatureTimeStamp[signerInfoIndex] == null) {
            return null;
        }
        if (sigTimeStampIndex < 0 || sigTimeStampIndex >= this.signatureTimeStamp[signerInfoIndex].length) {
            return null;
        }
        String canonic = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        try {
            Element sv;
            byte[] canonicalized;
            Element encTimeStamp;
            Element cm = (Element)this.lookForChild(this.signatureTimeStamp[signerInfoIndex][sigTimeStampIndex], "CanonicalizationMethod");
            if (cm != null) {
                canonic = cm.getAttribute("Algorithm");
                if (logger.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Canonicalizer: " + canonic);
                }
            } else if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Using Default Canonicalizer: " + canonic);
            }
            if ((encTimeStamp = (Element)this.lookForChild(this.signatureTimeStamp[signerInfoIndex][sigTimeStampIndex], "EncapsulatedTimeStamp")) == null) {
                if (logger.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Missing EncapsulatedTimeStamp");
                }
                throw new CapiException("Missing EncapsulatedTimeStamp", 50023);
            }
            String encodAtt = encTimeStamp.getAttribute("Encoding");
            if (!(encodAtt == null || encodAtt.startsWith("http://uri.etsi.org/01903") && encodAtt.endsWith("#DER"))) {
                if (logger.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Wrong TimeStamp Encoding. " + encodAtt + " Expected DER encoding.");
                }
                throw new CapiException("Wrong TimeStamp Encoding. Expected DER encoding.", 50023);
            }
            String PemTimeStamp = encTimeStamp.getFirstChild().getNodeValue();
            Util u = new Util();
            byte[] tstampDER = Util.base64DecodeStr(PemTimeStamp);
            TimeStampToken tst = new TimeStampToken(tstampDER);
            if (!tst.compare(canonicalized = this.getCanonicalC11N11ElmenteByte(sv = (Element)this.lookForChild(this.signatureList.item(signerInfoIndex), "SignatureValue")), false)) {
                if (logger.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] SignatureTimeStamp does not match signature value");
                }
                throw new CapiException("SignatureTimeStamp does not match signature value.", 50023);
            }
            if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] SignatureTimeStamp parsed.");
            }
            return tst;
        }
        catch (CapiException e) {
            if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + e.getMessage());
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + e.getMessage());
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error parsing SignatureTimeStamp", 50023);
        }
    }

    public byte[] getSignature(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.signatureTimeStamp == null || signerInfoIndex >= this.signatureTimeStamp.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.signatureTimeStamp[signerInfoIndex] == null) {
            return null;
        }
        try {
            Element sv = (Element)this.lookForChild(this.signatureList.item(signerInfoIndex), "SignatureValue");
            byte[] canonicalized = this.getCanonicalC11N11ElmenteByte(sv);
            return canonicalized;
        }
        catch (CapiException e) {
            if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + e.getMessage());
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + e.getMessage());
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error parsing SignatureTimeStamp", 50023);
        }
    }

    public byte[] getTimeStamp(int signerInfoIndex, int sigTimeStampIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.signatureTimeStamp == null || signerInfoIndex >= this.signatureTimeStamp.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.signatureTimeStamp[signerInfoIndex] == null) {
            return null;
        }
        if (sigTimeStampIndex < 0 || sigTimeStampIndex >= this.signatureTimeStamp[signerInfoIndex].length) {
            return null;
        }
        String canonic = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        try {
            Element encTimeStamp;
            Element cm = (Element)this.lookForChild(this.signatureTimeStamp[signerInfoIndex][sigTimeStampIndex], "CanonicalizationMethod");
            if (cm != null) {
                canonic = cm.getAttribute("Algorithm");
                if (logger.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Canonicalizer: " + canonic);
                }
            } else if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Using Default Canonicalizer: " + canonic);
            }
            if ((encTimeStamp = (Element)this.lookForChild(this.signatureTimeStamp[signerInfoIndex][sigTimeStampIndex], "EncapsulatedTimeStamp")) == null) {
                if (logger.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Missing EncapsulatedTimeStamp");
                }
                throw new CapiException("Missing EncapsulatedTimeStamp", 50023);
            }
            String encodAtt = encTimeStamp.getAttribute("Encoding");
            if (!(encodAtt == null || encodAtt.isEmpty() || encodAtt.startsWith("http://uri.etsi.org/01903") && encodAtt.endsWith("#DER"))) {
                if (logger.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Wrong TimeStamp Encoding. " + encodAtt + " Expected DER encoding.");
                }
                throw new CapiException("Wrong TimeStamp Encoding. Expected DER encoding.", 50023);
            }
            String PemTimeStamp = encTimeStamp.getFirstChild().getNodeValue();
            Util u = new Util();
            byte[] tstampDER = Util.base64DecodeStr(PemTimeStamp);
            return tstampDER;
        }
        catch (CapiException e) {
            if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + e.getMessage());
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + e.getMessage());
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error parsing SignatureTimeStamp", 50023);
        }
    }

    public int getNumSignatureTimeStamp(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.signatureTimeStamp == null || signerInfoIndex >= this.signatureTimeStamp.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.signatureTimeStamp[signerInfoIndex] == null) {
            return 0;
        }
        return this.signatureTimeStamp[signerInfoIndex].length;
    }

    public CounterSignedXMLEnvelope getCounterSignature(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.counterSig == null || signerInfoIndex >= this.counterSig.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Element signatureElem = (Element)this.signatureList.item(signerInfoIndex);
        CounterSignedXMLEnvelope csx = new CounterSignedXMLEnvelope(this.parsedDoc, signerInfoIndex, signatureElem, this.counterSig[signerInfoIndex]);
        if (logger.isDebugEnabled()) {
            this.print("[getCounterSignature] done.");
        }
        return csx;
    }

    public void setCounterSignature(int signerInfoIndex, CounterSignedXMLEnvelope csx) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.counterSig == null || signerInfoIndex >= this.counterSig.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex != csx.signerIndexToBeCSigned) {
            throw new CapiException("Signer index mismatch CounterSignedXMLEnvelope", 50010);
        }
        if (this.counterSig[signerInfoIndex] == null) {
            ItemList s;
            Node n;
            ArrayList<Node> vs = new ArrayList<Node>();
            if (logger.isDebugEnabled()) {
                this.print("[setCounterSignature] Adding first countersignature to signer n. " + signerInfoIndex + " ...");
            }
            try {
                n = this.lookForChild(csx.counterSignatureElem, "Signature");
            }
            catch (Exception e) {
                throw new CapiException("CounterSignature resynch error", 50025);
            }
            if (n == null) {
                throw new CapiException("CounterSignature resynch error", 50025);
            }
            vs.add(n);
            this.counterSig[signerInfoIndex] = s = new ItemList(vs);
            return;
        }
        if (this.counterSig[signerInfoIndex] != null) {
            Node n;
            if (logger.isDebugEnabled()) {
                this.print("[setCounterSignature] Adding another countersignature to signer " + signerInfoIndex + " ...");
            }
            try {
                n = this.lookForChild(csx.counterSignatureElem, "Signature");
            }
            catch (Exception e) {
                throw new CapiException("CounterSignature resynch error", 50025);
            }
            if (n != null) {
                this.counterSig[signerInfoIndex].add(n);
            } else {
                throw new CapiException("CounterSignature resynch error", 50025);
            }
        }
    }

    public String getSignerCertificate(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.certlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.certlist[signerInfoIndex];
    }

    public String getSignerDigestAlg(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null || this.digestlist == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.digestlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.digestlist[signerInfoIndex];
    }

    public String getSignerEncDigestAlg(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null || this.encdigestlist == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.encdigestlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.encdigestlist[signerInfoIndex];
    }

    public String getSignerEncryptionAlg(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.referencedIsVerified == null || this.encdigestlist == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.encdigestlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        int pos = this.encdigestlist[signerInfoIndex].lastIndexOf("-");
        if (pos != -1 && pos < this.encdigestlist[signerInfoIndex].length() - 1) {
            if (logger.isDebugEnabled()) {
                this.print("[getSignerEncryptionAlg] Encryption-Alg: " + this.encdigestlist[signerInfoIndex].substring(0, pos).toUpperCase());
            }
            return this.encdigestlist[signerInfoIndex].substring(0, pos).toUpperCase();
        }
        return this.encdigestlist[signerInfoIndex];
    }

    public int getNumReference(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.reference == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex >= this.reference.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.reference[signerInfoIndex].length;
    }

    public Reference getReferenceInfo(int signerInfoIndex, int referenceIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.verifiedlist == null || this.dnlist == null || this.idlist == null || this.certlist == null || this.reference == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.verifiedlist.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.reference == null || signerInfoIndex >= this.reference.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.reference[signerInfoIndex] == null) {
            return null;
        }
        if (referenceIndex >= this.reference[signerInfoIndex].length) {
            return null;
        }
        try {
            return this.reference[signerInfoIndex][referenceIndex];
        }
        catch (Exception e) {
            throw new CapiException("Wrong signer index", 50010);
        }
    }

    public boolean isSignatureParsed(int signerInfoIndex) throws CapiException {
        if (this.status != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.parsed == null || signerInfoIndex >= this.parsed.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.parsed[signerInfoIndex];
    }

    /*
     * WARNING - void declaration
     */
    private void parseNodeList(NodeList nodeList, EventHandlerSelector fileSelector) throws CapiException {
        int sigOK = 0;
        int sigKO = 0;
        this.dnlist = new String[nodeList.getLength()];
        this.idlist = new String[nodeList.getLength()];
        this.certlist = new String[nodeList.getLength()];
        this.digestlist = new String[nodeList.getLength()];
        this.encdigestlist = new String[nodeList.getLength()];
        this.verifiedlist = new boolean[nodeList.getLength()];
        this.signingTime = new String[nodeList.getLength()];
        this.signingCertDigestMethod = new String[nodeList.getLength()];
        this.signingCertDigestValue = new String[nodeList.getLength()];
        this.signingCertIssuerSerialName = new String[nodeList.getLength()];
        this.signingCertIssuerSerialNumber = new BigInteger[nodeList.getLength()];
        this.signingCert = new boolean[nodeList.getLength()];
        this.signingCertV2 = new boolean[nodeList.getLength()];
        this.signatureTimeStamp = new Element[nodeList.getLength()][];
        this.counterSig = new ItemList[nodeList.getLength()];
        this.referencedIsVerified = new boolean[nodeList.getLength()][];
        this.reference = new Reference[nodeList.getLength()][];
        this.dsParent = new Node[nodeList.getLength()];
        this.parsed = new boolean[nodeList.getLength()];
        if (logger.isDebugEnabled()) {
            this.print("[parseNodeList] parsing " + nodeList.getLength() + " XMLSignatures");
        }
        for (int j = 0; j < nodeList.getLength(); ++j) {
            void var15_29;
            List<InputHandler> handlers;
            if (logger.isDebugEnabled()) {
                this.print("[parseNodeList] start parsing XMLSignature " + j);
            }
            Element signatureElem = (Element)nodeList.item(j);
            if (fileSelector instanceof EventHandlerMultiSelector && (handlers = ((EventHandlerMultiSelector)fileSelector).selectAllHandler()) != null && !handlers.isEmpty()) {
                for (InputHandler handler : handlers) {
                    this.internalUriDereferencer.addDocument(handler);
                }
            }
            XMLSignature sig = null;
            DOMValidateContext valContext = null;
            try {
                valContext = new DOMValidateContext(new InternalKeySelector(this.parsedDoc), (Node)signatureElem);
                valContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
                valContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", ProvUtils.bcProvider);
                valContext.setURIDereferencer(this.internalUriDereferencer);
                sig = fac.unmarshalXMLSignature(valContext);
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
                this.parsed[j] = false;
                ++sigKO;
                NodeList keyInfoList = signatureElem.getElementsByTagName("ds:KeyInfo");
                for (int iKeyInfo = 0; iKeyInfo < keyInfoList.getLength(); ++iKeyInfo) {
                    Node keyInfoElem = keyInfoList.item(iKeyInfo);
                    try {
                        DOMStructure keyInfo = new DOMStructure(keyInfoElem);
                        List<XMLStructure> list = KeyInfoFactory.getInstance().unmarshalKeyInfo(keyInfo).getContent();
                        for (int i = 0; i < list.size(); ++i) {
                            XMLStructure xmlStructure = list.get(i);
                            if (!(xmlStructure instanceof X509Data)) continue;
                            for (Object obj : ((X509Data)xmlStructure).getContent()) {
                                if (!(obj instanceof X509Certificate)) continue;
                                X509Certificate cX509 = (X509Certificate)obj;
                                this.certlist[j] = new String(Util.base64Encode(cX509.getEncoded()));
                                if (!this.certificates.contains(cX509)) {
                                    this.certificates.add(cX509);
                                }
                                if (this.certsForSigner.get(j) == null) {
                                    this.certsForSigner.put(j, new LinkedList());
                                }
                                if (!this.certsForSigner.get(j).contains(cX509)) {
                                    this.certsForSigner.get(j).add(cX509);
                                }
                                Certificate crt = new Certificate(this.certlist[j].getBytes());
                                this.dnlist[j] = crt.getSubjectDN();
                                if (this.dnlist[j] != null && this.certlist[j] != null) continue;
                                throw new CapiException("malformed X509Certificate for signer index " + (j + 1), 50025);
                            }
                        }
                        continue;
                    }
                    catch (CertificateEncodingException cee) {
                        throw new CapiException("CertificateEncodingException", 50025);
                    }
                    catch (MarshalException cee) {
                        // empty catch block
                    }
                }
                continue;
            }
            this.parsed[j] = true;
            X509Certificate cX509 = null;
            if (sig.getSignedInfo() == null) {
                throw new CapiException("SignedInfo not found", 50025);
            }
            if (sig.getKeyInfo() == null) {
                throw new CapiException("KeyInfo not found", 50025);
            }
            boolean certificateNotFound = false;
            SignatureMethod sigMethod = sig.getSignedInfo().getSignatureMethod();
            if (sigMethod == null) {
                throw new CapiException("SignatureMethodURI not found", 50025);
            }
            this.digestlist[j] = this.getDigestAlg(sigMethod.getAlgorithm());
            this.encdigestlist[j] = this.getEncryptionAndDigestAlg(sigMethod.getAlgorithm());
            this.dsParent[j] = nodeList.item(j).getParentNode();
            this.idlist[j] = sig.getId();
            boolean verifySignature = false;
            List<Object> certList = new ArrayList();
            try {
                verifySignature = sig.validate(valContext);
                certList = ((InternalKeySelector.InternalKeySelectorResult)sig.getKeySelectorResult()).getX509List();
                cX509 = ((InternalKeySelector.InternalKeySelectorResult)sig.getKeySelectorResult()).getX509();
            }
            catch (XMLSignatureException e) {
                if (e.getCause() instanceof URIReferenceException) {
                    verifySignature = false;
                    certList = ((InternalKeySelector.InternalKeySelectorResult)sig.getKeySelectorResult()).getX509List();
                    cX509 = ((InternalKeySelector.InternalKeySelectorResult)sig.getKeySelectorResult()).getX509();
                }
                if (e.getMessage().equals("cannot find validation key")) {
                    certificateNotFound = true;
                }
                throw new CapiException("XMLSignatureException", 50052);
            }
            if (!certificateNotFound) {
                try {
                    this.certlist[j] = new String(Util.base64Encode(cX509.getEncoded()));
                    if (!this.certificates.contains(cX509)) {
                        this.certificates.add(cX509);
                    }
                    if (this.certsForSigner.get(j) == null) {
                        this.certsForSigner.put(j, new LinkedList());
                    }
                    for (X509Certificate x509Certificate : certList) {
                        this.certsForSigner.get(j).add(x509Certificate);
                    }
                    Certificate crt = new Certificate(this.certlist[j].getBytes());
                    this.dnlist[j] = crt.getSubjectDN();
                    if (this.dnlist[j] == null || this.certlist[j] == null) {
                        throw new CapiException("malformed X509Certificate for signer index " + (j + 1), 50025);
                    }
                }
                catch (CertificateEncodingException e) {
                    throw new CapiException("CertificateEncodingException", 50025);
                }
            }
            int nRef = sig.getSignedInfo().getReferences().size();
            this.reference[j] = new Reference[nRef];
            this.referencedIsVerified[j] = new boolean[nRef];
            boolean bl = false;
            while (var15_29 < nRef) {
                if (logger.isDebugEnabled()) {
                    this.print("[parseNodeList] setting each Reference ... ");
                }
                Reference ref = sig.getSignedInfo().getReferences().get((int)var15_29);
                try {
                    ref.validate(valContext);
                    if (logger.isDebugEnabled()) {
                        this.print("[parseNodeList] reference uri: " + ref.getURI());
                    }
                    byte[] elemDig = ref.getDigestValue();
                    byte[] calcDig = ref.getCalculatedDigestValue();
                    this.referencedIsVerified[j][var15_29] = MessageDigest.isEqual(elemDig, calcDig);
                }
                catch (XMLSignatureException ex) {
                    this.referencedIsVerified[j][var15_29] = false;
                }
                this.reference[j][var15_29] = ref;
                ++var15_29;
            }
            this.verifiedlist[j] = verifySignature;
            if (logger.isDebugEnabled()) {
                this.print("[parseNodeList] Certificate Subject DN: " + this.dnlist[j]);
            }
            if (logger.isDebugEnabled()) {
                this.print("[parseNodeList] Signature is" + (verifySignature ? " " : " NOT ") + "valid");
            }
            if (verifySignature) {
                ++sigOK;
            } else {
                ++sigKO;
            }
            this.checkXADES(signatureElem, j);
            if (!logger.isDebugEnabled()) continue;
            this.print("[parseNodeList] end parsing XMLSignature " + j);
        }
        if (logger.isDebugEnabled()) {
            this.print("[parseNodeList] Valid signatures: " + sigOK + " out of " + nodeList.getLength());
        }
        if (logger.isDebugEnabled()) {
            this.print("[parseNodeList] Not valid signatures: " + sigKO + " out of " + nodeList.getLength());
        }
    }

    private String getDigestAlg(String sigMethod) {
        int pos;
        if (logger.isDebugEnabled()) {
            this.print("[getDigestAlg] SignatureMethodURI() " + sigMethod);
        }
        if ((pos = sigMethod.lastIndexOf("-")) != -1 && pos < sigMethod.length() - 1) {
            if (logger.isDebugEnabled()) {
                this.print("[getDigestAlg] Digest: " + sigMethod.substring(pos + 1).toUpperCase());
            }
            return sigMethod.substring(pos + 1).toUpperCase();
        }
        return null;
    }

    private String getEncryptionAndDigestAlg(String sigMethod) {
        int pos;
        if (logger.isDebugEnabled()) {
            this.print("[getEncryptionAndDigestAlg] SignatureMethodURI() " + sigMethod);
        }
        if ((pos = sigMethod.lastIndexOf("#")) != -1 && pos < sigMethod.length() - 1) {
            if (logger.isDebugEnabled()) {
                this.print("[getEncryptionAndDigestAlg] Encryption-Digest: " + sigMethod.substring(pos + 1).toUpperCase());
            }
            return sigMethod.substring(pos + 1).toUpperCase();
        }
        return null;
    }

    private Node lookForChild(Node father, String childEndWith) throws Exception {
        if (father.hasChildNodes()) {
            NodeList children = father.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                short type = children.item(i).getNodeType();
                if (type != 1 || !children.item(i).getNodeName().endsWith(childEndWith)) continue;
                return children.item(i);
            }
        }
        return null;
    }

    private ItemList lookForChilds(Node father, String childEndWith) throws Exception {
        ItemList c = null;
        if (father.hasChildNodes()) {
            c = new ItemList(new ArrayList<Node>());
            NodeList children = father.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                short type = children.item(i).getNodeType();
                if (type != 1 || !children.item(i).getNodeName().endsWith(childEndWith)) continue;
                c.add(children.item(i));
            }
        }
        return c;
    }

    private void checkXADES(Element signature, int index) throws CapiException {
        Node st = null;
        Node sc = null;
        Node sc2 = null;
        Node cert = null;
        Node certDigest = null;
        Node certIssuerSerial = null;
        Node certDigestMethod = null;
        Node certDigestValue = null;
        Node certIssuerSerialName = null;
        Node certIssuerSerialNumber = null;
        Node qp = null;
        String attrDef = null;
        try {
            ItemList objects = this.lookForChilds(signature, "ds:Object");
            for (int i = 0; i < objects.getLength(); ++i) {
                Node ssp;
                Node sp;
                Element obj = (Element)objects.item(i);
                if (logger.isDebugEnabled()) {
                    this.print("[checkXADES] finding SigningTime...");
                }
                if ((qp = this.lookForChild(obj, "QualifyingProperties")) == null || (sp = this.lookForChild(qp, "SignedProperties")) == null) continue;
                String spID = ((Element)sp).getAttribute("Id");
                if (logger.isDebugEnabled()) {
                    this.print("[checkXADES] Signed Properties Id: " + spID);
                }
                if ((ssp = this.lookForChild(sp, "SignedSignatureProperties")) == null) continue;
                st = this.lookForChild(ssp, "SigningTime");
                if (st != null) {
                    this.signingTime[index] = st.getFirstChild().getNodeValue();
                    if (logger.isDebugEnabled()) {
                        this.print("[checkXADES] Found Signing Time for Signer n. " + index + " : " + this.signingTime[index]);
                    }
                }
                if ((sc = this.lookForChild(ssp, "SigningCertificate")) != null) {
                    this.signingCert[index] = true;
                    if (logger.isDebugEnabled()) {
                        this.print("[checkXADES] Found Signing Certificate for Signer n. " + index);
                    }
                    if ((cert = this.lookForChild(sc, "Cert")) != null) {
                        if (logger.isDebugEnabled()) {
                            this.print("[checkXADES] Found Cert for Signer n. " + index);
                        }
                        if ((certDigest = this.lookForChild(cert, "CertDigest")) != null) {
                            if (logger.isDebugEnabled()) {
                                this.print("[checkXADES] Found CertDigest for Signer n. " + index);
                            }
                            if ((certDigestMethod = this.lookForChild(certDigest, "DigestMethod")) != null && certDigestMethod.hasAttributes() && certDigestMethod.getAttributes().getNamedItem("Algorithm") != null) {
                                this.signingCertDigestMethod[index] = certDigestMethod.getAttributes().getNamedItem("Algorithm").getNodeValue();
                                if (logger.isDebugEnabled()) {
                                    this.print("[checkXADES] Found CertDigest Method for Signer n. " + index + " : " + this.signingCertDigestMethod[index]);
                                }
                            }
                            if ((certDigestValue = this.lookForChild(certDigest, "DigestValue")) != null) {
                                this.signingCertDigestValue[index] = certDigestValue.getFirstChild().getNodeValue();
                                if (logger.isDebugEnabled()) {
                                    this.print("[checkXADES] Found CertDigest Value for Signer n. " + index + " : " + this.signingCertDigestValue[index]);
                                }
                            }
                        }
                        if ((certIssuerSerial = this.lookForChild(cert, "IssuerSerial")) != null) {
                            if (logger.isDebugEnabled()) {
                                this.print("[checkXADES] Found IssuerSerial for Signer n. " + index);
                            }
                            if ((certIssuerSerialName = this.lookForChild(certIssuerSerial, "X509IssuerName")) != null) {
                                this.signingCertIssuerSerialName[index] = certIssuerSerialName.getFirstChild().getNodeValue();
                                if (logger.isDebugEnabled()) {
                                    this.print("[checkXADES] Found IsserSerial Name for Signer n. " + index + " : " + this.signingCertIssuerSerialName[index]);
                                }
                            }
                            if ((certIssuerSerialNumber = this.lookForChild(certIssuerSerial, "X509SerialNumber")) != null) {
                                try {
                                    this.signingCertIssuerSerialNumber[index] = new BigInteger(certIssuerSerialNumber.getFirstChild().getNodeValue());
                                    if (logger.isDebugEnabled()) {
                                        this.print("[checkXADES] Found IsserSerial Number for Signer n. " + index + " : " + this.signingCertIssuerSerialNumber[index]);
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                } else {
                    this.signingCert[index] = false;
                }
                if ((sc2 = this.lookForChild(ssp, "SigningCertificateV2")) != null) {
                    this.signingCertV2[index] = true;
                    if (logger.isDebugEnabled()) {
                        this.print("[checkXADES] Found Signing Certificate V2 for Signer n. " + index + " : " + this.signingTime[index]);
                    }
                    if ((cert = this.lookForChild(sc2, "Cert")) == null) continue;
                    if (logger.isDebugEnabled()) {
                        this.print("[checkXADES] Found Cert for Signer n. " + index);
                    }
                    if ((certDigest = this.lookForChild(cert, "CertDigest")) != null) {
                        if (logger.isDebugEnabled()) {
                            this.print("[checkXADES] Found CertDigest for Signer n. " + index);
                        }
                        if ((certDigestMethod = this.lookForChild(certDigest, "DigestMethod")) != null && certDigestMethod.hasAttributes() && certDigestMethod.getAttributes().getNamedItem("Algorithm") != null) {
                            this.signingCertDigestMethod[index] = certDigestMethod.getAttributes().getNamedItem("Algorithm").getNodeValue();
                            if (logger.isDebugEnabled()) {
                                this.print("[checkXADES] Found CertDigest Method for Signer n. " + index + " : " + this.signingCertDigestMethod[index]);
                            }
                        }
                        if ((certDigestValue = this.lookForChild(certDigest, "DigestValue")) != null) {
                            this.signingCertDigestValue[index] = certDigestValue.getFirstChild().getNodeValue();
                            if (logger.isDebugEnabled()) {
                                this.print("[checkXADES] Found CertDigest Value for Signer n. " + index + " : " + this.signingCertDigestValue[index]);
                            }
                        }
                    }
                    if ((certIssuerSerial = this.lookForChild(cert, "IssuerSerialV2")) == null) continue;
                    this.signingCertIssuerSerialName[index] = certIssuerSerial.getFirstChild().getNodeValue();
                    if (!logger.isDebugEnabled()) continue;
                    this.print("[checkXADES] Found IssuerSerialV2 for Signer n. " + index);
                    continue;
                }
                this.signingCertV2[index] = false;
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("SigningTime encoding error", 50025);
        }
        if (qp == null) {
            return;
        }
        Node usp = null;
        try {
            attrDef = ((Element)qp).getAttribute("xmlns");
            Node up = this.lookForChild(qp, "UnsignedProperties");
            if (up == null) {
                return;
            }
            usp = this.lookForChild(up, "UnsignedSignatureProperties");
            if (usp == null) {
                return;
            }
        }
        catch (CapiException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new CapiException("UnsignedProperties error", 50025);
        }
        this.checkUnsignedProperties(usp, index);
    }

    private void checkUnsignedProperties(Node usp, int index) throws CapiException {
        block44: {
            block43: {
                block42: {
                    try {
                        if (logger.isDebugEnabled()) {
                            this.print("[checkXADES] finding xades:CertificateValues...");
                        }
                        Node xadesCertificateValues = this.lookForChild(usp, "xades:CertificateValues");
                        this.parseCertificateValues(index, xadesCertificateValues);
                    }
                    catch (CapiException ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block42;
                        logger.debug(ex.getMessage(), (Throwable)ex);
                    }
                }
                try {
                    if (logger.isDebugEnabled()) {
                        this.print("[checkXADES] finding <xades:RevocationValues>...");
                    }
                    Node xadesRevocationValues = this.lookForChild(usp, "xades:RevocationValues");
                    this.parseRevocationValues(index, xadesRevocationValues);
                }
                catch (CapiException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(ex.getMessage(), (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block43;
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
            }
            try {
                ItemList s;
                if (logger.isDebugEnabled()) {
                    this.print("[checkXADES] finding CounterSignatures...");
                }
                NodeList cs = null;
                Node c = this.lookForChild(usp, "CounterSignature");
                if (c != null && this.lookForChild(c, "Signature") != null) {
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    xPath.setNamespaceContext(this.nsctx);
                    XPathExpression expres = xPath.compile("xades:CounterSignature[ds:Signature]");
                    cs = (NodeList)expres.evaluate(usp, XPathConstants.NODESET);
                }
                if (cs == null || cs.getLength() == 0) {
                    if (logger.isDebugEnabled()) {
                        this.print("[checkXADES] Signer " + index + " has not Contersignatures in xades namespace");
                    }
                    break block44;
                }
                if (logger.isDebugEnabled()) {
                    this.print("[checkXADES] Signer " + index + " has: " + cs.getLength() + " Contersignatures");
                }
                Node n = null;
                ArrayList<Node> vs = new ArrayList<Node>();
                for (int i = 0; i < cs.getLength(); ++i) {
                    if (logger.isDebugEnabled()) {
                        this.print("[checkXADES] parsing Countersignature element n. " + i + " ...");
                    }
                    if ((n = this.lookForChild(cs.item(i), "Signature")) == null) {
                        if (!logger.isDebugEnabled()) continue;
                        this.print("[checkXADES] CounterSignature error: missing Signature element");
                        continue;
                    }
                    XMLSignature csig = null;
                    DOMValidateContext valContext = null;
                    boolean isCSReferredToSignatureValue = false;
                    try {
                        if (logger.isDebugEnabled()) {
                            this.print("[checkXADES] Verifying Countersignature is referred to SignatureValue");
                        }
                        valContext = new DOMValidateContext(new InternalKeySelector(this.parsedDoc), n);
                        csig = fac.unmarshalXMLSignature(valContext);
                        Element sv = (Element)this.lookForChild(this.signatureList.item(index), "SignatureValue");
                        if (sv == null) {
                            if (!logger.isDebugEnabled()) continue;
                            this.print("[checkXADES] Cannot find signatureValue the countersignature is referred to");
                            continue;
                        }
                        String svId = null;
                        svId = sv.getAttribute("Id");
                        if (svId == null || svId.equals("")) {
                            if (!logger.isDebugEnabled()) continue;
                            this.print("[checkXADES] missing signatureValue Id for signatureValue the countersignature is referred to");
                            continue;
                        }
                        if (logger.isDebugEnabled()) {
                            this.print("[checkXADES] Referred SignatureValue has Id: " + svId);
                        }
                        int cRef = csig.getSignedInfo().getReferences().size();
                        for (int r = 0; r < cRef; ++r) {
                            String referenceURI = csig.getSignedInfo().getReferences().get(r).getURI();
                            if (logger.isDebugEnabled()) {
                                this.print("[checkXADES] CounterSignature ReferenceURI is: " + referenceURI);
                            }
                            if (referenceURI.compareTo("#" + svId) != 0 && referenceURI.compareTo("#xpointer(id('" + svId + "'))") != 0) continue;
                            if (logger.isDebugEnabled()) {
                                this.print("[checkXADES] CounterSignature is referred to Signature Value");
                            }
                            isCSReferredToSignatureValue = true;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        this.print("CounterSignature encoding error: " + e.getMessage());
                        continue;
                    }
                    if (!isCSReferredToSignatureValue) {
                        if (!logger.isDebugEnabled()) continue;
                        this.print("[checkXADES] CounterSignature is not referred to Signature Value");
                        continue;
                    }
                    vs.add(n);
                }
                this.counterSig[index] = s = new ItemList(vs);
            }
            catch (CapiException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw e;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw new CapiException("CounterSignature encoding error", 50025);
            }
        }
        ItemList sts = null;
        try {
            if (logger.isDebugEnabled()) {
                this.print("[checkXADES] finding SignatureTimeStamp...");
            }
            if ((sts = this.lookForChilds(usp, "SignatureTimeStamp")) == null || sts.getLength() == 0) {
                if (logger.isDebugEnabled()) {
                    this.print("[checkXADES] Signer " + index + " has not SignatureTimeStamps");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    this.print("[checkXADES] Signer " + index + " has: " + sts.getLength() + " SignatureTimeStamps");
                }
                Element ts = null;
                this.signatureTimeStamp[index] = new Element[sts.getLength()];
                for (int i = 0; i < sts.getLength(); ++i) {
                    this.signatureTimeStamp[index][i] = ts = (Element)sts.item(i);
                }
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("SignatureTimeStamp encoding error", 50025);
        }
    }

    private void parseCertificateValues(int index, Node xadesCertificateValues) throws Exception {
        if (xadesCertificateValues == null) {
            return;
        }
        ItemList list = this.lookForChilds(xadesCertificateValues, "xades:EncapsulatedX509Certificate");
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String scert = node.getTextContent();
                Certificate cert = new Certificate(Base64.decode((String)scert));
                if (this.certsForSigner.get(index) == null) {
                    this.certsForSigner.put(index, new LinkedList());
                }
                if (this.certsForSigner.get(index).contains(cert.getInternalCert())) continue;
                this.certsForSigner.get(index).add(cert.getInternalCert());
            }
        }
    }

    private void parseRevocationValues(int index, Node xadesRevocationValues) throws Exception {
        Node xadesCRLValues;
        if (xadesRevocationValues == null) {
            return;
        }
        Node xadesOCSPValues = this.lookForChild(xadesRevocationValues, "xades:OCSPValues");
        if (xadesOCSPValues != null) {
            this.parseOCSPValues(index, xadesOCSPValues);
        }
        if ((xadesCRLValues = this.lookForChild(xadesRevocationValues, "xades:CRLValues")) != null) {
            this.parseCRLValues(index, xadesCRLValues);
        }
    }

    private void parseOCSPValues(int index, Node xadesOCSPValue) throws Exception {
        if (xadesOCSPValue == null) {
            return;
        }
        ItemList list = this.lookForChilds(xadesOCSPValue, "xades:EncapsulatedOCSPValue");
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String socsp = node.getTextContent();
                BasicOCSPResp resp = OcspUtils.getInstaceByBytes(Base64.decode((String)socsp));
                if (this.ocspsForSigner.get(index) == null) {
                    this.ocspsForSigner.put(index, new LinkedList());
                }
                if (this.ocspsForSigner.get(index).contains(resp)) continue;
                this.ocspsForSigner.get(index).add(resp);
            }
        }
    }

    private void parseCRLValues(int index, Node xadesCRLValues) throws Exception {
        if (xadesCRLValues == null) {
            return;
        }
        ItemList list = this.lookForChilds(xadesCRLValues, "xades:EncapsulatedCRLValue");
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String scrl = node.getTextContent();
                CRL crl = new CRL(Base64.decode((String)scrl));
                if (this.crlsForSigner.get(index) == null) {
                    this.crlsForSigner.put(index, new LinkedList());
                }
                if (this.crlsForSigner.get(index).contains(crl)) continue;
                this.crlsForSigner.get(index).add(crl);
            }
        }
    }

    private byte[] getTimeStamp(byte[] message) throws CapiException {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        ByteArrayInputStream TSReq = null;
        String tsr = null;
        try {
            if (this.TSAClient != null) {
                return this.TSAClient.timeStamp(this.TSApolicy, this.TSAhashAlgorithm, message, nonce, this.TSAcertReq).toByteArray(false, true);
            }
            Client cli = new Client();
            tsr = cli.getRequest(this.TSApolicy, this.TSAhashAlgorithm, message, false, nonce, this.TSAcertReq);
            if (logger.isDebugEnabled()) {
                this.print("[getTimeStamp] generated TSReq");
            }
            TSReq = new ByteArrayInputStream(Util.base64DecodeStr(tsr));
        }
        catch (IllegalParamException e) {
            throw new CapiException("Error generating TSReq", 50040);
        }
        catch (CapiException e) {
            if (logger.isDebugEnabled()) {
                this.print("[getTimeStamp] Error generating TSReq");
            }
            throw e;
        }
        catch (IOException e) {
            throw new CapiException("Error sending TSReq", 50040);
        }
        byte[] XMLSignatureTS = null;
        if (logger.isDebugEnabled()) {
            this.print("[getTimeStamp] trying send TSA Request ...");
        }
        try {
            if (this.TSAhttps != null) {
                XMLSignatureTS = this.TSAhttps.doPost(this.TSA, "application/timestamp-query", TSReq, null);
            } else {
                HTTP_URLConnection u = new HTTP_URLConnection();
                XMLSignatureTS = u.doPost(this.TSA, "application/timestamp-query", Util.base64DecodeStr(tsr), this.TSABasicAuthUser, this.TSABasicAuthPassword);
            }
        }
        catch (CapiException c) {
            if (logger.isDebugEnabled()) {
                this.print("[getTimeStamp] Error sending TSReq");
            }
            throw c;
        }
        catch (Exception c) {
            c.printStackTrace();
            if (logger.isDebugEnabled()) {
                this.print("[getTimeStamp] Error sending TSReq");
            }
            throw new CapiException("Exception posting TSReq using HTTP_URLConnection: " + c.getMessage(), 91007);
        }
        if (XMLSignatureTS == null || XMLSignatureTS.length == 0) {
            throw new CapiException("Null response from TSA", 50040);
        }
        if (logger.isDebugEnabled()) {
            this.print("[getTimeStamp] received Time Stamp Token form TSA.");
        }
        return XMLSignatureTS;
    }

    protected void print(String s) {
        logger.debug("[SignedXMLEnvelope] " + s);
    }

    private static Node[] getNodes(int tabCount, boolean isLastNode, Document doc) {
        String s1 = "\n";
        for (int t = 0; t < tabCount; ++t) {
            s1 = s1.concat("\t");
        }
        Text n1 = doc.createTextNode(s1);
        Text n2 = null;
        if (isLastNode) {
            String s2 = "\n";
            if (isLastNode) {
                for (int t = 0; t < tabCount - 1; ++t) {
                    s2 = s2.concat("\t");
                }
            } else {
                s2 = s1;
            }
            n2 = doc.createTextNode(s2);
        }
        Node[] nodes = new Node[]{n1, n2};
        return nodes;
    }

    public byte[] getRawSignature(int index) {
        DOMImplementationLS impl = (DOMImplementationLS)((Object)this.parsedDoc.getImplementation());
        LSSerializer serializer = impl.createLSSerializer();
        LSOutput lsOutput = impl.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lsOutput.setCharacterStream(stringWriter);
        serializer.write(this.signatureList.item(index), lsOutput);
        String result = ((Object)stringWriter).toString();
        try {
            return result.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return result.getBytes();
        }
    }

    public LinkedList<X509Certificate> getCertificates(int signerInfoIdex) throws Exception {
        return this.certsForSigner.get(signerInfoIdex);
    }

    public LinkedList<CRL> getCRLS(int signerInfoIdex) throws CapiException, CRLException, CMSException {
        return this.crlsForSigner.get(signerInfoIdex);
    }

    public LinkedList<BasicOCSPResp> getBasicOCSPResponses(int signerInfoIdex) throws CMSException, CRLException {
        return this.ocspsForSigner.get(signerInfoIdex);
    }

    public boolean hasSigningCertificate(int signerInfoIndex) {
        return this.signingCert[signerInfoIndex] || this.signingCertV2[signerInfoIndex];
    }

    private byte[] getCanonicalC11N11ElmenteByte(Element node) throws IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, TransformException {
        TransformService service = TransformService.getInstance("http://www.w3.org/2006/12/xml-c14n11#WithComments", "DOM");
        DOMValidateContext context = new DOMValidateContext(new InternalKeySelector(null), (Node)node);
        service.init(new DOMStructure(node), null);
        Data data = service.transform(new DOMSubTreeData(node, false), context);
        InputStream is = ((OctetStreamData)data).getOctetStream();
        return IOUtils.toByteArray((InputStream)is);
    }

    protected class ItemList
    implements NodeList {
        List<Node> cs = null;

        ItemList(List<Node> v) {
            this.cs = v;
        }

        @Override
        public Node item(int index) {
            return this.cs.get(index);
        }

        @Override
        public int getLength() {
            return this.cs.size();
        }

        public void add(Node n) {
            this.cs.add(n);
        }
    }
}

