/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.MemoryUtils;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

public class ClonerInputStream
extends InputStream {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final int MIN_CHUNK_SIZE = 2048;
    private static final int MAX_CHUNK_SIZE = (int)(MemoryUtils.getMaxHeapBytes() / 50L);
    private InputStream source = null;
    private OutputStream target = null;
    private int chunkSize = 0;

    public void setChunkSizeForced(int size) {
        this.chunkSize = size;
    }

    private void flushTarget() throws IOException {
        if (this.target != null) {
            this.target.flush();
        }
    }

    public ClonerInputStream(InputStream source, OutputStream target) {
        this.source = source;
        this.target = target;
        this.chunkSize = MAX_CHUNK_SIZE;
    }

    public void setChunkSize(int size) {
        this.chunkSize = Math.min(Math.max(2048, size), MAX_CHUNK_SIZE);
    }

    public int cloneChunk(boolean flush) throws IOException {
        int bytesRead;
        for (bytesRead = 0; this.read() >= 0 && bytesRead < this.chunkSize; ++bytesRead) {
        }
        if (flush) {
            this.flushTarget();
        }
        return bytesRead;
    }

    public int cloneChunkBuffered(boolean flush) throws IOException {
        int bytesRead;
        int read;
        byte[] buffer = new byte[4096];
        for (bytesRead = 0; (read = this.read(buffer)) >= 0 && bytesRead < this.chunkSize; bytesRead += read) {
        }
        if (flush) {
            this.flushTarget();
        }
        return bytesRead;
    }

    public int cloneChunk() throws IOException {
        return this.cloneChunk(true);
    }

    public long cloneAll() throws IOException {
        int partial;
        long total = 0L;
        do {
            partial = this.cloneChunk(false);
            total += (long)partial;
        } while (partial >= this.chunkSize);
        this.flushTarget();
        return total;
    }

    public InputStream getSlaveInputStream(InputStream slave) {
        return new ClonerSlaveInputStream(slave);
    }

    @Override
    public int read() throws IOException {
        int read = -1;
        if (this.source != null) {
            read = this.source.read();
        }
        if (this.target != null && read >= 0) {
            this.target.write(read);
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = -1;
        if (this.source != null) {
            read = this.source.read(b);
        }
        if (this.target != null && read >= 0) {
            this.target.write(b, 0, read);
        }
        return read;
    }

    public class ClonerSlaveInputStream
    extends InputStream {
        private InputStream slave = null;

        public ClonerSlaveInputStream(InputStream slave) {
            this.slave = slave;
        }

        @Override
        public int read() throws IOException {
            int read = this.slave.read();
            if (read < 0) {
                ClonerInputStream.this.cloneChunk();
                read = this.slave.read();
            }
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = this.slave.read(b);
            if (read < 0) {
                ClonerInputStream.this.cloneChunkBuffered(true);
                read = this.slave.read(b);
            }
            return read;
        }
    }
}

