/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.Validator;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.logging.LoggerConfig;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.actalis.ellips.capi.tsl.ParsingResults;
import it.actalis.ellips.capi.tsl.TSL;
import it.actalis.ellips.capi.tsl.TSLParserFactory;
import it.actalis.ellips.capi.tsl.TSLPointer;
import it.actalis.ellips.capi.tsl.TSLServiceType;
import it.actalis.ellips.capi.tsl.TSLStatus;
import it.actalis.ellips.capi.tsl.rootupdater.RootUpdaterGUI;
import it.actalis.ellips.capi.tsl.rootupdater.RootUpdaterReport;
import it.actalis.ellips.capi.tsl.rootupdater.TSLInfo;
import it.actalis.ellips.capi.tsl.rootupdater.TSLUtils;
import it.actalis.ellips.capi.tsl.rootupdater.UpdateMode;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import it.arubapec.ca.utils.ConfigParameter;
import it.arubapec.ca.utils.FileUtils;
import it.arubapec.ca.utils.LockApplication;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.slf4j.Logger;
import secretstoreutils.SecretStore;

public class RootUpdater {
    protected String homeFolder = null;
    protected static Logger logger = null;
    protected CertDB cdb = null;
    protected String cdbName = null;
    protected java.io.File cdbFile = null;
    protected String cdbPassword = null;
    protected String customTSLItaUrl = null;
    protected String customTSLItaCert = null;
    protected String reportFileName = "";
    protected String mergeFileName = "";
    protected java.io.File indexLastUpdFile = null;
    protected java.io.File lastUpdFile = null;
    protected java.io.File progressFile = null;
    protected java.io.File reportFile = null;
    protected java.io.File mergeFile = null;
    protected java.io.File tslEndPointFile = null;
    protected final String DEBUG_CDB_NAME = "cert_debug.cdb";
    protected TSLParserFactory parserFactory = null;
    protected boolean forcedUpdate = false;
    protected boolean fileProgressEnabled = false;
    protected boolean printTSLEndpoints = false;
    protected boolean checkAdditionalSrvInfo = false;
    protected String TSLHistoryFolder = null;
    protected int iProgressStep;
    protected int totProgressSteps;
    protected RootUpdaterReport report = null;
    protected RootUpdaterGUI updaterGUI = null;
    protected UpdateMode updateMode = UpdateMode.ATSL_SIGNED;
    protected final int UPD_DONE = 0;
    protected final int UPD_ERROR = 1;
    protected final int UPD_SKIP = 2;
    protected final int UPD_UNKNOWN = 3;
    protected final int UPD_IGNORED = 4;
    protected final int UPD_ARCHIVED = 5;
    protected final String arubaCDBServerUrl = "https://updatesfirma.aruba.it/cdb/cert.cdb";
    protected final String arubaCDBSignedServerUrl = "https://updatesfirma.aruba.it/cdb/cert.cdb.p7m";
    protected final String arubaCDBChecksumServerUrl = "https://updatesfirma.aruba.it/cdb/checksum.txt";
    protected List<String> ignoreTSL = new LinkedList<String>();
    protected List<String> ignoreVerificationTSL = new LinkedList<String>();
    protected String debugTSL = "";

    public RootUpdater(String homeFolder, String cdbName) throws CapiException {
        this(homeFolder, cdbName, "1234567890AAbbCCdd", null);
    }

    public RootUpdater(String homeFolder, String cdbName, String cdbPwd) throws CapiException {
        this(homeFolder, cdbName, cdbPwd, null);
    }

    public RootUpdater(String homeFolder, String cdbName, String cdbPwd, NetworkConfig netConf) throws CapiException {
        this(homeFolder, cdbName, cdbPwd, netConf, null);
    }

    public RootUpdater(String homeFolder, String cdbName, String cdbPwd, NetworkConfig netConf, Logger log) throws CapiException {
        this(homeFolder, "TSL", cdbName, cdbPwd, netConf, log);
    }

    public RootUpdater(String homeFolder, String subFolder, String cdbName, String cdbPwd, NetworkConfig netConf, Logger log) throws CapiException {
        this(homeFolder, subFolder, cdbName, cdbPwd, null, netConf, log);
    }

    public RootUpdater(String homeFolder, String cdbName, java.io.File defaultCdb, String cdbPwd, NetworkConfig netConf, Logger log) throws CapiException {
        this(homeFolder, "TSL", cdbName, cdbPwd, defaultCdb, netConf, log);
    }

    public RootUpdater(String homeFolder, String subFolder, String cdbName, String cdbPwd, java.io.File defaultCdb, NetworkConfig netConf, Logger log) throws CapiException {
        this.initialize(homeFolder, subFolder, cdbName, cdbPwd, netConf, log, defaultCdb);
    }

    public RootUpdater(String homeFolder, ValidatorConfig config) throws CapiException {
        this(homeFolder, config, null);
    }

    public RootUpdater(String homeFolder, ValidatorConfig config, Logger log) throws CapiException {
        if (config == null) {
            throw new CapiException("No config specified", 1003);
        }
        NetworkConfig netConf = config.getNetConfiguration();
        if (netConf == null) {
            String ldapProxyEnabled;
            String httpProxyEnabled;
            netConf = new NetworkConfig(log, false);
            boolean bEnableHttpProxy = false;
            if (config.getElement("http.proxy", null) != null && (httpProxyEnabled = config.getElement("http.proxy", null)).equalsIgnoreCase("true")) {
                bEnableHttpProxy = true;
            }
            if (bEnableHttpProxy) {
                String px_host = "";
                if (config.getElement("http.proxy.host", null) != null) {
                    px_host = config.getElement("http.proxy.host", null);
                }
                int px_port = config.getIntElement("http.proxy.port", 8080);
                String px_user = "";
                if (config.getElement("http.proxy.user", null) != null) {
                    px_user = config.getElement("http.proxy.user", null);
                }
                String px_pass = "";
                if (config.getElement("http.proxy.pass", null) != null) {
                    px_pass = config.getElement("http.proxy.pass", null);
                }
                String px_no_proxy_hosts = "";
                if (config.getElement("http.proxy.noProxyHosts", null) != null) {
                    px_no_proxy_hosts = config.getElement("http.proxy.noProxyHosts", null);
                }
                netConf.setProxy(px_host);
                netConf.setProxyPort(px_port + "");
                netConf.setUserProxy(px_user);
                netConf.setPasswordProxy(px_pass);
                netConf.setProxynohosts(px_no_proxy_hosts.split(","));
            }
            boolean bEnableLdapProxy = false;
            if (config.getElement("ldap.proxy", null) != null && (ldapProxyEnabled = config.getElement("ldap.proxy", null)).equalsIgnoreCase("true")) {
                bEnableLdapProxy = true;
            }
            if (bEnableLdapProxy) {
                String px_host = "";
                if (config.getElement("ldap.proxy.host", null) != null) {
                    px_host = config.getElement("ldap.proxy.host", null);
                }
                int px_port = config.getIntElement("ldap.proxy.port", 8080);
                String px_user = "";
                if (config.getElement("ldap.proxy.user", null) != null) {
                    px_user = config.getElement("http.proxy.user", null);
                }
                String px_pass = "";
                if (config.getElement("ldap.proxy.pass", null) != null) {
                    px_pass = config.getElement("ldap.proxy.pass", null);
                }
                netConf.setLdapProxy(px_host);
                netConf.setLdapProxyPort(px_port + "");
                netConf.setLdapUserProxy(px_user);
                netConf.setLdapPasswordProxy(px_pass);
            }
        }
        String certdbfilepath = config.getElement("certdb.file");
        java.io.File certdbFile = new java.io.File(certdbfilepath);
        String pwd = config.getElement("certdb.pwd");
        this.initialize(homeFolder, "", certdbFile.getName(), pwd, netConf, log, null);
    }

    private void initialize(String homeFolder, String subFolder, String cdbName, String cdbPwd, NetworkConfig netConf, Logger log, java.io.File defaultCDB) throws CapiException {
        if (Util.isNullOrEmpty(homeFolder)) {
            throw new CapiException("TSL home folder wrong or not specified", 1003);
        }
        if (Util.isNullOrEmpty(cdbName)) {
            throw new CapiException("cdb name wrong or not specified", 1003);
        }
        if (Util.isNullOrEmpty(cdbPwd)) {
            throw new CapiException("cdb password wrong or not specified", 1003);
        }
        logger = log == null ? EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME) : log;
        this.customTSLItaUrl = "";
        this.customTSLItaCert = "";
        this.parserFactory = new TSLParserFactory();
        if (netConf == null) {
            netConf = new NetworkConfig(logger, false);
        }
        this.parserFactory.setNetworkConfig(netConf);
        this.fileProgressEnabled = false;
        this.reportFileName = "";
        this.mergeFileName = "";
        this.report = new RootUpdaterReport();
        this.iProgressStep = 0;
        this.totProgressSteps = 1;
        this.cdbName = cdbName;
        this.homeFolder = homeFolder;
        if (!Util.isNullOrEmpty(subFolder)) {
            this.homeFolder = homeFolder + java.io.File.separator + subFolder;
        }
        java.io.File TSLFolder = new java.io.File(this.homeFolder);
        try {
            if (!TSLFolder.exists()) {
                TSLFolder.mkdirs();
                logger.info("TSL folder created");
            }
        }
        catch (SecurityException ex) {
            logger.error("Unable to create TSL folder: " + ex.getMessage());
            throw new CapiException("Unable to create TSL folder", 1003, ex);
        }
        this.cdbFile = new java.io.File(TSLFolder + java.io.File.separator + this.cdbName);
        this.indexLastUpdFile = new java.io.File(TSLFolder + java.io.File.separator + "lastUpdIndex.ini");
        this.lastUpdFile = new java.io.File(TSLFolder + java.io.File.separator + "atslLastUpd.txt");
        this.progressFile = new java.io.File(TSLFolder + java.io.File.separator + "progress.txt");
        this.tslEndPointFile = new java.io.File(TSLFolder + java.io.File.separator + "tslEndPoints.txt");
        this.forcedUpdate = false;
        this.cdbPassword = cdbPwd;
        try {
            if (!this.cdbFile.exists() && defaultCDB != null && defaultCDB.exists()) {
                logger.info(String.format("Using the cdb %s. Its size is %d KB", defaultCDB.getAbsolutePath(), defaultCDB.length() / 1024L));
                Utils.copyFile(defaultCDB, this.cdbFile);
                this.cdb = CertDB.getInstance(this.cdbFile.getAbsolutePath(), this.cdbPassword, false, true);
                logger.info("The installer's cdb was copied to default cdb folder");
            } else {
                logger.info("create cdb " + !this.cdbFile.exists());
                this.cdb = CertDB.getInstance(this.cdbFile.getAbsolutePath(), this.cdbPassword, !this.cdbFile.exists(), true);
            }
        }
        catch (CertDBException ex) {
            throw new CapiException("Error opening or loading cdb file", 1003, ex);
        }
        catch (IOException ex) {
            throw new CapiException("Error copying cdb file", 1003, ex);
        }
        catch (Exception ex) {
            throw new CapiException("General cdb file error", 1003, ex);
        }
    }

    public void setReportFileName(String fileName) {
        this.reportFileName = fileName;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setMergeDiffFileName(String fileName) {
        this.mergeFileName = fileName;
    }

    public String getMergeDiffFileName() {
        return this.mergeFileName;
    }

    public String getTSLHistoryFolder() {
        return this.TSLHistoryFolder;
    }

    public void setTSLHistoryFolder(String TSLHistoryFolder) {
        this.TSLHistoryFolder = TSLHistoryFolder;
    }

    public void setForcedUpdate(boolean bForce) {
        this.forcedUpdate = bForce;
    }

    public boolean isForcedUpdate() {
        return this.forcedUpdate;
    }

    public void setForceHTTPSConnections(boolean bVal) {
        if (this.parserFactory != null) {
            this.parserFactory.setForceHTTPSConnections(bVal);
        }
    }

    public boolean isCheckAdditionalSrvInfo() {
        return this.checkAdditionalSrvInfo;
    }

    public void setCheckAdditionalSrvInfo(boolean checkAdditionalSrvInfo) {
        this.checkAdditionalSrvInfo = checkAdditionalSrvInfo;
    }

    public boolean isForcedToHTTPSConnections() {
        if (this.parserFactory != null) {
            return this.parserFactory.isForcedToHTTPSConnections();
        }
        return false;
    }

    public void setUntrustedStates(String[] untrustState) throws CapiException {
        if (this.parserFactory == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setUntrustedStates(untrustState);
    }

    public void setTrustedStates(String[] trustState) throws CapiException {
        if (this.parserFactory == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setTrustedStates(trustState);
    }

    public void setWarningStates(String[] warningState) throws CapiException {
        if (this.parserFactory == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setWarningStates(warningState);
    }

    public void setRemoveStates(String[] removeState) throws CapiException {
        if (this.parserFactory == null) {
            throw new CapiException("ParserFactory not initialized", 1003);
        }
        TSLStatus.setRemoveStates(removeState);
    }

    public String getTSLUrlDSIta() {
        return TSL.URL_DSList.getUrl();
    }

    public void setTSLUrlDSIta(String url) {
        TSL.URL_DSList.setUrl(url);
    }

    public String getTSLUrlEU() {
        return TSL.URL_ListOfList.getUrl();
    }

    public void setTSLUrlEU(String url) {
        TSL.URL_ListOfList.setUrl(url);
    }

    public void setConnectionTimeout(int mSec) {
        this.parserFactory.setReadTimeout(mSec);
        this.parserFactory.setConnectionTimeout(mSec);
    }

    public void enableFileProgress() {
        this.fileProgressEnabled = true;
    }

    public void disableFileProgress() {
        this.fileProgressEnabled = false;
    }

    public boolean isProgressEnabled() {
        return this.fileProgressEnabled;
    }

    public java.io.File getProgressFile() {
        return this.progressFile;
    }

    public boolean isUpdateNeeded() {
        if (this.isRebuildFromScratchNeeded()) {
            return true;
        }
        switch (this.updateMode) {
            case TSL: {
                return this.isTSLUpdated(TSL.URL_DSList.getUrl()) || this.isTSLUpdated(TSL.URL_ListOfList.getUrl());
            }
            case ATSL: {
                return this.isTSLUpdated("https://updatesfirma.aruba.it/cdb/cert.cdb");
            }
            case ATSL_SIGNED: {
                return this.isTSLUpdated("https://updatesfirma.aruba.it/cdb/cert.cdb.p7m");
            }
            case DEBUG: {
                return true;
            }
        }
        return false;
    }

    protected boolean isRebuildFromScratchNeeded() {
        if (!this.cdbFile.exists()) {
            logger.info("no cdb file found in " + this.cdbFile.getAbsolutePath() + ". It will be rebuilt from scratch");
            return true;
        }
        if (this.cdb.getSize() == 0) {
            logger.info("cdb is empty. It will be rebuilt from scratch");
            return true;
        }
        if (this.updateMode.equals((Object)UpdateMode.TSL)) {
            if (!this.indexLastUpdFile.exists()) {
                logger.info("no index file found. Cdb will be rebuilt from scratch");
                return true;
            }
        } else if ((this.updateMode.equals((Object)UpdateMode.ATSL) || this.updateMode.equals((Object)UpdateMode.ATSL_SIGNED)) && !this.lastUpdFile.exists()) {
            logger.info("no update file found. Cdb will be downloaded");
            return true;
        }
        return false;
    }

    public CertDB getCertificateDB() {
        return this.cdb;
    }

    public void setGUI(RootUpdaterGUI updaterGUI) {
        this.updaterGUI = updaterGUI;
    }

    /*
     * Exception decompiling
     */
    public boolean doUpdate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK], 26[CATCHBLOCK], 6[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RootUpdaterReport getReport() {
        return this.report;
    }

    protected java.io.File validateCdb(java.io.File downloadedCdb) throws CapiException {
        if (this.updateMode != UpdateMode.ATSL_SIGNED) {
            return downloadedCdb;
        }
        ValidatedDocument doc = null;
        InputStream is = null;
        File extracted = null;
        InputHandler hFile = null;
        try {
            ValidatorConfig validatorConfig = new ValidatorConfig();
            validatorConfig.setElement("certdb.file", this.cdb.getFilePath());
            validatorConfig.setElement("certdb.pwd", "1234567890AAbbCCdd");
            validatorConfig.setNetConfiguration(this.parserFactory.getNetworkConfig());
            Validator validator = new Validator(validatorConfig, (Logger)EllipsLoggerFactory.getLogger((String)"TEST"));
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            format.setTimeZone(Constants.DEFAULT_TIMEZONE);
            ValidationDate vDate = new ValidationDate(new Date(), DateSource.SYSTEM);
            hFile = DataHandlerBuilder.get().setFile(downloadedCdb).buildInput();
            doc = validator.validate(hFile, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, vDate, null);
            if (!doc.isOverAllOk() || doc.getSubResults().isEmpty()) {
                throw new CapiException("Invalid ATSL cdb signature", 1003);
            }
            is = doc.getSubResults().get(0).getHandler().getInputAsNewStream();
            extracted = TmpFileUtils.createTempFile("extracted", ".cdb");
            Files.copy(is, extracted.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception ex) {
            try {
                throw new CapiException(ex.getMessage(), 1003, ex);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(hFile);
                Util.closeQuietly(is);
                if (doc != null) {
                    Util.closeQuietly(doc.getHandler());
                }
                throw throwable;
            }
        }
        Util.closeQuietly(hFile);
        Util.closeQuietly(is);
        if (doc != null) {
            Util.closeQuietly(doc.getHandler());
        }
        return extracted;
    }

    public void setIgnoreTSLList(List<String> ignoreTSL) {
        this.ignoreTSL.clear();
        for (int i = 0; i < ignoreTSL.size(); ++i) {
            String url = this.removeProtocol(ignoreTSL.get(i).toLowerCase());
            this.ignoreTSL.add(url);
        }
    }

    public void setIgnoreVerificationTSLList(List<String> ignoreTSL) {
        this.ignoreVerificationTSL.clear();
        for (int i = 0; i < ignoreTSL.size(); ++i) {
            String url = this.removeProtocol(ignoreTSL.get(i).toLowerCase());
            this.ignoreVerificationTSL.add(url);
        }
    }

    public String getCertDBFilePath() {
        return this.cdbFile.getAbsolutePath();
    }

    public void useCustomTSLDSIta(String customTslITAUrl, String customTslITACert) {
        this.customTSLItaUrl = customTslITAUrl;
        this.customTSLItaCert = customTslITACert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            if (this.updaterGUI != null) {
                this.updaterGUI.closeGUI();
            }
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    private String removeProtocol(String urlWithProtocol) {
        return urlWithProtocol.replace("http://", "").replace("https://", "");
    }

    public boolean isPrintTSLEndPoints() {
        return this.printTSLEndpoints;
    }

    public void setPrintTSLEndPoints(boolean bPrintTSLEndpoints) {
        this.printTSLEndpoints = bPrintTSLEndpoints;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public void setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateProgress(double stepRatio, String status, String detail) {
        if (this.updaterGUI != null) {
            this.updaterGUI.updateProgress(stepRatio);
            this.updaterGUI.updateDetailArea(detail);
            this.updaterGUI.updateStatus(status);
        }
        if (!this.fileProgressEnabled) {
            return false;
        }
        try {
            if (!this.progressFile.exists()) {
                this.progressFile.createNewFile();
            }
            ArrayList<String> data = new ArrayList<String>();
            data.add(String.format("%d", this.iProgressStep));
            data.add(status);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.progressFile), "UTF-8"));
            try {
                for (int iS = 0; iS < data.size(); ++iS) {
                    out.write((String)data.get(iS) + "\n");
                }
            }
            finally {
                Util.closeQuietly(out);
            }
            return true;
        }
        catch (IOException ex) {
            logger.error("error writing last ita TSL update data");
            return false;
        }
        catch (SecurityException ex1) {
            logger.error("error writing last ita TSL update data");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeToReport(String msg) {
        if (this.reportFileName.isEmpty()) {
            return false;
        }
        if (this.reportFile == null) {
            return false;
        }
        if (!this.reportFile.exists()) {
            return false;
        }
        if (!this.reportFile.canWrite()) {
            return false;
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.reportFile.getAbsoluteFile(), true);
            fw.write(msg + '\n');
        }
        catch (IOException ex) {
            boolean bl;
            try {
                logger.error("error writing report", (Throwable)ex);
                bl = false;
            }
            catch (Throwable throwable) {
                Util.closeQuietly(fw);
                throw throwable;
            }
            Util.closeQuietly(fw);
            return bl;
        }
        Util.closeQuietly(fw);
        logger.debug(msg);
        return true;
    }

    protected boolean isTSLUpdated(String url) {
        if (this.forcedUpdate) {
            return true;
        }
        Date cdbDate = new Date(this.cdbFile.lastModified());
        Date remoteDate = TSLUtils.getLastTSLModifiedDate(url, this.parserFactory.getNetworkConfig(), logger);
        if (remoteDate != null && !remoteDate.after(cdbDate)) {
            logger.info(url + "  not modified");
            return false;
        }
        return true;
    }

    protected Date getLastTSLUpdateDate(String tslUrl) throws ParseException {
        if (!this.indexLastUpdFile.exists() || Util.isNullOrEmpty(tslUrl)) {
            return null;
        }
        String tslUrlKey = this.removeProtocol(tslUrl);
        String[] parts = tslUrlKey.split("/");
        if (parts.length < 1) {
            return null;
        }
        tslUrlKey = parts[0];
        try {
            IniPreferences prefs = new IniPreferences(new Ini(this.indexLastUpdFile));
            String localDate = prefs.node("TSL").get(tslUrlKey, "");
            if (Util.isNullOrEmpty(localDate)) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            return sdf.parse(localDate);
        }
        catch (IOException ex) {
            logger.warn("local date for " + tslUrl + " not found");
        }
        catch (IllegalStateException ex) {
            logger.warn("local date for " + tslUrl + " not found");
        }
        return null;
    }

    protected boolean setLastTSLUpdateDate(String tslUrl, Date updDate) {
        if (Util.isNullOrEmpty(tslUrl) || updDate == null) {
            return false;
        }
        String tslUrlKey = this.removeProtocol(tslUrl);
        String[] parts = tslUrlKey.split("/");
        if (parts.length < 1) {
            return false;
        }
        tslUrlKey = parts[0];
        try {
            if (!this.indexLastUpdFile.exists()) {
                this.indexLastUpdFile.createNewFile();
            }
            Ini iniFile = new Ini(this.indexLastUpdFile);
            IniPreferences prefs = new IniPreferences(iniFile);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            prefs.node("TSL").put(tslUrlKey, sdf.format(updDate));
            try {
                prefs.sync();
                iniFile.store();
            }
            catch (BackingStoreException ex) {
                logger.error(String.format("unable to update local date file", ex.getMessage()));
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            logger.error("unable to get local date for " + tslUrl + " " + ex.getMessage());
            return false;
        }
    }

    protected int doUpdateNationalTSL(TSLPointer tslPtr, CertDB certDB) {
        return this.doUpdateNationalTSL(tslPtr, certDB, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doUpdateNationalTSL(TSLPointer tslPtr, CertDB certDB, java.io.File tempTSLFile) {
        if (tslPtr == null || tslPtr.getUrl().isEmpty()) {
            return 1;
        }
        String url = tslPtr.getUrl();
        if (TSL.URL_ListOfList.getUrl().equals(url)) {
            return 2;
        }
        ParsingResults results = null;
        TSLInfo tslReportInfo = new TSLInfo(url);
        int nCert = 0;
        try {
            String nationality = TSLUtils.getNationalityFromUrl(url);
            tslReportInfo.setNationalId(TSLUtils.extendedNationId(nationality));
            String matchUrl = this.removeProtocol(url.toLowerCase());
            if (this.ignoreVerificationTSL.contains(matchUrl)) {
                tslPtr.setVerifyXMLSignature(false);
            }
            if (tslPtr.getArchivedFile() != null) {
                try {
                    results = this.parserFactory.parseEUStateList(tslPtr, certDB, tempTSLFile);
                    tslReportInfo.setParsingResults(results);
                }
                catch (Throwable ex) {
                    this.writeToReport(String.format("archived tsl parsing failed: %s", ex.getMessage()));
                    tslReportInfo.setLastError(ex.getMessage());
                    int n = 1;
                    if (this.report != null) {
                        this.report.addTSLInfo(tslReportInfo);
                    }
                    return n;
                }
            } else {
                Date localLastUpdDate = this.getLastTSLUpdateDate(url);
                Date remoteTslUpdDate = TSLUtils.getLastTSLModifiedDate(url, this.parserFactory.getNetworkConfig(), logger);
                tslReportInfo.setLastModification(remoteTslUpdDate);
                boolean unknownDates = localLastUpdDate == null || remoteTslUpdDate == null;
                boolean isRemoteUpdated = true;
                if (localLastUpdDate != null && remoteTslUpdDate != null) {
                    isRemoteUpdated = remoteTslUpdDate.after(localLastUpdDate);
                }
                if (this.isForcedUpdate() || unknownDates || isRemoteUpdated) {
                    results = this.parserFactory.parseEUStateList(tslPtr, certDB, tempTSLFile);
                    tslReportInfo.setParsingResults(results);
                }
                if (!this.setLastTSLUpdateDate(url, new Date())) {
                    this.writeToReport("error updating local index date file!");
                    tslReportInfo.setLastError("error updating local index date file!");
                    int n = 1;
                    return n;
                }
            }
            if (results == null) {
                this.writeToReport("no parsing results for TSL " + url + ": skip it");
                int ex = 2;
                return ex;
            }
            this.writeToReport(String.format("%d providers found with %d services and %d TSL certificates", results.nProviders, results.nServices, results.nTotalCerts));
            if (results.nServiceTrusted > 0) {
                this.writeToReport(String.format("  %d services are in <trusted> statuses", results.nServiceTrusted));
            }
            if (results.nServiceWarning > 0) {
                this.writeToReport(String.format("  %d services are in <warnings> statuses", results.nServiceWarning));
            }
            if (results.nServiceUntrusted > 0) {
                this.writeToReport(String.format("  %d services are in <untrusted> statuses ", results.nServiceUntrusted));
            }
            if (results.nServiceRemoved > 0) {
                this.writeToReport(String.format("  %d services are in <removed> statuses", results.nServiceRemoved));
            }
            String indent = "  ";
            String certs = String.format(indent + "certificates:  %d imported into db - %d updated - %d removed - %d skipped (import or remove) - %d imported by CAIssuer - %d on error", results.nCertImported, results.nCertUpdated, results.nCertRemoved, results.nCertImportSkipped + results.nCertRemoveSkipped + results.nCertUpdateSkipped, results.nCertImportedByCAIssuer, results.nCertErrors);
            this.writeToReport(certs);
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            df.setTimeZone(Constants.DEFAULT_TIMEZONE);
            if (results.lastUpdate != null) {
                this.writeToReport(String.format(indent + "TSL last update: %s", df.format(results.lastUpdate)));
            }
            if (results.nextUpdate != null) {
                this.writeToReport(String.format(indent + "TSL next update: %s", df.format(results.nextUpdate)));
            }
            if (this.checkAdditionalSrvInfo) {
                if (results.serviceTypeWithoutAdditionalSrvInfo.contains(TSLServiceType.urlToId("http://uri.etsi.org/TrstSvc/Svctype/CA/QC"))) {
                    this.writeToReport(String.format(indent + "Warning: QC service type without any AdditionalServiceInformation", new Object[0]));
                }
                String srvTypes = "";
                for (int i = 0; i < results.serviceTypeWithAdditionalSrvInfo.size(); ++i) {
                    if (results.serviceTypeWithAdditionalSrvInfo.get(i).equals(TSLServiceType.urlToId("http://uri.etsi.org/TrstSvc/Svctype/CA/QC"))) continue;
                    srvTypes = srvTypes + results.serviceTypeWithAdditionalSrvInfo.get(i) + ";";
                }
                if (!srvTypes.isEmpty()) {
                    this.writeToReport(String.format(indent + "Warning: %s services type with some AdditionalServiceInformation", srvTypes));
                }
            }
        }
        finally {
            if (this.report != null) {
                this.report.addTSLInfo(tslReportInfo);
            }
        }
        logger.debug(String.format("TSL update done: %d certificates processed. Local date file updated", nCert));
        if (tslPtr.getArchivedFile() != null) {
            return 5;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean doUpdateEuropeanListOfTSL(CertDB certDB) throws IOException {
        nTSLOk = 0;
        nTSLError = 0;
        nTSLSkip = 0;
        nTSLIgnored = 0;
        nTSLTot = 0;
        endPointsBW = null;
        try {
            tslList = this.parserFactory.parseListOfTSL(TSL.URL_ListOfList.getUrl());
            nTSLTot = tslList.size();
            if (nTSLTot > 0) {
                this.setLastTSLUpdateDate(TSL.URL_ListOfList.getUrl(), new Date());
            }
            if (this.printTSLEndpoints) {
                try {
                    this.tslEndPointFile.delete();
                    this.tslEndPointFile.createNewFile();
                    endPointsBW = new BufferedWriter(new FileWriter(this.tslEndPointFile, true));
                }
                catch (IOException ex) {
                    RootUpdater.logger.error("error creating endpoints " + ex.getMessage());
                }
            }
            for (iTSL = 0; iTSL < nTSLTot; ++iTSL) {
                block72: {
                    block70: {
                        block71: {
                            block69: {
                                curTSL = tslList.get(iTSL);
                                nationId = TSLUtils.getNationalityFromUrl(curTSL.getUrl()).toUpperCase();
                                endpoint = curTSL.getUrl();
                                if (nationId.isEmpty()) {
                                    nationId = "EU";
                                    endpoint = TSL.URL_ListOfList.getUrl();
                                }
                                RootUpdater.logger.info(String.format("===================================================================", new Object[0]));
                                ignored = "";
                                if (this.ignoreTSL.contains(this.removeProtocol(curTSL.getUrl().toLowerCase()))) {
                                    ignored = " (ignored)";
                                }
                                noSignature = "";
                                if (this.ignoreVerificationTSL.contains(this.removeProtocol(curTSL.getUrl().toLowerCase()))) {
                                    noSignature = " (no signature verification)";
                                }
                                RootUpdater.logger.info(String.format("%d) %s", new Object[]{iTSL + 1, endpoint}) + ignored + noSignature);
                                RootUpdater.logger.info(String.format("===================================================================\n", new Object[0]));
                                if (endPointsBW != null) {
                                    try {
                                        endPointsBW.write(endpoint + "\n");
                                    }
                                    catch (IOException var15_19) {
                                        // empty catch block
                                    }
                                }
                                this.writeToReport(String.format("\n%d) %s - %s", new Object[]{iTSL + 1, TSLUtils.extendedNationId(nationId), endpoint}));
                                iRet = 3;
                                if (!nationId.equals("IT") && !nationId.equals("EU")) break block69;
                                iRet = 0;
                                this.updateProgress((double)(++this.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(nationId), iTSL + 1, nTSLTot}));
                                switch (iRet) {
                                    case 0: {
                                        ++nTSLOk;
                                        this.writeToReport("=== Updated");
                                        RootUpdater.logger.info("parsed");
                                        break;
                                    }
                                    case 1: {
                                        ++nTSLError;
                                        this.writeToReport(">>> Error");
                                        RootUpdater.logger.info("error");
                                        break;
                                    }
                                    case 2: {
                                        ++nTSLSkip;
                                        this.writeToReport("*** Skipped");
                                        RootUpdater.logger.info("skipped");
                                        break;
                                    }
                                    case 3: {
                                        ++nTSLError;
                                        this.writeToReport("??? Error");
                                        RootUpdater.logger.info("unknown error");
                                        break;
                                    }
                                    case 4: {
                                        ++nTSLIgnored;
                                        this.writeToReport("!!! Ignored");
                                        RootUpdater.logger.info("ignored");
                                        break;
                                    }
                                    case 5: {
                                        ++nTSLIgnored;
                                        this.writeToReport("### From archive");
                                        RootUpdater.logger.info("from archive");
                                        break;
                                    }
                                }
                                continue;
                            }
                            tempTSLFile = null;
                            if (!this.ignoreTSL.contains(this.removeProtocol(curTSL.getUrl().toLowerCase()))) ** GOTO lbl150
                            lastTSL = this.getLastArchivedTSL(nationId);
                            if (lastTSL != null) break block70;
                            RootUpdater.logger.info("unable to find a copy of TSL in archive: it is really ignored");
                            iRet = 4;
                            if (tempTSLFile == null) break block71;
                            tempTSLFile.delete();
                        }
                        this.updateProgress((double)(++this.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(nationId), iTSL + 1, nTSLTot}));
                        switch (iRet) {
                            case 0: {
                                ++nTSLOk;
                                this.writeToReport("=== Updated");
                                RootUpdater.logger.info("parsed");
                                break;
                            }
                            case 1: {
                                ++nTSLError;
                                this.writeToReport(">>> Error");
                                RootUpdater.logger.info("error");
                                break;
                            }
                            case 2: {
                                ++nTSLSkip;
                                this.writeToReport("*** Skipped");
                                RootUpdater.logger.info("skipped");
                                break;
                            }
                            case 3: {
                                ++nTSLError;
                                this.writeToReport("??? Error");
                                RootUpdater.logger.info("unknown error");
                                break;
                            }
                            case 4: {
                                ++nTSLIgnored;
                                this.writeToReport("!!! Ignored");
                                RootUpdater.logger.info("ignored");
                                break;
                            }
                            case 5: {
                                ++nTSLIgnored;
                                this.writeToReport("### From archive");
                                RootUpdater.logger.info("from archive");
                                break;
                            }
                        }
                        continue;
                    }
                    try {
                        block74: {
                            RootUpdater.logger.info("continue with the archived copy of TSL");
                            curTSL.setArchivedFile(lastTSL);
                            break block74;
lbl150:
                            // 1 sources

                            tempTSLFile = TmpFileUtils.createTempFile("tsl_", ".xml");
                        }
                        iRet = this.doUpdateNationalTSL(curTSL, certDB, tempTSLFile);
                        if (iRet == 1 && !this.isForcedToHTTPSConnections() && curTSL.getUrl().startsWith("http://")) {
                            curTSL.setUrl(curTSL.getUrl().replace("http://", "https://"));
                            iRet = this.doUpdateNationalTSL(curTSL, certDB, tempTSLFile);
                        }
                        if (iRet == 0 && !nationId.equals("EU")) {
                            this.archiveTSL(nationId, tempTSLFile);
                        }
                        break block72;
                        {
                            catch (Throwable var18_23) {
                                throw var18_23;
                            }
                        }
                        finally {
                            if (tempTSLFile != null) {
                                tempTSLFile.delete();
                            }
                        }
                    }
                    catch (Exception ex) {
                        try {
                            RootUpdater.logger.error(String.format("error processing TSL %s\n%s", new Object[]{tslList.get(iTSL), ex.getMessage()}));
                            this.updateProgress((double)(++this.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" * %s: FAIL update TSL (%d/%d)", new Object[]{TSLUtils.extendedNationId(nationId), iTSL + 1, nTSLTot}));
                            this.writeToReport(">>> GENERIC ERROR (see log) <<<");
                            ++nTSLError;
                        }
                        catch (Throwable var19_24) {
                            this.updateProgress((double)(++this.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(nationId), iTSL + 1, nTSLTot}));
                            switch (iRet) {
                                case 0: {
                                    ++nTSLOk;
                                    this.writeToReport("=== Updated");
                                    RootUpdater.logger.info("parsed");
                                    break;
                                }
                                case 1: {
                                    ++nTSLError;
                                    this.writeToReport(">>> Error");
                                    RootUpdater.logger.info("error");
                                    break;
                                }
                                case 2: {
                                    ++nTSLSkip;
                                    this.writeToReport("*** Skipped");
                                    RootUpdater.logger.info("skipped");
                                    break;
                                }
                                case 3: {
                                    ++nTSLError;
                                    this.writeToReport("??? Error");
                                    RootUpdater.logger.info("unknown error");
                                    break;
                                }
                                case 4: {
                                    ++nTSLIgnored;
                                    this.writeToReport("!!! Ignored");
                                    RootUpdater.logger.info("ignored");
                                    break;
                                }
                                case 5: {
                                    ++nTSLIgnored;
                                    this.writeToReport("### From archive");
                                    RootUpdater.logger.info("from archive");
                                    break;
                                }
                            }
                            throw var19_24;
                        }
                        this.updateProgress((double)(++this.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(nationId), iTSL + 1, nTSLTot}));
                        switch (iRet) {
                            case 0: {
                                ++nTSLOk;
                                this.writeToReport("=== Updated");
                                RootUpdater.logger.info("parsed");
                                break;
                            }
                            case 1: {
                                ++nTSLError;
                                this.writeToReport(">>> Error");
                                RootUpdater.logger.info("error");
                                break;
                            }
                            case 2: {
                                ++nTSLSkip;
                                this.writeToReport("*** Skipped");
                                RootUpdater.logger.info("skipped");
                                break;
                            }
                            case 3: {
                                ++nTSLError;
                                this.writeToReport("??? Error");
                                RootUpdater.logger.info("unknown error");
                                break;
                            }
                            case 4: {
                                ++nTSLIgnored;
                                this.writeToReport("!!! Ignored");
                                RootUpdater.logger.info("ignored");
                                break;
                            }
                            case 5: {
                                ++nTSLIgnored;
                                this.writeToReport("### From archive");
                                RootUpdater.logger.info("from archive");
                                break;
                            }
                        }
                        continue;
                    }
                }
                this.updateProgress((double)(++this.iProgressStep) / (double)this.totProgressSteps, "updating national EU TSL...", String.format(" - %s: TSL updated (%d/%d)", new Object[]{TSLUtils.extendedNationId(nationId), iTSL + 1, nTSLTot}));
                switch (iRet) {
                    case 0: {
                        ++nTSLOk;
                        this.writeToReport("=== Updated");
                        RootUpdater.logger.info("parsed");
                        break;
                    }
                    case 1: {
                        ++nTSLError;
                        this.writeToReport(">>> Error");
                        RootUpdater.logger.info("error");
                        break;
                    }
                    case 2: {
                        ++nTSLSkip;
                        this.writeToReport("*** Skipped");
                        RootUpdater.logger.info("skipped");
                        break;
                    }
                    case 3: {
                        ++nTSLError;
                        this.writeToReport("??? Error");
                        RootUpdater.logger.info("unknown error");
                        break;
                    }
                    case 4: {
                        ++nTSLIgnored;
                        this.writeToReport("!!! Ignored");
                        RootUpdater.logger.info("ignored");
                        break;
                    }
                    case 5: {
                        ++nTSLIgnored;
                        this.writeToReport("### From archive");
                        RootUpdater.logger.info("from archive");
                        break;
                    }
                }
                continue;
            }
        }
        catch (CapiException ex) {
            RootUpdater.logger.error(String.format("error processing EU TSL %s", new Object[]{ex.getMessage()}));
            this.writeToReport("!!! GENERAL ERROR (see log) !!!");
            var9_12 = false;
            return var9_12;
        }
        finally {
            Util.closeQuietly(endPointsBW);
        }
        RootUpdater.logger.debug(String.format("%d/%d TSL processed", new Object[]{nTSLOk, nTSLTot}));
        RootUpdater.logger.debug(String.format("%d/%d TSL NOT processed", new Object[]{nTSLError, nTSLTot}));
        RootUpdater.logger.debug(String.format("%d/%d TSL skipped", new Object[]{nTSLSkip, nTSLTot}));
        this.writeToReport(String.format("\n- - - - -\n>> %d TSL processed\n>> %d TSL NOT processed\n>> %d TSL skipped or ignored", new Object[]{nTSLOk, nTSLError, nTSLSkip + nTSLIgnored}));
        return true;
    }

    private void archiveTSL(String nationID, java.io.File tslFile) throws FileNotFoundException, NoSuchAlgorithmException, IOException {
        if (this.TSLHistoryFolder == null) {
            return;
        }
        java.io.File histFolder = new java.io.File(this.TSLHistoryFolder);
        histFolder.mkdirs();
        boolean doArchive = false;
        java.io.File lastTSL = this.getLastArchivedTSL(nationID);
        if (lastTSL == null || lastTSL != null && !FileUtils.areIdenticalFile(tslFile, lastTSL)) {
            doArchive = true;
        }
        if (!doArchive) {
            return;
        }
        java.io.File nextTSL = this.getNextArchivedTSL(nationID);
        Files.copy(tslFile.toPath(), nextTSL.toPath(), StandardCopyOption.REPLACE_EXISTING);
        logger.info("TSL " + nationID + " was archived to " + nextTSL.getAbsolutePath());
    }

    private java.io.File getLastArchivedTSL(String nationID) {
        if (this.TSLHistoryFolder == null) {
            return null;
        }
        int lastIndex = 1;
        java.io.File prevFile = null;
        java.io.File lastFile = new java.io.File(this.TSLHistoryFolder + java.io.File.separator + String.format("%s-%05d.xml", nationID, lastIndex));
        while (lastFile.exists()) {
            prevFile = lastFile;
            lastFile = new java.io.File(this.TSLHistoryFolder + java.io.File.separator + String.format("%s-%05d.xml", nationID, ++lastIndex));
        }
        return prevFile;
    }

    private java.io.File getNextArchivedTSL(String nationID) {
        if (this.TSLHistoryFolder == null) {
            return null;
        }
        int lastIndex = 1;
        java.io.File lastFile = new java.io.File(this.TSLHistoryFolder + java.io.File.separator + String.format("%s-%05d.xml", nationID, lastIndex++));
        while (lastFile.exists()) {
            lastFile = new java.io.File(this.TSLHistoryFolder + java.io.File.separator + String.format("%s-%05d.xml", nationID, lastIndex++));
        }
        return lastFile;
    }

    public static void main(String[] args) {
        block25: {
            if (args.length == 0) {
                System.exit(0);
            }
            String rootUpdaterAppPath = null;
            String rootUpdaterModelPath = null;
            String cdbConfig = null;
            String mode = null;
            boolean createFolder = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-guiApp")) {
                    rootUpdaterAppPath = args[++i];
                    System.out.println("-guiApp " + rootUpdaterAppPath);
                    continue;
                }
                if (args[i].startsWith("-updaterModel")) {
                    rootUpdaterModelPath = args[++i];
                    System.out.println("-updaterModel " + rootUpdaterModelPath);
                    continue;
                }
                if (args[i].startsWith("-cdbConfig")) {
                    cdbConfig = args[++i];
                    System.out.println("-cdbConfig " + cdbConfig);
                    continue;
                }
                if (args[i].startsWith("-mode")) {
                    mode = args[++i];
                    System.out.println("-mode " + mode);
                    continue;
                }
                if (args[i].startsWith("-createFolder")) {
                    createFolder = true;
                    System.out.println("-createFolder");
                    continue;
                }
                System.out.println("Argument not recognized: " + args[i]);
            }
            final String finalMode = mode;
            if (!Util.isNullOrEmpty(cdbConfig)) {
                java.io.File configurationFolder = new java.io.File(new java.io.File(cdbConfig).getParent());
                if (mode != null && mode.equals("AK")) {
                    System.setProperty("user.name", "ArubaKey_user");
                    if (!configurationFolder.exists() && createFolder) {
                        try {
                            java.io.File tslFolder = new java.io.File(configurationFolder + java.io.File.separator + "TSL");
                            java.io.File logFolder = new java.io.File(configurationFolder + java.io.File.separator + "log");
                            java.io.File configFile = new java.io.File(cdbConfig);
                            Files.createDirectory(configurationFolder.toPath(), new FileAttribute[0]);
                            if (!tslFolder.exists()) {
                                Files.createDirectory(tslFolder.toPath(), new FileAttribute[0]);
                            }
                            if (!logFolder.exists()) {
                                Files.createDirectory(logFolder.toPath(), new FileAttribute[0]);
                            }
                            if (!configFile.exists()) {
                                RootUpdater.createDefaultAKConfig(configFile);
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (configurationFolder.exists()) {
                    try {
                        ConfigFile configFile = new ConfigFile(cdbConfig);
                        configFile.loadConfigFile();
                        LoggerConfig loggerConfig = new LoggerConfig();
                        String fileAppender = configFile.getElement("fileAppender", null);
                        loggerConfig.setFileAppender(fileAppender != null ? configurationFolder.toPath().resolve(fileAppender.replace("\\", "/")).toFile() : null);
                        System.out.println("logAppender: " + loggerConfig.getFileAppender().getAbsolutePath());
                        loggerConfig.setConsoleAppender(configFile.getBinElement("consoleAppender", false));
                        logger = EllipsLoggerFactory.createLogger((String)"RootUpdater", (String)"%d [%t] [%p] %C{1}.%M(%F:%L) - %m%n", (LoggerLevel)LoggerLevel.valueOf((String)configFile.getElement("level", "INFO")), (LoggerConfig)loggerConfig);
                        EllipsLoggerFactory.setMasterLogger((String)"RootUpdater");
                        logger.info("\n-------------------------\nRootUpdater - start logger\n-------------------------");
                        for (String arg : args) {
                            logger.info(arg);
                        }
                        ValidatorConfig validatorConfig = RootUpdater.setupValidatorConfig(new ValidatorConfig(configFile), configurationFolder);
                        validatorConfig.setNetConfiguration(RootUpdater.createNetworkConfig(configFile));
                        java.io.File cdbLock = new java.io.File(validatorConfig.getElement("homeFolder", "") + java.io.File.separator + "rootUpdater.lck");
                        if (!LockApplication.lockInstance(cdbLock.getAbsolutePath())) {
                            logger.info("RootUpdater already opened");
                            break block25;
                        }
                        logger.info("Start RootUpdater");
                        final RootUpdater rootUpdater = RootUpdater.createRootUpdater(validatorConfig);
                        if (!Util.isNullOrEmpty(rootUpdaterAppPath) && !Util.isNullOrEmpty(rootUpdaterModelPath)) {
                            try {
                                logger.info("Found GUI class path, try to instantiate");
                                ClassLoader loader = RootUpdater.class.getClassLoader();
                                Class<?> rootUpdaterModel = loader.loadClass(rootUpdaterModelPath);
                                Constructor<?> rootUpdaterModelConstructor = rootUpdaterModel.getConstructors()[0];
                                final RootUpdaterGUI rootUpdaterModelObject = (RootUpdaterGUI)rootUpdaterModelConstructor.newInstance(new Object[0]);
                                rootUpdater.setGUI(rootUpdaterModelObject);
                                Class<?> rootUpdaterApp = loader.loadClass(rootUpdaterAppPath);
                                Constructor<?> rootUpdaterAppConstructor = rootUpdaterApp.getConstructors()[0];
                                rootUpdaterAppConstructor.newInstance(rootUpdaterModelObject, new Runnable(){

                                    @Override
                                    public void run() {
                                        if (rootUpdater.isUpdateNeeded()) {
                                            try {
                                                Thread t = new Thread(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        rootUpdater.doUpdate();
                                                    }
                                                });
                                                t.start();
                                                t.join();
                                                Thread.sleep(5000L);
                                            }
                                            catch (InterruptedException ex) {
                                                logger.error(ex.getMessage(), (Throwable)ex);
                                            }
                                        } else if (finalMode != null && finalMode.equals("AK")) {
                                            rootUpdaterModelObject.showGUI();
                                            rootUpdaterModelObject.closeGUI();
                                            try {
                                                Thread.sleep(5000L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                        }
                                        System.exit(0);
                                    }
                                });
                            }
                            catch (Throwable e) {
                                logger.error(e.getMessage(), e);
                            }
                        }
                        if (rootUpdater.isUpdateNeeded()) {
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    rootUpdater.doUpdate();
                                }
                            });
                            t.start();
                            t.join();
                            Thread.sleep(5000L);
                        }
                    }
                    catch (Exception ex) {
                        if (logger != null) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                        ex.printStackTrace();
                    }
                }
            }
        }
        System.exit(0);
    }

    private static NetworkConfig createNetworkConfig(ConfigFile configFile) {
        String decrypt_value;
        NetworkConfig networkConfig = new NetworkConfig();
        networkConfig.setProxyType(configFile.getElement("proxyType", ""));
        networkConfig.setProxy(configFile.getElement("proxyHost", ""));
        networkConfig.setProxyPort(configFile.getElement("proxyPort", ""));
        networkConfig.setUserProxy(configFile.getElement("proxyUser", ""));
        String proxyPassword = configFile.getElement("proxyPassword", "");
        if (proxyPassword != null && !proxyPassword.equals("")) {
            decrypt_value = SecretStore.DecryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)proxyPassword);
            if (Util.isNullOrEmpty(decrypt_value)) {
                decrypt_value = SecretStore.DecryptByPassword((String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)ConfigParameter.USER_NAME, (String)proxyPassword);
            }
            proxyPassword = !Util.isNullOrEmpty(decrypt_value) ? decrypt_value : "";
        }
        networkConfig.setPasswordProxy(proxyPassword);
        networkConfig.setLdapProxyType(configFile.getElement("ldapProxyType", ""));
        networkConfig.setLdapProxy(configFile.getElement("ldapProxyHost", ""));
        networkConfig.setLdapProxyPort(configFile.getElement("ldapProxyPort", ""));
        networkConfig.setLdapUserProxy(configFile.getElement("ldapProxyUser", ""));
        proxyPassword = configFile.getElement("ldapProxyPassword", "");
        if (proxyPassword != null && !proxyPassword.equals("")) {
            decrypt_value = SecretStore.DecryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)proxyPassword);
            if (Util.isNullOrEmpty(decrypt_value)) {
                decrypt_value = SecretStore.DecryptByPassword((String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)ConfigParameter.USER_NAME, (String)proxyPassword);
            }
            proxyPassword = !Util.isNullOrEmpty(decrypt_value) ? decrypt_value : "";
        }
        networkConfig.setLdapPasswordProxy(proxyPassword);
        networkConfig.setConnectionTimeOut(configFile.getElement("connectionTimeOut", ""));
        return networkConfig;
    }

    private static RootUpdater createRootUpdater(ValidatorConfig validatorConfig) throws CapiException {
        String ignoreTSL;
        RootUpdater rootUpdater = new RootUpdater(validatorConfig.getElement("homeFolder", ""), validatorConfig, logger);
        rootUpdater.setForcedUpdate(validatorConfig.getBinElement("forceUpdate", false));
        rootUpdater.setPrintTSLEndPoints(validatorConfig.getBinElement("printTSLEndpoints", false));
        rootUpdater.setReportFileName(validatorConfig.getElement("reportFileName", "LastUpdateReport.txt"));
        rootUpdater.setMergeDiffFileName(validatorConfig.getElement("mergeFileName", ""));
        rootUpdater.setUpdateMode(UpdateMode.valueOf(validatorConfig.getElement("updateMode", UpdateMode.ATSL_SIGNED.name())));
        rootUpdater.useCustomTSLDSIta(validatorConfig.getElement("customTSLItaUrl", ""), validatorConfig.getElement("customTSLItaCert", ""));
        rootUpdater.setForceHTTPSConnections(validatorConfig.getBinElement("forceHttpsConnection", false));
        if (validatorConfig.getBinElement("fileProgressEnabled", false)) {
            rootUpdater.enableFileProgress();
        }
        if (!(ignoreTSL = validatorConfig.getElement("ignorelist", "")).isEmpty()) {
            String[] tsl = ignoreTSL.split(";");
            rootUpdater.setIgnoreTSLList(new ArrayList<String>(Arrays.asList(tsl)));
        }
        return rootUpdater;
    }

    private static ValidatorConfig setupValidatorConfig(ValidatorConfig validatorConfig, java.io.File configFile) {
        if (!validatorConfig.getElement("homeFolder", "").equals("")) {
            validatorConfig.setElement("homeFolder", configFile.toPath().resolve(validatorConfig.getElement("homeFolder", "")).toString().replace("\\", "/"));
        }
        if (!validatorConfig.getElement("certdb.file", "").equals("")) {
            validatorConfig.setElement("certdb.file", configFile.toPath().resolve(validatorConfig.getElement("certdb.file", "")).toString().replace("\\", "/"));
        }
        if (!validatorConfig.getElement("certdb.pwd", "").equals("")) {
            String pwd = SecretStore.DecryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)validatorConfig.getElement("certdb.pwd", ""));
            if (Util.isNullOrEmpty(pwd)) {
                pwd = SecretStore.DecryptByPassword((String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)ConfigParameter.USER_NAME, (String)validatorConfig.getElement("certdb.pwd", ""));
            }
            validatorConfig.setElement("certdb.pwd", pwd);
        }
        return validatorConfig;
    }

    private static void createDefaultAKConfig(java.io.File configFile) {
        ConfigFile cf = new ConfigFile(configFile.getAbsolutePath());
        cf.setElement("homeFolder", "TSL");
        cf.setElement("certdb.file", "TSL" + java.io.File.separator + "cert.cdb");
        cf.setElement("certdb.pwd", SecretStore.CryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)"1234567890AAbbCCdd"));
        cf.setElement("reportFileName", "LastUpdateReport.txt");
        cf.setElement("proxyType", "direct");
        cf.setElement("ldapProxyType", "direct");
        cf.setElement("connectionTimeOut", "20000");
        cf.setElement("forceHttpsConnection", "false");
        cf.setElement("maxDaysFromLastUpdateEU", "30");
        cf.setElement("forcedUpdate", "false");
        cf.setElement("fileProgressEnabled", "false");
        cf.setElement("printTSLEndpoints", "false");
        cf.setElement("updateMode", "ATSL");
        cf.setElement("fileAppender", "log" + java.io.File.separator + "rootUpdater.log");
        cf.setElement("level", "INFO");
        cf.setElement("consoleAppender", "false");
        cf.saveConfigFile();
    }

    public String getDebugTSL() {
        return this.debugTSL;
    }

    public void setDebugTSL(String debugTSL) {
        this.debugTSL = debugTSL;
    }
}

