/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import esecurity.statistics.util.StatisticKeyEnum;
import esecurity.statistics.util.StatisticsInfoUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.ellips.capi.tsa.TSAResponseValidator;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.ConfigParameter;
import it.arubapec.ca.utils.Hex;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.slf4j.Logger;

public class TSAUtil {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static String currentUrl = null;
    private static String alternativeUrl = null;
    private static long lastFailover = 0L;
    private static Gson gson = new Gson();

    public static void clearStatus() {
        currentUrl = null;
        alternativeUrl = null;
        lastFailover = 0L;
    }

    public static String getCurrentUrl() {
        return currentUrl;
    }

    public static String getAlternativeUrl() {
        return alternativeUrl;
    }

    @Deprecated
    public static TimeStampResponse getMarkFromRequest(TimeStampRequest objReq, ConfigParameter objConf) throws IOException, TSAException {
        return TSAUtil.getMarkFromRequest(objReq, objConf.getRequestTsaUrl(), objConf.getTSAData(), objConf.getNetConf());
    }

    public static TimeStampResponse getMarkFromRequest(TimeStampRequest objReq, TSAData tsaData, NetworkConfig netConf) throws TSAException, IOException {
        return TSAUtil.getMarkFromRequest(objReq, tsaData.getTSAUrl(), tsaData, netConf);
    }

    public static TimeStampResponse getMarkFromRequest(TimeStampRequest objReq, String requestTSAUrl, TSAData tsaData, NetworkConfig netConf) throws TSAException, IOException {
        return TSAUtil.getMarkFromRequest(objReq, requestTSAUrl, tsaData, netConf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeStampResponse getMarkFromRequest(TimeStampRequest objReq, String requestTSAUrl, TSAData tsaData, NetworkConfig netConf, TSAResponseValidator responseValidator) throws TSAException, IOException {
        StatisticsInfoUtils.start(StatisticKeyEnum.MARK_TIME);
        try {
            URLCredentials creds;
            TimeStampResponse objReturn = null;
            UrlClient client = new UrlClient(netConf, logger);
            RequestData reqData = new RequestData();
            reqData.setType("TSA");
            reqData.setPostdata(objReq.getEncoded());
            Date startd = new Date();
            if (logger.isDebugEnabled()) {
                logger.debug("Richiesta TSA id: " + startd.getTime());
            }
            long request_time = new Date().getTime();
            boolean primario = true;
            UrlReturn response = null;
            if (Util.isNullOrEmpty(requestTSAUrl)) {
                if (currentUrl == null) {
                    currentUrl = tsaData.getTSAUrl();
                    if (!Util.isNullOrEmpty(tsaData.getTSAAlternativeUrl())) {
                        alternativeUrl = tsaData.getTSAAlternativeUrl();
                    }
                } else if (!currentUrl.equals(tsaData.getTSAUrl())) {
                    primario = false;
                    if (!Util.isNullOrEmpty(tsaData.getTSAAlternativeUrl()) && request_time - lastFailover > 900000L) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Riprovo sul primario");
                        }
                        currentUrl = tsaData.getTSAUrl();
                        lastFailover = 0L;
                        alternativeUrl = tsaData.getTSAAlternativeUrl();
                    }
                }
                creds = TSAUtil.getCredentialsFromUrl(currentUrl, tsaData);
                response = client.downloadUrl(currentUrl, reqData, creds);
            } else {
                creds = new URLCredentials(tsaData.getTSAUser(), tsaData.getTSAPassword(), null, null);
                response = client.downloadUrl(requestTSAUrl, reqData, creds);
            }
            TSAMessageEnum msg = responseValidator != null ? responseValidator.validateTSAResponse(response) : TSAUtil.getMessageFromResponse(response);
            if (msg != null && (msg == TSAMessageEnum.INTERNAL_ERROR || msg == TSAMessageEnum.SERVICE_UNAVAILABLE || msg == TSAMessageEnum.RESOURCE_NOT_FOUND) && !Util.isNullOrEmpty(alternativeUrl) && Util.isNullOrEmpty(requestTSAUrl)) {
                URLCredentials creds2;
                if (logger.isDebugEnabled()) {
                    logger.debug("URL TSA Primario non ha risposto tento sul secondario.");
                }
                if ((response = client.downloadUrl(alternativeUrl, reqData, creds2 = TSAUtil.getCredentialsFromUrl(alternativeUrl, tsaData))) != null && response.getStatus().equals("OK")) {
                    lastFailover = request_time;
                    String scambio = currentUrl;
                    currentUrl = alternativeUrl;
                    alternativeUrl = scambio;
                }
                msg = responseValidator != null ? responseValidator.validateTSAResponse(response) : TSAUtil.getMessageFromResponse(response);
            } else if (primario) {
                lastFailover = 0L;
            }
            if (msg != null) {
                throw new TSAException(msg);
            }
            try {
                objReturn = new TimeStampResponse(response.getData());
                if (objReturn.getFailInfo() != null) {
                    throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
                }
            }
            catch (TSPException ex) {
                throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, (Exception)((Object)ex));
            }
            Date endd = new Date();
            if (logger.isDebugEnabled()) {
                logger.debug("Richiesta TSA id :" + startd.getTime() + " Terminiata in " + (endd.getTime() - startd.getTime()) + " millisecondi");
            }
            TimeStampResponse timeStampResponse = objReturn;
            return timeStampResponse;
        }
        finally {
            StatisticsInfoUtils.end(StatisticKeyEnum.MARK_TIME);
        }
    }

    public static TimeStampRequest generateMarkRequest(String algorithm, BigInteger nonce, byte[] hash, String policy, boolean certReq) throws TSAException {
        TimeStampRequestGenerator objRequestGen = new TimeStampRequestGenerator();
        if (policy != null && !policy.trim().equals("")) {
            try {
                objRequestGen.setReqPolicy(policy);
            }
            catch (Exception ex) {
                throw new TSAException(TSAMessageEnum.BAD_TSQ);
            }
        }
        objRequestGen.setCertReq(certReq);
        return objRequestGen.generate(TSPAlgorithms.SHA256, hash);
    }

    @Deprecated
    public static TimeStampRequest generateMarkRequest(String algorithm, BigInteger nonce, InputStream in, String policy, boolean certReq) throws IOException, TSAException {
        return TSAUtil.generateMarkRequest(in, policy, certReq);
    }

    public static TimeStampRequest generateMarkRequest(InputStream in, String policy, boolean certReq) throws IOException, TSAException {
        SHA256Digest objDigest = new SHA256Digest();
        objDigest.reset();
        byte[] bytes = new byte[objDigest.getDigestSize()];
        byte[] buffer = new byte[4096];
        int letti = in.read(buffer);
        while (letti != -1) {
            objDigest.update(buffer, 0, letti);
            letti = in.read(buffer);
        }
        objDigest.doFinal(bytes, 0);
        if (logger.isDebugEnabled()) {
            logger.debug("Hash da marcare: " + Hex.getHex(bytes));
        }
        TimeStampRequest objReq = TSAUtil.generateMarkRequest("SHA-256", null, bytes, policy, certReq);
        return objReq;
    }

    @Deprecated
    public static void getMark(String in, String out, ConfigParameter objConf) throws IOException, TSPException, TSAException {
        FileInputStream objIn = new FileInputStream(in);
        if (logger.isDebugEnabled()) {
            logger.debug("File in :" + in);
            logger.debug("File out :" + out);
        }
        TimeStampResponse objResponse = TSAUtil.getMark("SHA-256", null, (InputStream)objIn, objConf.getTSAPolicy(), objConf, true);
        objIn.close();
        FileOutputStream objOut = new FileOutputStream(out);
        objOut.write(objResponse.getEncoded());
        objOut.close();
    }

    @Deprecated
    public static void getMark(InputStream in, OutputStream out, String tsaUrl, String tsaUsername, String tsaPassword, String tsaPolicy) throws IOException, TSPException, TSAException {
        ConfigParameter objConf = new ConfigParameter(1);
        objConf.setTSAUrl(tsaUrl);
        objConf.setTSAUser(tsaUsername);
        objConf.setTSAPassword(tsaPassword);
        objConf.setTSAPolicy(tsaPolicy);
        TimeStampResponse objResponse = TSAUtil.getMark("SHA-256", null, in, tsaPolicy, objConf, true);
        out.write(objResponse.getEncoded());
    }

    @Deprecated
    public static TimeStampResponse getMark(String algorithm, BigInteger nonce, InputStream in, String policy, ConfigParameter objConf, boolean certReq) throws IOException, TSPException, TSAException {
        TimeStampResponse objReturn = null;
        SHA256Digest objDigest = new SHA256Digest();
        objDigest.reset();
        byte[] bytes = new byte[objDigest.getDigestSize()];
        byte[] buffer = new byte[4096];
        int letti = in.read(buffer);
        while (letti != -1) {
            objDigest.update(buffer, 0, letti);
            letti = in.read(buffer);
        }
        objDigest.doFinal(bytes, 0);
        if (logger.isDebugEnabled()) {
            logger.debug("Hash da marcare :" + Hex.getHex(bytes));
        }
        TimeStampRequest objReq = TSAUtil.generateMarkRequest(algorithm, nonce, bytes, policy, certReq);
        objReturn = TSAUtil.getMarkFromRequest(objReq, objConf);
        return objReturn;
    }

    @Deprecated
    public static TimeStampResponse getMark(String algorithm, BigInteger nonce, InputStream in, boolean certReq, TSAData tsaData, NetworkConfig netConf) throws IOException, TSPException, TSAException {
        TimeStampRequest objReq = TSAUtil.generateMarkRequest(algorithm, nonce, in, tsaData.getTSAPolicy(), certReq);
        return TSAUtil.getMarkFromRequest(objReq, tsaData, netConf);
    }

    public static TimeStampResponse getMark(InputStream in, boolean certReq, TSAData tsaData, NetworkConfig netConf) throws IOException, TSPException, TSAException {
        return TSAUtil.getMark(in, certReq, tsaData, netConf, null);
    }

    public static TimeStampResponse getMark(InputStream in, boolean certReq, TSAData tsaData, NetworkConfig netConf, TSAResponseValidator responseValidator) throws IOException, TSPException, TSAException {
        TimeStampRequest objReq = TSAUtil.generateMarkRequest(in, tsaData.getTSAPolicy(), certReq);
        return TSAUtil.getMarkFromRequest(objReq, tsaData.getTSAUrl(), tsaData, netConf, responseValidator);
    }

    private static TSAMessageEnum getMessageFromResponse(UrlReturn response) {
        TSAMessageEnum objReturn = null;
        if (response == null || response.getStatus() == null || !response.getStatus().equals("OK") || response.getData() == null) {
            objReturn = TSAMessageEnum.INTERNAL_ERROR;
            if (response != null && response.getStatus() != null && !response.getStatus().equals("OK")) {
                if (response.getStatus_code() == -1 && response.getStatus().equals("KO")) {
                    return TSAMessageEnum.NETWORK_ERROR;
                }
                int tsaCode = TSAUtil.retrieveTsaCode(response);
                if (tsaCode != 0) {
                    for (TSAMessageEnum msg : TSAMessageEnum.values()) {
                        if (msg.getStatusCode() != response.getStatus_code() || !msg.getErrCode().equals("" + tsaCode)) continue;
                        return msg;
                    }
                }
            }
        }
        return objReturn;
    }

    private static int retrieveTsaCode(UrlReturn response) {
        int intRet = 0;
        try {
            JsonElement element = (JsonElement)gson.fromJson(new String(response.getErrordata()), JsonElement.class);
            if (element.isJsonObject()) {
                intRet = element.getAsJsonObject().get("code").getAsInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return intRet;
    }

    public static TSAData getTSAData(ConfigParameter conf) {
        if (conf == null) {
            return null;
        }
        TSAData tsaData = new TSAData();
        tsaData.setTSAUrl(conf.getTSAUrl());
        tsaData.setTSAUser(conf.getTSAUser());
        tsaData.setTSAPassword(conf.getTSAPassword());
        tsaData.setTSAAlternativeUrl(conf.getTSAAlternativeUrl());
        tsaData.setTSAAlternativeUser(conf.getTSAAlternativeUser());
        tsaData.setTSAAlternativePassword(conf.getTSAAlternativePassword());
        tsaData.setTSAPolicy(conf.getTSAPolicy());
        return tsaData;
    }

    private static URLCredentials getCredentialsFromUrl(String url, TSAData tsaData) {
        String username = tsaData.getTSAUser();
        String password = tsaData.getTSAPassword();
        if (url != null && tsaData.getTSAAlternativeUrl() != null && url.equalsIgnoreCase(tsaData.getTSAAlternativeUrl())) {
            username = tsaData.getTSAAlternativeUser();
            password = tsaData.getTSAAlternativePassword();
        }
        return new URLCredentials(username, password, null, null);
    }
}

