/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.signature;

import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public enum DigestAlgorithm {
    MD5("MD5", CMSSignedDataGenerator.DIGEST_MD5, "http://www.w3.org/2001/04/xmlenc#md5", AlgorithmPolicy.NOT_RECOMMENDED),
    SHA1("SHA1", CMSSignedDataGenerator.DIGEST_SHA1, "http://www.w3.org/2000/09/xmldsig#sha1", AlgorithmPolicy.NOT_RECOMMENDED),
    SHA224("SHA-224", CMSSignedDataGenerator.DIGEST_SHA224, "https://www.w3.org/2001/04/xmldsig-more#sha224", AlgorithmPolicy.NOT_RECOMMENDED),
    SHA256("SHA-256", CMSSignedDataGenerator.DIGEST_SHA256, "http://www.w3.org/2001/04/xmlenc#sha256", AlgorithmPolicy.RECOMMENDED),
    SHA384("SHA-384", CMSSignedDataGenerator.DIGEST_SHA384, "http://www.w3.org/2000/09/xmldsig#sh384", AlgorithmPolicy.RECOMMENDED),
    SHA512("SHA-512", CMSSignedDataGenerator.DIGEST_SHA512, "http://www.w3.org/2001/04/xmlenc#sha512", AlgorithmPolicy.RECOMMENDED),
    SHA3_224("SHA3-224", NISTObjectIdentifiers.id_sha3_224.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-224", AlgorithmPolicy.NOT_RECOMMENDED),
    SHA3_256("SHA3-256", NISTObjectIdentifiers.id_sha3_256.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-256", AlgorithmPolicy.RECOMMENDED),
    SHA3_384("SHA3-384", NISTObjectIdentifiers.id_sha3_384.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-384", AlgorithmPolicy.RECOMMENDED),
    SHA3_512("SHA3-512", NISTObjectIdentifiers.id_sha3_512.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-512", AlgorithmPolicy.RECOMMENDED),
    RIPEMD128("RIPEMD-128", CMSSignedDataGenerator.DIGEST_RIPEMD128, null, AlgorithmPolicy.NOT_RECOMMENDED),
    RIPEMD160("RIPEMD-160", CMSSignedDataGenerator.DIGEST_RIPEMD160, "http://www.w3.org/2001/04/xmlenc#ripemd160", AlgorithmPolicy.NOT_RECOMMENDED),
    RIPEMD256("RIPEMD-256", CMSSignedDataGenerator.DIGEST_RIPEMD256, null, AlgorithmPolicy.NOT_RECOMMENDED),
    GOST3411("GOST3411", CMSSignedDataGenerator.DIGEST_GOST3411, null, AlgorithmPolicy.NOT_RECOMMENDED);

    private String javaName = null;
    private String id = null;
    private String xades_id = null;
    private AlgorithmPolicy policy = null;

    private DigestAlgorithm(String javaName, String id, String xades_id, AlgorithmPolicy policy) {
        this.javaName = javaName;
        this.id = id;
        this.xades_id = xades_id;
        this.policy = policy;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.javaName;
    }

    public String getXadesID() {
        return this.xades_id;
    }

    public boolean isRecommended() {
        return this.policy != null && this.policy.equals((Object)AlgorithmPolicy.RECOMMENDED);
    }

    public boolean isForbidden() {
        return this.policy != null && this.policy.equals((Object)AlgorithmPolicy.FORBIDDEN);
    }

    public static DigestAlgorithm valueFromJavaName(String javaName) {
        switch (javaName) {
            case "MD5": {
                return MD5;
            }
            case "SHA1": {
                return SHA1;
            }
            case "SHA224": 
            case "SHA-224": {
                return SHA224;
            }
            case "SHA256": 
            case "SHA-256": {
                return SHA256;
            }
            case "SHA384": 
            case "SHA-384": {
                return SHA384;
            }
            case "SHA512": 
            case "SHA-512": {
                return SHA512;
            }
            case "SHA3-224": {
                return SHA3_224;
            }
            case "SHA3-256": {
                return SHA3_256;
            }
            case "SHA3-384": {
                return SHA3_384;
            }
            case "SHA3-512": {
                return SHA3_512;
            }
            case "RIPEMD-128": {
                return RIPEMD128;
            }
            case "RIPEMD-160": {
                return RIPEMD160;
            }
            case "RIPEMD-256": {
                return RIPEMD256;
            }
            case "GOST3411": {
                return GOST3411;
            }
        }
        return null;
    }

    public static DigestAlgorithm valueFromXadesId(String xadesId) {
        if (xadesId.equals(DigestAlgorithm.MD5.xades_id)) {
            return MD5;
        }
        if (xadesId.equals(DigestAlgorithm.SHA1.xades_id)) {
            return SHA1;
        }
        if (xadesId.equals(DigestAlgorithm.SHA224.xades_id)) {
            return SHA224;
        }
        if (xadesId.equals(DigestAlgorithm.SHA256.xades_id)) {
            return SHA256;
        }
        if (xadesId.equals(DigestAlgorithm.SHA384.xades_id)) {
            return SHA384;
        }
        if (xadesId.equals(DigestAlgorithm.SHA512.xades_id)) {
            return SHA512;
        }
        if (xadesId.equals(DigestAlgorithm.RIPEMD160.xades_id)) {
            return RIPEMD160;
        }
        if (xadesId.equals(DigestAlgorithm.SHA3_224.xades_id)) {
            return SHA3_224;
        }
        if (xadesId.equals(DigestAlgorithm.SHA3_256.xades_id)) {
            return SHA3_256;
        }
        if (xadesId.equals(DigestAlgorithm.SHA3_384.xades_id)) {
            return SHA3_384;
        }
        if (xadesId.equals(DigestAlgorithm.SHA3_512.xades_id)) {
            return SHA3_512;
        }
        return null;
    }

    public static DigestAlgorithm valueFromCadesId(String cadesId) {
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_MD5)) {
            return MD5;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_SHA1)) {
            return SHA1;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_SHA224)) {
            return SHA224;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_SHA256)) {
            return SHA256;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_SHA384)) {
            return SHA384;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_SHA512)) {
            return SHA512;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_RIPEMD128)) {
            return RIPEMD128;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_RIPEMD160)) {
            return RIPEMD160;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_RIPEMD256)) {
            return RIPEMD256;
        }
        if (cadesId.equals(CMSSignedDataGenerator.DIGEST_GOST3411)) {
            return GOST3411;
        }
        if (cadesId.equals(NISTObjectIdentifiers.id_sha3_224.getId())) {
            return SHA3_224;
        }
        if (cadesId.equals(NISTObjectIdentifiers.id_sha3_256.getId())) {
            return SHA3_256;
        }
        if (cadesId.equals(NISTObjectIdentifiers.id_sha3_384.getId())) {
            return SHA3_384;
        }
        if (cadesId.equals(NISTObjectIdentifiers.id_sha3_512.getId())) {
            return SHA3_512;
        }
        return null;
    }

    private static enum AlgorithmPolicy {
        RECOMMENDED,
        NOT_RECOMMENDED,
        FORBIDDEN;

    }
}

