/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.enroll.constants.KeyAlgo;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.provider.AbstractSWKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

public class PureSWKey
extends AbstractSWKey {
    private PrivateKey pkey = null;
    private Cipher rsa = null;

    public PureSWKey() {
    }

    public PureSWKey(String alias, String pin, byte[] encoded) {
        super(alias, pin, encoded);
        this.pkey = this.decodePrivateKey();
    }

    public PureSWKey(String alias, KeyAlgo algo, String pin, int bits) {
        super(alias, pin, null);
        try {
            this.pkey = TokenSpi.genSoftKeyPair(algo, bits).getPrivate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PureSWKey(String alias, String pin, PrivateKey pkey) {
        super(alias, pin, null);
        this.pkey = pkey;
    }

    @Override
    public void init(String alg, int mode) {
        try {
            this.rsa = Cipher.getInstance(alg, ProvUtils.bcProvider);
            this.rsa.init(mode, this.getPrivateKeySpi());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] doFinal(byte[] bytes, int mode) {
        try {
            return this.rsa.doFinal(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PrivateKey decodePrivateKey() {
        try {
            PKCS8EncodedKeySpec keySpec = TokenSpi.fromPKCS8(this.encoded, this.pin);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey pk = kf.generatePrivate(keySpec);
            return pk;
        }
        catch (Exception e) {
            try {
                PKCS8EncodedKeySpec keySpec = TokenSpi.fromPKCS8(this.encoded, this.pin);
                KeyFactory kf = KeyFactory.getInstance("EC");
                PrivateKey pk = kf.generatePrivate(keySpec);
                return pk;
            }
            catch (Exception e2) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public PrivateKey getPrivateKeySpi() {
        if (this.pkey == null) {
            this.pkey = this.decodePrivateKey();
        }
        return this.pkey;
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.pkey == null) {
            this.pkey = this.decodePrivateKey();
        }
        BigInteger mod = ((RSAPrivateCrtKey)this.pkey).getModulus();
        BigInteger exp = ((RSAPrivateCrtKey)this.pkey).getPublicExponent();
        RSAPublicKeySpec rsaPubKeySpec = new RSAPublicKeySpec(mod, exp);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey pubKey = kf.generatePublic(rsaPubKeySpec);
            return pubKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoded == null && this.pkey != null) {
            try {
                this.encoded = TokenSpi.toPKCS8(this.pkey, this.pin);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.encoded;
    }

    @Override
    public byte[] getForcedEncoded(String newPin) {
        this.pin = newPin;
        if (this.pkey != null) {
            try {
                this.encoded = TokenSpi.toPKCS8(this.pkey, this.pin);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.encoded;
    }
}

