/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;

public class ActalisProvider
extends Provider {
    public static final String NAME = "Actalis";
    public static final String NAME_LONG = "Actalis Security Provider 1.0";

    public ActalisProvider() {
        super(NAME, 1.0, NAME_LONG);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ActalisProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.addKeyStoreAlgo();
        this.addRSAAlgo();
        this.addECAlgo();
    }

    private void addRSAAlgo() {
        this.put("Cipher.RSA", "it.actalis.ellips.capi.provider.Actalis_RSACipher");
        this.put("Signature.SHA/RSA", "it.actalis.ellips.capi.rsa.SHA1RSASignature");
        this.put("Signature.SHA1/RSA", "it.actalis.ellips.capi.rsa.SHA1RSASignature");
        this.put("Signature.SHA1withRSA", "it.actalis.ellips.capi.rsa.SHA1RSASignature");
        this.put("Signature.SHAwithRSA", "it.actalis.ellips.capi.rsa.SHA1RSASignature");
        this.put("Signature.SHA1WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA1RSASignature");
        this.put("Signature.1.3.14.3.2.26WITHRSA", "it.actalis.ellips.capi.rsa.SHA1RSASignature");
        this.put("Signature.2.16.840.1.101.3.4.2.1WITHRSA", "it.actalis.ellips.capi.rsa.SHA256RSASignature");
        this.put("1.2.840.113549.1.1.1with1.3.14.3.2.26", "it.actalis.ellips.capi.rsa.SHA1RSASignature");
        this.put("1.3.14.3.2.26WITHRSA", "it.actalis.ellips.capi.rsa.SHA1RSASignature");
        this.put("Signature.SHA224withRSA", "it.actalis.ellips.capi.rsa.SHA224RSASignature");
        this.put("Signature.SHA224WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA224RSASignature");
        this.put("Signature.SHA256withRSA", "it.actalis.ellips.capi.rsa.SHA256RSASignature");
        this.put("Signature.SHA256WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA256RSASignature");
        this.put("1.2.840.113549.1.1.1with2.16.840.1.101.3.4.2.1", "it.actalis.ellips.capi.rsa.SHA256RSASignature");
        this.put("2.16.840.1.101.3.4.2.1WITHRSA", "it.actalis.ellips.capi.rsa.SHA256RSASignature");
        this.put("Signature.SHA384withRSA", "it.actalis.ellips.capi.rsa.SHA384RSASignature");
        this.put("Signature.SHA384WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA384RSASignature");
        this.put("Signature.SHA512withRSA", "it.actalis.ellips.capi.rsa.SHA512RSASignature");
        this.put("Signature.SHA512WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA512RSASignature");
        this.put("Signature.SHA3-224withRSA", "it.actalis.ellips.capi.rsa.SHA3B224RSASignature");
        this.put("Signature.SHA3-224WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA3B224RSASignature");
        this.put("Signature.SHA3-256withRSA", "it.actalis.ellips.capi.rsa.SHA3B256RSASignature");
        this.put("Signature.SHA3-256WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA3B256RSASignature");
        this.put("Signature.SHA3-384withRSA", "it.actalis.ellips.capi.rsa.SHA3B384RSASignature");
        this.put("Signature.SHA3-384WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA3B384RSASignature");
        this.put("Signature.SHA3-512withRSA", "it.actalis.ellips.capi.rsa.SHA3B512RSASignature");
        this.put("Signature.SHA3-512WITHRSAENCRYPTION", "it.actalis.ellips.capi.rsa.SHA3B512RSASignature");
    }

    private void addKeyStoreAlgo() {
        this.put("KeyStore.ActalisKeyStore", "it.actalis.ellips.capi.provider.ActalisKeyStore");
    }

    private void addECAlgo() {
        this.put("Signature.ECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSA");
        this.put("Signature.NONEwithECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSAnone");
        this.put("Alg.Alias.Signature.SHA1withECDSA", "ECDSA");
        this.put("Alg.Alias.Signature.ECDSAwithSHA1", "ECDSA");
        this.put("Alg.Alias.Signature.SHA1WITHECDSA", "ECDSA");
        this.put("Alg.Alias.Signature.ECDSAWITHSHA1", "ECDSA");
        this.put("Alg.Alias.Signature.SHA1WithECDSA", "ECDSA");
        this.put("Alg.Alias.Signature.ECDSAWithSHA1", "ECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.1", "ECDSA");
        this.put("Alg.Alias.Signature." + TeleTrusTObjectIdentifiers.ecSignWithSha1, "ECDSA");
        this.put("Signature.NONEwithECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSAnone");
        this.put("Signature.ECDDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDetDSA");
        this.put("Signature.SHA224withECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSA224");
        this.put("Signature.SHA256withECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSA256");
        this.put("Signature.SHA384withECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSA384");
        this.put("Signature.SHA512withECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSA512");
        this.put("Signature.SHA3-224withECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSASha3_224");
        this.put("Signature.2.16.840.1.101.3.4.3.9", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSASha3_224");
        this.put("Signature.SHA3-256withECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSASha3_256");
        this.put("Signature.2.16.840.1.101.3.4.3.10", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSASha3_256");
        this.put("Signature.SHA3-384withECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSASha3_384");
        this.put("Signature.2.16.840.1.101.3.4.3.11", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSASha3_384");
        this.put("Signature.SHA3-512withECDSA", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSASha3_512");
        this.put("Signature.2.16.840.1.101.3.4.3.12", "it.actalis.ellips.capi.provider.ActalisECDSA$ecDSASha3_512");
    }
}

