/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.https;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class LocalSSLRootBuilder {
    public static KeyPair createKeyPair(int keyLength) throws CapiException {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(keyLength);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CapiException(e.getMessage(), 1003, e);
        }
    }

    public static KeyPair createKeyPair() throws CapiException {
        return LocalSSLRootBuilder.createKeyPair(2048);
    }

    public static X509Certificate generateRootSelfSignedCertificate(PrivateKey privateKey, PublicKey publicKey, Date membersNotBefore, Date membersNotAfter, String applicationName) throws CapiException {
        try {
            ContentSigner signer = new JcaContentSignerBuilder("SHA512withRSA").build(privateKey);
            X500Name name = LocalSSLRootBuilder.getX500SubjectForRoot(applicationName);
            SubjectPublicKeyInfo membersKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(name, new BigInteger(48, Util.secureRandom), membersNotBefore, membersNotAfter, name, membersKeyInfo);
            KeyUsage keyUsage = new KeyUsage(6);
            certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(1));
            X509CertificateHolder cert = certBuilder.build(signer);
            return LocalSSLRootBuilder.toX509Certificate(cert);
        }
        catch (Exception e) {
            throw new CapiException(e.getMessage(), 1003, e);
        }
    }

    public static X509Certificate generateCertificateForWebServer(PrivateKey rootPk, X509Certificate rootCert, PrivateKey privatekey, PublicKey publicKey, Date membersNotBefore, Date membersNotAfter, String applicationName) throws CapiException {
        try {
            ContentSigner signer = new JcaContentSignerBuilder("SHA512withRSA").build(rootPk);
            X500Name rootX500Name = new JcaX509CertificateHolder(rootCert).getSubject();
            X500Name subjectX500Name = LocalSSLRootBuilder.getX500SubjectForWebServer(applicationName);
            SubjectPublicKeyInfo membersKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(rootX500Name, new BigInteger(48, Util.secureRandom), membersNotBefore, membersNotAfter, subjectX500Name, membersKeyInfo);
            KeyUsage keyUsage = new KeyUsage(160);
            certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
            ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth});
            certBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)extendedKeyUsage);
            ArrayList<GeneralName> namesList = new ArrayList<GeneralName>();
            namesList.add(new GeneralName(2, "localhost"));
            namesList.add(new GeneralName(7, "127.0.0.1"));
            DERSequence derSeq = new DERSequence((ASN1Encodable[])namesList.toArray(new GeneralName[0]));
            certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)derSeq);
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            X509CertificateHolder cert = certBuilder.build(signer);
            return LocalSSLRootBuilder.toX509Certificate(cert);
        }
        catch (Exception e) {
            throw new CapiException(e.getMessage(), 1003, e);
        }
    }

    public static X509Certificate generateCertificateForUser(PrivateKey rootPk, X509Certificate rootCert, byte[] PKCS10Request, Date membersNotBefore, Date membersNotAfter, String applicationName) throws CapiException {
        try {
            PKCS10CertificationRequest req = new PKCS10CertificationRequest(PKCS10Request);
            return LocalSSLRootBuilder.generateCertificateForUser(rootPk, rootCert, req, membersNotBefore, membersNotAfter, applicationName);
        }
        catch (IOException ex) {
            throw new CapiException(ex.getMessage(), 1003, ex);
        }
    }

    public static X509Certificate generateCertificateForUser(PrivateKey rootPk, X509Certificate rootCert, PKCS10CertificationRequest req, Date membersNotBefore, Date membersNotAfter, String applicationName) throws CapiException {
        try {
            ContentSigner signer = new JcaContentSignerBuilder("SHA512withRSA").build(rootPk);
            X500Name rootX500Name = new JcaX509CertificateHolder(rootCert).getSubject();
            X500NameBuilder builder = new X500NameBuilder();
            builder.addRDN(BCStyle.CN, "localhost");
            builder.addRDN(BCStyle.O, applicationName);
            builder.addRDN(BCStyle.OU, "webserver");
            builder.addRDN(BCStyle.C, "IT");
            X500Name subjectX500Name = builder.build();
            SubjectPublicKeyInfo membersKeyInfo = req.getSubjectPublicKeyInfo();
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(rootX500Name, new BigInteger(48, Util.secureRandom), membersNotBefore, membersNotAfter, subjectX500Name, membersKeyInfo);
            KeyUsage keyUsage = new KeyUsage(160);
            certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
            ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth});
            certBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)extendedKeyUsage);
            ArrayList<GeneralName> namesList = new ArrayList<GeneralName>();
            namesList.add(new GeneralName(2, "localhost"));
            namesList.add(new GeneralName(7, "127.0.0.1"));
            DERSequence derSeq = new DERSequence((ASN1Encodable[])namesList.toArray(new GeneralName[0]));
            certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)derSeq);
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            X509CertificateHolder cert = certBuilder.build(signer);
            return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
        }
        catch (Exception e) {
            throw new CapiException(e.getMessage(), 1003, e);
        }
    }

    private static X509Certificate toX509Certificate(X509CertificateHolder holder) throws CertificateException, IOException {
        return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(holder.getEncoded()));
    }

    private static X500Name getX500SubjectForRoot(String applicationName) {
        X500NameBuilder builder = new X500NameBuilder();
        builder.addRDN(BCStyle.CN, "localhost");
        builder.addRDN(BCStyle.O, applicationName);
        builder.addRDN(BCStyle.C, "IT");
        return builder.build();
    }

    private static X500Name getX500SubjectForWebServer(String applicationName) {
        X500NameBuilder builder = new X500NameBuilder();
        builder.addRDN(BCStyle.CN, "localhost");
        builder.addRDN(BCStyle.O, applicationName);
        builder.addRDN(BCStyle.OU, "webserver");
        builder.addRDN(BCStyle.C, "IT");
        return builder.build();
    }
}

