/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.DataHandlerUtils;
import it.actalis.ellips.capi.datahandlers.outputs.CloudOutputHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class S3OutputHandler
extends CloudOutputHandler {
    public static final int MIN_PART_SIZE = 0x500000;
    protected DataHandler.S3_TYPE s3CloudType = null;
    protected String bucket = null;
    protected String filepath = null;
    protected AmazonS3 s3Client = null;
    protected String uploadId = null;
    protected byte[] partBuffer = new byte[0x500000];
    protected int partBufferIndex = 0;
    protected int partNumber = 1;
    protected List<PartETag> partETags = new ArrayList<PartETag>();

    public DataHandler.S3_TYPE getS3CloudType() {
        return this.s3CloudType;
    }

    protected S3OutputHandler() {
    }

    protected final void initS3OutputHandler(AmazonS3ClientBuilder s3ClientBuilder, String bucket, String filepath, String name, Long finalSize) {
        if (s3ClientBuilder == null) {
            throw new IllegalArgumentException("Please specify a non-null S3 client builder!");
        }
        this.s3Client = (AmazonS3)s3ClientBuilder.build();
        this.bucket = bucket;
        this.filepath = filepath == null ? "" : filepath;
        this.initCloudOutputHandler(DataHandler.CLOUD_TYPE.S3, name, finalSize);
        this.s3CloudType = DataHandler.S3_TYPE.GENERIC;
    }

    protected void abortUpload() {
        this.s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, DataHandlerUtils.getS3FileKey(this.filepath, this.name), this.uploadId));
    }

    public S3OutputHandler(AmazonS3ClientBuilder s3ClientBuilder, String bucket, String filepath, String name, Long finalSize) throws IOException {
        this.initS3OutputHandler(s3ClientBuilder, bucket, filepath, name, finalSize);
    }

    public S3OutputHandler(AmazonS3ClientBuilder s3ClientBuilder, String bucket, String filepath, String name) throws IOException {
        this(s3ClientBuilder, bucket, filepath, name, null);
    }

    @Override
    protected CloudOutputHandler.CloudWriteProxyOutputStream getCloudUnderlyingProxyOutputStream() {
        return new S3WriteProxyOutputStream();
    }

    @Override
    protected void initBeforeFirstWrite() throws IOException {
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.bucket, DataHandlerUtils.getS3FileKey(this.filepath, this.name));
        InitiateMultipartUploadResult initResponse = this.s3Client.initiateMultipartUpload(initRequest);
        this.uploadId = initResponse.getUploadId();
    }

    @Override
    protected void finalizeBeforeClosing() throws IOException {
        try {
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.bucket, DataHandlerUtils.getS3FileKey(this.filepath, this.name), this.uploadId, this.partETags);
            this.s3Client.completeMultipartUpload(compRequest);
        }
        catch (RuntimeException e) {
            this.abortUpload();
            throw e;
        }
    }

    protected class S3WriteProxyOutputStream
    extends CloudOutputHandler.CloudWriteProxyOutputStream {
        protected S3WriteProxyOutputStream() {
            super(S3OutputHandler.this);
        }

        @Override
        public void flush() throws IOException {
            if (S3OutputHandler.this.partBufferIndex <= 0) {
                return;
            }
            byte[] actualArray = S3OutputHandler.this.partBufferIndex >= S3OutputHandler.this.partBuffer.length ? S3OutputHandler.this.partBuffer : Arrays.copyOfRange(S3OutputHandler.this.partBuffer, 0, S3OutputHandler.this.partBufferIndex);
            ByteArrayInputStream bis = new ByteArrayInputStream(actualArray);
            try {
                UploadPartRequest uploadPartReq = new UploadPartRequest().withBucketName(S3OutputHandler.this.bucket).withKey(DataHandlerUtils.getS3FileKey(S3OutputHandler.this.filepath, S3OutputHandler.this.name)).withInputStream((InputStream)bis).withUploadId(S3OutputHandler.this.uploadId).withPartNumber(S3OutputHandler.this.partNumber).withPartSize((long)actualArray.length);
                S3OutputHandler.this.partETags.add(S3OutputHandler.this.s3Client.uploadPart(uploadPartReq).getPartETag());
            }
            catch (RuntimeException e) {
                S3OutputHandler.this.abortUpload();
                throw e;
            }
            bis.close();
            S3OutputHandler.this.partBufferIndex = 0;
            ++S3OutputHandler.this.partNumber;
        }

        @Override
        public void write(int b) throws IOException {
            S3OutputHandler.this.partBuffer[S3OutputHandler.this.partBufferIndex] = (byte)(b & 0xFF);
            ++S3OutputHandler.this.partBufferIndex;
            if (S3OutputHandler.this.partBufferIndex >= S3OutputHandler.this.partBuffer.length) {
                this.flush();
            }
        }
    }
}

