/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemReader;

public class PEMInputStream
extends FilterInputStream {
    PemReader reader;
    byte[] buf = null;
    int currente_pos = 0;

    public PEMInputStream(InputStream in) {
        super(in);
        this.reader = new PemReader((Reader)new InputStreamReader(in));
    }

    @Override
    public int read() throws IOException {
        if (this.buf == null || this.currente_pos >= this.buf.length - 1) {
            String line = this.reader.readLine();
            if (line == null) {
                return -1;
            }
            if (line.startsWith("-----") || line.trim().equals("")) {
                return this.read();
            }
            this.buf = Base64.decode((String)line);
            this.currente_pos = 0;
        } else {
            ++this.currente_pos;
        }
        return this.buf[this.currente_pos] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        IOException e = null;
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        try {
            super.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }
}

