/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenManager;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.VerifiedSignatureToken;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public class TokenHelper {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static TokenSpi initToken(String tokenType, String[] args) throws CapiException {
        TokenSpi objReturn = null;
        ServiceLoader<TokenManager> managerLoader = ServiceLoader.load(TokenManager.class, TokenManager.class.getClassLoader());
        Iterator<TokenManager> managers = managerLoader.iterator();
        try {
            TokenManager manager;
            while (managers.hasNext() && (objReturn = (manager = managers.next()).initToken(tokenType)) == null) {
            }
        }
        catch (Throwable ex) {
            throw new CapiException(ex.getMessage(), 10010);
        }
        if (args == null) {
            logger.error("null arguments!");
        } else {
            if (args[0] == null) {
                logger.error("first argument null!");
            } else {
                logger.info("first argument = " + args[0]);
            }
            if (args[1] == null) {
                logger.error("second argument null!");
            } else {
                logger.info("second argument = " + args[1]);
            }
        }
        if (objReturn == null) {
            throw new CapiException(tokenType + " not initialized!", 10010);
        }
        objReturn.initializeLib(args);
        return objReturn;
    }

    public static TokenSpi initToken(String tokenType, TokenParameters param) throws CapiException {
        TokenSpi objReturn = null;
        ServiceLoader<TokenManager> managerLoader = ServiceLoader.load(TokenManager.class, TokenManager.class.getClassLoader());
        Iterator<TokenManager> managers = managerLoader.iterator();
        try {
            TokenManager manager;
            while (managers.hasNext() && (objReturn = (manager = managers.next()).initToken(tokenType)) == null) {
            }
        }
        catch (Throwable ex) {
            throw new CapiException(ex.getMessage(), 10010);
        }
        if (param == null) {
            logger.error("null arguments!");
        }
        if (objReturn == null) {
            throw new CapiException(tokenType + " not initialized!", 10010);
        }
        objReturn.initializeLib(param);
        return objReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(TokenSpi tk) {
        long TlastDestroyTM = 0L;
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            logger.debug("destroy");
            if (tk != null) {
                TlastDestroyTM = System.currentTimeMillis();
                logger.debug("finalize starting at TlastDestroyTM: " + TlastDestroyTM + " ms");
                tk.finalizeLib();
                tk = null;
                TlastDestroyTM = System.currentTimeMillis();
                logger.debug("finalize ok at TlastDestroyTM: " + TlastDestroyTM + " ms");
            }
        }
    }

    public static void openPublicSession(TokenSpi tk) throws CapiException {
        logger.debug("openPublicSession");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tk.openPublicSession();
        logger.debug("openPublicSession OK");
    }

    public static void logout(TokenSpi tk) throws CapiException {
        logger.debug("logout");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tk.closeSession();
    }

    public static String[] listObjects(TokenSpi tk, String aliasFilter, byte typeFilter) throws CapiException {
        logger.debug("listObjects");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (!TokenHelper.isLogged(tk)) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.listObjects(aliasFilter, typeFilter);
    }

    public static String getObjectID(TokenSpi tk, String alias) throws CapiException {
        logger.debug("getObjectType (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!TokenHelper.isLogged(tk)) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getObjectID(alias);
    }

    public static String getCertificate(TokenSpi tk, String alias) throws CapiException {
        logger.debug("getCertificate (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!TokenHelper.isLogged(tk)) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getCert(alias);
    }

    public static boolean isLogged(TokenSpi tk) throws CapiException {
        logger.debug("isLogged");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.isSessionOpen();
    }

    public static void login(TokenSpi tk) throws CapiException {
        logger.debug("login");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tk.openSessionAuthPath(false);
        logger.debug("login OK");
    }

    public static void login(TokenSpi tk, String PIN) throws CapiException {
        logger.debug("login");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (PIN == null) {
            throw new CapiException("Null parameters", 1001);
        }
        tk.openSession(false, PIN);
        logger.debug("login OK");
    }

    public static byte[] doSign(TokenSpi tk, byte[] digest, String alias, int mode) throws CapiException {
        logger.debug("login");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (digest == null || digest.length == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        return tk.doSign(digest, alias, mode);
    }

    public static byte[] doVerifiedSignature(Actalis_PrivateKey key, byte[] signer_info, int mode) throws CapiException {
        logger.debug("login");
        if (key == null && key instanceof Actalis_PrivateKey) {
            throw new CapiException("invalid not initialized", 10003);
        }
        if (signer_info == null || signer_info.length == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        TokenSpi tk = key.getCryptoDev();
        if (tk instanceof VerifiedSignatureToken) {
            if (mode == 0) {
                return ((VerifiedSignatureToken)((Object)tk)).verifiedSignature(signer_info, key.getAlias());
            }
            if (mode == 1) {
                return ((VerifiedSignatureToken)((Object)tk)).xmlVerifiedSignature(signer_info, key.getAlias());
            }
            throw new CapiException("Token non support verified signature interface", 1004);
        }
        throw new CapiException("Token non support verified signature interface", 1004);
    }

    public static PrivateKey getPrivateKeyByAlias(TokenSpi tk, String alias) throws CapiException {
        return tk.getPrivateKey(alias);
    }
}

