/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.core.TokenManager;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisProvider;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;

public class ProvUtils {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final Provider bcProvider = new BouncyCastleProvider();
    public static final Provider actalisProvider = new ActalisProvider();

    public static final void removeProvider(String name) {
        while (Security.getProvider(name) != null) {
            logger.debug("removingProvider name=" + name);
            Security.removeProvider(name);
        }
    }

    public static Provider retrieveBestProviderForKey(PrivateKey key) {
        Provider objReturn = null;
        ServiceLoader<TokenManager> managerLoader = ServiceLoader.load(TokenManager.class, TokenManager.class.getClassLoader());
        for (TokenManager manager : managerLoader) {
            objReturn = manager.retrieveProviderForKey(key);
            if (objReturn == null) continue;
            return objReturn;
        }
        return bcProvider;
    }

    public static TokenSpi retrieveTokenByAlias(String alias) {
        TokenManager manager;
        TokenSpi objReturn = null;
        ServiceLoader<TokenManager> managerLoader = ServiceLoader.load(TokenManager.class, TokenManager.class.getClassLoader());
        Iterator<TokenManager> managers = managerLoader.iterator();
        while (managers.hasNext() && (objReturn = (manager = managers.next()).retrieveTokenByAlias(alias)) == null) {
        }
        return objReturn;
    }
}

