/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.X509StatusValidator;
import esecurity.validator.x509status.ocsp.HttpOCSPClient;
import esecurity.validator.x509status.ocsp.OCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.DigestUtils;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.I;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.slf4j.Logger;

public class OCSPX509StatusValidator
implements X509StatusValidator {
    private ValidatorConfig config;
    private Logger logger;
    private HttpOCSPClient client;
    private OCSPCacheManager cacheManager;
    private boolean enableCache;

    public OCSPX509StatusValidator(ValidatorConfig config, OCSPCacheManager cacheManager, Logger logger) throws CapiException {
        this.config = config;
        this.enableCache = config.getBinElement("x509StatusService.cacheEnabled", true);
        this.client = new HttpOCSPClient(config.getNetConfiguration(), logger, config.getCertDB());
        this.cacheManager = cacheManager;
        this.logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (logger != null) {
            this.logger = logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertificateStatus checkStatus(Certificate cert, ValidationDate validationDate) {
        CertificateStatus certificateStatus = new CertificateStatus();
        certificateStatus.setCrlBean(null);
        try {
            ArrayList<CertDBItem> chain;
            String ocspUrl;
            block32: {
                if (cert.getSubjectDN().equalsIgnoreCase(cert.getIssuerDN())) {
                    this.logger.debug(I.d() + "e' selfsigned: non fa la verifica OCSP");
                    certificateStatus.setCertValid(true);
                    certificateStatus.setCrlStatus("NO_CHECK");
                    CertificateStatus certificateStatus2 = certificateStatus;
                    return certificateStatus2;
                }
                if (cert.isRsVerified()) {
                    this.logger.debug(I.d() + "e' RsVerified");
                    certificateStatus.setCertValid(true);
                    certificateStatus.setCrlStatus("VERIFIED SIGNATURE");
                    CertificateStatus certificateStatus3 = certificateStatus;
                    return certificateStatus3;
                }
                ocspUrl = cert.getOcspUrl();
                if (ocspUrl == null || ocspUrl.isEmpty()) {
                    this.logger.debug("no valid OCSP url found");
                    certificateStatus.setCrlStatus("NOT FOUND");
                    CertificateStatus certificateStatus4 = certificateStatus;
                    return certificateStatus4;
                }
                chain = new ArrayList<CertDBItem>();
                try {
                    this.config.getCertDB().onLineVerify(this.config.getNetConfiguration(), cert.getInternalCert().getEncoded(), chain);
                }
                catch (CapiException e) {
                    if (e.getErrorCode() != 30007) break block32;
                    certificateStatus.setCertCorrupted(true);
                }
            }
            CertDBItem[] caCerts = chain.toArray(new CertDBItem[chain.size()]);
            if (caCerts.length == 0) {
                this.logger.debug(I.d() + "e' selfsigned: non fa la verifica OCSP");
                certificateStatus.setCertValid(false);
                certificateStatus.setInvalidityReason("No chain in CDB");
                CertificateStatus certificateStatus5 = certificateStatus;
                return certificateStatus5;
            }
            certificateStatus.setCertRevoked(false);
            certificateStatus.setCertValid(true);
            certificateStatus.setCrlStatus("OCSP_CHECK");
            certificateStatus.setVerificationType("OCSP");
            OCSPResponse ocspResponse = null;
            boolean checkIntoCache = this.enableCache;
            String certId = null;
            if (checkIntoCache) {
                try {
                    certId = this.calculateCertId(cert);
                }
                catch (CapiException ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (checkIntoCache &= certId != null) {
                ocspResponse = this.cacheManager.get(certId);
            }
            if (ocspResponse == null) {
                Certificate root = caCerts[0].getCertificate();
                ocspResponse = this.client.sendOCSPRequest(ocspUrl, cert.getInternalCert(), root.getInternalCert());
                if (this.enableCache) {
                    this.cacheManager.addToCache(certId, ocspResponse);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("got ocsp response from server for " + certId);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("got ocsp response from cache for " + certId);
            }
            int status = ocspResponse.getCertStatus();
            if (status == OCSPResponse.REVOKED) {
                String reason = this.translateReason(ocspResponse.getReasonCode());
                if (ocspResponse.getRevocationTime() != null && validationDate.getDate().before(ocspResponse.getRevocationTime())) {
                    reason = reason + " - After the verification date";
                } else {
                    certificateStatus.setCertRevoked(true);
                    certificateStatus.setCertValid(false);
                }
                certificateStatus.setInvalidityReason(reason);
                certificateStatus.setRevocationReason(Integer.toString(ocspResponse.getReasonCode()));
                certificateStatus.setRevocationDate(ocspResponse.getRevocationTime());
                certificateStatus.setCrlStatus("VALID");
            } else if (status == OCSPResponse.GOOD) {
                certificateStatus.setCrlStatus("VALID");
            } else if (status == OCSPResponse.UNKNOWN) {
                certificateStatus.setInvalidityReason("Unknown revocation status");
                certificateStatus.setCrlStatus("NOT FOUND");
            }
        }
        catch (Exception e) {
            certificateStatus.setCrlStatus("NOT FOUND");
            this.logger.error(I.d() + e.getMessage());
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("CRLX509StatusValidator result:");
                this.logger.debug(certificateStatus.toString());
            }
        }
        return certificateStatus;
    }

    private String translateReason(int rc) {
        String revstr = "";
        switch (rc) {
            case 3: {
                revstr = "AffiliationChanged";
                break;
            }
            case 2: {
                revstr = "CACompromise";
                break;
            }
            case 6: {
                revstr = "CertificateHold";
                break;
            }
            case 5: {
                revstr = "CessationOfOperation";
                break;
            }
            case 1: {
                revstr = "KeyCompromise";
                break;
            }
            case 8: {
                revstr = "RemoveFromCRL";
                break;
            }
            case 4: {
                revstr = "Superseded";
                break;
            }
            case 0: {
                revstr = "Unspecified";
                break;
            }
            case 9: {
                revstr = "PrivilegeWithdrawn";
                break;
            }
            case 10: {
                revstr = "AACompromise";
                break;
            }
            default: {
                revstr = "Unknown";
            }
        }
        return revstr;
    }

    private String calculateCertId(Certificate cert) throws CapiException {
        try {
            return DigestUtils.calculateHexString(DigestAlgorithm.SHA512, cert.getDerEncoded());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new CapiException("Unable to calculate cert Identifier", 1003, ex);
        }
    }
}

