/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import it.actalis.ellips.capi.core.ProvUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class OCSPRequest {
    private final OCSPReq ocspRequest;
    private final X509Certificate subjectCert;
    private final X509Certificate issuerCert;
    private CertificateID certID;
    private byte[] nonce;

    public OCSPRequest(X509Certificate subjectCert, X509Certificate issuerCert, boolean setAcceptBasic, boolean setNonce) throws Exception {
        this.subjectCert = subjectCert;
        this.issuerCert = issuerCert;
        this.ocspRequest = this.createReqCert(setAcceptBasic, setNonce);
    }

    public X509Certificate getSubjectCert() {
        return this.subjectCert;
    }

    public X509Certificate getIssuerCert() {
        return this.issuerCert;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public byte[] getEncodedOCSPReq() {
        try {
            return this.ocspRequest.getEncoded();
        }
        catch (Exception ce) {
            return null;
        }
    }

    public OCSPReq getOCSPReq() {
        return this.ocspRequest;
    }

    public CertificateID getReqCert() {
        return this.certID;
    }

    private OCSPReq createReqCert(boolean setAcceptBasic, boolean setNonce) throws Exception {
        DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
        DigestCalculator dc = dcp.get(CertificateID.HASH_SHA1);
        this.certID = new CertificateID(dc, (X509CertificateHolder)new JcaX509CertificateHolder(this.issuerCert), this.subjectCert.getSerialNumber());
        OCSPReqBuilder oscpBuilder = new OCSPReqBuilder();
        oscpBuilder.addRequest(this.certID);
        Extension extNonce = null;
        Extension extAB = null;
        if (setNonce) {
            BigInteger noncebigI = BigInteger.valueOf(System.currentTimeMillis());
            extNonce = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(noncebigI.toByteArray()));
            this.nonce = extNonce.getExtnValue().getEncoded();
        }
        ASN1EncodableVector vect = new ASN1EncodableVector();
        vect.add((ASN1Encodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        DERSequence seq = new DERSequence(vect);
        if (setAcceptBasic) {
            extAB = new Extension(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.4"), false, (ASN1OctetString)new DEROctetString(seq.getEncoded()));
        }
        if (extNonce != null && extAB != null) {
            oscpBuilder.setRequestExtensions(new Extensions(new Extension[]{extNonce, extAB}));
        } else if (extNonce == null && extAB != null) {
            oscpBuilder.setRequestExtensions(new Extensions(new Extension[]{extAB}));
        } else if (extNonce != null && extAB == null) {
            oscpBuilder.setRequestExtensions(new Extensions(new Extension[]{extNonce}));
        }
        OCSPReq req = oscpBuilder.build();
        return req;
    }
}

