/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.constants.RevocationVerifyMode;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.X509StatusValidator;
import esecurity.validator.x509status.crl.CRLCacheManager;
import esecurity.validator.x509status.crl.CRLX509StatusValidator;
import esecurity.validator.x509status.crl.DefaultCrlCacheManager;
import esecurity.validator.x509status.ocsp.DefaultOCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPX509StatusValidator;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import org.slf4j.Logger;

public class X509StatusService {
    private static Logger logger = null;
    private X509StatusValidator[] helpers = null;

    private X509StatusService(X509StatusValidator[] helper, Logger callerLogger) {
        if (callerLogger != null) {
            logger = callerLogger;
        }
        this.helpers = helper;
    }

    public static X509StatusService getInstance(ValidatorConfig config, CRLCacheManager customCRLCacheManager, OCSPCacheManager customOCSPCacheManager, Logger callerLogger) throws CapiException {
        return new X509StatusService(X509StatusService.getDefaultHelper(config, customCRLCacheManager, customOCSPCacheManager, callerLogger), callerLogger);
    }

    public static X509StatusService getInstance(ValidatorConfig config, Logger callerLogger) throws CapiException {
        return X509StatusService.getInstance(config, null, null, callerLogger);
    }

    public static X509StatusService getInstance(ValidatorConfig config) throws CapiException {
        return X509StatusService.getInstance(config, null);
    }

    public static X509StatusService getInstance() throws CapiException {
        return X509StatusService.getInstance(null);
    }

    private static X509StatusValidator[] getDefaultHelper(ValidatorConfig config, CRLCacheManager customCRLCacheManager, OCSPCacheManager customOCSPCacheManager, Logger callerLogger) throws CapiException {
        ValidatorConfig curConfig;
        logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (callerLogger != null) {
            logger = callerLogger;
        }
        if ((curConfig = config) == null) {
            curConfig = new ValidatorConfig();
        }
        CRLCacheManager crlCacheManager = null;
        crlCacheManager = customCRLCacheManager != null ? customCRLCacheManager : new DefaultCrlCacheManager(curConfig, logger);
        OCSPCacheManager ocspCacheManager = null;
        ocspCacheManager = customCRLCacheManager != null ? customOCSPCacheManager : new DefaultOCSPCacheManager(curConfig, logger);
        X509StatusValidator[] helpers = null;
        String value = curConfig.getElement("verify.mode", RevocationVerifyMode.OCSPFIRST.name());
        if (RevocationVerifyMode.OCSPFIRST.name().equals(value)) {
            helpers = new X509StatusValidator[]{new OCSPX509StatusValidator(curConfig, ocspCacheManager, logger), new CRLX509StatusValidator(curConfig, crlCacheManager, logger)};
        } else if (RevocationVerifyMode.CRLFIRST.name().equals(value)) {
            helpers = new X509StatusValidator[2];
            helpers[1] = new OCSPX509StatusValidator(curConfig, ocspCacheManager, logger);
            helpers[0] = new CRLX509StatusValidator(curConfig, crlCacheManager, logger);
        } else if (RevocationVerifyMode.OCSPONLY.name().equals(value)) {
            helpers = new X509StatusValidator[]{new OCSPX509StatusValidator(curConfig, ocspCacheManager, logger)};
        } else if (RevocationVerifyMode.CRLONLY.name().equals(value)) {
            helpers = new X509StatusValidator[]{new CRLX509StatusValidator(curConfig, crlCacheManager, logger)};
        } else {
            throw new CapiException("Invalid verify.mode", 1003);
        }
        return helpers;
    }

    public void setX509StatusHelper(X509StatusValidator[] helpers) {
        this.helpers = helpers;
    }

    public CertificateStatus checkStatus(Certificate cert, ValidationDate validationDate) throws CapiException {
        X509StatusValidator validator;
        CertificateStatus certificateStatus = new CertificateStatus();
        if (this.helpers == null) {
            certificateStatus.setCertValid(false);
            certificateStatus.setInvalidityReason("MISSING CONFIGURATION");
            certificateStatus.setCrlStatus("NO_CHECK");
            return certificateStatus;
        }
        if (validationDate == null) {
            validationDate = new ValidationDate(new Date(), DateSource.SYSTEM);
        }
        X509StatusValidator[] arr$ = this.helpers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((certificateStatus = (validator = arr$[i$]).checkStatus(cert, validationDate)) == null || certificateStatus.getCrlStatus().equals("OFFLINE") || certificateStatus.getCrlStatus().equals("NOT FOUND")); ++i$) {
        }
        return certificateStatus;
    }
}

