/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status;

import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.x509status.CrlBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class CertificateStatus {
    private boolean certCorrupted = false;
    private boolean certValid = false;
    private boolean certTimeValid = false;
    private boolean certTrusted = false;
    private boolean certRevoked = false;
    private boolean checkAnotherHelper = false;
    private Date revocationDate = null;
    private String revocationReason = "";
    private String invalidityReason = "";
    private String crlStatus = "";
    private String verificationType = "";
    private CrlBean crlBean = new CrlBean();
    private transient Date checkDate = null;

    public boolean getCertValid() {
        return this.certValid;
    }

    public void setCertValid(boolean certValid) {
        this.certValid = certValid;
    }

    public boolean getCertTrusted() {
        return this.certTrusted;
    }

    public void setCertTrusted(boolean certTrust) {
        this.certTrusted = certTrust;
    }

    public boolean getCertRevoked() {
        return this.certRevoked;
    }

    public void setCertRevoked(boolean certRevoked) {
        this.certRevoked = certRevoked;
    }

    public boolean getCertTimeValid() {
        return this.certTimeValid;
    }

    public void setCertTimeValid(boolean certTimeValid) {
        this.certTimeValid = certTimeValid;
    }

    public boolean getCertCorrupted() {
        return this.certCorrupted;
    }

    public void setCertCorrupted(boolean certCorrupted) {
        this.certCorrupted = certCorrupted;
    }

    public String getCrlStatus() {
        return this.crlStatus;
    }

    public void setCrlStatus(String crlStatus) {
        this.crlStatus = crlStatus;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void setRevocationDate(Date revocationDate) {
        this.revocationDate = revocationDate;
    }

    public String getRevocationReason() {
        return this.revocationReason;
    }

    public void setRevocationReason(String revocationReason) {
        this.revocationReason = revocationReason;
    }

    public String getInvalidityReason() {
        return this.invalidityReason;
    }

    public void setInvalidityReason(String invalidityReason) {
        this.invalidityReason = invalidityReason;
    }

    public CrlBean getCrlBean() {
        return this.crlBean;
    }

    public void setCrlBean(CrlBean crlBean) {
        this.crlBean = crlBean;
    }

    public String getVerificationType() {
        return this.verificationType;
    }

    public void setVerificationType(String verificationType) {
        this.verificationType = verificationType;
    }

    public boolean isCheckAnotherHelper() {
        return this.checkAnotherHelper;
    }

    public void setCheckAnotherHelper(boolean checkAnotherHelper) {
        this.checkAnotherHelper = checkAnotherHelper;
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        String ret = "CertificateStatus:\ncorrupted: " + this.getCertCorrupted() + "\n" + "revoked: " + this.getCertRevoked() + "\n" + "time valid: " + this.getCertTimeValid() + "\n" + "trusted: " + this.getCertTrusted() + "\n" + "corrupted: " + this.getCertCorrupted() + "\n" + "invalidity reason: " + this.getInvalidityReason() + "\n";
        if (this.getRevocationDate() != null) {
            ret = ret + "revocation date: " + df.format(this.getRevocationDate()) + "\n";
        }
        ret = ret + "revocation reason: " + this.getRevocationReason() + "\n" + "check another helper: " + this.isCheckAnotherHelper() + "\n" + "verification type: " + this.getVerificationType() + "\n" + "crl status: " + this.getCrlStatus() + "\n";
        if (this.getCrlBean() != null) {
            ret = ret + "crl bean: " + this.getCrlBean().toString();
        }
        return ret;
    }

    public Date getCheckDate() {
        return this.checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    public void applyToValidate(ValidatedCertificate vCert) {
        vCert.setCertRevoked(this.getCertRevoked());
        vCert.setCertValid(this.getCertValid());
        vCert.setRevocationDate(this.getRevocationDate());
        vCert.setRevocationReason(this.getRevocationReason());
        vCert.setInvalidityReason(this.getInvalidityReason());
        vCert.setCrlStatus(this.getCrlStatus());
        if (!this.verificationType.equals("CRL")) {
            vCert.setCrlBean(null);
        } else {
            vCert.setCrlBean(this.getCrlBean());
        }
        vCert.setCheckAnotherHelper(this.isCheckAnotherHelper());
        vCert.setVerificationType(this.getVerificationType());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateStatus)) {
            return false;
        }
        CertificateStatus other = (CertificateStatus)obj;
        if (this.revocationReason == null ? other.revocationReason != null : !this.revocationReason.equals(other.revocationReason)) {
            return false;
        }
        if (this.invalidityReason == null ? other.invalidityReason != null : !this.invalidityReason.equals(other.invalidityReason)) {
            return false;
        }
        if (this.crlStatus == null ? other.crlStatus != null : !this.crlStatus.equals(other.crlStatus)) {
            return false;
        }
        if (this.verificationType == null ? other.verificationType != null : !this.verificationType.equals(other.verificationType)) {
            return false;
        }
        if (this.certCorrupted != other.certCorrupted) {
            return false;
        }
        if (this.certValid != other.certValid) {
            return false;
        }
        if (this.certTimeValid != other.certTimeValid) {
            return false;
        }
        if (this.certTrusted != other.certTrusted) {
            return false;
        }
        if (this.certRevoked != other.certRevoked) {
            return false;
        }
        if (this.checkAnotherHelper != other.checkAnotherHelper) {
            return false;
        }
        if (this.revocationDate == null ? other.revocationDate != null : !this.revocationDate.equals(other.revocationDate)) {
            return false;
        }
        if (this.checkDate == null ? other.checkDate != null : !this.checkDate.equals(other.checkDate)) {
            return false;
        }
        return !(this.crlBean == null ? other.crlBean != null : !this.crlBean.equals(other.crlBean));
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.certCorrupted ? 1 : 0);
        hash = 37 * hash + (this.certValid ? 1 : 0);
        hash = 37 * hash + (this.certTimeValid ? 1 : 0);
        hash = 37 * hash + (this.certTrusted ? 1 : 0);
        hash = 37 * hash + (this.certRevoked ? 1 : 0);
        hash = 37 * hash + (this.checkAnotherHelper ? 1 : 0);
        hash = 37 * hash + Objects.hashCode(this.revocationDate);
        hash = 37 * hash + Objects.hashCode(this.revocationReason);
        hash = 37 * hash + Objects.hashCode(this.invalidityReason);
        hash = 37 * hash + Objects.hashCode(this.crlStatus);
        hash = 37 * hash + Objects.hashCode(this.verificationType);
        hash = 37 * hash + Objects.hashCode(this.crlBean);
        hash = 37 * hash + Objects.hashCode(this.checkDate);
        return hash;
    }
}

