/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;

public class StepX509TimestampKeyUsageCompliance
extends SingleValidationSubStepImpl {
    public StepX509TimestampKeyUsageCompliance() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        block6: {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            format.setTimeZone(param.getTimeZone());
            Date validationDate = param.getCalculatedValidationDate().getDate();
            if (param != null && param.getSignerCertificate() != null && param.getSignature() != null && param.getSignature().getFormat() != null && param.getSignature().getFormat().equals((Object)SignatureFormat.TST) && param.getSignerCertificate().getCert() != null) {
                Certificate cert = param.getSignerCertificate().getCert();
                String keyUsage = "";
                try {
                    keyUsage = param.getSignerCertificate().getCert().keyUsageToString(cert.getKeyUsage());
                }
                catch (CapiException e) {
                    keyUsage = "";
                }
                try {
                    String[] extKeyUsage = cert.getExtendedKeyUsage();
                    if ((!keyUsage.contains("digitalSignature") || extKeyUsage.length != 1 || !extKeyUsage[0].equalsIgnoreCase("1.3.6.1.5.5.7.3.8") || cert.getPolicies(';').length == 0 || cert.getAuthorityKeyIdentifier().length == 0 || cert.getSubjectKeyIdentifier().length == 0) && validationDate.after(Constants.DPCM_CNIPA_45_2009) && validationDate.before(Constants.DPCM_AGID_121_2019)) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0013_CERT_TSA_NOCNIPA45, this.getClass().getName());
                    }
                }
                catch (CapiException ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                    if (!validationDate.after(Constants.DPCM_CNIPA_45_2009) || !validationDate.before(Constants.DPCM_AGID_121_2019)) break block6;
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0013_CERT_TSA_NOCNIPA45, this.getClass().getName());
                }
            }
        }
        return null;
    }
}

