/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.core.qc.PdsLocation;
import java.util.LinkedList;
import java.util.List;

public class StepX509QcPDS
extends MultipleValidationSubStepImpl {
    public StepX509QcPDS() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        List<PdsLocation> pdsLocation;
        LinkedList<ValidatorMessage> objReturn = new LinkedList<ValidatorMessage>();
        if (param != null && param.getSignerCertificate() != null && param.getSignerCertificate().getCert() != null && (pdsLocation = param.getSignerCertificate().getCert().getQcPdsLocation()) != null && pdsLocation.size() > 0) {
            for (int j = 0; j < pdsLocation.size(); ++j) {
                if (pdsLocation.get(j).getUrl() == null || pdsLocation.get(j).getLanguage() == null) continue;
                objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0007_CERT_PDS, pdsLocation.get(j).getLanguage(), pdsLocation.get(j).getUrl()));
            }
        }
        return objReturn;
    }
}

