/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.LinkedList;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class StepX509DPCM45Issuer
extends SingleValidationSubStepImpl {
    public StepX509DPCM45Issuer() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        ValidatorMessage msg = null;
        if (param != null && param.getSignerCertificate() != null && param.getSignerCertificate().getCert().getInternalCert().getNotBefore().after(Constants.DPCM_CNIPA_45_2009) && param.getSignerCertificate().getCert().getInternalCert().getNotBefore().before(Constants.DPCM_AGID_189_2017_STARTDATE)) {
            if (param.getSignerCertificate().getIssuer() == null) {
                return null;
            }
            boolean valid = false;
            try {
                String[] countryName = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                String[] organizationName = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.organization.getId());
                if (countryName != null && countryName.length == 1 && organizationName != null && organizationName.length == 1) {
                    valid = true;
                }
            }
            catch (CapiException ex) {
                valid = false;
            }
            if (!valid) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0016_INVALID_ISSUER_DPCM45, new Object[0]);
            }
        }
        return msg;
    }
}

