/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.steps.CertificateValidationStep;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.steps.core.x509.StepX509CertificateChain;
import esecurity.validator.steps.core.x509.StepX509DPCM189Compliance;
import esecurity.validator.steps.core.x509.StepX509DPCM45Compliance;
import esecurity.validator.steps.core.x509.StepX509ETSICompliance;
import esecurity.validator.steps.core.x509.StepX509KeyUsage;
import esecurity.validator.steps.core.x509.StepX509Status;
import esecurity.validator.steps.core.x509.StepX509TimeValidity;
import esecurity.validator.steps.core.x509.StepX509ValidationTime;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=30)
public class StepX509CertificateReliable
extends CertificateValidationStep {
    public StepX509CertificateReliable() {
        this.subSteps.add(new StepX509ValidationTime());
        this.subSteps.add(new StepX509CertificateChain());
        this.subSteps.add(new StepX509DPCM45Compliance());
        this.subSteps.add(new StepX509DPCM189Compliance());
        this.subSteps.add(new StepX509ETSICompliance());
        this.subSteps.add(new StepX509TimeValidity());
        this.subSteps.add(new StepX509Status());
        this.subSteps.add(new StepX509KeyUsage());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
        if (level == MessageLevel.ERROR) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.EC0003_CERT_NOT_RELIABLE, new Object[0]);
        }
        if (level == MessageLevel.WARNING) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.WC0003_STATUS_WARNING, new Object[0]);
        }
        return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.IC0002_CERT_IS_RELIABLE, new Object[0]);
    }
}

