/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.dts.TimeStampToken;
import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import java.util.LinkedList;

public class TimeStampStepSignatureDPCM45DigestAlgoCheck
extends SingleValidationSubStepImpl {
    public TimeStampStepSignatureDPCM45DigestAlgoCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        if (param.getSignature() == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        SignerInfoData data = param.getSignature().getSignerInfoData();
        if (data == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0008_TIMESTAMP_NOSHA256, this.getClass().getName());
        }
        if (data.getDigestAlgo().equals(DigestAlgorithm.SHA256.getId()) || data.getDigestAlgo().equals(DigestAlgorithm.SHA512.getId())) {
            TimeStampToken tstToken = null;
            try {
                tstToken = new TimeStampToken(param.getSignature().getSignatureInfo());
            }
            catch (CapiException ex) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0027_INVALID_TIMESTAMP, this.getClass().getName());
            }
            try {
                if (tstToken.getSigningCertificateV2HashAlg() != null && tstToken.getSigningCertificateV2HashAlg().equals(DigestAlgorithm.SHA256.getId()) && tstToken.getInternalTst().getTimeStampInfo().getMessageImprintAlgOID().getId() != null && tstToken.getInternalTst().getTimeStampInfo().getMessageImprintAlgOID().getId().equals(DigestAlgorithm.SHA256.getId())) {
                    return null;
                }
            }
            catch (CapiException ex) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0027_INVALID_TIMESTAMP, this.getClass().getName());
            }
            catch (Exception ex) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
        }
        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0008_TIMESTAMP_NOSHA256, this.getClass().getName());
    }
}

