/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.dts.TimeStampToken;
import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.bean.LevelValidation;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.steps.SignatureValidationStep;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.utils.LevelValidationUtils;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.signature.SignatureLevel;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSException;

@StepOrder(order=0)
public class StepValidationLevel
extends SignatureValidationStep {
    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        block31: {
            LevelValidation levelValidation = null;
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            df.setTimeZone(param.getTimeZone());
            try {
                ValidationDate vDate;
                if (param.getSignature() == null) break block31;
                if (param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
                    if (param.getSignerCertificate() != null && param.getSignature().getSignatureDate() != null) {
                        vDate = new ValidationDate(df.parse(param.getSignature().getSignatureDate()), DateSource.TIMESTAMP);
                        param.setCalculatedValidationDate(vDate);
                    } else if (param.getValidationDate() != null) {
                        param.setCalculatedValidationDate(param.getValidationDate());
                    } else {
                        vDate = new ValidationDate(new Date(), DateSource.SYSTEM);
                        param.setCalculatedValidationDate(vDate);
                    }
                } else if (param.getSignature().getTimeStampTokens() != null && param.getSignature().getTimeStampTokens().size() > 0) {
                    if (param.getSignature().getTimeStampTokens().get(0) != null) {
                        int iCert;
                        TimeStampToken tsToken = new TimeStampToken(param.getSignature().getTimeStampTokens().get(0).getSignatureInfo());
                        Certificate tsaCert = tsToken.getTSACert();
                        if (tsaCert == null) {
                            if (param.getValidationDate() == null) {
                                ValidationDate vDate2 = new ValidationDate(new Date(), DateSource.SYSTEM);
                                param.setCalculatedValidationDate(vDate2);
                            } else {
                                param.setCalculatedValidationDate(param.getValidationDate());
                            }
                            return null;
                        }
                        X509Certificate cert = null;
                        try {
                            cert = param.getSignerCertificate().getCert().getInternalCert();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        LinkedList<CertDBItem> rootsDBItems = new LinkedList<CertDBItem>();
                        for (iCert = 0; iCert < param.getLstCert().size(); ++iCert) {
                            CertDBItem dbItem = param.getCertDB().contains(param.getLstCert().get(iCert).getEncoded());
                            if (dbItem == null) continue;
                            rootsDBItems.add(dbItem);
                        }
                        levelValidation = LevelValidationUtils.validateLevelByRefCRL(tsToken.getDate(), cert, tsaCert.getInternalCert(), param.getLstCert(), param.getLstOcsp(), param.getDoc().getCrls(), this.logger);
                        if (levelValidation != null) {
                            if (levelValidation.getSignerChain() != null) {
                                block7: for (iCert = 0; iCert < levelValidation.getSignerChain().length; ++iCert) {
                                    for (int jCert = 0; jCert < rootsDBItems.size(); ++jCert) {
                                        if (!levelValidation.getSignerChain()[iCert].getID().equals(((CertDBItem)rootsDBItems.get(jCert)).getID())) continue;
                                        levelValidation.getSignerChain()[iCert] = (CertDBItem)rootsDBItems.get(jCert);
                                        continue block7;
                                    }
                                }
                            }
                            param.setLevelValidation(levelValidation);
                            if (levelValidation.getLevel().compareTo(SignatureLevel.T) >= 0) {
                                boolean useCustomDate = false;
                                if (param.getValidationDate() != null) {
                                    try {
                                        Date customValidationDate = param.getValidationDate().getDate();
                                        Date timestampDate = tsToken.getDate();
                                        if (timestampDate.after(customValidationDate)) {
                                            param.setCalculatedValidationDate(param.getValidationDate());
                                            useCustomDate = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        this.logger.debug(e.getMessage());
                                    }
                                }
                                if (!useCustomDate) {
                                    ValidationDate vDate3 = new ValidationDate(tsToken.getDate(), DateSource.TIMESTAMP);
                                    param.setCalculatedValidationDate(vDate3);
                                }
                            }
                        }
                    }
                } else if (param.getSignerCertificate() != null && param.getSignerCertificate().isRsVerified()) {
                    SignerInfo info = param.getSignature().getSignerInfoData().getSignerInfo();
                    Time signingTime = StepValidationLevel.getSigningTime(info);
                    ValidationDate vDate4 = new ValidationDate(signingTime.getDate(), DateSource.RSVERIFIED);
                    param.setCalculatedValidationDate(vDate4);
                }
                if (param.getCalculatedValidationDate() == null) {
                    if (param.getValidationDate() == null) {
                        vDate = new ValidationDate(new Date(), DateSource.SYSTEM);
                        param.setCalculatedValidationDate(vDate);
                    } else {
                        param.setCalculatedValidationDate(param.getValidationDate());
                    }
                }
            }
            catch (Throwable ex) {
                this.logger.error(ex.getMessage());
            }
        }
        return null;
    }

    private static Time getSigningTime(SignerInfo info) throws CMSException {
        ASN1Primitive validSigningTime = StepValidationLevel.getSingleValuedSignedAttribute(CMSAttributes.signingTime, "signing-time", info);
        if (validSigningTime == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)validSigningTime);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }

    private static ASN1Primitive getSingleValuedSignedAttribute(ASN1ObjectIdentifier attrOID, String printableName, SignerInfo info) throws CMSException {
        AttributeTable unsignedAttrTable = null;
        if (info.getUnauthenticatedAttributes() != null) {
            unsignedAttrTable = new AttributeTable(info.getUnauthenticatedAttributes());
        }
        if (unsignedAttrTable != null && unsignedAttrTable.getAll(attrOID).size() > 0) {
            throw new CMSException("The " + printableName + " attribute MUST NOT be an unsigned attribute");
        }
        AttributeTable signedAttrTable = null;
        if (info.getAuthenticatedAttributes() != null) {
            signedAttrTable = new AttributeTable(info.getAuthenticatedAttributes());
        }
        if (signedAttrTable == null) {
            return null;
        }
        ASN1EncodableVector v = signedAttrTable.getAll(attrOID);
        switch (v.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Attribute t = (Attribute)v.get(0);
                ASN1Set attrValues = t.getAttrValues();
                if (attrValues.size() != 1) {
                    throw new CMSException("A " + printableName + " attribute MUST have a single attribute value");
                }
                return attrValues.getObjectAt(0).toASN1Primitive();
            }
        }
        throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + printableName + " attribute");
    }
}

