/*
 * Decompiled with CFR 0.152.
 */
package esecurity.enroll.bean;

import it.actalis.ellips.capi.util.RFC4519InternalStyle;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;

public class CertificateFields {
    private RDN[] rdns = null;
    private String countryName;
    private String organizationName;
    private String orgUnitName1;
    private String orgUnitName2;
    private String orgUnitName3;
    private String commonName;
    private String surname;
    private String givenName;
    private String title;
    private String localityName;
    private String serialNumber;
    private String dnQualifier;
    private String challengePassword;

    public CertificateFields() {
    }

    public CertificateFields(String x509format) throws IllegalArgumentException {
        this.orgUnitName1 = null;
        this.orgUnitName2 = null;
        this.orgUnitName3 = null;
        for (RDN rdn : this.rdns = RFC4519InternalStyle.INSTANCE.fromString(x509format)) {
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.c)) {
                this.countryName = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.o)) {
                this.organizationName = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.ou)) {
                if (this.orgUnitName1 == null) {
                    this.orgUnitName1 = rdn.getTypesAndValues()[0].getValue().toString();
                    continue;
                }
                if (this.orgUnitName2 == null) {
                    this.orgUnitName2 = rdn.getTypesAndValues()[0].getValue().toString();
                    continue;
                }
                if (this.orgUnitName3 != null) continue;
                this.orgUnitName3 = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.cn)) {
                this.commonName = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.sn)) {
                this.surname = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.givenName)) {
                this.givenName = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.title)) {
                this.title = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.l)) {
                this.localityName = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.serialNumber)) {
                this.serialNumber = rdn.getTypesAndValues()[0].getValue().toString();
                continue;
            }
            if (!rdn.getTypesAndValues()[0].getType().equals((ASN1Primitive)RFC4519InternalStyle.dnQualifier)) continue;
            this.dnQualifier = rdn.getTypesAndValues()[0].getValue().toString();
        }
    }

    public RDN[] getRdns() {
        return this.rdns;
    }

    public String getX509Names() {
        return RFC4519InternalStyle.INSTANCE.toString(new X500Name(this.rdns));
    }

    public X500Name getX500Name() {
        return new X500Name(this.rdns);
    }

    public String getChallengePassword() {
        return this.challengePassword;
    }

    public void setChallengePassword(String val) {
        this.challengePassword = val;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrgUnitName1() {
        return this.orgUnitName1;
    }

    public void setOrgUnitName1(String orgUnitName1) {
        this.orgUnitName1 = orgUnitName1;
    }

    public String getOrgUnitName2() {
        return this.orgUnitName2;
    }

    public void setOrgUnitName2(String orgUnitName2) {
        this.orgUnitName2 = orgUnitName2;
    }

    public String getOrgUnitName3() {
        return this.orgUnitName3;
    }

    public void setOrgUnitName3(String orgUnitName3) {
        this.orgUnitName3 = orgUnitName3;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String localityName) {
        this.localityName = localityName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getDnQualifier() {
        return this.dnQualifier;
    }

    public void setDnQualifier(String dnQualifier) {
        this.dnQualifier = dnQualifier;
    }
}

