/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.ldap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.crypto.gui.ldap.LdapEndPoint;
import esecurity.crypto.gui.ldap.bcgqgqqk;
import esecurity.crypto.gui.ldap.cxcfmltg;
import esecurity.crypto.gui.properties.AppProperties;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LdapEndPointLoader {
    private static final EllipsLogger logger = LdapEndPointLoader.qr("1kc21st", Constants.CAPI_LOGGER_NAME);
    private static final File LDAP_DATA_FILE;
    private static final File DEFAULT_LDAP_DATA_FILE;
    private static List<LdapEndPoint> ldapDataLoader;

    public static void load() {
        ldapDataLoader = LdapEndPointLoader.loadFromFile();
    }

    public static List<LdapEndPoint> getEndPoints() {
        if (ldapDataLoader == null) {
            LdapEndPointLoader.load();
        }
        return ldapDataLoader;
    }

    public static void addEndPoint(LdapEndPoint endPoint) {
        LdapEndPointLoader.getEndPoints().add(endPoint);
    }

    public static void removeEndPoint(LdapEndPoint endPoint) {
        if (endPoint == null) {
            return;
        }
        LdapEndPointLoader.getEndPoints().remove(endPoint);
    }

    public static void removeEndPoint(String name) {
        if (name == null || LdapEndPointLoader.qr("-1v4hu4d", name) != false) {
            return;
        }
        List<LdapEndPoint> endPoints = LdapEndPointLoader.getEndPoints();
        boolean found = false;
        for (int i = 0; !found && i < endPoints.size(); ++i) {
            if (LdapEndPointLoader.qr("-1s4bu4b", name, LdapEndPointLoader.qr("5jc1ri", endPoints.get(i))) == false) continue;
            endPoints.remove(i);
            found = true;
        }
    }

    public static void saveToFile() {
        ObjectMapper om = new ObjectMapper();
        LdapEndPointLoader.qr("-hn7u4c", om, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, (boolean)false);
        try {
            LdapEndPointLoader.qr("es1sn", om, LDAP_DATA_FILE, LdapEndPointLoader.getEndPoints());
        }
        catch (IOException ex) {
            LdapEndPointLoader.qr("k0e1sp", logger, LdapEndPointLoader.qr("-1ccpu3a", ex), (Object)ex);
        }
    }

    private static List<LdapEndPoint> loadFromFile() {
        ArrayList<LdapEndPoint> endpoints = new ArrayList<LdapEndPoint>();
        ObjectMapper om = new ObjectMapper();
        LdapEndPointLoader.qr("-hn7u4c", om, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, (boolean)false);
        if (LdapEndPointLoader.qr("-18m1u38", DEFAULT_LDAP_DATA_FILE) != false) {
            try {
                LdapEndPointLoader.qr("q401sq", endpoints, (Collection)LdapEndPointLoader.qr("-1hlju35", om, DEFAULT_LDAP_DATA_FILE, (Object)new TypeReference<List<LdapEndPoint>>(){}));
            }
            catch (IOException ex) {
                LdapEndPointLoader.qr("k0e1sp", logger, LdapEndPointLoader.qr("-1ccpu3a", ex), (Object)ex);
            }
        }
        if (LdapEndPointLoader.qr("-18m1u38", LDAP_DATA_FILE) != false) {
            try {
                LdapEndPointLoader.qr("q401sq", endpoints, (Collection)LdapEndPointLoader.qr("-1hlju35", om, LDAP_DATA_FILE, (Object)new TypeReference<List<LdapEndPoint>>(){}));
            }
            catch (IOException ex) {
                LdapEndPointLoader.qr("k0e1sp", logger, LdapEndPointLoader.qr("-1ccpu3a", ex), (Object)ex);
            }
        }
        return endpoints;
    }

    static {
        char[] cArray = "\u3bc5\u2ae0\uadd3\u1e74\uf644\u4bcc\ufd4d\u20c1\ua1e9\u698b".toCharArray();
        cArray[6] = (char)(cArray[6] ^ 0x514E);
        LDAP_DATA_FILE = new File((String)LdapEndPointLoader.qr("11n21s1", LdapEndPointLoader.qr("-mn1u42", LdapEndPointLoader.qr("-mn1u42", LdapEndPointLoader.qr("-mn1u42", new StringBuilder(), LdapEndPointLoader.qr("4rk1rv", LdapEndPointLoader.qr("1g201ss"), AppProperties.WORK_FOLDER, (Object)"")), File.separator), bcgqgqqk.y(cArray, (short)9807, false, (byte)2))));
        char[] cArray2 = "\u00b7\ubec4\uef6d\ua662\ud5d6\uceeb\ud257\u1f92\u4e83\u4747\uca16\u4de3\u53d0\u2750".toCharArray();
        cArray2[6] = (char)(cArray2[6] ^ 0x6F25);
        DEFAULT_LDAP_DATA_FILE = new File((String)LdapEndPointLoader.qr("11n21s1", LdapEndPointLoader.qr("-mn1u42", LdapEndPointLoader.qr("-mn1u42", LdapEndPointLoader.qr("-mn1u42", new StringBuilder(), LdapEndPointLoader.qr("4rk1rv", LdapEndPointLoader.qr("1g201ss"), AppProperties.BASE_FOLDER, (Object)"")), File.separator), bcgqgqqk.y(cArray2, (short)16251, true, (byte)4))));
    }

    private static Object qr(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(cxcfmltg.N(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

