/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.cms.CadesSignedDataGeneratorProxy;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.LTResource;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.TimeStampGenerator;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.slf4j.Logger;

public class CadesUnSignedAttributeGenerator
implements CMSAttributeTableGenerator {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private final CadesSignatureOptions options;
    private final CadesSignedDataGeneratorProxy generator;
    private final LTResourceResolver resolver;
    private final X509Certificate x509Cert;
    private final boolean verifiedSigner;

    public CadesUnSignedAttributeGenerator(LTResourceResolver resolver, CadesSignatureOptions options, CadesSignedDataGeneratorProxy generator, X509Certificate x509Cert, boolean verifiedSigner) {
        this.options = options;
        this.resolver = resolver;
        this.generator = generator;
        this.x509Cert = x509Cert;
        this.verifiedSigner = verifiedSigner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
        ASN1EncodableVector objReturn;
        block22: {
            objReturn = new ASN1EncodableVector();
            try {
                block23: {
                    TimeStampToken tsToken;
                    block24: {
                        byte[] signature = (byte[])parameters.get("encryptedDigest");
                        if (this.verifiedSigner) {
                            try {
                                SignerInfo verifiedSignatureReturn = SignerInfo.getInstance((Object)((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])signature)));
                                signature = verifiedSignatureReturn.getEncryptedDigest().getOctets();
                            }
                            catch (Throwable verifiedSignatureReturn) {
                                // empty catch block
                            }
                        }
                        if (this.options.getSignatureLevel() == SignatureLevel.BES && !this.options.isResolveCertificateChainResources()) break block22;
                        if ((this.options.getTimeStampOptions() == null || this.options.getTimeStampOptions().getTSAClient() == null) && !this.options.isResolveCertificateChainResources()) break block23;
                        tsToken = null;
                        if (this.options.getTimeStampOptions() == null || this.options.getTimeStampOptions().getTSAClient() == null) break block24;
                        logger.debug("Signature TimeStampToken adding..");
                        ByteArrayInputStream is = null;
                        byte[] ts = null;
                        try {
                            is = new ByteArrayInputStream(signature);
                            ts = TimeStampGenerator.timestamp((TimeStampOptions)this.options.getTimeStampOptions(), (InputStream)is);
                        }
                        catch (Throwable throwable) {
                            Util.closeQuietly(is);
                            throw throwable;
                        }
                        Util.closeQuietly((Closeable)is);
                        tsToken = new TimeStampToken(ts);
                        byte[] tstByteArray = tsToken.toByteArray(false, true);
                        Attribute attr = this.getTSUnsignedAttribute(tstByteArray);
                        objReturn.add((ASN1Encodable)attr);
                        logger.debug("Signature TimeStampToken adding OK");
                    }
                    if (this.options.getSignatureLevel().compareTo((Enum)SignatureLevel.T) > 0 || this.options.isIncludeCertificateChain()) {
                        LTResource resolvedResource = this.resolver.resolve(this.x509Cert, tsToken.getDate());
                        for (X509Certificate cert : resolvedResource.getCerts()) {
                            this.generator.addCertByAttribute(cert);
                        }
                        for (CRL crl : resolvedResource.getCrls()) {
                            this.generator.addCRLByAttribute(crl);
                        }
                        for (OCSPResponse ocsp : resolvedResource.getOcsps()) {
                            this.generator.addBasicOCSPByAttribute(ocsp.getBasicOcspResponse());
                        }
                        if (tsToken != null) {
                            Certificate tsaCert = tsToken.getTSACert();
                            LTResource resolveTsaResource = this.resolver.resolve(tsaCert.getInternalCert(), tsToken.getDate());
                            for (X509Certificate cert : resolveTsaResource.getCerts()) {
                                this.generator.addCertByAttribute(cert);
                            }
                            for (CRL crl : resolveTsaResource.getCrls()) {
                                this.generator.addCRLByAttribute(crl);
                            }
                            for (OCSPResponse ocsp : resolveTsaResource.getOcsps()) {
                                this.generator.addBasicOCSPByAttribute(ocsp.getBasicOcspResponse());
                            }
                        }
                    }
                    if (this.options.getSignatureLevel() != SignatureLevel.LTA) break block22;
                }
                logger.error("Unable to generate unsigned attribute Time Stamp options is required ");
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute Time Stamp options is required");
            }
            catch (ApiGeneralException ex) {
                logger.error("Unable to generate unsigned attribute: " + ex.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + ex.getMessage());
            }
            catch (CapiException ex) {
                logger.error("Unable to generate unsigned attribute: " + ex.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + ex.getMessage(), (Exception)((Object)ex));
            }
            catch (CertificateEncodingException ex) {
                logger.error("Unable to generate unsigned attribute: " + ex.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + ex.getMessage());
            }
            catch (IOException ex) {
                logger.error("Unable to generate unsigned attribute: " + ex.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + ex.getMessage());
            }
            catch (CMSException ex) {
                logger.error("Unable to generate unsigned attribute: " + ex.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + ex.getMessage());
            }
            catch (CRLException ex) {
                logger.error("Unable to generate unsigned attribute: " + ex.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + ex.getMessage());
            }
            catch (CertificateException ex) {
                logger.error("Unable to generate unsigned attribute: " + ex.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + ex.getMessage());
            }
        }
        if (objReturn.size() == 0) {
            return null;
        }
        return new AttributeTable(objReturn);
    }

    private Attribute getTSUnsignedAttribute(byte[] tstByteArray) throws CapiException {
        try {
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(tstByteArray));
            ContentInfo ci = ContentInfo.getInstance((Object)extIn.readObject());
            Attribute attr = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((ASN1Encodable)ci));
            return attr;
        }
        catch (Exception x) {
            logger.error(x.getMessage(), (Throwable)x);
            throw new CapiException("Error adding signature Time Stamp Token", 50040);
        }
    }
}

