/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.slf4j.Logger;

public class CadesSignedAttributeGenerator
implements CMSAttributeTableGenerator {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private CadesSignatureOptions options;
    private X509Certificate cert;

    public CadesSignedAttributeGenerator(CadesSignatureOptions options, X509Certificate cert) {
        this.options = options;
        this.cert = cert;
    }

    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
        AttributeTable objReturn = null;
        try {
            Attribute attr;
            MessageDigest digester;
            byte[] digest = (byte[])parameters.get("digest");
            if (this.options.getDetachedContent() != null && this.options.getSignatureMode().equals((Object)SignatureMode.DETACHED)) {
                digest = Utils.toByteArray((InputStream)this.options.getDetachedContent().getInputAsNewStream());
            }
            ASN1EncodableVector hashTabAtt = new ASN1EncodableVector();
            IssuerSerial issSerial = new IssuerSerial(new GeneralNames(new GeneralName(JcaX500NameUtil.getIssuer((X509Certificate)this.cert))), new ASN1Integer(this.cert.getSerialNumber()));
            if (this.options.getDigestAlgorithm().getId().compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
                logger.debug("using SHA1 digest ...");
                digester = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
                ESSCertID essCertid = new ESSCertID(digester.digest(this.cert.getEncoded()), issSerial);
                Attribute attr2 = new Attribute(SignedData.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate(essCertid)));
                hashTabAtt.add((ASN1Encodable)attr2);
            } else {
                logger.debug("using V2 digest ...");
                digester = MessageDigest.getInstance(this.options.getDigestAlgorithm().getId(), ProvUtils.bcProvider);
                ESSCertIDv2 essCertidv2 = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.options.getDigestAlgorithm().getId())), digester.digest(this.cert.getEncoded()), issSerial);
                ESSCertIDv2[] essCertArray = new ESSCertIDv2[]{essCertidv2};
                Attribute attr3 = new Attribute(SignedData.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificateV2(essCertArray)));
                hashTabAtt.add((ASN1Encodable)attr3);
            }
            if (!(!Util.isNullOrEmpty((String)this.options.getSignaturePath()) || this.options instanceof CadesSignatureOptions && this.options.isCounterSignature())) {
                attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
                hashTabAtt.add((ASN1Encodable)attr);
            }
            if (this.options.isIncludeSigningTime()) {
                logger.debug("time is always true, including SigningTime!!");
                if (this.options.getSigningTime() != null) {
                    attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(this.options.getSigningTime())));
                    hashTabAtt.add((ASN1Encodable)attr);
                } else {
                    Date d = new Date();
                    Attribute attr4 = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(d)));
                    hashTabAtt.add((ASN1Encodable)attr4);
                }
            }
            attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(digest)));
            hashTabAtt.add((ASN1Encodable)attr);
            objReturn = new AttributeTable(hashTabAtt);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("Unable to generate signed attribute");
            throw new CMSAttributeTableGenerationException("Unable to generate signed attribute", (Exception)ex);
        }
        catch (CertificateEncodingException ex) {
            logger.error("Unable to generate signed attribute");
            throw new CMSAttributeTableGenerationException("Unable to generate signed attribute", (Exception)ex);
        }
        catch (IOException ex) {
            logger.error("Unable to generate signed attribute");
            throw new CMSAttributeTableGenerationException("Unable to generate signed attribute", (Exception)ex);
        }
        return objReturn;
    }
}

