/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xades;

import esecurity.dts.TimeStampToken;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.bc.Base64;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.LTResource;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.TimeStampGenerator;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.util.SignUtils;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.capi.xades.XadesTransformation;
import it.actalis.ellips.capi.xades.enums.XadesSignatureProfile;
import it.actalis.ellips.capi.xades.exception.XadesModeException;
import it.actalis.ellips.capi.xml.DOMSubTreeData;
import it.actalis.ellips.capi.xml.InternalKeySelector;
import it.actalis.ellips.capi.xml.InternalUriDereferencer;
import it.actalis.ellips.capi.xml.utils.XMLUtils;
import it.actalis.vol.utils.Constants;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XadesDocument {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Document currentDocument = null;
    private DocumentBuilder db;
    private String referredStylesheet = null;
    private ProcessingInstruction nodeStylesheet = null;
    private String baseUri = "";
    private boolean isXml = false;
    private DOMSignContext currentContext = null;
    private XMLSignature currentSignature = null;
    private NodeList currentSignatureList = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private String bodyId = "";

    XadesDocument(InputHandler in) throws CapiException {
        InputStream ins = null;
        try {
            ins = in.getInputAsNewStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.db = dbf.newDocumentBuilder();
            try {
                this.currentDocument = this.db.parse(ins);
                this.lookForPI(this.currentDocument);
                this.setIdObject(this.currentDocument);
                this.isXml = true;
                NodeList bodyElements = this.currentDocument.getElementsByTagName("soapenv:Body");
                if (bodyElements != null && bodyElements.getLength() > 0) {
                    Element bodyElem = (Element)bodyElements.item(0);
                    if (bodyElem != null && bodyElem.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
                        this.bodyId = bodyElem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    } else if (bodyElem != null && bodyElem.hasAttribute("Id")) {
                        this.bodyId = bodyElem.getAttribute("Id");
                    }
                }
            }
            catch (SAXException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Envelope format unknown or not implemented", 50023);
        }
    }

    Document createSoapSignature(XadesSignatureOptions options, X509Certificate x509Cert, PrivateKey privateKey, Provider prov) throws CapiException, CertificateEncodingException {
        logger.debug("[addSigner] generating SOAP ENVELOPED Signature...");
        long time = System.currentTimeMillis();
        String signerid = "Signer-T-" + time;
        if (options.getSignerId() != null) {
            signerid = options.getSignerId();
        }
        LinkedList objects = new LinkedList();
        LinkedList<Reference> references = new LinkedList<Reference>();
        this.checkCanAdd(this.currentDocument, options.getSignatureMode());
        XMLSignatureFactory fac = XMLUtils.getXMLSignatureFactoryInstance();
        NodeList timestampElements = this.currentDocument.getElementsByTagName("wsu:Timestamp");
        if (timestampElements != null && timestampElements.getLength() > 0) {
            Element timestamp = (Element)timestampElements.item(0);
            timestamp.setAttribute("Id", "Timestamp");
            timestamp.setIdAttribute("Id", true);
            timestamp.setAttribute("xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            Date date = new Date();
            Date date_hour = new Date(date.getTime() + 3600000L);
            Element created = this.currentDocument.createElement("wsu:Created");
            created.setTextContent(this.formatter.format(date));
            Element expires = this.currentDocument.createElement("wsu:Expires");
            expires.setTextContent(this.formatter.format(date_hour));
            timestamp.appendChild(created);
            timestamp.appendChild(expires);
            this.currentDocument.getElementsByTagName("wsse:Security").item(0).appendChild(timestamp);
            Element binarySecurityToken = this.currentDocument.createElement("wsse:BinarySecurityToken");
            binarySecurityToken.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            binarySecurityToken.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            binarySecurityToken.setAttribute("Id", "X509Token");
            binarySecurityToken.setIdAttribute("Id", true);
            binarySecurityToken.setTextContent(new String(Base64.encode((byte[])x509Cert.getEncoded())));
            this.currentDocument.getElementsByTagName("wsse:Security").item(0).appendChild(binarySecurityToken);
            if (this.currentDocument == null) {
                throw new CapiException("Mimetype: " + options.getXmlMimetype() + " Enveloped Signature requires text/xml", 50025);
            }
            try {
                this.currentContext = new DOMSignContext(privateKey, this.currentDocument.getElementsByTagName("wsse:Security").item(0));
                this.currentContext.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
                NodeList bodyElements = this.currentDocument.getElementsByTagName("soapenv:Body");
                Element bodyElem = null;
                if (bodyElements != null && bodyElements.getLength() > 0) {
                    bodyElem = (Element)bodyElements.item(0);
                    if (bodyElem != null && bodyElem.hasAttributeNS(this.baseUri, this.baseUri)) {
                        bodyElem.setIdAttribute("wsu:Id", true);
                    } else if (bodyElem != null && bodyElem.hasAttribute("Id")) {
                        bodyElem.setIdAttribute("Id", true);
                    } else {
                        throw new CapiException("Attribute Id not found inside soap:body element!", 50025);
                    }
                }
                if (bodyElem == null) {
                    throw new CapiException("Element soap:body not found in document!", 50025);
                }
                ((Element)this.currentDocument.getElementsByTagName("wsu:Timestamp").item(0)).setIdAttribute("Id", true);
                Element tokenRefToken = this.currentDocument.createElement("wsse:SecurityTokenReference");
                Element tokenRef = this.currentDocument.createElement("wsse:Reference");
                tokenRefToken.appendChild(tokenRef);
                tokenRef.setAttribute("URI", "#X509Token");
                KeyInfoFactory kfac = fac.getKeyInfoFactory();
                KeyInfo ki = kfac.newKeyInfo(Collections.singletonList(new DOMStructure(tokenRefToken)), null);
                references.add(fac.newReference("#" + timestamp.getAttribute("Id"), fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null)), null, null));
                references.add(fac.newReference("#" + bodyElem.getAttribute("Id"), fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null)));
                CanonicalizationMethod cm = fac.newCanonicalizationMethod(options.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
                String sigMethod = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)options.getDigestAlgorithm()).getXadesName();
                SignedInfo info = fac.newSignedInfo(cm, fac.newSignatureMethod(sigMethod, null), references);
                this.currentSignature = fac.newXMLSignature(info, ki, objects, null, null);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                if (e instanceof CapiException) {
                    throw (CapiException)e;
                }
                throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
            }
            LinkedList<X509Certificate> lstCertOnEncapsulatedCert = new LinkedList<X509Certificate>();
            LinkedList<OCSPResp> lstOcspResp = new LinkedList<OCSPResp>();
            LinkedList<CRL> lstCrlResp = new LinkedList<CRL>();
            this.currentContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            this.currentContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", prov);
            this.sign(x509Cert);
            this.addXadesCertificateValues(this.currentSignature, this.currentDocument, lstCertOnEncapsulatedCert);
            this.addOCSPValues(this.currentSignature, this.currentDocument, lstOcspResp);
            this.addCRLValues(this.currentSignature, this.currentDocument, lstCrlResp);
            return this.currentDocument;
        }
        throw new CapiException("Timestamp Element not found!", 1003);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Document createXadesSignature(XadesSignatureOptions options, X509Certificate signerCert, PrivateKey privateKey, Provider prov) throws CapiException {
        Element signatureToBeCSigned = null;
        if (options.getSignaturePath() != null && !options.getSignaturePath().isEmpty() && (signatureToBeCSigned = this.retrieveSignatureToCounterSign(options.getSignaturePath())) == null) {
            throw new CapiException("Invalid Signature Path", 1003);
        }
        if (signatureToBeCSigned == null) {
            this.checkCanAdd(this.currentDocument, options.getSignatureMode());
            try {
                Element node;
                int i;
                XPath xPath = XPathFactory.newInstance().newXPath();
                NodeList nodes = (NodeList)xPath.evaluate("//*[@id]", this.currentDocument, XPathConstants.NODESET);
                for (i = 0; i < nodes.getLength(); ++i) {
                    node = (Element)nodes.item(i);
                    node.setIdAttribute("id", true);
                }
                nodes = (NodeList)xPath.evaluate("//*[@Id]", this.currentDocument, XPathConstants.NODESET);
                for (i = 0; i < nodes.getLength(); ++i) {
                    node = (Element)nodes.item(i);
                    node.setIdAttribute("Id", true);
                }
                nodes = (NodeList)xPath.evaluate("//*[@ID]", this.currentDocument, XPathConstants.NODESET);
                for (i = 0; i < nodes.getLength(); ++i) {
                    node = (Element)nodes.item(i);
                    node.setIdAttribute("ID", true);
                }
            }
            catch (XPathExpressionException xpee) {
                logger.error(xpee.getMessage(), (Throwable)xpee);
            }
            if (options.getSignatureMode() == SignatureMode.DETACHED) {
                this.generateDetached(options, signerCert, privateKey);
            } else if (options.getSignatureMode() == SignatureMode.ENVELOPED) {
                this.generateEnveloped(options, signerCert, privateKey, false);
            } else if (options.getSignatureMode() == SignatureMode.ENVELOPING) {
                this.generateEnveloping(options, signerCert, privateKey);
            } else {
                if (options.getSignatureMode() != SignatureMode.DETACHED_INTERNAL) throw new CapiException("Invalid Xades Mode", 50026);
                this.generateDetachedInternal(options, signerCert, privateKey);
            }
        } else {
            this.generateCounterSignature(options, signerCert, signatureToBeCSigned, privateKey);
        }
        this.currentContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        this.currentContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", prov);
        try {
            this.sign(signerCert);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        LinkedList<X509Certificate> lstCertOnEncapsulatedCert = new LinkedList<X509Certificate>();
        LinkedList<OCSPResp> lstOcspResp = new LinkedList<OCSPResp>();
        LinkedList<CRL> lstCrlResp = new LinkedList<CRL>();
        if (options.getSignatureLevel() != SignatureLevel.BES && options.getTimeStampOptions() != null) {
            TimeStampToken tsToken = this.addSignatureTimeStamp(this.currentSignature, this.currentDocument, options);
            Certificate currentTsaCert = tsToken.getTSACert();
            if (!lstCertOnEncapsulatedCert.contains(currentTsaCert.getInternalCert())) {
                lstCertOnEncapsulatedCert.add(currentTsaCert.getInternalCert());
            }
            if (options.getSignatureLevel().compareTo((Enum)SignatureLevel.T) > 0) {
                try {
                    LTResourceResolver resourceResolver = new LTResourceResolver(options.getNetworkConfig(), logger, options.getCertdb());
                    LTResource signerResolvedRes = resourceResolver.resolve(signerCert, tsToken.getDate());
                    for (X509Certificate cert : signerResolvedRes.getCerts()) {
                        if (lstCertOnEncapsulatedCert.contains(cert)) continue;
                        lstCertOnEncapsulatedCert.add(cert);
                    }
                    for (CRL crl : signerResolvedRes.getCrls()) {
                        if (lstCrlResp.contains(crl)) continue;
                        lstCrlResp.add(crl);
                    }
                    for (OCSPResponse ocsp : signerResolvedRes.getOcsps()) {
                        if (lstOcspResp.contains(ocsp)) continue;
                        lstOcspResp.add(ocsp.getFullOcspResponse());
                    }
                    LTResource tsaResolvedRes = resourceResolver.resolve(currentTsaCert.getInternalCert(), tsToken.getDate());
                    for (X509Certificate cert : tsaResolvedRes.getCerts()) {
                        if (lstCertOnEncapsulatedCert.contains(cert)) continue;
                        lstCertOnEncapsulatedCert.add(cert);
                    }
                    for (CRL crl : tsaResolvedRes.getCrls()) {
                        if (lstCrlResp.contains(crl)) continue;
                        lstCrlResp.add(crl);
                    }
                    for (OCSPResponse ocsp : tsaResolvedRes.getOcsps()) {
                        if (lstOcspResp.contains(ocsp)) continue;
                        lstOcspResp.add(ocsp.getFullOcspResponse());
                    }
                }
                catch (IOException | CertificateException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    throw new CapiException("Unable to resolve resources for certificate", 50040, (Throwable)ex);
                }
            }
        }
        this.addXadesCertificateValues(this.currentSignature, this.currentDocument, lstCertOnEncapsulatedCert);
        this.addOCSPValues(this.currentSignature, this.currentDocument, lstOcspResp);
        this.addCRLValues(this.currentSignature, this.currentDocument, lstCrlResp);
        return this.currentDocument;
    }

    private void sign(X509Certificate signerCert) throws CapiException {
        try {
            Certificate cert = new Certificate(signerCert.getEncoded());
            if (cert.isRsVerified()) {
                throw new UnsupportedOperationException("to be ported from XMLSEC");
            }
            this.currentSignature.sign(this.currentContext);
        }
        catch (MarshalException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new CapiException("MarshalException error occurred: " + ex.getMessage(), 50025, (Throwable)ex);
        }
        catch (XMLSignatureException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new CapiException("XMLSignatureException error occurred: " + ex.getMessage(), 50025, (Throwable)ex);
        }
        catch (CertificateEncodingException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new CapiException("CertificateEncodingException error occurred: " + ex.getMessage(), 50025, (Throwable)ex);
        }
    }

    private void generateDetachedInternal(XadesSignatureOptions options, X509Certificate x509Cert, PrivateKey privateKey) throws CapiException {
        Document signedDoc;
        block32: {
            logger.debug("[addSigner] generating XML DETACHED internal Signature...");
            InputStream in = null;
            signedDoc = this.db.newDocument();
            long time = System.currentTimeMillis();
            String signerid = "Signer-T-" + time;
            if (options.getSignerId() != null) {
                signerid = options.getSignerId();
            }
            LinkedList<XMLObject> objects = new LinkedList<XMLObject>();
            LinkedList<Transform> transforms = new LinkedList<Transform>();
            LinkedList<Reference> references = new LinkedList<Reference>();
            XMLSignatureFactory fac = XMLUtils.getXMLSignatureFactoryInstance();
            try {
                in = options.getInput().getInputAsNewStream();
                if (this.currentDocument != null) {
                    String objectId;
                    Element root;
                    if (this.currentSignatureList != null && this.currentSignatureList.getLength() > 0) {
                        signedDoc = this.currentDocument;
                        root = null;
                        String rootName = this.currentDocument.getDocumentElement().getTagName();
                        if (rootName.endsWith(":Signature") || rootName.compareToIgnoreCase("Signature") == 0) {
                            Element oldroot = this.currentDocument.getDocumentElement();
                            Node dsClone = this.currentDocument.getDocumentElement().cloneNode(true);
                            root = this.currentDocument.createElement("Envelope");
                            root.appendChild(dsClone);
                            this.currentDocument.replaceChild(root, oldroot);
                            this.setIdObject(this.currentDocument);
                        } else {
                            root = this.currentDocument.getDocumentElement();
                        }
                        this.currentContext = new DOMSignContext(privateKey, (Node)root);
                        this.currentContext.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
                        objectId = null;
                        if (!this.addTransformations(signedDoc, transforms, options.getXmlTransforms(), fac)) {
                            transforms = null;
                        }
                        if (options.getXmlTargetID() != null) {
                            objectId = options.getXmlTargetID();
                        } else {
                            String dsObjectId = "";
                            Node dsObjectNode = this.lookForChild(this.currentDocument.getDocumentElement(), "Object");
                            if (dsObjectNode != null && dsObjectNode.hasAttributes() && dsObjectNode.getAttributes().getNamedItem("Id") != null) {
                                dsObjectId = dsObjectNode.getAttributes().getNamedItem("Id").getTextContent();
                            } else {
                                Node dsSignatureNode = this.lookForChild(this.currentDocument.getDocumentElement(), "Signature");
                                if (dsSignatureNode != null && (dsObjectNode = this.lookForChild(dsSignatureNode, "Object")) != null && dsObjectNode.hasAttributes() && dsObjectNode.getAttributes().getNamedItem("Id") != null) {
                                    dsObjectId = "xpointer(id('" + dsObjectNode.getAttributes().getNamedItem("Id").getTextContent() + "'))";
                                }
                            }
                            objectId = dsObjectId;
                        }
                        references.add(fac.newReference("#" + objectId, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), transforms, null, "r-doc-" + signerid));
                    } else {
                        root = signedDoc.createElement("Envelope");
                        signedDoc.appendChild(root);
                        this.currentContext = new DOMSignContext(privateKey, (Node)root);
                        this.currentContext.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
                        Element object = signedDoc.createElement("ds:Object");
                        objectId = "ToBeSigned" + time;
                        object.setAttribute("Id", objectId);
                        object.setAttribute("Encoding", "UTF-8");
                        object.setAttribute("MimeTYpe", "text/xml");
                        object.setIdAttribute("Id", true);
                        object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
                        root.appendChild(object);
                        if (this.currentDocument != null) {
                            if (this.nodeStylesheet != null) {
                                object.appendChild(signedDoc.createProcessingInstruction(this.nodeStylesheet.getTarget(), this.nodeStylesheet.getData()));
                            }
                            Node elem = signedDoc.importNode(this.currentDocument.getDocumentElement(), true);
                            object.appendChild(elem);
                        } else {
                            String line;
                            BufferedReader dis = new BufferedReader(new InputStreamReader(in));
                            StringBuilder fBuf = new StringBuilder();
                            while ((line = dis.readLine()) != null) {
                                fBuf.append(line.concat("\n"));
                            }
                            in.close();
                            object.appendChild(signedDoc.createTextNode(fBuf.toString()));
                        }
                        if (!this.addTransformations(signedDoc, transforms, options.getXmlTransforms(), fac)) {
                            transforms = null;
                        }
                        references.add(fac.newReference("#" + objectId, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), transforms, null, "r-doc-" + signerid));
                    }
                    Date signingTime = options.getSigningTime();
                    if (signingTime == null) {
                        signingTime = new Date();
                    }
                    if (this.referredStylesheet != null) {
                        Reference ref = fac.newReference(this.referredStylesheet, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, null, "r-stylesheet-" + signerid);
                        try {
                            this.currentContext.getURIDereferencer().dereference(new DOMURIReference(){

                                @Override
                                public Node getHere() {
                                    return XadesDocument.this.nodeStylesheet;
                                }

                                @Override
                                public String getURI() {
                                    return XadesDocument.this.referredStylesheet;
                                }

                                @Override
                                public String getType() {
                                    return "http://uri.etsi.org/01903#SignedProperties";
                                }
                            }, this.currentContext);
                            references.add(ref);
                        }
                        catch (NullPointerException | URIReferenceException ex) {
                            logger.warn("Can't add {} to referenced signature", (Object)ref.getURI());
                        }
                    }
                    references.add(fac.newReference("#SignedProperties-" + signerid, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, "http://uri.etsi.org/01903#SignedProperties", null));
                    LinkedList<X509Certificate> lstCertOnKeyInfo = new LinkedList<X509Certificate>();
                    lstCertOnKeyInfo.add(x509Cert);
                    KeyInfoFactory kfac = fac.getKeyInfoFactory();
                    X509Data kv = kfac.newX509Data(lstCertOnKeyInfo);
                    String keyInfoID = "KeyInfo-" + signerid;
                    KeyInfo ki = kfac.newKeyInfo(Collections.singletonList(kv), keyInfoID);
                    references.add(fac.newReference("#" + keyInfoID, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, null, "r-keyinfo-" + signerid));
                    objects.add(this.addXadesAttribute(options, signingTime, fac, signedDoc, x509Cert, signerid, references));
                    CanonicalizationMethod cm = fac.newCanonicalizationMethod(options.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
                    String sigMethod = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)options.getDigestAlgorithm()).getXadesName();
                    SignedInfo info = fac.newSignedInfo(cm, fac.newSignatureMethod(sigMethod, null), references);
                    this.currentSignature = fac.newXMLSignature(info, ki, objects, signerid, "SignatureValue-" + signerid);
                    break block32;
                }
                throw new CapiException("Unable make Dethaced Interna if XML file", 50050);
            }
            catch (RuntimeException e) {
                if (e.getMessage().equals("Interrupted by user")) {
                    throw new CapiException("Interrupted by user", 50052);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw new CapiException("RuntimeException" + e.getMessage(), 50025);
            }
            catch (CapiException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw e;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
            }
            finally {
                Util.closeQuietly((Closeable)in);
            }
        }
        this.currentDocument = signedDoc;
    }

    private void generateDetached(XadesSignatureOptions options, X509Certificate x509Cert, PrivateKey privateKey) throws CapiException {
        logger.debug("[addSigner] generating XML DETACHED Signature...");
        XMLSignatureFactory fac = XMLUtils.getXMLSignatureFactoryInstance();
        long time = System.currentTimeMillis();
        String signerid = "Signer-T-" + time;
        if (options.getSignerId() != null) {
            signerid = options.getSignerId();
        }
        LinkedList<XMLObject> objects = new LinkedList<XMLObject>();
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        LinkedList<Reference> references = new LinkedList<Reference>();
        InputStream in = null;
        try {
            Date signingTime;
            in = options.getInput().getInputAsNewStream();
            this.currentDocument = this.db.newDocument();
            this.currentContext = new DOMSignContext(privateKey, (Node)this.currentDocument);
            InternalUriDereferencer resolver = new InternalUriDereferencer(null, null, null);
            this.currentContext.setURIDereferencer((URIDereferencer)resolver);
            resolver.addDocument(options.getInput());
            if (options.getSignerId() != null) {
                signerid = options.getSignerId();
            }
            if ((signingTime = options.getSigningTime()) == null) {
                signingTime = new Date();
            }
            if (!this.addTransformations(this.currentDocument, transforms, options.getXmlTransforms(), fac)) {
                transforms = null;
            }
            for (int i = 0; i < options.getDetachedURI().size(); ++i) {
                references.add(fac.newReference((String)options.getDetachedURI().get(i), fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), transforms, null, "r-id-1"));
            }
            references.add(fac.newReference(options.getInput().getName(), fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), transforms, null, "r-doc-" + signerid));
            if (this.referredStylesheet != null) {
                Reference ref = fac.newReference(this.referredStylesheet, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, null, "r-stylesheet-" + signerid);
                try {
                    this.currentContext.getURIDereferencer().dereference(new DOMURIReference(){

                        @Override
                        public Node getHere() {
                            return XadesDocument.this.nodeStylesheet;
                        }

                        @Override
                        public String getURI() {
                            return XadesDocument.this.referredStylesheet;
                        }

                        @Override
                        public String getType() {
                            return "http://uri.etsi.org/01903#SignedProperties";
                        }
                    }, this.currentContext);
                    references.add(ref);
                }
                catch (NullPointerException | URIReferenceException ex) {
                    logger.warn("Can't add {} to referenced signature", (Object)ref.getURI());
                }
            }
            references.add(fac.newReference("#SignedProperties-" + signerid, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, "http://uri.etsi.org/01903#SignedProperties", null));
            LinkedList<X509Certificate> lstCertOnKeyInfo = new LinkedList<X509Certificate>();
            lstCertOnKeyInfo.add(x509Cert);
            KeyInfoFactory kfac = fac.getKeyInfoFactory();
            X509Data kv = kfac.newX509Data(lstCertOnKeyInfo);
            String keyInfoID = "KeyInfo-" + signerid;
            KeyInfo ki = kfac.newKeyInfo(Collections.singletonList(kv), keyInfoID);
            references.add(fac.newReference("#" + keyInfoID, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, null, "r-keyinfo-" + signerid));
            objects.add(this.addXadesAttribute(options, signingTime, fac, this.currentDocument, x509Cert, signerid, references));
            CanonicalizationMethod cm = fac.newCanonicalizationMethod(options.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
            String sigMethod = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)options.getDigestAlgorithm()).getXadesName();
            SignedInfo info = fac.newSignedInfo(cm, fac.newSignatureMethod(sigMethod, null), references);
            this.currentSignature = fac.newXMLSignature(info, ki, objects, signerid, "SignatureValue-" + signerid);
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("Interrupted by user")) {
                throw new CapiException("Interrupted by user", 50052);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("RuntimeException" + e.getMessage(), 50025);
        }
        catch (CapiException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
        }
        finally {
            Util.closeQuietly((Closeable)in);
        }
    }

    private Node lookForChild(Node father, String childEndWith) {
        if (!father.hasChildNodes()) {
            return null;
        }
        NodeList children = father.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            short type = children.item(i).getNodeType();
            if (type != 1 || !children.item(i).getNodeName().endsWith(childEndWith)) continue;
            return children.item(i);
        }
        return null;
    }

    private void addXadesCertificateValues(XMLSignature sig, Document doc, List<X509Certificate> lstCert) throws CapiException {
        if (lstCert != null && lstCert.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("[addCertificateValues] Add Additional  X509Certificate Values...");
            }
            Node unsignedSignatureProperties = this.retrieveUnsignedSignaturePropertiesNode(sig, doc);
            Element certificateValues = doc.createElement("xades:CertificateValues");
            unsignedSignatureProperties.appendChild(certificateValues);
            for (X509Certificate cert : lstCert) {
                try {
                    Element eCert = doc.createElement("xades:EncapsulatedX509Certificate");
                    String eCertPEM = Util.base64EncodeStr((byte[])cert.getEncoded());
                    Text textNode = doc.createTextNode(eCertPEM);
                    eCert.appendChild(textNode);
                    certificateValues.appendChild(eCert);
                }
                catch (CertificateEncodingException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    throw new CapiException("Unable To Encode Cert", 50050);
                }
            }
        }
    }

    private Node retrieveXadesRevocationValues(XMLSignature sig, Document doc) throws CapiException {
        try {
            Node unsignedSignatureProperties = this.retrieveUnsignedSignaturePropertiesNode(sig, doc);
            Element rv = (Element)this.lookForChild(unsignedSignatureProperties, "RevocationValues");
            if (rv == null) {
                rv = doc.createElement("xades:RevocationValues");
                unsignedSignatureProperties.appendChild(rv);
            }
            return rv;
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new CapiException("An error occurred adding retrieveXadesRevocationValues", 50025);
        }
    }

    private void addCRLValues(XMLSignature sig, Document doc, List<CRL> lstCrl) throws CapiException {
        if (lstCrl != null && lstCrl.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("[addCertificateValues] Add Additional  X509Certificate Values...");
            }
            Element rv = (Element)this.retrieveXadesRevocationValues(sig, doc);
            Element crlValues = doc.createElement("xades:CRLValues");
            rv.appendChild(crlValues);
            for (CRL cert : lstCrl) {
                try {
                    Element eCrl = doc.createElement("xades:EncapsulatedCRLValue");
                    String eCrlPEM = Util.base64EncodeStr((byte[])cert.getInternalCRL().getEncoded());
                    Text textNode = doc.createTextNode(eCrlPEM);
                    eCrl.appendChild(textNode);
                    crlValues.appendChild(eCrl);
                }
                catch (CRLException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    throw new CapiException("Unable To Encode Cert", 50050);
                }
            }
        }
    }

    private void addOCSPValues(XMLSignature sig, Document doc, List<OCSPResp> lstOcsp) throws CapiException {
        if (lstOcsp != null && lstOcsp.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("[addCertificateValues] Add Additional  X509Certificate Values...");
            }
            Element rv = (Element)this.retrieveXadesRevocationValues(sig, doc);
            Element ocspValues = doc.createElement("xades:OCSPValues");
            rv.appendChild(ocspValues);
            for (OCSPResp ocsp : lstOcsp) {
                try {
                    Element eOcsp = doc.createElement("xades:EncapsulatedOCSPValue");
                    String eOcspPEM = Util.base64EncodeStr((byte[])ocsp.getEncoded());
                    eOcsp.appendChild(doc.createTextNode(eOcspPEM));
                    ocspValues.appendChild(eOcsp);
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    throw new CapiException("Unable To Encode Cert", 50050);
                }
            }
        }
    }

    private TimeStampToken addSignatureTimeStamp(XMLSignature sig, Document doc, XadesSignatureOptions options) throws CapiException {
        Element addingSigTimeStamp = null;
        if (logger.isDebugEnabled()) {
            logger.debug("[addSignatureTimeStamp] getting Time Stamp Token from TSA ...");
        }
        byte[] timeStampToken = null;
        try {
            String sigId = sig.getId();
            Element sigEl = doc.getElementById(sigId);
            Element sv = (Element)this.lookForChild(sigEl, "SignatureValue");
            String svId = sv.getAttribute("Id");
            if (svId == null || svId.equals("")) {
                svId = "SignatureValue-" + sigId;
                sv.setAttributeNS(null, "Id", svId);
                sv.setIdAttribute("Id", true);
                logger.info("[addSigner] Signature Value Id setted to: " + svId);
            } else {
                logger.info("[addSigner] Signature Value Id is: " + svId);
            }
            TransformService service = TransformService.getInstance("http://www.w3.org/2006/12/xml-c14n11#WithComments", "DOM");
            DOMValidateContext context = new DOMValidateContext((KeySelector)new InternalKeySelector(null), (Node)sv);
            service.init(new DOMStructure(sv), null);
            Data data = service.transform((Data)new DOMSubTreeData((Node)sv, false), context);
            InputStream is = ((OctetStreamData)data).getOctetStream();
            byte[] canonicalizedsigValue = IOUtils.toByteArray((InputStream)is);
            timeStampToken = this.getTimeStamp(canonicalizedsigValue, options);
        }
        catch (CapiException e) {
            if (e instanceof TSAException) {
                throw e;
            }
            throw new CapiException(e.getMessage(), 50053);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | TransformException e) {
            throw new CapiException("Invalid Canonicalizer Exception generating Time Stamp Token", 50053);
        }
        catch (IOException e) {
            throw new CapiException("Invalid Exception generating Time Stamp Token", 50053);
        }
        if (timeStampToken == null) {
            throw new CapiException("An error occurred getting Time Stamp Token from TSA", 50053);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[addSignatureTimeStamp] Time Stamp Token received from TSA.");
        }
        String tstampPEM = Util.base64EncodeStr((byte[])timeStampToken);
        if (logger.isDebugEnabled()) {
            logger.debug("[addSignatureTimeStamp] Time Stamp Token has been base64 encoded.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[addSignatureTimeStamp] SignatureTimeStamp node preparing ...");
        }
        Node usp = this.retrieveUnsignedSignaturePropertiesNode(sig, doc);
        addingSigTimeStamp = doc.createElement("xades:SignatureTimeStamp");
        usp.appendChild(addingSigTimeStamp);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("[addSignatureTimeStamp] setting CanonicalizationMethod...");
            }
            Element can = doc.createElement("ds:CanonicalizationMethod");
            can.setAttributeNS(null, "Algorithm", "http://www.w3.org/2006/12/xml-c14n11#WithComments");
            addingSigTimeStamp.appendChild(can);
            if (logger.isDebugEnabled()) {
                logger.debug("[addSignatureTimeStamp] setting EncapsulatedTimeStamp...");
            }
            Element encTimeStamp = doc.createElement("xades:EncapsulatedTimeStamp");
            encTimeStamp.setAttributeNS(null, "Encoding", "http://uri.etsi.org/01903/v1.2.2#DER");
            addingSigTimeStamp.appendChild(encTimeStamp);
            if (logger.isDebugEnabled()) {
                logger.debug("[addSignatureTimeStamp] setting Base64TimeStamp...to: " + tstampPEM);
            }
            Text textNode = doc.createTextNode(tstampPEM);
            encTimeStamp.appendChild(textNode);
            if (logger.isDebugEnabled()) {
                logger.debug("[addSignatureTimeStamp] SignatureTimeStamp generated.");
            }
            return new TimeStampToken(timeStampToken);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("[addSignatureTimeStamp] Error generating SignatureTimeStamp" + e.getMessage());
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error generating SignatureTimeStamp", 50023);
        }
    }

    private Node retrieveUnsignedSignaturePropertiesNode(XMLSignature sig, Document doc) throws CapiException {
        String signerId = null;
        Node usp = null;
        try {
            signerId = sig.getId();
            if (signerId == null || signerId.equals("")) {
                long time = System.currentTimeMillis();
                signerId = "Signer-T-" + time;
            }
            int nObj = sig.getObjects().size();
            Node qp = null;
            for (int obj = 0; obj < nObj; ++obj) {
                List<XMLStructure> objElements = sig.getObjects().get(obj).getContent();
                for (XMLStructure element : objElements) {
                    if (!(element instanceof DOMStructure) || !((DOMStructure)element).getNode().getNodeName().endsWith("QualifyingProperties")) continue;
                    qp = (Element)((DOMStructure)element).getNode();
                    break;
                }
                if (qp != null) break;
            }
            if (qp != null) {
                Node up = this.lookForChild(qp, "UnsignedProperties");
                if (up == null) {
                    up = doc.createElement("xades:UnsignedProperties");
                    qp.appendChild(up);
                    usp = doc.createElement("xades:UnsignedSignatureProperties");
                    up.appendChild(usp);
                } else {
                    usp = this.lookForChild(up, "UnsignedSignatureProperties");
                }
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("An error occurred adding signature time stamp", 50025);
        }
        return usp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTimeStamp(byte[] message, XadesSignatureOptions options) throws CapiException {
        ByteArrayInputStream is = null;
        byte[] ts = null;
        try {
            is = new ByteArrayInputStream(message);
            ts = TimeStampGenerator.timestamp((TimeStampOptions)options.getTimeStampOptions(), (InputStream)is);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(is);
            throw throwable;
        }
        Util.closeQuietly((Closeable)is);
        return ts;
    }

    private Element retrieveUnsignedPropertyElement(Element signature) {
        Node node;
        Element qp = null;
        for (int iNode = 0; iNode < signature.getChildNodes().getLength() && (qp = (Element)this.lookForChild(node = signature.getChildNodes().item(iNode), "QualifyingProperties")) == null; ++iNode) {
        }
        if (qp == null) {
            return null;
        }
        Node usp = null;
        String Prefix = null;
        String attrDef = qp.getAttribute("xmlns");
        Prefix = attrDef != null && attrDef.compareToIgnoreCase("http://uri.etsi.org/01903/v1.3.2#") == 0 ? "" : ((Prefix = qp.getPrefix()) == null || Prefix.compareTo("") == 0 ? "" : Prefix + ":");
        Node up = this.lookForChild(qp, "UnsignedProperties");
        if (up != null) {
            usp = this.lookForChild(up, "UnsignedSignatureProperties");
        }
        return (Element)usp;
    }

    private Element retrieveCounterSignatureElement(XadesSignatureOptions options, Document parsedDoc, Element signatureToBeCSigned) throws CapiException {
        Node node;
        Element qp = null;
        for (int iNode = 0; iNode < signatureToBeCSigned.getChildNodes().getLength() && (qp = (Element)this.lookForChild(node = signatureToBeCSigned.getChildNodes().item(iNode), "QualifyingProperties")) == null; ++iNode) {
        }
        Element counterSignatureElem = null;
        if (qp == null) {
            qp = parsedDoc.createElement("xades:QualifyingProperties");
            qp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
            qp.setAttributeNS(null, "Target", "#" + options.getSignerId());
            Element up = parsedDoc.createElement("xades:UnsignedProperties");
            qp.appendChild(up);
            Element usp = parsedDoc.createElement("xades:UnsignedSignatureProperties");
            up.appendChild(usp);
            counterSignatureElem = parsedDoc.createElement("xades:CounterSignature");
            usp.appendChild(counterSignatureElem);
            signatureToBeCSigned.appendChild(qp);
        } else {
            String prefix = null;
            String attrDef = qp.getAttribute("xmlns");
            prefix = attrDef != null && attrDef.compareToIgnoreCase("http://uri.etsi.org/01903/v1.3.2#") == 0 ? "" : ((prefix = qp.getPrefix()) == null || prefix.isEmpty() ? "" : prefix + ":");
            Node up = this.lookForChild(qp, "UnsignedProperties");
            if (up == null) {
                up = parsedDoc.createElement(prefix + "UnsignedProperties");
                qp.appendChild(up);
                Element usp = parsedDoc.createElement(prefix + "UnsignedSignatureProperties");
                up.appendChild(usp);
                counterSignatureElem = parsedDoc.createElement(prefix + "CounterSignature");
                usp.appendChild(counterSignatureElem);
            } else {
                Node usp = this.lookForChild(up, "UnsignedSignatureProperties");
                if (usp == null) {
                    usp = parsedDoc.createElement(prefix + "UnsignedSignatureProperties");
                    up.appendChild(usp);
                    counterSignatureElem = parsedDoc.createElement(prefix + "CounterSignature");
                    usp.appendChild(counterSignatureElem);
                } else {
                    counterSignatureElem = parsedDoc.createElement(prefix + "CounterSignature");
                    usp.appendChild(counterSignatureElem);
                }
            }
        }
        return counterSignatureElem;
    }

    private void generateCounterSignature(XadesSignatureOptions options, X509Certificate x509Cert, Element signatureToBeCSigned, PrivateKey privateKey) throws CapiException {
        Element counterSignatureElem = this.retrieveCounterSignatureElement(options, this.currentDocument, signatureToBeCSigned);
        if (counterSignatureElem == null) {
            throw new CapiException("Unable to find signature to countersign", 50025);
        }
        try {
            this.generateEnveloped(options, x509Cert, privateKey, counterSignatureElem, signatureToBeCSigned.getAttribute("Id"), true);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("CounterSignature encoding error", 50025);
        }
    }

    private void generateSoapSignature(XadesSignatureOptions options, X509Certificate x509Cert, String bodyId) throws CapiException {
        throw new UnsupportedOperationException("To be implemented");
    }

    private void generateEnveloped(XadesSignatureOptions options, X509Certificate x509Cert, PrivateKey privateKey, boolean isCountersignature) throws CapiException {
        this.generateEnveloped(options, x509Cert, privateKey, null, null, isCountersignature);
    }

    private void generateEnveloped(XadesSignatureOptions options, X509Certificate x509Cert, PrivateKey privateKey, Element sigElement, String parentSignerId, boolean isCountersignature) throws CapiException {
        logger.debug("[addSigner] generating XML ENVELOPED Signature...");
        if (this.currentDocument == null) {
            throw new CapiException("Mimetype: " + options.getXmlMimetype() + " Enveloped Signature requires text/xml", 50025);
        }
        XMLSignatureFactory signatureFactory = XMLUtils.getXMLSignatureFactoryInstance();
        long time = System.currentTimeMillis();
        String signerid = "Signer-T-" + time;
        if (options.getSignerId() != null) {
            signerid = options.getSignerId();
        } else if (parentSignerId != null && !parentSignerId.isEmpty()) {
            signerid = "Countersignature-" + time + "-" + parentSignerId;
        }
        LinkedList<XMLObject> objects = new LinkedList<XMLObject>();
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        LinkedList<Reference> references = new LinkedList<Reference>();
        try {
            if (sigElement == null) {
                String aid;
                NodeList listXades = this.currentDocument.getElementsByTagName("Revision");
                for (int i = 0; i < listXades.getLength(); ++i) {
                    aid = ((Element)listXades.item(i)).getAttribute("ID");
                    if (aid == null || aid.equals("")) continue;
                    ((Element)listXades.item(i)).setIdAttribute("ID", true);
                }
                Element atto = (Element)this.currentDocument.getElementsByTagName("Atto").item(0);
                if (atto != null && (aid = atto.getAttribute("ID")) != null && !aid.equals("")) {
                    atto.setIdAttribute("ID", true);
                }
                sigElement = options.getXmlSignatureLocation() == null ? this.currentDocument.getDocumentElement() : (Element)this.currentDocument.getElementsByTagName(options.getXmlSignatureLocation()).item(0);
            }
            this.currentContext = new DOMSignContext(privateKey, (Node)sigElement);
            this.currentContext.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
            Date signingTime = options.getSigningTime();
            if (signingTime == null) {
                signingTime = new Date();
            }
            if (!isCountersignature) {
                HashMap<String, String> nsMap = new HashMap<String, String>();
                nsMap.put("ds", "http://www.w3.org/2000/09/xmldsig#");
                XPathFilter2ParameterSpec xpath2Spec = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType("/descendant::ds:Signature", XPathType.Filter.SUBTRACT, nsMap)));
                transforms.add(signatureFactory.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", xpath2Spec));
            }
            this.addTransformations(this.currentDocument, transforms, options.getXmlTransforms(), signatureFactory);
            String uri = "";
            if (parentSignerId != null && !parentSignerId.isEmpty()) {
                uri = "#SignatureValue-" + parentSignerId;
            } else if (options.getXmlTargetID() != null) {
                uri = "#" + options.getXmlTargetID();
            }
            String refType = null;
            if (isCountersignature) {
                refType = "http://uri.etsi.org/01903#CountersignedSignature";
            }
            Reference refe = signatureFactory.newReference(uri, signatureFactory.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), transforms, refType, "r-doc-" + signerid);
            references.add(refe);
            if (this.referredStylesheet != null) {
                Reference ref = signatureFactory.newReference(this.referredStylesheet, signatureFactory.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, null, "r-stylesheet-" + signerid);
                try {
                    this.currentContext.getURIDereferencer().dereference(new DOMURIReference(){

                        @Override
                        public Node getHere() {
                            return XadesDocument.this.nodeStylesheet;
                        }

                        @Override
                        public String getURI() {
                            return XadesDocument.this.referredStylesheet;
                        }

                        @Override
                        public String getType() {
                            return "http://uri.etsi.org/01903#SignedProperties";
                        }
                    }, this.currentContext);
                    references.add(ref);
                }
                catch (NullPointerException | URIReferenceException ex) {
                    logger.warn("Can't add {} to referenced signature", (Object)ref.getURI());
                }
            }
            references.add(signatureFactory.newReference("#SignedProperties-" + signerid, signatureFactory.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, "http://uri.etsi.org/01903#SignedProperties", null));
            LinkedList<X509Certificate> lstCertOnKeyInfo = new LinkedList<X509Certificate>();
            lstCertOnKeyInfo.add(x509Cert);
            KeyInfoFactory kfac = signatureFactory.getKeyInfoFactory();
            X509Data kv = kfac.newX509Data(lstCertOnKeyInfo);
            String keyInfoID = "KeyInfo-" + signerid;
            KeyInfo ki = kfac.newKeyInfo(Collections.singletonList(kv), keyInfoID);
            references.add(signatureFactory.newReference("#" + keyInfoID, signatureFactory.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, null, "r-keyinfo-" + signerid));
            objects.add(this.addXadesAttribute(options, signingTime, signatureFactory, this.currentDocument, x509Cert, signerid, references));
            CanonicalizationMethod cm = signatureFactory.newCanonicalizationMethod(options.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
            SignedInfo info = signatureFactory.newSignedInfo(cm, signatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null), references);
            this.currentSignature = signatureFactory.newXMLSignature(info, ki, objects, signerid, "SignatureValue-" + signerid);
        }
        catch (CapiException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
        }
    }

    private Element retrieveSignatureToCounterSign(String signaturePath) throws CapiException {
        if (this.currentDocument == null) {
            return null;
        }
        String[] arrPath = signaturePath.split(":");
        NodeList signatureList = null;
        int level = 1;
        try {
            signatureList = this.retrieveNodeList(this.currentDocument);
        }
        catch (XPathExpressionException e) {
            throw new CapiException("TransformerException getting Signature Nodes", 50001, (Throwable)e);
        }
        if (signatureList.getLength() == 0) {
            return null;
        }
        int index = Integer.parseInt(arrPath[0]);
        if (signatureList.item(index) == null) {
            return null;
        }
        if (level == arrPath.length) {
            return (Element)signatureList.item(index);
        }
        return this.searchCounterSignature((Element)signatureList.item(index), arrPath, level + 1);
    }

    private NodeList retrieveNodeList(Document curDocument) throws XPathExpressionException {
        NamespaceContext nsctx = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("xades")) {
                    return "http://uri.etsi.org/01903/v1.3.2#";
                }
                if (prefix.equals("ds")) {
                    return "http://www.w3.org/2000/09/xmldsig#";
                }
                return null;
            }

            public Iterator getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }
        };
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(nsctx);
        XPathExpression expres = xPath.compile("//ds:Signature[not(ancestor::ds:Signature)]");
        return (NodeList)expres.evaluate(curDocument, XPathConstants.NODESET);
    }

    private Element searchCounterSignature(Element signature, String[] arrPath, int level) throws CapiException {
        if (signature == null) {
            return null;
        }
        LinkedList<Node> signatureList = null;
        Element usp_elem = this.retrieveUnsignedPropertyElement(signature);
        if (usp_elem != null) {
            signatureList = this.retrieveChildsList(usp_elem, "CounterSignature");
        }
        if (signatureList == null || signatureList.isEmpty()) {
            return null;
        }
        int index = Integer.parseInt(arrPath[level - 1]);
        if (signatureList.get(index) == null) {
            return null;
        }
        if (level == arrPath.length) {
            return (Element)signatureList.get(index).getFirstChild();
        }
        return this.searchCounterSignature((Element)signatureList.get(index).getFirstChild(), arrPath, level++);
    }

    private LinkedList<Node> retrieveChildsList(Element father, String endWith) {
        LinkedList<Node> signatureList = new LinkedList<Node>();
        if (father.hasChildNodes()) {
            NodeList children = father.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                short type = children.item(i).getNodeType();
                if (type != 1 || !children.item(i).getNodeName().endsWith(endWith)) continue;
                signatureList.add(children.item(i));
            }
        }
        return signatureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateEnveloping(XadesSignatureOptions options, X509Certificate x509Cert, PrivateKey privateKey) throws CapiException {
        logger.debug("[addSigner] generating XML ENVELOPING Signature");
        Document signedDoc = this.db.newDocument();
        XMLSignatureFactory fac = XMLUtils.getXMLSignatureFactoryInstance();
        this.currentContext = new DOMSignContext(privateKey, (Node)signedDoc);
        this.currentContext.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
        try {
            long time = System.currentTimeMillis();
            String objectId = "SignedObject-" + time;
            XMLObject content = null;
            if (this.currentDocument != null) {
                logger.debug("[addSigner] XML ENVELOPING Object is XML text");
                LinkedList<DOMStructure> lst = new LinkedList<DOMStructure>();
                if (this.nodeStylesheet != null) {
                    lst.add(new DOMStructure(signedDoc.createProcessingInstruction(this.nodeStylesheet.getTarget(), this.nodeStylesheet.getData())));
                }
                Node elem = signedDoc.importNode(this.currentDocument.getDocumentElement(), true);
                lst.add(new DOMStructure(elem));
                content = fac.newXMLObject(lst, objectId, options.getXmlMimetype(), options.getXmlEncoding());
            } else {
                logger.debug("[addSigner] XML ENVELOPING Object is Base64 encoded");
                StringBuilder fBuf = new StringBuilder();
                InputStream in = options.getInput().getInputAsNewStream();
                try {
                    String line;
                    BufferedReader dis = new BufferedReader(new InputStreamReader(in));
                    while ((line = dis.readLine()) != null) {
                        fBuf.append(line.concat("\n"));
                    }
                }
                finally {
                    Util.closeQuietly((Closeable)in);
                }
                content = fac.newXMLObject(Collections.singletonList(new DOMStructure(signedDoc.createTextNode(fBuf.toString()))), objectId, options.getXmlMimetype(), options.getXmlEncoding());
            }
            LinkedList<XMLObject> objects = new LinkedList<XMLObject>();
            objects.add(content);
            LinkedList<Transform> transforms = new LinkedList<Transform>();
            if (!this.addTransformations(signedDoc, transforms, options.getXmlTransforms(), fac)) {
                transforms = null;
            }
            String signerid = "Signer-T-" + time;
            if (options.getSignerId() != null) {
                signerid = options.getSignerId();
            }
            LinkedList<Reference> references = new LinkedList<Reference>();
            references.add(fac.newReference("#xpointer(id('" + objectId + "'))", fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), transforms, null, "r-doc-" + signerid));
            Date signingTime = options.getSigningTime();
            if (signingTime == null) {
                signingTime = new Date();
            }
            references.add(fac.newReference("#SignedProperties-" + signerid, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, "http://uri.etsi.org/01903#SignedProperties", null));
            if (this.referredStylesheet != null) {
                Reference ref = fac.newReference(this.referredStylesheet, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, null, "r-stylesheet-" + signerid);
                try {
                    this.currentContext.getURIDereferencer().dereference(new DOMURIReference(){

                        @Override
                        public Node getHere() {
                            return XadesDocument.this.nodeStylesheet;
                        }

                        @Override
                        public String getURI() {
                            return XadesDocument.this.referredStylesheet;
                        }

                        @Override
                        public String getType() {
                            return "http://uri.etsi.org/01903#SignedProperties";
                        }
                    }, this.currentContext);
                    references.add(ref);
                }
                catch (NullPointerException | URIReferenceException ex) {
                    logger.warn("Can't add {} to referenced signature", (Object)ref.getURI());
                }
            }
            LinkedList<X509Certificate> lstCertOnKeyInfo = new LinkedList<X509Certificate>();
            lstCertOnKeyInfo.add(x509Cert);
            KeyInfoFactory kfac = fac.getKeyInfoFactory();
            X509Data kv = kfac.newX509Data(lstCertOnKeyInfo);
            String keyInfoID = "KeyInfo-" + signerid;
            KeyInfo ki = kfac.newKeyInfo(Collections.singletonList(kv), keyInfoID);
            references.add(fac.newReference("#" + keyInfoID, fac.newDigestMethod(options.getDigestAlgorithm().getXadesID(), null), null, null, "r-keyinfo-" + signerid));
            objects.add(this.addXadesAttribute(options, signingTime, fac, signedDoc, x509Cert, signerid, references));
            CanonicalizationMethod cm = fac.newCanonicalizationMethod(options.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
            String sigMethod = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)options.getDigestAlgorithm()).getXadesName();
            SignedInfo info = fac.newSignedInfo(cm, fac.newSignatureMethod(sigMethod, null), references);
            this.currentSignature = fac.newXMLSignature(info, ki, objects, signerid, "SignatureValue-" + signerid);
        }
        catch (CapiException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
        }
        this.currentDocument = signedDoc;
    }

    private void lookForPI(Document doc) throws CapiException {
        this.dumpPI(doc);
    }

    private void dumpPI(Node node) throws CapiException {
        switch (node.getNodeType()) {
            case 7: {
                this.dumpXmlStylesheetPI((ProcessingInstruction)node);
                break;
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.dumpPI(list.item(i));
        }
    }

    private void dumpXmlStylesheetPI(ProcessingInstruction node) throws CapiException {
        if (logger.isDebugEnabled()) {
            logger.debug("[dumpProcesssInstruction] PI: target=" + node.getTarget());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[dumpProcesssInstruction] PI: data=" + node.getData());
        }
        if (node.getTarget().startsWith("xml-stylesheet")) {
            Node parent = node.getParentNode();
            if (parent != null && parent.getNodeType() == 9) {
                this.nodeStylesheet = node;
            }
            int idx = -1;
            idx = node.getData().indexOf("href=");
            if (idx < 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            String style = node.getData().substring(idx + 5);
            idx = style.indexOf("\"");
            if (idx < 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            int idx2 = style.indexOf("\"", idx + 1);
            if (idx2 <= idx + 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            this.referredStylesheet = style.substring(idx + 1, idx2);
            if (this.referredStylesheet != null && !"".equals(this.referredStylesheet)) {
                try {
                    URL url = new URL(this.referredStylesheet);
                    url.toURI();
                }
                catch (Exception e) {
                    String referredStylesheetCleaned = this.hrefCleaner(this.referredStylesheet);
                    try {
                        URL url = new URL(referredStylesheetCleaned);
                        url.toURI();
                        this.referredStylesheet = referredStylesheetCleaned;
                    }
                    catch (Exception ex) {
                        throw new CapiException("Malformed stilesheet href", 50025);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[dumpProcesssInstruction] stylesheet href setted to: " + this.referredStylesheet);
            }
        }
    }

    private Element newXadesQualifyingProperties(String signerid, Document doc) {
        Element qp = doc.createElement("xades:QualifyingProperties");
        qp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
        qp.setAttributeNS(null, "Target", "#" + signerid);
        return qp;
    }

    private Node newXadesSignedProperties(Element parent, String signerid, Document doc) throws CapiException {
        Element sp = doc.createElement("xades:SignedProperties");
        sp.setAttributeNS(null, "Id", "SignedProperties-" + signerid);
        sp.setIdAttributeNS(null, "Id", true);
        XadesDocument.appendChild(parent, sp, 2, true, doc);
        return sp;
    }

    private XMLObject addXadesAttribute(XadesSignatureOptions options, Date sTime, XMLSignatureFactory fac, Document doc, X509Certificate cert, String signerid, List<Reference> references) throws CapiException, NoSuchAlgorithmException {
        try {
            Element qualifyingPropertiesElement = this.newXadesQualifyingProperties(signerid, doc);
            Element signedPropertiesElement = (Element)this.newXadesSignedProperties(qualifyingPropertiesElement, signerid, doc);
            Element signedSignaturePropsElement = doc.createElement("xades:SignedSignatureProperties");
            Element signingTimeElement = doc.createElement("xades:SigningTime");
            Date date = sTime;
            if (date == null) {
                date = new Date();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String sdate = sdf.format(date);
            SimpleDateFormat tZoneParser = null;
            String xmlTZone = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("[addSignTime]doing Z format..");
                }
                tZoneParser = new SimpleDateFormat("Z");
                String tZoneStr = tZoneParser.format(date);
                xmlTZone = tZoneStr.substring(0, 3) + ":" + tZoneStr.substring(3, 5);
            }
            catch (IllegalArgumentException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[addSignTime] catched Exception ..");
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(date);
                int hour = cal.get(15) / 3600000;
                DecimalFormat myFormatter = new DecimalFormat("00");
                xmlTZone = hour >= 0 ? "+" + myFormatter.format(hour) + ":00" : "-" + myFormatter.format(hour) + ":00";
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[addSignTime] SigningTime is: " + sdate + xmlTZone);
            }
            signingTimeElement.appendChild(doc.createTextNode(sdate + xmlTZone));
            Element signingCertElement = null;
            signingCertElement = options.getSignatureProfile() != null && options.getSignatureProfile().equals((Object)XadesSignatureProfile.ETSI_EN_319_132_1_v1_1_1) ? doc.createElement("xades:SigningCertificateV2") : doc.createElement("xades:SigningCertificate");
            Element certificateElement = doc.createElement("xades:Cert");
            Element certDigestElement = doc.createElement("xades:CertDigest");
            Element digestMethodElement = doc.createElement("ds:DigestMethod");
            digestMethodElement.setAttributeNS(null, "Algorithm", options.getDigestAlgorithm().getXadesID());
            Element digestValueElement = doc.createElement("ds:DigestValue");
            MessageDigest md = MessageDigest.getInstance(options.getDigestAlgorithm().getId(), ProvUtils.bcProvider);
            md.update(cert.getEncoded());
            byte[] certDigest = md.digest();
            digestValueElement.appendChild(doc.createTextNode(new String(Util.base64Encode((byte[])certDigest))));
            Element issuerSerialElement = null;
            if (options.getSignatureProfile() != null && options.getSignatureProfile().equals((Object)XadesSignatureProfile.ETSI_EN_319_132_1_v1_1_1)) {
                issuerSerialElement = doc.createElement("xades:IssuerSerialV2");
                issuerSerialElement.appendChild(doc.createTextNode(new String(Util.base64Encode((byte[])cert.getIssuerX500Principal().getEncoded()))));
            } else {
                issuerSerialElement = doc.createElement("xades:IssuerSerial");
                Element issuerSerialNameElement = doc.createElement("ds:X509IssuerName");
                issuerSerialNameElement.appendChild(doc.createTextNode(cert.getIssuerX500Principal().getName()));
                issuerSerialElement.appendChild(issuerSerialNameElement);
                Element issuerSerialNumberElement = doc.createElement("ds:X509SerialNumber");
                issuerSerialNumberElement.appendChild(doc.createTextNode(cert.getSerialNumber().toString()));
                issuerSerialElement.appendChild(issuerSerialNumberElement);
            }
            int tabCount = 3;
            XadesDocument.appendChild(signedPropertiesElement, signedSignaturePropsElement, tabCount, true, doc);
            XadesDocument.appendChild(signedSignaturePropsElement, signingTimeElement, ++tabCount, false, doc);
            XadesDocument.appendChild(signedSignaturePropsElement, signingCertElement, tabCount, true, doc);
            XadesDocument.appendChild(signingCertElement, certificateElement, ++tabCount, true, doc);
            XadesDocument.appendChild(certificateElement, certDigestElement, ++tabCount, false, doc);
            XadesDocument.appendChild(certDigestElement, digestMethodElement, ++tabCount, false, doc);
            XadesDocument.appendChild(certDigestElement, digestValueElement, tabCount, true, doc);
            XadesDocument.appendChild(certificateElement, issuerSerialElement, --tabCount, true, doc);
            Element signedDataObjPropsElement = doc.createElement("xades:SignedDataObjectProperties");
            tabCount = 3;
            XadesDocument.appendChild(signedPropertiesElement, signedDataObjPropsElement, tabCount, true, doc);
            if (references != null) {
                for (Reference ref : references) {
                    if (ref.getType() != null && ref.getType().equals("http://uri.etsi.org/01903#SignedProperties")) continue;
                    Element dataObjectFormatElement = doc.createElement("xades:DataObjectFormat");
                    dataObjectFormatElement.setAttribute("ObjectReference", "#" + ref.getId());
                    String mimeType = "text/xml";
                    if (ref.getId().startsWith("r-doc-") && !this.isXml) {
                        mimeType = "application/octet-stream";
                    }
                    Element mimeTypeElement = doc.createElement("xades:MimeType");
                    mimeTypeElement.appendChild(doc.createTextNode(mimeType));
                    XadesDocument.appendChild(signedDataObjPropsElement, dataObjectFormatElement, tabCount + 1, true, doc);
                    XadesDocument.appendChild(dataObjectFormatElement, mimeTypeElement, tabCount + 2, true, doc);
                }
            }
            DOMStructure content = new DOMStructure(qualifyingPropertiesElement);
            return fac.newXMLObject(Collections.singletonList(content), null, null, null);
        }
        catch (NoSuchAlgorithmException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("NoSuchAlgorithmException occurred: " + e.getMessage(), 50025);
        }
        catch (CertificateEncodingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("CertificateEncodingException occurred: " + e.getMessage(), 50025);
        }
    }

    private static void appendChild(Node parentNode, Node childNode, int tabCount, boolean isLastNode, Document doc) {
        Node[] nodes = XadesDocument.getNodes(tabCount, isLastNode, doc);
        parentNode.appendChild(nodes[0]);
        parentNode.appendChild(childNode);
        if (isLastNode) {
            parentNode.appendChild(nodes[1]);
        }
    }

    private static Node[] getNodes(int tabCount, boolean isLastNode, Document doc) {
        String s1 = "\n";
        for (int t = 0; t < tabCount; ++t) {
            s1 = s1.concat("\t");
        }
        Text n1 = doc.createTextNode(s1);
        Text n2 = null;
        if (isLastNode) {
            String s2 = "\n";
            if (isLastNode) {
                for (int t = 0; t < tabCount - 1; ++t) {
                    s2 = s2.concat("\t");
                }
            } else {
                s2 = s1;
            }
            n2 = doc.createTextNode(s2);
        }
        Node[] nodes = new Node[]{n1, n2};
        return nodes;
    }

    private boolean addTransformations(Document doc, List<Transform> transforms, List<XadesTransformation> transformationsToBeAdded, XMLSignatureFactory signFactory) throws Exception {
        if (transformationsToBeAdded == null || transformationsToBeAdded.isEmpty()) {
            return false;
        }
        for (XadesTransformation xadesTransformation : transformationsToBeAdded) {
            if (xadesTransformation == null || xadesTransformation.getAlgorithm() == null) continue;
            switch (xadesTransformation.getAlgorithm()) {
                case "http://www.w3.org/TR/1999/REC-xpath-19991116": {
                    XPathFilterParameterSpec specXPath = new XPathFilterParameterSpec("samlp:AuthnRequest/UserID", Collections.singletonMap("ds", "http://www.w3.org/2000/09/xmldsig#"));
                    transforms.add(signFactory.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", specXPath));
                    break;
                }
                case "http://www.w3.org/2002/06/xmldsig-filter2": {
                    if (xadesTransformation.getFilter() == null) break;
                    HashMap<String, String> nsMap = new HashMap<String, String>();
                    nsMap.put("ds", "http://www.w3.org/2000/09/xmldsig#");
                    nsMap.put(xadesTransformation.getNsPrefix(), xadesTransformation.getNsUri());
                    XPathType.Filter xPathfilter = XPathType.Filter.SUBTRACT;
                    if (xadesTransformation.getFilter().compareToIgnoreCase("intersect") == 0) {
                        xPathfilter = XPathType.Filter.INTERSECT;
                    } else if (xadesTransformation.getFilter().compareToIgnoreCase("union") == 0) {
                        xPathfilter = XPathType.Filter.UNION;
                    }
                    XPathFilter2ParameterSpec xpath2Spec = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType(xadesTransformation.getValue(), xPathfilter, nsMap)));
                    transforms.add(signFactory.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", xpath2Spec));
                    break;
                }
                case "http://www.w3.org/TR/1999/REC-xslt-19991116": {
                    FileInputStream xslt = null;
                    try {
                        xslt = new FileInputStream(xadesTransformation.getValue());
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        dbf.setNamespaceAware(true);
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document docxslt = db.parse(xslt);
                        Element xslElem = docxslt.getDocumentElement();
                        Node xslElemImported = doc.importNode(xslElem, true);
                        XSLTTransformParameterSpec specXSLT = new XSLTTransformParameterSpec(new DOMStructure(xslElemImported));
                        transforms.add(signFactory.newTransform("http://www.w3.org/TR/1999/REC-xslt-19991116", specXSLT));
                    }
                    catch (Exception e) {
                        try {
                            throw e;
                        }
                        catch (Throwable throwable) {
                            Util.closeQuietly(xslt);
                            throw throwable;
                        }
                    }
                    Util.closeQuietly((Closeable)xslt);
                    break;
                }
                default: {
                    transforms.add(signFactory.newTransform(xadesTransformation.getAlgorithm(), new DOMStructure(doc.getDocumentElement())));
                }
            }
        }
        return true;
    }

    private void checkCanAdd(Document current_doc, SignatureMode mode) throws CapiException {
        if (current_doc == null) {
            return;
        }
        try {
            this.currentSignatureList = this.retrieveNodeList(current_doc);
            if (this.currentSignatureList.getLength() == 0) {
                return;
            }
            String rootName = current_doc.getDocumentElement().getTagName();
            if ((rootName.endsWith(":Signature") || rootName.compareToIgnoreCase("Signature") == 0) && mode == SignatureMode.ENVELOPED) {
                XadesModeException exception = new XadesModeException(mode, SignatureMode.DETACHED_INTERNAL);
                throw exception;
            }
            int nTransformedSignatures = 0;
            for (int i = 0; i < this.currentSignatureList.getLength(); ++i) {
                Node signature = this.currentSignatureList.item(i);
                Node signedInfo = this.lookForChild((Element)signature, "SignedInfo");
                LinkedList<Node> references = this.retrieveChildsList((Element)signedInfo, "Reference");
                boolean transformedSignature = false;
                for (Node reference : references) {
                    LinkedList<Node> lstTransforms;
                    Node transforms;
                    String URI2 = ((Element)reference).getAttribute("URI");
                    if (URI2 == null || !URI2.isEmpty() || (transforms = this.lookForChild((Element)reference, "Transforms")) == null || (lstTransforms = this.retrieveChildsList((Element)transforms, "Transform")).isEmpty()) continue;
                    boolean validTransform = false;
                    for (Node transform : lstTransforms) {
                        Node xPath;
                        String xPathValue;
                        String strAlgorithm = ((Element)transform).getAttribute("Algorithm");
                        if (strAlgorithm.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                            Node xPathNode = this.lookForChild((Element)transform, "XPath");
                            String filter = ((Element)xPathNode).getAttribute("Filter");
                            if (!filter.equals("subtract") || !((Element)xPathNode).getTextContent().equals("/descendant::ds:Signature")) continue;
                            validTransform = true;
                            continue;
                        }
                        if (!strAlgorithm.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") || !"not(ancestor-or-self::ds:Signature)".equals(xPathValue = (xPath = this.lookForChild((Element)transform, "XPath")).getTextContent())) continue;
                        validTransform = true;
                    }
                    if (mode == SignatureMode.ENVELOPED && !validTransform) {
                        throw new XadesModeException(mode, null);
                    }
                    if (mode != SignatureMode.ENVELOPED && validTransform) {
                        throw new XadesModeException(mode, SignatureMode.ENVELOPED);
                    }
                    transformedSignature = true;
                }
                if (!transformedSignature) continue;
                ++nTransformedSignatures;
            }
            if (nTransformedSignatures < this.currentSignatureList.getLength() && mode == SignatureMode.ENVELOPED) {
                throw new XadesModeException(mode, SignatureMode.DETACHED_INTERNAL);
            }
        }
        catch (XPathExpressionException e) {
            throw new CapiException("TransformerException getting Signature Nodes", 50001, (Throwable)e);
        }
    }

    private void setIdObject(Document doc) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression expr = xpath.compile("descendant-or-self::*/@Id");
        NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Attr attr = (Attr)nodes.item(i);
            attr.getOwnerElement().setIdAttributeNode(attr, true);
        }
    }

    public String getBodyId() {
        return this.bodyId;
    }

    private String hrefCleaner(String href) {
        String cleaned = href.replaceAll("\\\\", "/").replaceAll("\\s+", "");
        return "file://" + cleaned;
    }
}

