/*
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */
#include <stdio.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <assert.h>
#include <errno.h>

int main(int argc, char* argv[])
{
	int fd;
	int i;
	fd= open("fsynctestdata",O_CREAT|O_RDWR|O_SYNC|O_DSYNC);
	assert(fd > 0);
	assert(errno == 0);
	for (i = 0; i < 1000; ++i) {
		write(fd, "a", 1);
		assert(errno == 0);
		fsync(fd);
		assert(errno == 0);
		write(fd, "a", 1);
		assert(errno == 0);
		fdatasync(fd);
		assert(errno == 0);
		write(fd, "a", 1);
		assert(errno == 0);
		sync();
		assert(errno == 0);
	}
	close(fd);
	unlink("fsynctestdata");
	msync(0,0,0);
	assert(errno == 0);
	return 0;
}
