pragma Ada_2005;
pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with System;
with dbus_types_h;

package dbus_threads_h is

   --  skipped empty struct DBusMutex

   --  skipped empty struct DBusCondVar

   type DBusMutexNewFunction is access function return System.Address;
   pragma Convention (C, DBusMutexNewFunction);  -- ../dbus/dbus-threads.h:46

   type DBusMutexFreeFunction is access procedure (arg1 : System.Address);
   pragma Convention (C, DBusMutexFreeFunction);  -- ../dbus/dbus-threads.h:48

   type DBusMutexLockFunction is access function (arg1 : System.Address) return dbus_types_h.dbus_bool_t;
   pragma Convention (C, DBusMutexLockFunction);  -- ../dbus/dbus-threads.h:50

   type DBusMutexUnlockFunction is access function (arg1 : System.Address) return dbus_types_h.dbus_bool_t;
   pragma Convention (C, DBusMutexUnlockFunction);  -- ../dbus/dbus-threads.h:52

   type DBusRecursiveMutexNewFunction is access function return System.Address;
   pragma Convention (C, DBusRecursiveMutexNewFunction);  -- ../dbus/dbus-threads.h:61

   type DBusRecursiveMutexFreeFunction is access procedure (arg1 : System.Address);
   pragma Convention (C, DBusRecursiveMutexFreeFunction);  -- ../dbus/dbus-threads.h:64

   type DBusRecursiveMutexLockFunction is access procedure (arg1 : System.Address);
   pragma Convention (C, DBusRecursiveMutexLockFunction);  -- ../dbus/dbus-threads.h:68

   type DBusRecursiveMutexUnlockFunction is access procedure (arg1 : System.Address);
   pragma Convention (C, DBusRecursiveMutexUnlockFunction);  -- ../dbus/dbus-threads.h:72

   type DBusCondVarNewFunction is access function return System.Address;
   pragma Convention (C, DBusCondVarNewFunction);  -- ../dbus/dbus-threads.h:77

   type DBusCondVarFreeFunction is access procedure (arg1 : System.Address);
   pragma Convention (C, DBusCondVarFreeFunction);  -- ../dbus/dbus-threads.h:80

   type DBusCondVarWaitFunction is access procedure (arg1 : System.Address; arg2 : System.Address);
   pragma Convention (C, DBusCondVarWaitFunction);  -- ../dbus/dbus-threads.h:92

   type DBusCondVarWaitTimeoutFunction is access function
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : int) return dbus_types_h.dbus_bool_t;
   pragma Convention (C, DBusCondVarWaitTimeoutFunction);  -- ../dbus/dbus-threads.h:101

   type DBusCondVarWakeOneFunction is access procedure (arg1 : System.Address);
   pragma Convention (C, DBusCondVarWakeOneFunction);  -- ../dbus/dbus-threads.h:108

   type DBusCondVarWakeAllFunction is access procedure (arg1 : System.Address);
   pragma Convention (C, DBusCondVarWakeAllFunction);  -- ../dbus/dbus-threads.h:114

   subtype DBusThreadFunctionsMask is unsigned;
   DBUS_THREAD_FUNCTIONS_MUTEX_NEW_MASK : constant DBusThreadFunctionsMask := 1;
   DBUS_THREAD_FUNCTIONS_MUTEX_FREE_MASK : constant DBusThreadFunctionsMask := 2;
   DBUS_THREAD_FUNCTIONS_MUTEX_LOCK_MASK : constant DBusThreadFunctionsMask := 4;
   DBUS_THREAD_FUNCTIONS_MUTEX_UNLOCK_MASK : constant DBusThreadFunctionsMask := 8;
   DBUS_THREAD_FUNCTIONS_CONDVAR_NEW_MASK : constant DBusThreadFunctionsMask := 16;
   DBUS_THREAD_FUNCTIONS_CONDVAR_FREE_MASK : constant DBusThreadFunctionsMask := 32;
   DBUS_THREAD_FUNCTIONS_CONDVAR_WAIT_MASK : constant DBusThreadFunctionsMask := 64;
   DBUS_THREAD_FUNCTIONS_CONDVAR_WAIT_TIMEOUT_MASK : constant DBusThreadFunctionsMask := 128;
   DBUS_THREAD_FUNCTIONS_CONDVAR_WAKE_ONE_MASK : constant DBusThreadFunctionsMask := 256;
   DBUS_THREAD_FUNCTIONS_CONDVAR_WAKE_ALL_MASK : constant DBusThreadFunctionsMask := 512;
   DBUS_THREAD_FUNCTIONS_RECURSIVE_MUTEX_NEW_MASK : constant DBusThreadFunctionsMask := 1024;
   DBUS_THREAD_FUNCTIONS_RECURSIVE_MUTEX_FREE_MASK : constant DBusThreadFunctionsMask := 2048;
   DBUS_THREAD_FUNCTIONS_RECURSIVE_MUTEX_LOCK_MASK : constant DBusThreadFunctionsMask := 4096;
   DBUS_THREAD_FUNCTIONS_RECURSIVE_MUTEX_UNLOCK_MASK : constant DBusThreadFunctionsMask := 8192;
   DBUS_THREAD_FUNCTIONS_ALL_MASK : constant DBusThreadFunctionsMask := 16383;  -- ../dbus/dbus-threads.h:138

   type DBusThreadFunctions is record
      mask : aliased unsigned;  -- ../dbus/dbus-threads.h:154
      mutex_new : DBusMutexNewFunction;  -- ../dbus/dbus-threads.h:156
      mutex_free : DBusMutexFreeFunction;  -- ../dbus/dbus-threads.h:157
      mutex_lock : DBusMutexLockFunction;  -- ../dbus/dbus-threads.h:158
      mutex_unlock : DBusMutexUnlockFunction;  -- ../dbus/dbus-threads.h:159
      condvar_new : DBusCondVarNewFunction;  -- ../dbus/dbus-threads.h:161
      condvar_free : DBusCondVarFreeFunction;  -- ../dbus/dbus-threads.h:162
      condvar_wait : DBusCondVarWaitFunction;  -- ../dbus/dbus-threads.h:163
      condvar_wait_timeout : DBusCondVarWaitTimeoutFunction;  -- ../dbus/dbus-threads.h:164
      condvar_wake_one : DBusCondVarWakeOneFunction;  -- ../dbus/dbus-threads.h:165
      condvar_wake_all : DBusCondVarWakeAllFunction;  -- ../dbus/dbus-threads.h:166
      recursive_mutex_new : DBusRecursiveMutexNewFunction;  -- ../dbus/dbus-threads.h:168
      recursive_mutex_free : DBusRecursiveMutexFreeFunction;  -- ../dbus/dbus-threads.h:169
      recursive_mutex_lock : DBusRecursiveMutexLockFunction;  -- ../dbus/dbus-threads.h:170
      recursive_mutex_unlock : DBusRecursiveMutexUnlockFunction;  -- ../dbus/dbus-threads.h:171
      padding1 : access procedure;  -- ../dbus/dbus-threads.h:173
      padding2 : access procedure;  -- ../dbus/dbus-threads.h:174
      padding3 : access procedure;  -- ../dbus/dbus-threads.h:175
      padding4 : access procedure;  -- ../dbus/dbus-threads.h:176
   end record;
   pragma Convention (C_Pass_By_Copy, DBusThreadFunctions);  -- ../dbus/dbus-threads.h:178

   --  skipped anonymous struct anon_9

   function dbus_threads_init (functions : access constant DBusThreadFunctions) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:181
   pragma Import (C, dbus_threads_init, "dbus_threads_init");

   function dbus_threads_init_default return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:183
   pragma Import (C, dbus_threads_init_default, "dbus_threads_init_default");

end dbus_threads_h;
