/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;

class TextViewer
extends JFrame
implements ActionListener {
    JTextArea textArea = new JTextArea(35, 80);
    File file = null;
    JButton refreshButton;
    JButton dismissButton;
    Timer tim = null;
    int rcnt = 0;
    int tms = 250;
    boolean delete_it = false;
    TextViewer me;

    public TextViewer(String string, File file, boolean bl) {
        this.delete_it = bl;
        this.file = file;
        this.me = this;
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 22, 32);
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 1);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextViewer.this.cleanse();
                TextViewer.this.me.dispose();
            }
        };
        this.textArea.getInputMap(1).put(keyStroke, "escapeAction");
        this.textArea.getInputMap().put(keyStroke, "escapeAction");
        this.textArea.getActionMap().put("escapeAction", abstractAction);
        this.refreshButton = new JButton();
        this.refreshButton.setText("Reload");
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(this);
        this.dismissButton = new JButton();
        this.dismissButton.setText("Dismiss");
        this.dismissButton.setName("dismissButton");
        this.dismissButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.refreshButton, "West");
        jPanel.add((Component)this.dismissButton, "East");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextViewer.this.refresh();
            }
        };
        this.tim = new Timer(this.tms, actionListener);
        this.tim.start();
        this.setContentPane(jPanel2);
        this.setTitle("TextViewer - " + string);
        this.pack();
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        ++this.rcnt;
        if (this.rcnt * this.tms > 3000 && this.tim != null) {
            this.tim.stop();
            this.tim = null;
        }
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (bufferedReader == null) {
                bufferedReader = new BufferedReader(new FileReader(this.file));
            }
            String string = null;
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (n == 0) {
                    // empty if block
                }
                ++n;
                stringBuffer.append(string);
                stringBuffer.append(System.getProperty("line.separator"));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (Exception exception) {}
        }
        this.textArea.setText(stringBuffer.toString());
        this.textArea.setCaretPosition(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refreshButton) {
            this.refresh();
        }
        if (actionEvent.getSource() == this.dismissButton) {
            this.cleanse();
            this.dispose();
        }
    }

    private void cleanse() {
        block2: {
            if (!this.delete_it || this.file == null) break block2;
            try {
                this.file.delete();
                this.file = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanse();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

